/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.shared;

import com.charliemouse.cambozola.shared.ResizableByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Hashtable;

public class StreamSplit {
    public static final String BOUNDARY_MARKER_PREFIX = "--";
    public static final String BOUNDARY_MARKER_TERM = "--";
    private DataInputStream m_dis;
    private boolean m_streamEnd;

    public StreamSplit(DataInputStream dataInputStream) {
        this.m_dis = dataInputStream;
        this.m_streamEnd = false;
    }

    public Hashtable readHeaders() throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        boolean bl = false;
        while (true) {
            int n;
            if ((string = this.m_dis.readLine()) == null) {
                this.m_streamEnd = true;
                break;
            }
            if (string.equals("")) {
                if (bl) {
                    break;
                }
            } else {
                bl = true;
            }
            if ((n = string.indexOf(":")) == -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            hashtable.put(string2.toLowerCase(), string3);
        }
        return hashtable;
    }

    public Hashtable readHeaders(URLConnection uRLConnection) {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 1;
        while ((string = uRLConnection.getHeaderFieldKey(n)) != null) {
            String string2 = uRLConnection.getHeaderField(n);
            hashtable.put(string.toLowerCase(), string2);
            ++n;
        }
        return hashtable;
    }

    public void skipToBoundary(String string) throws IOException {
        this.readToBoundary(string);
    }

    public byte[] readToBoundary(String string) throws IOException {
        ResizableByteArrayOutputStream resizableByteArrayOutputStream = new ResizableByteArrayOutputStream();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (true) {
            byte by;
            try {
                by = this.m_dis.readByte();
            }
            catch (EOFException eOFException) {
                this.m_streamEnd = true;
                break;
            }
            if (by == 10 || by == 13) {
                String string2 = stringBuffer.toString();
                if (string2.startsWith("--") && string2.startsWith(string)) {
                    String string3 = string2.substring(string.length());
                    if (string3.equals("--")) {
                        this.m_streamEnd = true;
                    }
                    n2 = n;
                    break;
                }
                stringBuffer = new StringBuffer();
                n = n2 + 1;
            } else {
                stringBuffer.append((char)by);
            }
            ++n2;
            resizableByteArrayOutputStream.write(by);
        }
        resizableByteArrayOutputStream.close();
        resizableByteArrayOutputStream.resize(n2);
        return resizableByteArrayOutputStream.toByteArray();
    }

    public boolean isAtStreamEnd() {
        return this.m_streamEnd;
    }
}

