'''
@edit Jan 5 2022
    add system memory
'''

INDY_SHM_ROBOT_ADDR_ERROR_STRUCT_DATA = 0x061000

INDY_SUPPORT_INDYGO_SHM_NAME = "indyCAREShm"  # "indyGoShm"  # "indyCAREShm"
INDY_SUPPORT_INDYGO_SHM_LEN = 4096
INDY_SHM_MGR_OFFSET = 64

# Size Information of Shared Memory
INDY_SHM_NAME = "indySHM"
INDY_SHM_LEN = 0x1000000  # 16MB		== 0x000000~0xFFFFFF (~16777216)

INDY_SHM_SERVER_START = 0x000000  # 0~4MB		== 0x000000~0x3FFFFF
INDY_SHM_SERVER_SIZE = 0x400000  # 4MB
INDY_SHM_SERVER_END = 0x3FFFFF  # 0~2MB
INDY_SHM_CLIENT_START = 0x400000  # 4~8MB		== 0x400000~0x7FFFFF
INDY_SHM_CLIENT_SIZE = 0x400000  # 4MB
INDY_SHM_CLIENT_END = 0x7FFFFF  # 2~4MB
INDY_SHM_GENERAL_START = 0x800000  # 8MB~16MB	== 0x800000~0xFFFFFF
INDY_SHM_GENERAL_SIZE = 0x800000  # 8MB
INDY_SHM_GENERAL_END = 0xFFFFFF  # 8MB~16MB

# Server (Monitor, Event) Shared Memory
# System Status Data
INDY_SHM_RT_ADDR_STRUCT_DATA = 0x000000
INDY_SHM_RT_ADDR_RUNNING_TIME = 0x000000
INDY_SHM_RT_ADDR_TASK_TIME = 0x000008
INDY_SHM_RT_ADDR_TASK_TIME_MAX = 0x000010
INDY_SHM_RT_ADDR_COMPUTE_TIME = 0x000018
INDY_SHM_RT_ADDR_COMPUTE_TIME_MAX = 0x000020
INDY_SHM_RT_ADDR_ECAT_TIME = 0x000028
INDY_SHM_RT_ADDR_ECAT_TIME_MAX = 0x000030
INDY_SHM_RT_ADDR_ECAT_MASTER_STATE = 0x000038
INDY_SHM_RT_ADDR_ECAT_SLAVE_NUM = 0x00003C

# Robot Status Data
INDY_SHM_ROBOT_ADDR_EMERG_STRUCT_DATA = 0x061000
INDY_SHM_ROBOT_ADDR_EMERG_CODE = 0x061000
INDY_SHM_ROBOT_ADDR_EMERG_ARG_INT1 = 0x061004
INDY_SHM_ROBOT_ADDR_EMERG_ARG_INT2 = 0x061008
INDY_SHM_ROBOT_ADDR_EMERG_ARG_INT3 = 0x06100C
INDY_SHM_ROBOT_ADDR_EMERG_ARG_DOUBLE1 = 0x061010
INDY_SHM_ROBOT_ADDR_EMERG_ARG_DOUBLE2 = 0x061018
INDY_SHM_ROBOT_ADDR_EMERG_ARG_DOUBLE3 = 0x061020
INDY_SHM_ROBOT_ADDR_EMERG_TIME = 0x061028
INDY_SHM_ROBOT_ADDR_EMERG_MSG = 0x061030  # 256

INDY_SHM_ROBOT_ADDR_STATE_STRUCT_DATA = 0x062000
INDY_SHM_ROBOT_ADDR_STATE_TASK_RUNNING = 0x062000
INDY_SHM_ROBOT_ADDR_STATE_CADKIT_CONNECTED = 0x062001
INDY_SHM_ROBOT_ADDR_STATE_CONTY_CONNECTED = 0x062002
INDY_SHM_ROBOT_ADDR_STATE_SCRIPT_RUNNING = 0x062003
INDY_SHM_ROBOT_ADDR_STATE_INDYEYE_CONNECTED = 0x062004
INDY_SHM_ROBOT_ADDR_STATE_TOOL_CONNECTED = 0x062005
INDY_SHM_ROBOT_ADDR_STATE_DEBUG_MODE = 0x062006
INDY_SHM_ROBOT_ADDR_STATE_PROGRAM_MODE = 0x062007
INDY_SHM_ROBOT_ADDR_STATE_PROGRAM_STATE = 0x062008

INDY_SHM_ROBOT_ADDR_CTRL_STATUS_STRUCT_DATA = 0x063000
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_READY = 0x063000
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_EMERGENCY = 0x063001  # Violation
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_COLLISION = 0x063002
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_ERROR = 0x063003  # Emergency pushed
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_BUSY = 0x063004
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_MOVE_FINISHED = 0x063005
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_HOME_REACHED = 0x063006
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_ZERO_REACHED = 0x063007
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_RESETTING = 0x063008
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_IN_TEACHING = 0x063009
INDY_SHM_ROBOT_ADDR_CTRL_STATUS_IN_DIRECT_TEACHING = 0x06300A

INDY_SHM_ROBOT_ADDR_MOTOR_STRUCT_DATA = 0x064000
INDY_SHM_ROBOT_ADDR_MOTOR_STATUS_WORD = 0x064000  # 00~13 (UINT16*10=2*10=20)
# 0x064028~0x064077 double 10 ea
INDY_SHM_ROBOT_ADDR_MOTOR_ERROR_CODE = 0x064014  # 14~27
INDY_SHM_ROBOT_ADDR_MOTOR_TEMPERATURE = 0x064028  # 28~77 (double*10=8*10=80) 
INDY_SHM_ROBOT_ADDR_MOTOR_CURRENT = 0x064078  # 28~C7 (double*10=8*10=80)

INDY_SHM_ROBOT_ADDR_INFO_STRUCT_DATA = 0x065000
INDY_SHM_ROBOT_ADDR_INFO_MODEL = 0x065000  # 256byte
INDY_SHM_ROBOT_ADDR_INFO_BUILD_VERSION = 0x065100  # 128byte
INDY_SHM_ROBOT_ADDR_INFO_BUILD_DATE = 0x065180  # 128byte
INDY_SHM_ROBOT_ADDR_INFO_ROBOT_SN = 0x065200  # 128byte
INDY_SHM_ROBOT_ADDR_INFO_CONTROL_BOX_SN = 0x065280  # 128byte
INDY_SHM_ROBOT_ADDR_INFO_STEP_SN = 0x065300  # 128byte
INDY_SHM_ROBOT_ADDR_INFO_MOTOR_VERSION = 0x065380  # 256*10 byte
INDY_SHM_ROBOT_ADDR_INFO_ZERO_POSITION = 0x065D80  # 8*10 byte
INDY_SHM_ROBOT_ADDR_INFO_SUBSYS_NUM_BODIES = 0x065DD0  # 4byte
INDY_SHM_ROBOT_ADDR_INFO_SUBSYS_NUM_JOINTS = 0x065DD4  # 4byte
INDY_SHM_ROBOT_ADDR_INFO_SUBSYS_JOINT_DOF = 0x065DD8  # 4byte

INDY_SHM_ROBOT_ADDR_INDYCARE_STATE_STRUCT_DATA = 0x068000
INDY_SHM_ROBOT_ADDR_INDYCARE_STATE_REPORTER_RUNNING = 0x068000  # 1byte
INDY_SHM_ROBOT_ADDR_INDYCARE_STATE_SERVER_CONNECTED = 0x068001  # 1byte

INDY_SHM_ROBOT_ADDR_CONFIG_STRUCT_DATA = 0x070000
INDY_SHM_ROBOT_ADDR_CONFIG_JMOVE_WAYPOINT_TIME = 0x070000  # 8byte
INDY_SHM_ROBOT_ADDR_CONFIG_TMOVE_WAYPOINT_TIME = 0x070008  # 8byte
INDY_SHM_ROBOT_ADDR_CONFIG_JMOVE_VEL_LEVEL = 0x070010  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_JMOVE_ACC_LEVEL = 0x070014  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_TMOVE_VEL_LEVEL = 0x070018  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_TMOVE_ACC_LEVEL = 0x07001C  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_COLLISION_LEVEL = 0x070020  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_REFFRAME_TYPE = 0x070024  # 4byte
INDY_SHM_ROBOT_ADDR_CONFIG_TOOL_PROPERTY = 0x070028  # 8*4=32byte
INDY_SHM_ROBOT_ADDR_CONFIG_TCP_DEFAULT = 0x070048  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CONFIG_TCP_COMP = 0x070078  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CONFIG_REFFRAME_TREF = 0x0700A8  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CONFIG_REFFRAME_POINTS = 0x0700D8  # 8*3*3=72byte
INDY_SHM_ROBOT_ADDR_CONFIG_JOINT_HOME = 0x070120  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CONFIG_TASK_HOME = 0x070170  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CONFIG_JOINT_BLEND_RADIUS = 0x0701A0  # 8byte
INDY_SHM_ROBOT_ADDR_CONFIG_TASK_BLEND_RADIUS = 0x0701A8  # 8byte
INDY_SHM_ROBOT_ADDR_CONFIG_ROBOT_MOUNT_ANGLE = 0x0701B0  # 8*2=16byte

INDY_SHM_ROBOT_ADDR_CONFIG_USER_STRUCT_DATA = 0x072000

INDY_SHM_ROBOT_ADDR_CTRL_STRUCT_DATA = 0x080000
INDY_SHM_ROBOT_ADDR_CTRL_TIME = 0x080000  # 8byte
INDY_SHM_ROBOT_ADDR_CTRL_CMODE = 0x080008  # 4byte
INDY_SHM_ROBOT_ADDR_CTRL_TCP_MODE = 0x08000C  # 4byte

INDY_SHM_ROBOT_ADDR_CTRL_Q = 0x080010  # 8*10=80byte (0x50)
INDY_SHM_ROBOT_ADDR_CTRL_QDOT = 0x080060  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_TAU_ACT = 0x0800B0  # 8*10=80byte

INDY_SHM_ROBOT_ADDR_CTRL_QD = 0x080100  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_QDOT_DES = 0x080150  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_QDOT_REF = 0x0801A0  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_QDDOT = 0x0801F0  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_QDDOT_DES = 0x080240  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_QDDOT_REF = 0x080290  # 8*10=80byte

INDY_SHM_ROBOT_ADDR_CTRL_P = 0x0802E0  # 8*6=48byte (0x30)
INDY_SHM_ROBOT_ADDR_CTRL_PD = 0x080310  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDOT = 0x080340  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDOT_DES = 0x080370  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDOT_REF = 0x0803A0  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDDOT = 0x0803D0  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDDOT_DES = 0x080400  # 8*6=48byte
INDY_SHM_ROBOT_ADDR_CTRL_PDDOT_REF = 0x080430  # 8*6=48byte

INDY_SHM_ROBOT_ADDR_CTRL_TAU = 0x080460  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_TAU_EXT = 0x0804B0  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_TAU_GRAV = 0x080500  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_TAU_IDYN = 0x080550  # 8*10=80byte
INDY_SHM_ROBOT_ADDR_CTRL_TAU_REF = 0x0805A0  # 8*10=80byte

INDY_SHM_ROBOT_ADDR_CTRL_FEXT = 0x0805F0  # 8*6=48byte

INDY_SHM_ROBOT_ADDR_CTRL_MOTOR_STATES = 0x080620  # 4*10=40byte
INDY_SHM_ROBOT_ADDR_CTRL_MOTOR_BRAKES = 0x080648  # 4*10=40byte

INDY_SHM_ROBOT_ADDR_LOGGING_EVENT_ON = 0x09F000  # 1byte
INDY_SHM_ROBOT_ADDR_FRIC_ID_LOGGING_TRIGGER = 0x09F002  # 4byte

# 8bit Server SHM
INDY_SHM_SERVER_ADDR8_XXX = 0x100000

# 16bit Server SHM
# 0x120000 ~

# 32bit Server SHM
INDY_SHM_SERVER_ADDR32_VAL_CUR_CTRL_MODE = 0x140000
INDY_SHM_SERVER_ADDR32_EVENT_CODE = 0x140004

# 64bit Server SHM
INDY_SHM_SERVER_ADDR64_VAL_CUR_TIME = 0x180000

# Custom-bit Server SHM */
INDY_SHM_SERVER_ADDRCUST_EVENT_EMERGENCY = 0x200000  # for extendibility
INDY_SHM_SERVER_ADDRCUST_EVENT_REALTIME = 0x200100
INDY_SHM_SERVER_ADDRCUST_EVENT_ROBOT_STATUS = 0x200200
INDY_SHM_SERVER_ADDRCUST_EVENT_CTRL_STATUS = 0x200300
INDY_SHM_SERVER_ADDRCUST_EVENT_CTRL = 0x200400
INDY_SHM_SERVER_ADDRCUST_EVENT_PROGRAM = 0x200500
INDY_SHM_SERVER_ADDRCUST_EVENT_GENERAL = 0x200600

INDY_SHM_SERVER_ADDRCUST_SMART_DI = 0x380000  # 00~1F (32*1)
INDY_SHM_SERVER_ADDRCUST_SMART_DO = 0x380020  # 20~3F (32*1)
INDY_SHM_SERVER_ADDRCUST_SMART_AI = 0x380040  # 40~47 (4*2)
INDY_SHM_SERVER_ADDRCUST_SMART_AO = 0x380048  # 48~4F (4*2)

INDY_SHM_SERVER_ADDRCUST_ENDTOOL_DO = 0x380C00

INDY_SHM_SERVER_ADDRCUST_EXTRA_IO_DATA = 0x381000  # start
INDY_SHM_SERVER_ADDRCUST_EXTRA_IO_FTSENSOR_ROBOT_CAN_RAW = 0x381000  # 00~0B (6*2)
INDY_SHM_SERVER_ADDRCUST_EXTRA_IO_FTSENSOR_ROBOT_CAN = 0x38100C  # 0C~3B (6*8)
INDY_SHM_SERVER_ADDRCUST_EXTRA_IO_FTSENSOR_CB_CAN_RAW = 0x38103C  # 3C~47 (6*2)
INDY_SHM_SERVER_ADDRCUST_EXTRA_IO_FTSENSOR_CB_CAN = 0x381048  # 48~77 (6*8)

## Client (Command) Shared Memory
## 8bit Client SHM
INDY_SHM_CLIENT_ADDR8_CMD_SET_CTRL_MODE = 0x400000
INDY_SHM_CLIENT_ADDR8_CMD_SET_TCP_CTRL_MODE = 0x400001
INDY_SHM_CLIENT_ADDR8_CMD_SET_JMOVE_WTIME = 0x400002
INDY_SHM_CLIENT_ADDR8_CMD_SET_JMOVE_VEL = 0x400003
INDY_SHM_CLIENT_ADDR8_CMD_SET_JMOVE_ACC = 0x400004
INDY_SHM_CLIENT_ADDR8_CMD_SET_JOINT_BLEND_RAD = 0x400005
INDY_SHM_CLIENT_ADDR8_CMD_SET_JMOVE_VEL_LEVEL = 0x400006
INDY_SHM_CLIENT_ADDR8_CMD_SET_JMOVE_ACC_LEVEL = 0x400007
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_WTIME = 0x400009
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_VEL = 0x40000A
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_ACC = 0x40000B
INDY_SHM_CLIENT_ADDR8_CMD_SET_TASK_BLEND_RAD = 0x40000C
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_VEL_LEVEL = 0x40000D
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_ACC_LEVEL = 0x40000E
INDY_SHM_CLIENT_ADDR8_CMD_SET_TMOVE_BASE = 0x400010
INDY_SHM_CLIENT_ADDR8_CMD_SET_HOME_POS = 0x400011
INDY_SHM_CLIENT_ADDR8_CMD_SET_THOME_POS = 0x400012
INDY_SHM_CLIENT_ADDR8_CMD_SET_HOME_POS_CURR = 0x400013
INDY_SHM_CLIENT_ADDR8_CMD_SET_THOME_POS_CURR = 0x400014
INDY_SHM_CLIENT_ADDR8_CMD_SET_TCP_DEFAULT = 0x400015
INDY_SHM_CLIENT_ADDR8_CMD_SET_TCP_COMP = 0x400016
INDY_SHM_CLIENT_ADDR8_CMD_SET_TCP_COMP_REVOKE = 0x400017
INDY_SHM_CLIENT_ADDR8_CMD_SET_REF_FRAME_DIRECT = 0x400018
INDY_SHM_CLIENT_ADDR8_CMD_SET_COLIISION_METHOD = 0x400019
INDY_SHM_CLIENT_ADDR8_CMD_SET_COLIISION_LEVEL = 0x40001A

INDY_SHM_CLIENT_ADDR8_CMD_STOP_SLOW = 0x400100
INDY_SHM_CLIENT_ADDR8_CMD_STOP_EMERGENCY = 0x400101
INDY_SHM_CLIENT_ADDR8_CMD_RESET_SOFT = 0x400102
INDY_SHM_CLIENT_ADDR8_CMD_RESET_HARD = 0x400103
INDY_SHM_CLIENT_ADDR8_CMD_RESET_AUTO = 0x400104
INDY_SHM_CLIENT_ADDR8_CMD_STOP_SAFE = 0x400105

INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_HOME = 0x400110
INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_ZERO = 0x400111
INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_TO = 0x400112
INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_BY = 0x400113
## INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_WAYPOINT_NUM=	0x400114
INDY_SHM_CLIENT_ADDR8_CMD_JMOVE_WAYPOINT_NAME = 0x400115
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_HOME = 0x400120
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_TO_XYZUVW = 0x400121
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_TO_UVW = 0x400122
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_TO_XYZ = 0x400123
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_BY_XYZUVW = 0x400124
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_BY_UVW = 0x400125
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_BY_XYZ = 0x400126
## INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_WAYPOINT_NUM=	0x400127
INDY_SHM_CLIENT_ADDR8_CMD_TMOVE_WAYPOINT_NAME = 0x400128
INDY_SHM_CLIENT_ADDR8_CMD_EXTMOVE_BIN_FILE = 0x400129
INDY_SHM_CLIENT_ADDR8_CMD_EXTMOVE_TXT_FILE = 0x40012A
INDY_SHM_CLIENT_ADDR8_CMD_EXECUTE_COMMAND = 0x400140
INDY_SHM_CLIENT_ADDR8_CMD_SWITCH_DIRECT_TEACHING = 0x400160
INDY_SHM_CLIENT_ADDR8_CMD_FINISH_DIRECT_TEACHING = 0x400161

INDY_SHM_CLIENT_ADDR8_CMD_START_CURR_PROGRAM = 0x400200
INDY_SHM_CLIENT_ADDR8_CMD_STOP_CURR_PROGRAM = 0x400201
INDY_SHM_CLIENT_ADDR8_CMD_PAUSE_CURR_PROGRAM = 0x400202
INDY_SHM_CLIENT_ADDR8_CMD_RESUME_CURR_PROGRAM = 0x400203
INDY_SHM_CLIENT_ADDR8_CMD_START_DEFAULT_PROGRAM = 0x400204
INDY_SHM_CLIENT_ADDR8_CMD_REG_DEFAULT_PROGRAM = 0x400205

INDY_SHM_CLIENT_ADDR8_CMD_JOGMOVE_TASK = 0x400300
INDY_SHM_CLIENT_ADDR8_CMD_JOGMOVE_JOINT = 0x400301
INDY_SHM_CLIENT_ADDR8_CMD_STOP_JOGMOVE = 0x400302

INDY_SHM_CLIENT_ADDR8_CMD_SET_JWP_MOVE = 0x400310
INDY_SHM_CLIENT_ADDR8_CMD_APPEND_JWP = 0x400311
INDY_SHM_CLIENT_ADDR8_CMD_REMOVE_JWP = 0x400312
INDY_SHM_CLIENT_ADDR8_CMD_CLEAN_JWP = 0x400313
INDY_SHM_CLIENT_ADDR8_CMD_EXECUTE_JWP_MOVE = 0x400314

INDY_SHM_CLIENT_ADDR8_CMD_SET_TWP_MOVE = 0x400315
INDY_SHM_CLIENT_ADDR8_CMD_APPEND_TWP = 0x400316
INDY_SHM_CLIENT_ADDR8_CMD_REMOVE_TWP = 0x400317
INDY_SHM_CLIENT_ADDR8_CMD_CLEAN_TWP = 0x400318
INDY_SHM_CLIENT_ADDR8_CMD_EXECUTE_TWP_MOVE = 0x400319

INDY_SHM_CLIENT_ADDR8_CMD_WRITE_MODBUS_VAR = 0x40031A  # 2.4.2
INDY_SHM_CLIENT_ADDR8_CMD_READ_MODBUS_VAR = 0x40031B  # 2.4.2
INDY_SHM_CLIENT_ADDR8_CMD_READ_MODBUS_VARS = 0x40031C  # 2.4.2

# 16bit Client SHM
# 0x420000

# 32bit Client SHM
INDY_SHM_CLIENT_ADDR32_VAL_CTRL_MODE = 0x440000
INDY_SHM_CLIENT_ADDR32_VAL_TCP_CTRL_MODE = 0x440004
INDY_SHM_CLIENT_ADDR32_VAL_TMOVE_BASE = 0x440008
INDY_SHM_CLIENT_ADDR32_VAL_JMOVE_WAYPOINT_NUM = 0x44000C
INDY_SHM_CLIENT_ADDR32_VAL_TMOVE_WAYPOINT_NUM = 0x440010
INDY_SHM_CLIENT_ADDR32_VAL_JMOVE_VEL_LEVEL = 0x440014
INDY_SHM_CLIENT_ADDR32_VAL_JMOVE_ACC_LEVEL = 0x440018
INDY_SHM_CLIENT_ADDR32_VAL_TMOVE_VEL_LEVEL = 0x440020
INDY_SHM_CLIENT_ADDR32_VAL_TMOVE_ACC_LEVEL = 0x440024
INDY_SHM_CLIENT_ADDR32_VAL_COLLISION_METHOD = 0x44102C
INDY_SHM_CLIENT_ADDR32_VAL_COLLISION_LEVEL = 0x441030
INDY_SHM_CLIENT_ADDR32_VAL_REG_DEFAULT_PRGRAM_IDX = 0x442000  # 4byte

INDY_SHM_CLIENT_ADDR32_VAL_MODBUS_ADDR = 0x442004  # 2.4.2
INDY_SHM_CLIENT_ADDR32_VAL_MODBUS_DATA = 0x442008  # 2.4.2
INDY_SHM_CLIENT_ADDR32_VAL_MODBUS_LEN = 0x44200A  # 2.4.2

INDY_SHM_CLIENT_ADDR32_VAL_JOGMOVE_TASK = 0x450000  # 32byte: vel, xyzuvw, tbase
INDY_SHM_CLIENT_ADDR32_VAL_JOGMOVE_JOINT = 0x450020  # 32byte: vel, xyzuvw, tbase

INDY_SHM_CLIENT_ADDR64_VAL_JWP_WAPOINT = 0x451000  # 64byte: q0-q6
INDY_SHM_CLIENT_ADDR32_VAL_JWP_WAPOINT_OPT = 0x451040  # 32byte:
INDY_SHM_CLIENT_ADDR64_VAL_TWP_WAPOINT = 0x451060  # 64byte: xyzuvw
INDY_SHM_CLIENT_ADDR32_VAL_TWP_WAPOINT_OPT = 0x4510A0  # 32byte:

# 64bit Client SHM
INDY_SHM_CLIENT_ADDR64_VAL_JMOVE_TIME = 0x500000
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_TIME = 0x500008
INDY_SHM_CLIENT_ADDR64_VAL_STOP_SLOW_TIME = 0x500010
INDY_SHM_CLIENT_ADDR64_VAL_JMOVE_VEL_VECTOR = 0x500100  # 80byte: j0~j9
INDY_SHM_CLIENT_ADDR64_VAL_JMOVE_ACC_VECTOR = 0x500150  # 80byte: j0~j9
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_VEL_XYZUVW = 0x5001A0  # 48byte: coordinate (xyz meter, uvw deg)
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_ACC_XYZUVW = 0x5001D0  # 48byte: coordinate (xyz meter, uvw deg)
INDY_SHM_CLIENT_ADDR64_VAL_JMOVE_TO_QVECTOR = 0x500200  # 80byte: q value
INDY_SHM_CLIENT_ADDR64_VAL_JMOVE_BY_QVECTOR = 0x500250  # 80byte: q value
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_TO_XYZUVW = 0x5002A0  # 48byte: xyzuvw
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_TO_UVW = 0x5002D0  # 24byte: uvw
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_TO_XYZ = 0x5002E8  # 24byte: xyz
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_BY_XYZUVW = 0x500300  # 48byte: xyzuvw
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_BY_UVW = 0x500330  # 24byte: uvw
INDY_SHM_CLIENT_ADDR64_VAL_TMOVE_BY_XYZ = 0x500348  # 24byte: uvw
INDY_SHM_CLIENT_ADDR64_VAL_HOME_POS_QVECTOR = 0x500360  # 80byte: q value
INDY_SHM_CLIENT_ADDR64_VAL_THOME_POS_XYZUVW = 0x5003B0  # 80byte: q value
INDY_SHM_CLIENT_ADDR64_VAL_TCP_DEFAULT_XYZUVW = 0x500400  # 48byte: xyzuvw
INDY_SHM_CLIENT_ADDR64_VAL_TCP_COMP_XYZUVW = 0x500430  # 48byte: xyzuvw
INDY_SHM_CLIENT_ADDR64_VAL_REF_FRAME_DIRECT_XYZUVW = 0x500460  # 48byte: xyzuvw
INDY_SHM_CLIENT_ADDR64_VAL_JOINT_BLEND_RADIUS = 0x500490
INDY_SHM_CLIENT_ADDR64_VAL_TASK_BLEND_RADIUS = 0x500498

# Custom-bit Client SHM
INDY_SHM_CLIENT_ADDRCUST_VAL_JMOVE_WAYPOINT_NAME = 0x600000  # 0~FF, 256byte
INDY_SHM_CLIENT_ADDRCUST_VAL_TMOVE_WAYPOINT_NAME = 0x600100  # 256byte
INDY_SHM_CLIENT_ADDRCUST_VAL_EXECUTE_COMMAND_NAME = 0x600200  # 256byte
INDY_SHM_CLIENT_ADDRCUST_VAL_EXTMOVE_BIN_FILE_PATH = 0x600300  # 256byte
INDY_SHM_CLIENT_ADDRCUST_VAL_EXTMOVE_TXT_FILE_PATH = 0x600400  # 256byte

# DIrect variable SHM
# DIRECT VARIABLE (vs NAMED VARIABLE)
INDY_SHM_DIRECT_VAR_ADDR_BYTE = 0x780000  # ~0x7803E7 (1byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_WORD = 0x780400  # ~0x780BCF (2byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_DWORD = 0x781000  # ~0x781FA0 (4byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_LWORD = 0x782000  # ~0x783F40 (8byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_FLOAT = 0x784000  # ~0x784FA0 (4byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_DFLOAT = 0x785000  # ~0x786F40 (8byte * 1000)
INDY_SHM_DIRECT_VAR_ADDR_MODBUS_USER = 0x787000  # ~0x787BCF (2byte * 1000)

INDY_SHM_EL1008_DI = 0x7F0000  # 1byte
INDY_SHM_EL4104_AO = 0x7F0000  # 2byte * 4 (output1 ~ output4) INDY_SHM_EL1008_DI 와 중복되지는 않음, 나중에 조절필요
INDY_SHM_EL2008_DO = 0x7F0010  # 1byte

# System shared information
''' Size Information of Shared Memory '''
NRMK_SHM_SYSTEM_NAME = "NRMKSystemData"
NRMK_SHM_NAME = NRMK_SHM_SYSTEM_NAME
NRMK_SHM_SYSTEM_LEN = 0x8000  # 32KB
NRMK_SHM_SYSTEM_START = 0x0000
NRMK_SHM_SYSTEM_END = 0x7FFF

NRMK_SHM_SYSTEM_ADDR_OVERRUN_COUNT = 0x0028

# Indy Care Support
# INDY_SHM_ROBOT_ADDR_ERROR_CODE = 0x061000  # bool isContyConnected, bool isSCMConnected, char programState ( 0:stop, 1: run, 2: ime st)
# INDY_SHM_ROBOT_ADDR_SCM_STATE_STRUCT_DATA = 0x068000  # SCMStateData (0x068000: isReporterRuning, ~1: isServerConnected)
# NRMK_SHM_SYSTEM_ADDR_STRUCT_DATA = 0x0000

INDY_NAME_POSIX_MSG_QUEUE = '/mq_indyCARE'
# INDY_REPORTER_SHM_NAME = 'reporterShm'
