# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TacacsCommandSetArgs', 'TacacsCommandSet']

@pulumi.input_type
class TacacsCommandSetArgs:
    def __init__(__self__, *,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permit_unmatched: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TacacsCommandSet resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] name: The name of the TACACS command set
        :param pulumi.Input[_builtins.bool] permit_unmatched: Permit unmatched commands - Default value: `false`
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permit_unmatched is not None:
            pulumi.set(__self__, "permit_unmatched", permit_unmatched)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]]:
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TACACS command set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="permitUnmatched")
    def permit_unmatched(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Permit unmatched commands - Default value: `false`
        """
        return pulumi.get(self, "permit_unmatched")

    @permit_unmatched.setter
    def permit_unmatched(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permit_unmatched", value)


@pulumi.input_type
class _TacacsCommandSetState:
    def __init__(__self__, *,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permit_unmatched: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering TacacsCommandSet resources.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] name: The name of the TACACS command set
        :param pulumi.Input[_builtins.bool] permit_unmatched: Permit unmatched commands - Default value: `false`
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permit_unmatched is not None:
            pulumi.set(__self__, "permit_unmatched", permit_unmatched)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]]:
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TacacsCommandSetCommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TACACS command set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="permitUnmatched")
    def permit_unmatched(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Permit unmatched commands - Default value: `false`
        """
        return pulumi.get(self, "permit_unmatched")

    @permit_unmatched.setter
    def permit_unmatched(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permit_unmatched", value)


@pulumi.type_token("ise:deviceadmin/tacacsCommandSet:TacacsCommandSet")
class TacacsCommandSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsCommandSetCommandArgs', 'TacacsCommandSetCommandArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permit_unmatched: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a TACACS Command Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.TacacsCommandSet("example",
            name="CommandSet1",
            description="My TACACS command set",
            permit_unmatched=True,
            commands=[{
                "grant": "PERMIT",
                "command": "show",
                "arguments": "",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/tacacsCommandSet:TacacsCommandSet example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] name: The name of the TACACS command set
        :param pulumi.Input[_builtins.bool] permit_unmatched: Permit unmatched commands - Default value: `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TacacsCommandSetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TACACS Command Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.TacacsCommandSet("example",
            name="CommandSet1",
            description="My TACACS command set",
            permit_unmatched=True,
            commands=[{
                "grant": "PERMIT",
                "command": "show",
                "arguments": "",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/tacacsCommandSet:TacacsCommandSet example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param TacacsCommandSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TacacsCommandSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsCommandSetCommandArgs', 'TacacsCommandSetCommandArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permit_unmatched: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TacacsCommandSetArgs.__new__(TacacsCommandSetArgs)

            __props__.__dict__["commands"] = commands
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["permit_unmatched"] = permit_unmatched
        super(TacacsCommandSet, __self__).__init__(
            'ise:deviceadmin/tacacsCommandSet:TacacsCommandSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commands: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TacacsCommandSetCommandArgs', 'TacacsCommandSetCommandArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permit_unmatched: Optional[pulumi.Input[_builtins.bool]] = None) -> 'TacacsCommandSet':
        """
        Get an existing TacacsCommandSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] name: The name of the TACACS command set
        :param pulumi.Input[_builtins.bool] permit_unmatched: Permit unmatched commands - Default value: `false`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TacacsCommandSetState.__new__(_TacacsCommandSetState)

        __props__.__dict__["commands"] = commands
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["permit_unmatched"] = permit_unmatched
        return TacacsCommandSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> pulumi.Output[Optional[Sequence['outputs.TacacsCommandSetCommand']]]:
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the TACACS command set
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="permitUnmatched")
    def permit_unmatched(self) -> pulumi.Output[_builtins.bool]:
        """
        Permit unmatched commands - Default value: `false`
        """
        return pulumi.get(self, "permit_unmatched")

