# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 mac: pulumi.Input[_builtins.str],
                 static_group_assignment: pulumi.Input[_builtins.bool],
                 static_profile_assignment: pulumi.Input[_builtins.bool],
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_compliance_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_enrolled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_imei: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_jail_broken: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_manufacturer: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_model: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_os: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_pinlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_user: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_group_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[_builtins.str] mac: MAC address of the endpoint
        :param pulumi.Input[_builtins.bool] static_group_assignment: Static Group Assignment
        :param pulumi.Input[_builtins.bool] static_profile_assignment: Static Profile Assignment
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: Custom Attributes
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] group_id: Identity Group ID
        :param pulumi.Input[_builtins.str] identity_store: Identity Store
        :param pulumi.Input[_builtins.str] identity_store_id: Identity Store Id
        :param pulumi.Input[_builtins.bool] mdm_compliance_status: Mdm Compliance Status
        :param pulumi.Input[_builtins.bool] mdm_encrypted: Mdm Encrypted
        :param pulumi.Input[_builtins.bool] mdm_enrolled: Mdm Enrolled
        :param pulumi.Input[_builtins.str] mdm_imei: Mdm IMEI
        :param pulumi.Input[_builtins.bool] mdm_jail_broken: Mdm JailBroken
        :param pulumi.Input[_builtins.str] mdm_manufacturer: Mdm Manufacturer
        :param pulumi.Input[_builtins.str] mdm_model: Mdm Model
        :param pulumi.Input[_builtins.str] mdm_os: Mdm OS
        :param pulumi.Input[_builtins.str] mdm_phone_number: Mdm PhoneNumber
        :param pulumi.Input[_builtins.bool] mdm_pinlock: Mdm Pinlock
        :param pulumi.Input[_builtins.bool] mdm_reachable: Mdm Reachable
        :param pulumi.Input[_builtins.str] mdm_serial: Mdm Serial
        :param pulumi.Input[_builtins.str] mdm_server_name: Mdm Server Name
        :param pulumi.Input[_builtins.str] name: The name of the endpoint
        :param pulumi.Input[_builtins.str] portal_user: Portal User
        :param pulumi.Input[_builtins.str] profile_id: Profile ID
        :param pulumi.Input[_builtins.bool] static_group_assignment_defined: staticGroupAssignmentDefined - Default value: `true`
        :param pulumi.Input[_builtins.bool] static_profile_assignment_defined: Static Profile Assignment Defined - Default value: `true`
        """
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "static_group_assignment", static_group_assignment)
        pulumi.set(__self__, "static_profile_assignment", static_profile_assignment)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if identity_store is not None:
            pulumi.set(__self__, "identity_store", identity_store)
        if identity_store_id is not None:
            pulumi.set(__self__, "identity_store_id", identity_store_id)
        if mdm_compliance_status is not None:
            pulumi.set(__self__, "mdm_compliance_status", mdm_compliance_status)
        if mdm_encrypted is not None:
            pulumi.set(__self__, "mdm_encrypted", mdm_encrypted)
        if mdm_enrolled is not None:
            pulumi.set(__self__, "mdm_enrolled", mdm_enrolled)
        if mdm_imei is not None:
            pulumi.set(__self__, "mdm_imei", mdm_imei)
        if mdm_jail_broken is not None:
            pulumi.set(__self__, "mdm_jail_broken", mdm_jail_broken)
        if mdm_manufacturer is not None:
            pulumi.set(__self__, "mdm_manufacturer", mdm_manufacturer)
        if mdm_model is not None:
            pulumi.set(__self__, "mdm_model", mdm_model)
        if mdm_os is not None:
            pulumi.set(__self__, "mdm_os", mdm_os)
        if mdm_phone_number is not None:
            pulumi.set(__self__, "mdm_phone_number", mdm_phone_number)
        if mdm_pinlock is not None:
            pulumi.set(__self__, "mdm_pinlock", mdm_pinlock)
        if mdm_reachable is not None:
            pulumi.set(__self__, "mdm_reachable", mdm_reachable)
        if mdm_serial is not None:
            pulumi.set(__self__, "mdm_serial", mdm_serial)
        if mdm_server_name is not None:
            pulumi.set(__self__, "mdm_server_name", mdm_server_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if portal_user is not None:
            pulumi.set(__self__, "portal_user", portal_user)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if static_group_assignment_defined is not None:
            pulumi.set(__self__, "static_group_assignment_defined", static_group_assignment_defined)
        if static_profile_assignment_defined is not None:
            pulumi.set(__self__, "static_profile_assignment_defined", static_profile_assignment_defined)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> pulumi.Input[_builtins.str]:
        """
        MAC address of the endpoint
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignment")
    def static_group_assignment(self) -> pulumi.Input[_builtins.bool]:
        """
        Static Group Assignment
        """
        return pulumi.get(self, "static_group_assignment")

    @static_group_assignment.setter
    def static_group_assignment(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "static_group_assignment", value)

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignment")
    def static_profile_assignment(self) -> pulumi.Input[_builtins.bool]:
        """
        Static Profile Assignment
        """
        return pulumi.get(self, "static_profile_assignment")

    @static_profile_assignment.setter
    def static_profile_assignment(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "static_profile_assignment", value)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom Attributes
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Group ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="identityStore")
    def identity_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Store
        """
        return pulumi.get(self, "identity_store")

    @identity_store.setter
    def identity_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_store", value)

    @_builtins.property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Store Id
        """
        return pulumi.get(self, "identity_store_id")

    @identity_store_id.setter
    def identity_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_store_id", value)

    @_builtins.property
    @pulumi.getter(name="mdmComplianceStatus")
    def mdm_compliance_status(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Compliance Status
        """
        return pulumi.get(self, "mdm_compliance_status")

    @mdm_compliance_status.setter
    def mdm_compliance_status(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_compliance_status", value)

    @_builtins.property
    @pulumi.getter(name="mdmEncrypted")
    def mdm_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Encrypted
        """
        return pulumi.get(self, "mdm_encrypted")

    @mdm_encrypted.setter
    def mdm_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="mdmEnrolled")
    def mdm_enrolled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Enrolled
        """
        return pulumi.get(self, "mdm_enrolled")

    @mdm_enrolled.setter
    def mdm_enrolled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_enrolled", value)

    @_builtins.property
    @pulumi.getter(name="mdmImei")
    def mdm_imei(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm IMEI
        """
        return pulumi.get(self, "mdm_imei")

    @mdm_imei.setter
    def mdm_imei(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_imei", value)

    @_builtins.property
    @pulumi.getter(name="mdmJailBroken")
    def mdm_jail_broken(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm JailBroken
        """
        return pulumi.get(self, "mdm_jail_broken")

    @mdm_jail_broken.setter
    def mdm_jail_broken(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_jail_broken", value)

    @_builtins.property
    @pulumi.getter(name="mdmManufacturer")
    def mdm_manufacturer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Manufacturer
        """
        return pulumi.get(self, "mdm_manufacturer")

    @mdm_manufacturer.setter
    def mdm_manufacturer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_manufacturer", value)

    @_builtins.property
    @pulumi.getter(name="mdmModel")
    def mdm_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Model
        """
        return pulumi.get(self, "mdm_model")

    @mdm_model.setter
    def mdm_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_model", value)

    @_builtins.property
    @pulumi.getter(name="mdmOs")
    def mdm_os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm OS
        """
        return pulumi.get(self, "mdm_os")

    @mdm_os.setter
    def mdm_os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_os", value)

    @_builtins.property
    @pulumi.getter(name="mdmPhoneNumber")
    def mdm_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm PhoneNumber
        """
        return pulumi.get(self, "mdm_phone_number")

    @mdm_phone_number.setter
    def mdm_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="mdmPinlock")
    def mdm_pinlock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Pinlock
        """
        return pulumi.get(self, "mdm_pinlock")

    @mdm_pinlock.setter
    def mdm_pinlock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_pinlock", value)

    @_builtins.property
    @pulumi.getter(name="mdmReachable")
    def mdm_reachable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Reachable
        """
        return pulumi.get(self, "mdm_reachable")

    @mdm_reachable.setter
    def mdm_reachable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_reachable", value)

    @_builtins.property
    @pulumi.getter(name="mdmSerial")
    def mdm_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Serial
        """
        return pulumi.get(self, "mdm_serial")

    @mdm_serial.setter
    def mdm_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_serial", value)

    @_builtins.property
    @pulumi.getter(name="mdmServerName")
    def mdm_server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Server Name
        """
        return pulumi.get(self, "mdm_server_name")

    @mdm_server_name.setter
    def mdm_server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_server_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portalUser")
    def portal_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Portal User
        """
        return pulumi.get(self, "portal_user")

    @portal_user.setter
    def portal_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_user", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile ID
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignmentDefined")
    def static_group_assignment_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        staticGroupAssignmentDefined - Default value: `true`
        """
        return pulumi.get(self, "static_group_assignment_defined")

    @static_group_assignment_defined.setter
    def static_group_assignment_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_group_assignment_defined", value)

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignmentDefined")
    def static_profile_assignment_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Static Profile Assignment Defined - Default value: `true`
        """
        return pulumi.get(self, "static_profile_assignment_defined")

    @static_profile_assignment_defined.setter
    def static_profile_assignment_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_profile_assignment_defined", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_compliance_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_enrolled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_imei: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_jail_broken: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_manufacturer: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_model: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_os: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_pinlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_user: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_group_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_group_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: Custom Attributes
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] group_id: Identity Group ID
        :param pulumi.Input[_builtins.str] identity_store: Identity Store
        :param pulumi.Input[_builtins.str] identity_store_id: Identity Store Id
        :param pulumi.Input[_builtins.str] mac: MAC address of the endpoint
        :param pulumi.Input[_builtins.bool] mdm_compliance_status: Mdm Compliance Status
        :param pulumi.Input[_builtins.bool] mdm_encrypted: Mdm Encrypted
        :param pulumi.Input[_builtins.bool] mdm_enrolled: Mdm Enrolled
        :param pulumi.Input[_builtins.str] mdm_imei: Mdm IMEI
        :param pulumi.Input[_builtins.bool] mdm_jail_broken: Mdm JailBroken
        :param pulumi.Input[_builtins.str] mdm_manufacturer: Mdm Manufacturer
        :param pulumi.Input[_builtins.str] mdm_model: Mdm Model
        :param pulumi.Input[_builtins.str] mdm_os: Mdm OS
        :param pulumi.Input[_builtins.str] mdm_phone_number: Mdm PhoneNumber
        :param pulumi.Input[_builtins.bool] mdm_pinlock: Mdm Pinlock
        :param pulumi.Input[_builtins.bool] mdm_reachable: Mdm Reachable
        :param pulumi.Input[_builtins.str] mdm_serial: Mdm Serial
        :param pulumi.Input[_builtins.str] mdm_server_name: Mdm Server Name
        :param pulumi.Input[_builtins.str] name: The name of the endpoint
        :param pulumi.Input[_builtins.str] portal_user: Portal User
        :param pulumi.Input[_builtins.str] profile_id: Profile ID
        :param pulumi.Input[_builtins.bool] static_group_assignment: Static Group Assignment
        :param pulumi.Input[_builtins.bool] static_group_assignment_defined: staticGroupAssignmentDefined - Default value: `true`
        :param pulumi.Input[_builtins.bool] static_profile_assignment: Static Profile Assignment
        :param pulumi.Input[_builtins.bool] static_profile_assignment_defined: Static Profile Assignment Defined - Default value: `true`
        """
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if identity_store is not None:
            pulumi.set(__self__, "identity_store", identity_store)
        if identity_store_id is not None:
            pulumi.set(__self__, "identity_store_id", identity_store_id)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if mdm_compliance_status is not None:
            pulumi.set(__self__, "mdm_compliance_status", mdm_compliance_status)
        if mdm_encrypted is not None:
            pulumi.set(__self__, "mdm_encrypted", mdm_encrypted)
        if mdm_enrolled is not None:
            pulumi.set(__self__, "mdm_enrolled", mdm_enrolled)
        if mdm_imei is not None:
            pulumi.set(__self__, "mdm_imei", mdm_imei)
        if mdm_jail_broken is not None:
            pulumi.set(__self__, "mdm_jail_broken", mdm_jail_broken)
        if mdm_manufacturer is not None:
            pulumi.set(__self__, "mdm_manufacturer", mdm_manufacturer)
        if mdm_model is not None:
            pulumi.set(__self__, "mdm_model", mdm_model)
        if mdm_os is not None:
            pulumi.set(__self__, "mdm_os", mdm_os)
        if mdm_phone_number is not None:
            pulumi.set(__self__, "mdm_phone_number", mdm_phone_number)
        if mdm_pinlock is not None:
            pulumi.set(__self__, "mdm_pinlock", mdm_pinlock)
        if mdm_reachable is not None:
            pulumi.set(__self__, "mdm_reachable", mdm_reachable)
        if mdm_serial is not None:
            pulumi.set(__self__, "mdm_serial", mdm_serial)
        if mdm_server_name is not None:
            pulumi.set(__self__, "mdm_server_name", mdm_server_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if portal_user is not None:
            pulumi.set(__self__, "portal_user", portal_user)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if static_group_assignment is not None:
            pulumi.set(__self__, "static_group_assignment", static_group_assignment)
        if static_group_assignment_defined is not None:
            pulumi.set(__self__, "static_group_assignment_defined", static_group_assignment_defined)
        if static_profile_assignment is not None:
            pulumi.set(__self__, "static_profile_assignment", static_profile_assignment)
        if static_profile_assignment_defined is not None:
            pulumi.set(__self__, "static_profile_assignment_defined", static_profile_assignment_defined)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom Attributes
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Group ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="identityStore")
    def identity_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Store
        """
        return pulumi.get(self, "identity_store")

    @identity_store.setter
    def identity_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_store", value)

    @_builtins.property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Store Id
        """
        return pulumi.get(self, "identity_store_id")

    @identity_store_id.setter
    def identity_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_store_id", value)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of the endpoint
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter(name="mdmComplianceStatus")
    def mdm_compliance_status(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Compliance Status
        """
        return pulumi.get(self, "mdm_compliance_status")

    @mdm_compliance_status.setter
    def mdm_compliance_status(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_compliance_status", value)

    @_builtins.property
    @pulumi.getter(name="mdmEncrypted")
    def mdm_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Encrypted
        """
        return pulumi.get(self, "mdm_encrypted")

    @mdm_encrypted.setter
    def mdm_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="mdmEnrolled")
    def mdm_enrolled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Enrolled
        """
        return pulumi.get(self, "mdm_enrolled")

    @mdm_enrolled.setter
    def mdm_enrolled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_enrolled", value)

    @_builtins.property
    @pulumi.getter(name="mdmImei")
    def mdm_imei(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm IMEI
        """
        return pulumi.get(self, "mdm_imei")

    @mdm_imei.setter
    def mdm_imei(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_imei", value)

    @_builtins.property
    @pulumi.getter(name="mdmJailBroken")
    def mdm_jail_broken(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm JailBroken
        """
        return pulumi.get(self, "mdm_jail_broken")

    @mdm_jail_broken.setter
    def mdm_jail_broken(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_jail_broken", value)

    @_builtins.property
    @pulumi.getter(name="mdmManufacturer")
    def mdm_manufacturer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Manufacturer
        """
        return pulumi.get(self, "mdm_manufacturer")

    @mdm_manufacturer.setter
    def mdm_manufacturer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_manufacturer", value)

    @_builtins.property
    @pulumi.getter(name="mdmModel")
    def mdm_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Model
        """
        return pulumi.get(self, "mdm_model")

    @mdm_model.setter
    def mdm_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_model", value)

    @_builtins.property
    @pulumi.getter(name="mdmOs")
    def mdm_os(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm OS
        """
        return pulumi.get(self, "mdm_os")

    @mdm_os.setter
    def mdm_os(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_os", value)

    @_builtins.property
    @pulumi.getter(name="mdmPhoneNumber")
    def mdm_phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm PhoneNumber
        """
        return pulumi.get(self, "mdm_phone_number")

    @mdm_phone_number.setter
    def mdm_phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_phone_number", value)

    @_builtins.property
    @pulumi.getter(name="mdmPinlock")
    def mdm_pinlock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Pinlock
        """
        return pulumi.get(self, "mdm_pinlock")

    @mdm_pinlock.setter
    def mdm_pinlock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_pinlock", value)

    @_builtins.property
    @pulumi.getter(name="mdmReachable")
    def mdm_reachable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Mdm Reachable
        """
        return pulumi.get(self, "mdm_reachable")

    @mdm_reachable.setter
    def mdm_reachable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mdm_reachable", value)

    @_builtins.property
    @pulumi.getter(name="mdmSerial")
    def mdm_serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Serial
        """
        return pulumi.get(self, "mdm_serial")

    @mdm_serial.setter
    def mdm_serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_serial", value)

    @_builtins.property
    @pulumi.getter(name="mdmServerName")
    def mdm_server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mdm Server Name
        """
        return pulumi.get(self, "mdm_server_name")

    @mdm_server_name.setter
    def mdm_server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mdm_server_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portalUser")
    def portal_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Portal User
        """
        return pulumi.get(self, "portal_user")

    @portal_user.setter
    def portal_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_user", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile ID
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignment")
    def static_group_assignment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Static Group Assignment
        """
        return pulumi.get(self, "static_group_assignment")

    @static_group_assignment.setter
    def static_group_assignment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_group_assignment", value)

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignmentDefined")
    def static_group_assignment_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        staticGroupAssignmentDefined - Default value: `true`
        """
        return pulumi.get(self, "static_group_assignment_defined")

    @static_group_assignment_defined.setter
    def static_group_assignment_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_group_assignment_defined", value)

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignment")
    def static_profile_assignment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Static Profile Assignment
        """
        return pulumi.get(self, "static_profile_assignment")

    @static_profile_assignment.setter
    def static_profile_assignment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_profile_assignment", value)

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignmentDefined")
    def static_profile_assignment_defined(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Static Profile Assignment Defined - Default value: `true`
        """
        return pulumi.get(self, "static_profile_assignment_defined")

    @static_profile_assignment_defined.setter
    def static_profile_assignment_defined(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "static_profile_assignment_defined", value)


@pulumi.type_token("ise:identitymanagement/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_compliance_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_enrolled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_imei: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_jail_broken: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_manufacturer: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_model: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_os: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_pinlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_user: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_group_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_group_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage an Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.Endpoint("example",
            name="00:11:22:33:44:55",
            description="My endpoint",
            mac="00:11:22:33:44:55",
            group_id="3a88eec0-8c00-11e6-996c-525400b48521",
            profile_id="3a91a150-8c00-11e6-996c-525400b48521",
            static_profile_assignment=True,
            static_profile_assignment_defined=True,
            static_group_assignment=True,
            static_group_assignment_defined=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/endpoint:Endpoint example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: Custom Attributes
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] group_id: Identity Group ID
        :param pulumi.Input[_builtins.str] identity_store: Identity Store
        :param pulumi.Input[_builtins.str] identity_store_id: Identity Store Id
        :param pulumi.Input[_builtins.str] mac: MAC address of the endpoint
        :param pulumi.Input[_builtins.bool] mdm_compliance_status: Mdm Compliance Status
        :param pulumi.Input[_builtins.bool] mdm_encrypted: Mdm Encrypted
        :param pulumi.Input[_builtins.bool] mdm_enrolled: Mdm Enrolled
        :param pulumi.Input[_builtins.str] mdm_imei: Mdm IMEI
        :param pulumi.Input[_builtins.bool] mdm_jail_broken: Mdm JailBroken
        :param pulumi.Input[_builtins.str] mdm_manufacturer: Mdm Manufacturer
        :param pulumi.Input[_builtins.str] mdm_model: Mdm Model
        :param pulumi.Input[_builtins.str] mdm_os: Mdm OS
        :param pulumi.Input[_builtins.str] mdm_phone_number: Mdm PhoneNumber
        :param pulumi.Input[_builtins.bool] mdm_pinlock: Mdm Pinlock
        :param pulumi.Input[_builtins.bool] mdm_reachable: Mdm Reachable
        :param pulumi.Input[_builtins.str] mdm_serial: Mdm Serial
        :param pulumi.Input[_builtins.str] mdm_server_name: Mdm Server Name
        :param pulumi.Input[_builtins.str] name: The name of the endpoint
        :param pulumi.Input[_builtins.str] portal_user: Portal User
        :param pulumi.Input[_builtins.str] profile_id: Profile ID
        :param pulumi.Input[_builtins.bool] static_group_assignment: Static Group Assignment
        :param pulumi.Input[_builtins.bool] static_group_assignment_defined: staticGroupAssignmentDefined - Default value: `true`
        :param pulumi.Input[_builtins.bool] static_profile_assignment: Static Profile Assignment
        :param pulumi.Input[_builtins.bool] static_profile_assignment_defined: Static Profile Assignment Defined - Default value: `true`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage an Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.Endpoint("example",
            name="00:11:22:33:44:55",
            description="My endpoint",
            mac="00:11:22:33:44:55",
            group_id="3a88eec0-8c00-11e6-996c-525400b48521",
            profile_id="3a91a150-8c00-11e6-996c-525400b48521",
            static_profile_assignment=True,
            static_profile_assignment_defined=True,
            static_group_assignment=True,
            static_group_assignment_defined=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:identitymanagement/endpoint:Endpoint example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_compliance_status: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_enrolled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_imei: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_jail_broken: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_manufacturer: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_model: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_os: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_pinlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
                 mdm_serial: Optional[pulumi.Input[_builtins.str]] = None,
                 mdm_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_user: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 static_group_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_group_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
                 static_profile_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["identity_store"] = identity_store
            __props__.__dict__["identity_store_id"] = identity_store_id
            if mac is None and not opts.urn:
                raise TypeError("Missing required property 'mac'")
            __props__.__dict__["mac"] = mac
            __props__.__dict__["mdm_compliance_status"] = mdm_compliance_status
            __props__.__dict__["mdm_encrypted"] = mdm_encrypted
            __props__.__dict__["mdm_enrolled"] = mdm_enrolled
            __props__.__dict__["mdm_imei"] = mdm_imei
            __props__.__dict__["mdm_jail_broken"] = mdm_jail_broken
            __props__.__dict__["mdm_manufacturer"] = mdm_manufacturer
            __props__.__dict__["mdm_model"] = mdm_model
            __props__.__dict__["mdm_os"] = mdm_os
            __props__.__dict__["mdm_phone_number"] = mdm_phone_number
            __props__.__dict__["mdm_pinlock"] = mdm_pinlock
            __props__.__dict__["mdm_reachable"] = mdm_reachable
            __props__.__dict__["mdm_serial"] = mdm_serial
            __props__.__dict__["mdm_server_name"] = mdm_server_name
            __props__.__dict__["name"] = name
            __props__.__dict__["portal_user"] = portal_user
            __props__.__dict__["profile_id"] = profile_id
            if static_group_assignment is None and not opts.urn:
                raise TypeError("Missing required property 'static_group_assignment'")
            __props__.__dict__["static_group_assignment"] = static_group_assignment
            __props__.__dict__["static_group_assignment_defined"] = static_group_assignment_defined
            if static_profile_assignment is None and not opts.urn:
                raise TypeError("Missing required property 'static_profile_assignment'")
            __props__.__dict__["static_profile_assignment"] = static_profile_assignment
            __props__.__dict__["static_profile_assignment_defined"] = static_profile_assignment_defined
        super(Endpoint, __self__).__init__(
            'ise:identitymanagement/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity_store: Optional[pulumi.Input[_builtins.str]] = None,
            identity_store_id: Optional[pulumi.Input[_builtins.str]] = None,
            mac: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_compliance_status: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_enrolled: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_imei: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_jail_broken: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_manufacturer: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_model: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_os: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_pinlock: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_reachable: Optional[pulumi.Input[_builtins.bool]] = None,
            mdm_serial: Optional[pulumi.Input[_builtins.str]] = None,
            mdm_server_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            portal_user: Optional[pulumi.Input[_builtins.str]] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            static_group_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
            static_group_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None,
            static_profile_assignment: Optional[pulumi.Input[_builtins.bool]] = None,
            static_profile_assignment_defined: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_attributes: Custom Attributes
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] group_id: Identity Group ID
        :param pulumi.Input[_builtins.str] identity_store: Identity Store
        :param pulumi.Input[_builtins.str] identity_store_id: Identity Store Id
        :param pulumi.Input[_builtins.str] mac: MAC address of the endpoint
        :param pulumi.Input[_builtins.bool] mdm_compliance_status: Mdm Compliance Status
        :param pulumi.Input[_builtins.bool] mdm_encrypted: Mdm Encrypted
        :param pulumi.Input[_builtins.bool] mdm_enrolled: Mdm Enrolled
        :param pulumi.Input[_builtins.str] mdm_imei: Mdm IMEI
        :param pulumi.Input[_builtins.bool] mdm_jail_broken: Mdm JailBroken
        :param pulumi.Input[_builtins.str] mdm_manufacturer: Mdm Manufacturer
        :param pulumi.Input[_builtins.str] mdm_model: Mdm Model
        :param pulumi.Input[_builtins.str] mdm_os: Mdm OS
        :param pulumi.Input[_builtins.str] mdm_phone_number: Mdm PhoneNumber
        :param pulumi.Input[_builtins.bool] mdm_pinlock: Mdm Pinlock
        :param pulumi.Input[_builtins.bool] mdm_reachable: Mdm Reachable
        :param pulumi.Input[_builtins.str] mdm_serial: Mdm Serial
        :param pulumi.Input[_builtins.str] mdm_server_name: Mdm Server Name
        :param pulumi.Input[_builtins.str] name: The name of the endpoint
        :param pulumi.Input[_builtins.str] portal_user: Portal User
        :param pulumi.Input[_builtins.str] profile_id: Profile ID
        :param pulumi.Input[_builtins.bool] static_group_assignment: Static Group Assignment
        :param pulumi.Input[_builtins.bool] static_group_assignment_defined: staticGroupAssignmentDefined - Default value: `true`
        :param pulumi.Input[_builtins.bool] static_profile_assignment: Static Profile Assignment
        :param pulumi.Input[_builtins.bool] static_profile_assignment_defined: Static Profile Assignment Defined - Default value: `true`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["identity_store"] = identity_store
        __props__.__dict__["identity_store_id"] = identity_store_id
        __props__.__dict__["mac"] = mac
        __props__.__dict__["mdm_compliance_status"] = mdm_compliance_status
        __props__.__dict__["mdm_encrypted"] = mdm_encrypted
        __props__.__dict__["mdm_enrolled"] = mdm_enrolled
        __props__.__dict__["mdm_imei"] = mdm_imei
        __props__.__dict__["mdm_jail_broken"] = mdm_jail_broken
        __props__.__dict__["mdm_manufacturer"] = mdm_manufacturer
        __props__.__dict__["mdm_model"] = mdm_model
        __props__.__dict__["mdm_os"] = mdm_os
        __props__.__dict__["mdm_phone_number"] = mdm_phone_number
        __props__.__dict__["mdm_pinlock"] = mdm_pinlock
        __props__.__dict__["mdm_reachable"] = mdm_reachable
        __props__.__dict__["mdm_serial"] = mdm_serial
        __props__.__dict__["mdm_server_name"] = mdm_server_name
        __props__.__dict__["name"] = name
        __props__.__dict__["portal_user"] = portal_user
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["static_group_assignment"] = static_group_assignment
        __props__.__dict__["static_group_assignment_defined"] = static_group_assignment_defined
        __props__.__dict__["static_profile_assignment"] = static_profile_assignment
        __props__.__dict__["static_profile_assignment_defined"] = static_profile_assignment_defined
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Custom Attributes
        """
        return pulumi.get(self, "custom_attributes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identity Group ID
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="identityStore")
    def identity_store(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identity Store
        """
        return pulumi.get(self, "identity_store")

    @_builtins.property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identity Store Id
        """
        return pulumi.get(self, "identity_store_id")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> pulumi.Output[_builtins.str]:
        """
        MAC address of the endpoint
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter(name="mdmComplianceStatus")
    def mdm_compliance_status(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm Compliance Status
        """
        return pulumi.get(self, "mdm_compliance_status")

    @_builtins.property
    @pulumi.getter(name="mdmEncrypted")
    def mdm_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm Encrypted
        """
        return pulumi.get(self, "mdm_encrypted")

    @_builtins.property
    @pulumi.getter(name="mdmEnrolled")
    def mdm_enrolled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm Enrolled
        """
        return pulumi.get(self, "mdm_enrolled")

    @_builtins.property
    @pulumi.getter(name="mdmImei")
    def mdm_imei(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm IMEI
        """
        return pulumi.get(self, "mdm_imei")

    @_builtins.property
    @pulumi.getter(name="mdmJailBroken")
    def mdm_jail_broken(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm JailBroken
        """
        return pulumi.get(self, "mdm_jail_broken")

    @_builtins.property
    @pulumi.getter(name="mdmManufacturer")
    def mdm_manufacturer(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm Manufacturer
        """
        return pulumi.get(self, "mdm_manufacturer")

    @_builtins.property
    @pulumi.getter(name="mdmModel")
    def mdm_model(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm Model
        """
        return pulumi.get(self, "mdm_model")

    @_builtins.property
    @pulumi.getter(name="mdmOs")
    def mdm_os(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm OS
        """
        return pulumi.get(self, "mdm_os")

    @_builtins.property
    @pulumi.getter(name="mdmPhoneNumber")
    def mdm_phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm PhoneNumber
        """
        return pulumi.get(self, "mdm_phone_number")

    @_builtins.property
    @pulumi.getter(name="mdmPinlock")
    def mdm_pinlock(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm Pinlock
        """
        return pulumi.get(self, "mdm_pinlock")

    @_builtins.property
    @pulumi.getter(name="mdmReachable")
    def mdm_reachable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Mdm Reachable
        """
        return pulumi.get(self, "mdm_reachable")

    @_builtins.property
    @pulumi.getter(name="mdmSerial")
    def mdm_serial(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm Serial
        """
        return pulumi.get(self, "mdm_serial")

    @_builtins.property
    @pulumi.getter(name="mdmServerName")
    def mdm_server_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mdm Server Name
        """
        return pulumi.get(self, "mdm_server_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the endpoint
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portalUser")
    def portal_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Portal User
        """
        return pulumi.get(self, "portal_user")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Profile ID
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignment")
    def static_group_assignment(self) -> pulumi.Output[_builtins.bool]:
        """
        Static Group Assignment
        """
        return pulumi.get(self, "static_group_assignment")

    @_builtins.property
    @pulumi.getter(name="staticGroupAssignmentDefined")
    def static_group_assignment_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        staticGroupAssignmentDefined - Default value: `true`
        """
        return pulumi.get(self, "static_group_assignment_defined")

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignment")
    def static_profile_assignment(self) -> pulumi.Output[_builtins.bool]:
        """
        Static Profile Assignment
        """
        return pulumi.get(self, "static_profile_assignment")

    @_builtins.property
    @pulumi.getter(name="staticProfileAssignmentDefined")
    def static_profile_assignment_defined(self) -> pulumi.Output[_builtins.bool]:
        """
        Static Profile Assignment Defined - Default value: `true`
        """
        return pulumi.get(self, "static_profile_assignment_defined")

