/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CertoraErrorType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0016\u0018\u0000 \f2\u00060\u0001j\u0002`\u0002:\u0001\fB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lutils/CertoraException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "type", "Lutils/CertoraErrorType;", "msg", "", "t", "", "(Lutils/CertoraErrorType;Ljava/lang/String;Ljava/lang/Throwable;)V", "getType", "()Lutils/CertoraErrorType;", "Companion", "Shared"})
public class CertoraException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CertoraErrorType type;

    public CertoraException(@NotNull CertoraErrorType type2, @NotNull String msg, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(msg, "msg");
        super(msg, t);
        this.type = type2;
    }

    public /* synthetic */ CertoraException(CertoraErrorType certoraErrorType, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        this(certoraErrorType, string, throwable);
    }

    @NotNull
    public final CertoraErrorType getType() {
        return this.type;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lutils/CertoraException$Companion;", "", "()V", "fromException", "Lutils/CertoraException;", "t", "", "timeoutMsg", "", "fromExceptionWithRuleName", "ruleName", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertoraException fromException(@NotNull Throwable t, @Nullable String timeoutMsg) {
            CertoraException certoraException;
            Intrinsics.checkNotNullParameter(t, "t");
            if (t instanceof CertoraException) {
                certoraException = (CertoraException)t;
            } else if (t instanceof InterruptedException || t instanceof RejectedExecutionException || t instanceof ExecutionException && t.getCause() instanceof RejectedExecutionException) {
                String string = timeoutMsg;
                if (string == null) {
                    string = "Timeout";
                }
                certoraException = new CertoraException(CertoraErrorType.TASK_TIMEOUT, string, null, 4, null);
            } else {
                Logger.Companion.alwaysError("Unknown error " + t, t);
                certoraException = new CertoraException(CertoraErrorType.UNKNOWN, "Unknown failure in Prover, please report in certora.com", t);
            }
            return certoraException;
        }

        public static /* synthetic */ CertoraException fromException$default(Companion companion, Throwable throwable, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.fromException(throwable, string);
        }

        @NotNull
        public final CertoraException fromExceptionWithRuleName(@NotNull Throwable t, @NotNull String ruleName) {
            Intrinsics.checkNotNullParameter(t, "t");
            Intrinsics.checkNotNullParameter(ruleName, "ruleName");
            return this.fromException(t, "Rule " + ruleName + " timed-out");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

