/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solver.Configuration;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lsolver/Z3SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_Z3_COMMAND", "", "alwaysOnOptions", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "clOptions", "getCmdToChangeTimelimit", "timelimit", "Ljava/time/Duration;", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "needsLogicALL", "", "features", "Lsolver/SolverConfig$LogicFeatures;", "plainConfig", "Lsolver/SolverConfig;", "incrementalMode", "readResolve", "", "supportsLogicFeatures", "GeneralUtils"})
public final class Z3SolverInfo
extends SolverInfo {
    @NotNull
    public static final Z3SolverInfo INSTANCE = new Z3SolverInfo();
    @NotNull
    private static final List<String> alwaysOnOptions = CollectionsKt.listOf("-st");
    @NotNull
    private static final String DEFAULT_Z3_COMMAND = "z3";

    private Z3SolverInfo() {
        super("Z3");
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf("-t:" + timelimit.toMillis());
    }

    @Override
    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        String[] stringArray = new String[]{"smt.random_seed=" + randomSeed, "sat.random_seed=" + randomSeed, "sat.phase=random", "smt.phase_selection=5"};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public String getCmdToChangeTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return "(set-option :timeout " + timelimit.toMillis() + ")";
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    public boolean needsLogicALL(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return features.getUsesDatatypes();
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[]{DEFAULT_Z3_COMMAND, "-in"};
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)alwaysOnOptions), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_Z3_COMMAND;
    }

    @NotNull
    public final SolverConfig plainConfig(@NotNull Duration timelimit, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return SolverConfig.copy$default((SolverConfig)Configuration.invoke$default(SolverConfig.Companion.getZ3(), null, 1, null), null, null, null, null, incrementalMode, timelimit, null, null, null, null, null, 1999, null);
    }

    public static /* synthetic */ SolverConfig plainConfig$default(Z3SolverInfo z3SolverInfo, Duration duration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return z3SolverInfo.plainConfig(duration, bl);
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

