# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCameraVideoLinkResult',
    'AwaitableGetCameraVideoLinkResult',
    'get_camera_video_link',
    'get_camera_video_link_output',
]

@pulumi.output_type
class GetCameraVideoLinkResult:
    """
    A collection of values returned by getCameraVideoLink.
    """
    def __init__(__self__, id=None, item=None, serial=None, timestamp=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if serial and not isinstance(serial, str):
            raise TypeError("Expected argument 'serial' to be a str")
        pulumi.set(__self__, "serial", serial)
        if timestamp and not isinstance(timestamp, str):
            raise TypeError("Expected argument 'timestamp' to be a str")
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetCameraVideoLinkItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter
    def serial(self) -> str:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[str]:
        """
        timestamp query parameter. [optional] The video link will start at this time. The timestamp should be a string in ISO8601 format. If no timestamp is specified, we will assume current time.
        """
        return pulumi.get(self, "timestamp")


class AwaitableGetCameraVideoLinkResult(GetCameraVideoLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCameraVideoLinkResult(
            id=self.id,
            item=self.item,
            serial=self.serial,
            timestamp=self.timestamp)


def get_camera_video_link(serial: Optional[str] = None,
                          timestamp: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCameraVideoLinkResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.devices.get_camera_video_link(serial="string",
        timestamp="string")
    pulumi.export("merakiDevicesCameraVideoLinkExample", example.item)
    ```


    :param str serial: serial path parameter.
    :param str timestamp: timestamp query parameter. [optional] The video link will start at this time. The timestamp should be a string in ISO8601 format. If no timestamp is specified, we will assume current time.
    """
    __args__ = dict()
    __args__['serial'] = serial
    __args__['timestamp'] = timestamp
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:devices/getCameraVideoLink:getCameraVideoLink', __args__, opts=opts, typ=GetCameraVideoLinkResult).value

    return AwaitableGetCameraVideoLinkResult(
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        serial=pulumi.get(__ret__, 'serial'),
        timestamp=pulumi.get(__ret__, 'timestamp'))


@_utilities.lift_output_func(get_camera_video_link)
def get_camera_video_link_output(serial: Optional[pulumi.Input[str]] = None,
                                 timestamp: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCameraVideoLinkResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.devices.get_camera_video_link(serial="string",
        timestamp="string")
    pulumi.export("merakiDevicesCameraVideoLinkExample", example.item)
    ```


    :param str serial: serial path parameter.
    :param str timestamp: timestamp query parameter. [optional] The video link will start at this time. The timestamp should be a string in ISO8601 format. If no timestamp is specified, we will assume current time.
    """
    ...
