"use strict";
const fs = require("fs");
const path = require("path");
const index_1 = require("../../lib/index");
class MyResource extends index_1.Resource {
    constructor(scope, id) {
        super(scope, id);
    }
}
function readJson(outdir, file) {
    return JSON.parse(fs.readFileSync(path.join(outdir, file), 'utf-8'));
}
module.exports = {
    'tree metadata is generated as expected'(test) {
        const app = new index_1.App();
        const stack = new index_1.Stack(app, 'mystack');
        new index_1.Construct(stack, 'group1');
        const group2 = new index_1.Construct(stack, 'group2');
        new MyResource(group2, 'resource3');
        const assembly = app.synth();
        const treeArtifact = assembly.tree();
        test.ok(treeArtifact);
        test.deepEqual(readJson(assembly.directory, treeArtifact.file), {
            version: 'tree-0.1',
            tree: {
                id: 'App',
                path: '',
                children: [
                    {
                        id: 'Tree',
                        path: 'Tree'
                    },
                    {
                        id: 'mystack',
                        path: 'mystack',
                        children: [
                            {
                                id: 'group1',
                                path: 'mystack/group1'
                            },
                            {
                                id: 'group2',
                                path: 'mystack/group2',
                                children: [
                                    { id: 'resource3', path: 'mystack/group2/resource3' }
                                ]
                            }
                        ]
                    },
                ]
            }
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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