"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const intrinsic_1 = require("./private/intrinsic");
const REFERENCE_SYMBOL = Symbol.for('@aws-cdk/core.Reference');
/**
 * An intrinsic Token that represents a reference to a construct.
 *
 * References are recorded.
 */
class Reference extends intrinsic_1.Intrinsic {
    constructor(value, target, displayName) {
        super(value);
        Object.defineProperty(this, REFERENCE_SYMBOL, { value: true });
        this.target = target;
        this.displayName = displayName || 'Reference';
    }
    /**
     * Check whether this is actually a Reference
     */
    static isReference(x) {
        return typeof x === 'object' && x !== null && REFERENCE_SYMBOL in x;
    }
}
exports.Reference = Reference;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVmZXJlbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVmZXJlbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbURBQWdEO0FBRWhELE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0FBRS9EOzs7O0dBSUc7QUFDSCxNQUFzQixTQUFVLFNBQVEscUJBQVM7SUFXL0MsWUFBWSxLQUFVLEVBQUUsTUFBa0IsRUFBRSxXQUFvQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDYixNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRSxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQy9ELElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxXQUFXLEdBQUcsV0FBVyxJQUFJLFdBQVcsQ0FBQztJQUNoRCxDQUFDO0lBZkQ7O09BRUc7SUFDSSxNQUFNLENBQUMsV0FBVyxDQUFDLENBQU07UUFDOUIsT0FBTyxPQUFPLENBQUMsS0FBSyxRQUFRLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxnQkFBZ0IsSUFBSSxDQUFDLENBQUM7SUFDdEUsQ0FBQztDQVdGO0FBakJELDhCQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEludHJpbnNpYyB9IGZyb20gXCIuL3ByaXZhdGUvaW50cmluc2ljXCI7XG5cbmNvbnN0IFJFRkVSRU5DRV9TWU1CT0wgPSBTeW1ib2wuZm9yKCdAYXdzLWNkay9jb3JlLlJlZmVyZW5jZScpO1xuXG4vKipcbiAqIEFuIGludHJpbnNpYyBUb2tlbiB0aGF0IHJlcHJlc2VudHMgYSByZWZlcmVuY2UgdG8gYSBjb25zdHJ1Y3QuXG4gKlxuICogUmVmZXJlbmNlcyBhcmUgcmVjb3JkZWQuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBSZWZlcmVuY2UgZXh0ZW5kcyBJbnRyaW5zaWMge1xuICAvKipcbiAgICogQ2hlY2sgd2hldGhlciB0aGlzIGlzIGFjdHVhbGx5IGEgUmVmZXJlbmNlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGlzUmVmZXJlbmNlKHg6IGFueSk6IHggaXMgUmVmZXJlbmNlIHtcbiAgICByZXR1cm4gdHlwZW9mIHggPT09ICdvYmplY3QnICYmIHggIT09IG51bGwgJiYgUkVGRVJFTkNFX1NZTUJPTCBpbiB4O1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IHRhcmdldDogSUNvbnN0cnVjdDtcbiAgcHVibGljIHJlYWRvbmx5IGRpc3BsYXlOYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IodmFsdWU6IGFueSwgdGFyZ2V0OiBJQ29uc3RydWN0LCBkaXNwbGF5TmFtZT86IHN0cmluZykge1xuICAgIHN1cGVyKHZhbHVlKTtcbiAgICBPYmplY3QuZGVmaW5lUHJvcGVydHkodGhpcywgUkVGRVJFTkNFX1NZTUJPTCwgeyB2YWx1ZTogdHJ1ZSB9KTtcbiAgICB0aGlzLnRhcmdldCA9IHRhcmdldDtcbiAgICB0aGlzLmRpc3BsYXlOYW1lID0gZGlzcGxheU5hbWUgfHwgJ1JlZmVyZW5jZSc7XG4gIH1cbn1cblxuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJy4vY29uc3RydWN0JztcbiJdfQ==