"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'Rule can be used to create rules'(test) {
        const stack = new lib_1.Stack();
        const rule = new lib_1.CfnRule(stack, 'MyRule');
        rule.addAssertion(lib_1.Fn.conditionEquals('lhs', 'rhs'), 'lhs equals rhs');
        rule.addAssertion(lib_1.Fn.conditionNot(lib_1.Fn.conditionAnd(lib_1.Fn.conditionContains(['hello', 'world'], "world"))), 'some assertion');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Rules: {
                MyRule: {
                    Assertions: [
                        {
                            Assert: { 'Fn::Equals': ['lhs', 'rhs'] },
                            AssertDescription: 'lhs equals rhs'
                        },
                        {
                            Assert: { 'Fn::Not': [{ 'Fn::And': [{ 'Fn::Contains': [['hello', 'world'], 'world'] }] }] },
                            AssertDescription: 'some assertion'
                        }
                    ]
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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