from json import dumps


class Description:
    def __init__(self, metric_id: str, desc: str = 'test',
                 labels: list = None, enabled: bool = False,
                 prometheus_method: str = 'gauge'):
        """
        :param metric_id: metrics identification,
                          example process_real_memory_total_bytes
        :param desc: description for metric id
        :param labels: list of all required labels, default set values are
                        ['host', 'resource_type', 'environment', 'company']
        """
        self.id = metric_id
        self.labels = ['host', 'resource_type', 'label1', 'label2', 'label3', 'label4']
        if labels is not None:
            for label in labels:
                if label not in self.labels:
                    self.labels.append(label)
        self.description = desc
        self.enabled = enabled
        self.prometheus_method = prometheus_method

    def __str__(self):
        return dumps(self.as_dict())

    def as_dict(self):
        obj = {}
        for key in self.__dict__.keys():
            value = self.__getattribute__(key)
            if type(value) is str or type(value) is list or \
                    type(value) is bool:
                obj[key] = value
        return obj
