/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2jwt.JwtKeyExchange;
import com.teradata.tdgss.jgssp2jwt.JwtTokenHdr;

public class JwtServerInfoToken {
    private JwtTokenHdr tokenHeader = null;
    private JwtKeyExchange keyExchange = null;
    private byte[] qopParcel = null;

    public JwtTokenHdr getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(JwtTokenHdr jwtTokenHdr) {
        this.tokenHeader = jwtTokenHdr;
    }

    public JwtKeyExchange getkeyExchange() {
        return this.keyExchange;
    }

    public void setkeyExchange(JwtKeyExchange jwtKeyExchange) {
        this.keyExchange = jwtKeyExchange;
    }

    public byte[] getQopParcel() {
        return this.qopParcel;
    }

    public void setQopParcel(byte[] byArray) {
        this.qopParcel = byArray;
    }

    public DER getDERObject() {
        ListArray listArray = new ListArray(DER.class);
        DER dER = new DER(1, listArray);
        if (this.tokenHeader == null) {
            throw new IllegalArgumentException("Argument tokenheader is null");
        }
        DER dER2 = this.tokenHeader.getDERObject();
        dER.add(dER2);
        if (null == this.qopParcel) {
            throw new IllegalArgumentException("Argument qopParcel is null");
        }
        dER2 = new DER(2, this.qopParcel);
        dER.add(dER2);
        dER2 = this.keyExchange.getDERObject();
        dER.add(dER2);
        return dER;
    }

    public void parseDERObject(DER dER) {
        if (1 != dER.getTagNumber()) {
            throw new IllegalArgumentException("Server Info token not  found");
        }
        DER dER2 = dER.getChildrenWithTag(0);
        if (dER2 == null) {
            throw new IllegalArgumentException("Server info Token header found");
        }
        this.tokenHeader = new JwtTokenHdr();
        this.tokenHeader.parseDERObject(dER2);
        DER dER3 = dER.getChildrenWithTag(2);
        if (dER3 == null) {
            throw new IllegalArgumentException("QOP parcel not found");
        }
        this.qopParcel = dER3.getValueAsOctetString();
        DER dER4 = dER.getChildrenWithTag(1);
        if (dER4 == null) {
            throw new IllegalArgumentException("KeyExchange not  found");
        }
        this.keyExchange = new JwtKeyExchange();
        this.keyExchange.parseDERObject(dER4);
    }
}

