import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Creates a project in GitLab
 *
 * @schema CfnProjectProps
 */
export interface CfnProjectProps {
    /**
     * The name of the project to create
     *
     * @schema CfnProjectProps#Name
     */
    readonly name: string;
    /**
     * The path of the project
     *
     * @schema CfnProjectProps#Path
     */
    readonly path?: string;
    /**
     * Whether the project should be public (default false)
     *
     * @schema CfnProjectProps#Public
     */
    readonly public?: boolean;
}
/**
 * Converts an object of type 'CfnProjectProps' to JSON representation.
 */
export declare function toJson_CfnProjectProps(obj: CfnProjectProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `GitLab::Projects::Project`
 *
 * @cloudformationResource GitLab::Projects::Project
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnProject extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::Project";
    /**
     * Resource props.
     */
    readonly props: CfnProjectProps;
    /**
     * Attribute `GitLab::Projects::Project.Id`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Create a new `GitLab::Projects::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnProjectProps);
}
