# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafRedactionArgs', 'NgwafRedaction']

@pulumi.input_type
class NgwafRedactionArgs:
    def __init__(__self__, *,
                 field: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a NgwafRedaction resource.
        :param pulumi.Input[_builtins.str] field: The name of the field that should be redacted.
        :param pulumi.Input[_builtins.str] type: The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def field(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the field that should be redacted.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _NgwafRedactionState:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafRedaction resources.
        :param pulumi.Input[_builtins.str] field: The name of the field that should be redacted.
        :param pulumi.Input[_builtins.str] type: The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the field that should be redacted.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafRedaction:NgwafRedaction")
class NgwafRedaction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Redaction, which can automatically redact known patterns of sensitive information.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_redaction = fastly.NgwafRedaction("demo_redaction",
            field="some field",
            type="request_header",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Redactions can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafRedaction:NgwafRedaction example <workspace_id>/<redaction_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] field: The name of the field that should be redacted.
        :param pulumi.Input[_builtins.str] type: The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafRedactionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Redaction, which can automatically redact known patterns of sensitive information.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_redaction = fastly.NgwafRedaction("demo_redaction",
            field="some field",
            type="request_header",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Redactions can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafRedaction:NgwafRedaction example <workspace_id>/<redaction_id>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafRedactionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafRedactionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafRedactionArgs.__new__(NgwafRedactionArgs)

            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(NgwafRedaction, __self__).__init__(
            'fastly:index/ngwafRedaction:NgwafRedaction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            field: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafRedaction':
        """
        Get an existing NgwafRedaction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] field: The name of the field that should be redacted.
        :param pulumi.Input[_builtins.str] type: The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafRedactionState.__new__(_NgwafRedactionState)

        __props__.__dict__["field"] = field
        __props__.__dict__["type"] = type
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafRedaction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def field(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the field that should be redacted.
        """
        return pulumi.get(self, "field")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of field that is being redacted. Accepted values are `request_parameter`, `request_header`, and `response_header`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

