import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlManagedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#administrator_login SqlManagedInstance#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#administrator_login_password SqlManagedInstance#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#collation SqlManagedInstance#collation}.
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#dns_zone_partner_id SqlManagedInstance#dns_zone_partner_id}.
     *
     * @stability stable
     */
    readonly dnsZonePartnerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#license_type SqlManagedInstance#license_type}.
     *
     * @stability stable
     */
    readonly licenseType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#location SqlManagedInstance#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#minimum_tls_version SqlManagedInstance#minimum_tls_version}.
     *
     * @stability stable
     */
    readonly minimumTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#name SqlManagedInstance#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#proxy_override SqlManagedInstance#proxy_override}.
     *
     * @stability stable
     */
    readonly proxyOverride?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#public_data_endpoint_enabled SqlManagedInstance#public_data_endpoint_enabled}.
     *
     * @stability stable
     */
    readonly publicDataEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#resource_group_name SqlManagedInstance#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#sku_name SqlManagedInstance#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#storage_size_in_gb SqlManagedInstance#storage_size_in_gb}.
     *
     * @stability stable
     */
    readonly storageSizeInGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#subnet_id SqlManagedInstance#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#tags SqlManagedInstance#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#timezone_id SqlManagedInstance#timezone_id}.
     *
     * @stability stable
     */
    readonly timezoneId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#vcores SqlManagedInstance#vcores}.
     *
     * @stability stable
     */
    readonly vcores: number;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#identity SqlManagedInstance#identity}
     *
     * @stability stable
     */
    readonly identity?: SqlManagedInstanceIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#timeouts SqlManagedInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlManagedInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface SqlManagedInstanceIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#type SqlManagedInstance#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function sqlManagedInstanceIdentityToTerraform(struct?: SqlManagedInstanceIdentityOutputReference | SqlManagedInstanceIdentity): any;
/**
 * @stability stable
 */
export declare class SqlManagedInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlManagedInstanceIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlManagedInstanceIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlManagedInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#create SqlManagedInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#delete SqlManagedInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#read SqlManagedInstance#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html#update SqlManagedInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlManagedInstanceTimeoutsToTerraform(struct?: SqlManagedInstanceTimeoutsOutputReference | SqlManagedInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlManagedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlManagedInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlManagedInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html azurerm_sql_managed_instance}.
 *
 * @stability stable
 */
export declare class SqlManagedInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_instance.html azurerm_sql_managed_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlManagedInstanceConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    private _dnsZonePartnerId?;
    /**
     * @stability stable
     */
    get dnsZonePartnerId(): string;
    /**
     * @stability stable
     */
    set dnsZonePartnerId(value: string);
    /**
     * @stability stable
     */
    resetDnsZonePartnerId(): void;
    /**
     * @stability stable
     */
    get dnsZonePartnerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _minimumTlsVersion?;
    /**
     * @stability stable
     */
    get minimumTlsVersion(): string;
    /**
     * @stability stable
     */
    set minimumTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinimumTlsVersion(): void;
    /**
     * @stability stable
     */
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _proxyOverride?;
    /**
     * @stability stable
     */
    get proxyOverride(): string;
    /**
     * @stability stable
     */
    set proxyOverride(value: string);
    /**
     * @stability stable
     */
    resetProxyOverride(): void;
    /**
     * @stability stable
     */
    get proxyOverrideInput(): string | undefined;
    private _publicDataEndpointEnabled?;
    /**
     * @stability stable
     */
    get publicDataEndpointEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicDataEndpointEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicDataEndpointEnabled(): void;
    /**
     * @stability stable
     */
    get publicDataEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _storageSizeInGb?;
    /**
     * @stability stable
     */
    get storageSizeInGb(): number;
    /**
     * @stability stable
     */
    set storageSizeInGb(value: number);
    /**
     * @stability stable
     */
    get storageSizeInGbInput(): number | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezoneId?;
    /**
     * @stability stable
     */
    get timezoneId(): string;
    /**
     * @stability stable
     */
    set timezoneId(value: string);
    /**
     * @stability stable
     */
    resetTimezoneId(): void;
    /**
     * @stability stable
     */
    get timezoneIdInput(): string | undefined;
    private _vcores?;
    /**
     * @stability stable
     */
    get vcores(): number;
    /**
     * @stability stable
     */
    set vcores(value: number);
    /**
     * @stability stable
     */
    get vcoresInput(): number | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): SqlManagedInstanceIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: SqlManagedInstanceIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): SqlManagedInstanceIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlManagedInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlManagedInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlManagedInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
