import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { StopDeploymentInput, StopDeploymentOutput } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link StopDeploymentCommand}.
 */
export interface StopDeploymentCommandInput extends StopDeploymentInput {
}
/**
 * @public
 *
 * The output of {@link StopDeploymentCommand}.
 */
export interface StopDeploymentCommandOutput extends StopDeploymentOutput, __MetadataBearer {
}
declare const StopDeploymentCommand_base: {
    new (input: StopDeploymentCommandInput): import("@smithy/smithy-client").CommandImpl<StopDeploymentCommandInput, StopDeploymentCommandOutput, CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: StopDeploymentCommandInput): import("@smithy/smithy-client").CommandImpl<StopDeploymentCommandInput, StopDeploymentCommandOutput, CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Attempts to stop an ongoing deployment.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, StopDeploymentCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, StopDeploymentCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // StopDeploymentInput
 *   deploymentId: "STRING_VALUE", // required
 *   autoRollbackEnabled: true || false,
 * };
 * const command = new StopDeploymentCommand(input);
 * const response = await client.send(command);
 * // { // StopDeploymentOutput
 * //   status: "Pending" || "Succeeded",
 * //   statusMessage: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param StopDeploymentCommandInput - {@link StopDeploymentCommandInput}
 * @returns {@link StopDeploymentCommandOutput}
 * @see {@link StopDeploymentCommandInput} for command's `input` shape.
 * @see {@link StopDeploymentCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link DeploymentAlreadyCompletedException} (client fault)
 *  <p>The deployment is already complete.</p>
 *
 * @throws {@link DeploymentDoesNotExistException} (client fault)
 *  <p>The deployment with the user or Amazon Web Services account does not exist.</p>
 *
 * @throws {@link DeploymentGroupDoesNotExistException} (client fault)
 *  <p>The named deployment group with the user or Amazon Web Services account does not
 *             exist.</p>
 *
 * @throws {@link DeploymentIdRequiredException} (client fault)
 *  <p>At least one deployment ID must be specified.</p>
 *
 * @throws {@link InvalidDeploymentIdException} (client fault)
 *  <p>At least one of the deployment IDs was specified in an invalid format.</p>
 *
 * @throws {@link UnsupportedActionForDeploymentTypeException} (client fault)
 *  <p>A call was submitted that is not supported for the specified deployment type.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 * @public
 */
export declare class StopDeploymentCommand extends StopDeploymentCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: StopDeploymentInput;
            output: StopDeploymentOutput;
        };
        sdk: {
            input: StopDeploymentCommandInput;
            output: StopDeploymentCommandOutput;
        };
    };
}
