(function(){suite("rb/collections/FilteredCollection",function(){var mainCollection,filteredCollection;beforeEach(function(){mainCollection=new Backbone.Collection([{id:1,label:"One",bool:true},{id:2,label:"Two",bool:false},{id:3,label:"Three",bool:true}])});describe("Initialization",function(){it("Defaults to full contents",function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(mainCollection.length)});it("Respects provided filter",function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2);expect(filteredCollection.at(0).id).toBe(2);expect(filteredCollection.at(1).id).toBe(3)})});describe("Methods",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});describe("setFilters",function(){it("With new filter",function(){filteredCollection.setFilters({label:"O"});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(1)});it("With multiple filters",function(){filteredCollection.setFilters({label:"T",bool:false});expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(2)});it("{}",function(){filteredCollection.setFilters({});expect(filteredCollection.length).toBe(3)});it("null",function(){filteredCollection.setFilters(null);expect(filteredCollection.length).toBe(3)});it("undefined",function(){filteredCollection.setFilters();expect(filteredCollection.length).toBe(3)})})});describe("Main collection events",function(){describe("With filters",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection,filters:{label:"T"}});expect(filteredCollection.length).toBe(2)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(1);expect(filteredCollection.at(0).id).toBe(11)});describe("add",function(){it("Matching filter",function(){mainCollection.add({id:4,label:"Test"});expect(filteredCollection.length).toBe(3);expect(filteredCollection.at(2).id).toBe(4)});it("Not matching filter",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(2)})});describe("remove",function(){it("Matching filter",function(){mainCollection.remove(mainCollection.get(2));expect(filteredCollection.length).toBe(1)});it("Not matching filter",function(){mainCollection.remove(mainCollection.get(0));expect(filteredCollection.length).toBe(2)})})});describe("Without filters",function(){beforeEach(function(){filteredCollection=new RB.FilteredCollection(null,{collection:mainCollection});expect(filteredCollection.length).toBe(3)});it("reset",function(){mainCollection.reset([{id:10,label:"Monday"},{id:11,label:"Tuesday"}]);expect(filteredCollection.length).toBe(2)});it("add",function(){mainCollection.add({id:4,label:"Four"});expect(filteredCollection.length).toBe(4);expect(filteredCollection.at(3).id).toBe(4)});it("remove",function(){mainCollection.remove(mainCollection.get(1));expect(filteredCollection.length).toBe(2)})})})});suite("rb/configForms/models/ResourceListItem",function(){var TestListItem,resource,listItem;TestListItem=RB.Config.ResourceListItem.extend({syncAttrs:["name","fileRegex"],createResource:function(attrs){return new RB.DefaultReviewer(attrs)}});beforeEach(function(){resource=new RB.DefaultReviewer({name:"my-name",fileRegex:".*"})});describe("Synchronizing attributes",function(){it("On resource attribute change",function(){listItem=new TestListItem({resource:resource});resource.set("name","foo");expect(listItem.get("name")).toBe("foo")});describe("On creation",function(){it("With existing resource",function(){listItem=new TestListItem({resource:resource,name:"dummy",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("my-name");expect(listItem.get("fileRegex")).toBe(".*")});it("With created resource",function(){listItem=new TestListItem({id:123,name:"new-name",fileRegex:"/foo/.*"});expect(listItem.get("name")).toBe("new-name");expect(listItem.get("fileRegex")).toBe("/foo/.*");resource=listItem.get("resource");expect(resource.id).toBe(123);expect(resource.get("name")).toBe("new-name");expect(resource.get("fileRegex")).toBe("/foo/.*")})})});describe("Event mirroring",function(){beforeEach(function(){listItem=new TestListItem({resource:resource});spyOn(listItem,"trigger")});it("destroy",function(){resource.trigger("destroy");expect(listItem.trigger).toHaveBeenCalledWith("destroy",listItem,undefined,undefined)});it("request",function(){resource.trigger("request");expect(listItem.trigger).toHaveBeenCalledWith("request")});it("sync",function(){resource.trigger("sync");expect(listItem.trigger).toHaveBeenCalledWith("sync")})})});suite("rb/diffviewer/models/DiffFile",function(){var model;beforeEach(function(){model=new RB.DiffFile});describe("parse",function(){it("API payloads",function(){var data=model.parse({binary:false,comment_counts:[1],deleted:true,depot_filename:"foo",dest_filename:"bar",filediff:{id:38,revision:2},id:28,index:3,interfilediff:{id:23,revision:4},newfile:true,revision:3});expect(data).not.toBe(undefined);expect(data.binary).toBe(false);expect(data.commentCounts).toEqual([1]);expect(data.deleted).toBe(true);expect(data.depotFilename).toBe("foo");expect(data.destFilename).toBe("bar");expect(data.filediff).not.toBe(undefined);expect(data.filediff.id).toBe(38);expect(data.filediff.revision).toBe(2);expect(data.id).toBe(28);expect(data.index).toBe(3);expect(data.interfilediff).not.toBe(undefined);expect(data.interfilediff.id).toBe(23);expect(data.interfilediff.revision).toBe(4);expect(data.newfile).toBe(true);expect(data.revision).toBe(3)})})});suite("rb/diffviewer/models/DiffReviewable",function(){var callbacks,reviewRequest;beforeEach(function(){callbacks={success:function(){},error:function(){},complete:function(){}};reviewRequest=new RB.ReviewRequest({reviewURL:"/r/1/"});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(callbacks,"complete")});describe("getRenderedDiff",function(){it("Without interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,fileIndex:4,revision:2});spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/?index=4&"+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,fileIndex:4,revision:2,interdiffRevision:3});spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3/?index=4&"+TEMPLATE_SERIAL);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiff(callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})});describe("getRenderedDiffFragment",function(){it("Without interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,fileIndex:5,revision:2});spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2/fragment/3/chunk/4/");expect(request.data.index).toBe(5);expect(request.data["lines-of-context"]).toBe(6);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()});it("With interdiffs",function(){var diffReviewable=new RB.DiffReviewable({reviewRequest:reviewRequest,fileDiffID:3,fileIndex:5,revision:2,interdiffRevision:3,interFileDiffID:4});spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("GET");expect(request.url).toBe("/r/1/diff/2-3/fragment/3-4/chunk/4/");expect(request.data.index).toBe(5);expect(request.data["lines-of-context"]).toBe(6);request.success("abc");request.complete("abc","success")});diffReviewable.getRenderedDiffFragment({chunkIndex:4,linesOfContext:6},callbacks);expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith("abc");expect(callbacks.complete).toHaveBeenCalledWith("abc","success");expect(callbacks.error).not.toHaveBeenCalled()})})});suite("rb/diffviewer/models/DiffRevision",function(){var model;beforeEach(function(){model=new RB.DiffRevision});describe("parse",function(){it("API payloads",function(){var data=model.parse({revision:2,latest_revision:3,interdiff_revision:4,is_interdiff:true,is_draft_diff:true});expect(data).not.toBe(undefined);expect(data.revision).toBe(2);expect(data.latestRevision).toBe(3);expect(data.interdiffRevision).toBe(4);expect(data.isInterdiff).toBe(true);expect(data.isDraftDiff).toBe(true)})})});suite("rb/diffviewer/models/Pagination",function(){var model;beforeEach(function(){model=new RB.Pagination});describe("parse",function(){it("API payloads",function(){var data=model.parse({is_paginated:true,pages:4,has_previous:true,has_next:true,page_numbers:[1,2,3,4],previous_page:1,next_page:3,current_page:2});expect(data).not.toBe(undefined);expect(data.isPaginated).toBe(true);expect(data.pages).toBe(4);expect(data.pageNumbers).toEqual([1,2,3,4]);expect(data.hasPrevious).toBe(true);expect(data.hasNext).toBe(true);expect(data.previousPage).toBe(1);expect(data.nextPage).toBe(3);expect(data.currentPage).toBe(2)})})});suite("rb/diffviewer/views/DiffReviewableView",function(){var diffTableTemplate=_.template(['<table class="sidebyside">'," <thead>","  <tr>",'   <th colspan="2">','    <a name="1" class="file-anchor"></a> my-file.txt',"   </th>","  </tr>","  <tr>",'   <th class="rev">Revision 1</th>','   <th class="rev">Revision 2</th>',"  </tr>"," </thead>"," <% _.each(chunks, function(chunk, index) { %>",'  <% if (chunk.type === "collapsed") { %>','   <tbody class="diff-header">',"    <tr>","     <th>",'      <a href="#" class="diff-expand-btn tests-expand-above"','         data-chunk-index="<%= index %>"','         data-lines-of-context="20,0"><img /></a>',"     </th>",'     <th colspan="3">','      <a href="#" class="diff-expand-btn tests-expand-chunk"','         data-chunk-index="<%= index %>"><img /> Expand</a>',"     </th>","    </tr>","    <tr>","     <th>",'      <a href="#" class="diff-expand-btn tests-expand-below"','         data-chunk-index="<%= index %>"','         data-lines-of-context="0,20"><img /></a>',"     </th>",'     <th colspan="3">','      <a href="#" class="diff-expand-btn tests-expand-header"','         data-chunk-index="<%= index %>"','         data-lines-of-context="0,<%= chunk.expandHeaderLines %>">',"       <img /> <code>Some Function</code>","      </a>","     </th>","    </tr>","   </tbody>","  <% } else { %>",'   <tbody class="<%= chunk.type %>',"                 <% if (chunk.expanded) { %>loaded<% } %>",'                 <%= chunk.extraClass || "" %>"','          id="chunk0.<%= index %>">',"    <% for (var i = 0; i < chunk.numRows; i++) { %>",'     <tr line="<%= i + chunk.startRow %>">',"      <th></th>","      <td>","       <% if (chunk.expanded && i === 0) { %>",'        <div class="collapse-floater">','         <img class="diff-collapse-btn"','              data-chunk-index="<%= index %>"','              data-lines-of-context="0" />',"        </div>","       <% } %>","      </td>","      <th></th>","      <td></td>","     </tr>","    <% } %>","   </tbody>","  <% } %>"," <% }); %>","</table>"].join("")),reviewRequest,$container,view;beforeEach(function(){$container=$("<div/>").appendTo($testsScratch);reviewRequest=new RB.ReviewRequest});afterEach(function(){view.remove()});describe("CommentRowSelector",function(){var selector,$rows;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"delete",startRow:6,numRows:10}]}))});view.render().$el.appendTo($container);selector=view._selector;$rows=view.$el.find("tbody tr")});describe("Selecting range",function(){var $startRow,startCell;beforeEach(function(){$startRow=$($rows[4]);startCell=$startRow[0].cells[0]});it("Beginning selection",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});describe("Adding rows to selection",function(){it("Above",function(){var $prevRow=$($rows[3]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$prevRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($prevRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(4);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($prevRow[0].rowIndex)});it("Below",function(){var $nextRow=$($rows[5]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$nextRow[0].cells[0]});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($nextRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(6);expect(selector._lastSeenIndex).toBe($nextRow[0].rowIndex)});it("Rows inbetween two events",function(){var $laterRow=$($rows[7]);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:$laterRow[0].cells[0]});expect($($rows[4]).hasClass("selected")).toBe(true);expect($($rows[5]).hasClass("selected")).toBe(true);expect($($rows[6]).hasClass("selected")).toBe(true);expect($($rows[7]).hasClass("selected")).toBe(true);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($laterRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(8);expect(selector._lastSeenIndex).toBe($laterRow[0].rowIndex)})});describe("Removing rows from selection",function(){it("Above",function(){var $prevRow=$($rows[3]),prevCell=$prevRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:prevCell});selector._onMouseOut({relatedTarget:startCell,target:prevCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($prevRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)});it("Below",function(){var $nextRow=$($rows[5]),nextCell=$nextRow[0].cells[0];selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:nextCell});selector._onMouseOut({relatedTarget:startCell,target:nextCell});selector._onMouseOver({target:startCell});expect($startRow.hasClass("selected")).toBe(true);expect($nextRow.hasClass("selected")).toBe(false);expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($startRow[0]);expect(selector._beginLineNum).toBe(5);expect(selector._endLineNum).toBe(5);expect(selector._lastSeenIndex).toBe($startRow[0].rowIndex)})});describe("Finishing selection",function(){beforeEach(function(){spyOn(view,"createAndEditCommentBlock")});describe("With single line",function(){var $row,cell;beforeEach(function(){$row=$($rows[4]);cell=$row[0].cells[0]});it("And existing comment",function(){var onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(cell);selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).not.toHaveBeenCalled();expect(onClick).toHaveBeenCalled();expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:cell});selector._onMouseDown({target:cell});selector._onMouseUp({target:cell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$row,$endRow:$row,beginLineNum:5,endLineNum:5});expect($row.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})});describe("With multiple lines",function(){var $startRow,$endRow,startCell,endCell;beforeEach(function(){$startRow=$($rows[4]);$endRow=$($rows[5]);startCell=$startRow[0].cells[0];endCell=$endRow[0].cells[0]});xit("And existing comment",function(){var onClick=jasmine.createSpy("onClick");$('<a class="commentflag" />').click(onClick).appendTo(cell);selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect(onClick).not.toHaveBeenCalled();expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)});it("And no existing comment",function(){selector._onMouseOver({target:startCell});selector._onMouseDown({target:startCell});selector._onMouseOver({target:endCell});expect(selector._$begin[0]).toBe($startRow[0]);expect(selector._$end[0]).toBe($endRow[0]);$startRow=selector._$begin;$endRow=selector._$end;selector._onMouseUp({target:endCell,stopImmediatePropagation:function(){},preventDefault:function(){}});expect(view.createAndEditCommentBlock).toHaveBeenCalledWith({$beginRow:$startRow,$endRow:$endRow,beginLineNum:5,endLineNum:6});expect($startRow.hasClass("selected")).toBe(false);expect($endRow.hasClass("selected")).toBe(false);expect(selector._$begin).toBe(null);expect(selector._$end).toBe(null);expect(selector._beginLineNum).toBe(0);expect(selector._endLineNum).toBe(0);expect(selector._lastSeenIndex).toBe(0)})})})});describe("Hovering",function(){describe("Over line",function(){var $row,cell;beforeEach(function(){$row=$($rows[4])});it("Contents cell",function(){cell=$row[0].cells[1];selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(false);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});describe("Line number cell",function(){beforeEach(function(){cell=$row[0].cells[0]});it("With existing comment on row",function(){$(cell).append('<a class="commentflag" />');selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("With no column flag",function(){selector._onMouseOver({target:cell});expect($row.hasClass("selected")).toBe(true);expect(selector._$ghostCommentFlag.css("display")).not.toBe("none")})})});describe("Out of line",function(){it("Contents cell",function(){var $row=$($rows[0]);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none")});it("Line number cell",function(){var $row=$($rows[0]);selector._onMouseOver({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).not.toBe("none");expect($row.hasClass("selected")).toBe(true);selector._onMouseOut({target:$row[0].cells[0]});expect(selector._$ghostCommentFlag.css("display")).toBe("none");expect($row.hasClass("selected")).toBe(false)})})})});describe("Incremental expansion",function(){var model;beforeEach(function(){model=new RB.DiffReviewable({reviewRequest:reviewRequest,fileIndex:1,fileDiffID:10,revision:1})});describe("Expanding",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"collapsed",expandHeaderLines:7},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container)});describe("Fetching fragment",function(){beforeEach(function(){spyOn(model,"getRenderedDiffFragment")});it("Full chunk",function(){var options;view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls[0].args[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(undefined)});it("+20 above",function(){var options;view.$(".tests-expand-above").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls[0].args[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("20,0")});it("+20 below",function(){var options;view.$(".tests-expand-below").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls[0].args[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,20")});it("Function/class",function(){var options;view.$(".tests-expand-header").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls[0].args[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe("0,7")})});describe("Injecting HTML",function(){it("Whole chunk",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").andCallFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").andCallThrough();view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._$collapseButtons.length).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").andCallFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").andCallThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);expect(view.$("tbody").length).toBe(5);view.$(".tests-expand-chunk").click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._$collapseButtons.length).toBe(1);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})});describe("Collapsing",function(){var $collapseButton;beforeEach(function(){view=new RB.DiffReviewableView({model:model,el:$(diffTableTemplate({chunks:[{type:"equal",startRow:1,numRows:5},{type:"equal",expanded:true,startRow:6,numRows:2},{type:"delete",startRow:10,numRows:5}]}))});view.render().$el.appendTo($container);$collapseButton=view.$(".diff-collapse-btn")});it("Fetching fragment",function(){var options;spyOn(model,"getRenderedDiffFragment");$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();options=model.getRenderedDiffFragment.calls[0].args[0];expect(options.chunkIndex).toBe(1);expect(options.linesOfContext).toBe(0)});describe("Injecting HTML",function(){it("Single expanded chunk",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").andCallFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").andCallThrough();$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._$collapseButtons.length).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")});it("Merging adjacent expanded chunks",function(){var $tbodies;spyOn(model,"getRenderedDiffFragment").andCallFake(function(options,callbacks,context){callbacks.success.call(context,['<tbody class="equal tests-new-chunk">',' <tr line="6">',"  <th></th>","  <td></td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""))});spyOn(view,"trigger").andCallThrough();$('<tbody class="equal loaded"/>').append($('<img class="diff-collapse-btn" />')).insertAfter(view.$("tbody")[1]).clone().insertBefore(view.$("tbody")[1]);$collapseButton.click();expect(model.getRenderedDiffFragment).toHaveBeenCalled();$tbodies=view.$("tbody");expect($tbodies.length).toBe(3);expect($($tbodies[0]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("equal")).toBe(true);expect($($tbodies[1]).hasClass("tests-new-chunk")).toBe(true);expect($($tbodies[2]).hasClass("delete")).toBe(true);expect(view._$collapseButtons.length).toBe(0);expect(view.trigger).toHaveBeenCalledWith("chunkExpansionChanged")})})})});describe("Comment flags",function(){describe("Placing visible comments",function(){var expandedDiffFragmentHTML=['<tbody class="equal tests-new-chunk">',' <tr line="11">',"  <th></th>","  <td>",'   <div class="collapse-floater">','    <img class="diff-collapse-btn"','         data-chunk-index="1"','         data-lines-of-context="0" />',"   </div>","  </td>","  <th></th>","  <td></td>"," </tr>","</tbody>"].join(""),$commentFlags,$rows,diffFragmentHTML;beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest,serializedCommentBlocks:[{linenum:2,num_lines:2,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 1",comment_id:1,user:{name:"testuser"},line:2}]},{linenum:4,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 2",comment_id:1,user:{name:"testuser"},line:4},{issue_opened:false,review_id:1,localdraft:false,text:"Comment 3",comment_id:1,user:{name:"testuser"},line:4}]},{linenum:11,num_lines:1,comments:[{issue_opened:false,review_id:1,localdraft:false,text:"Comment 4",comment_id:1,user:{name:"testuser"},line:12}]}]}),el:$(diffTableTemplate({chunks:[{type:"insert",startRow:1,numRows:10},{type:"collapsed",expandHeaderLines:7}]}))});view.render().$el.appendTo($container);diffFragmentHTML=expandedDiffFragmentHTML;spyOn(view.model,"getRenderedDiffFragment").andCallFake(function(options,callbacks,context){callbacks.success.call(context,diffFragmentHTML)});$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr")});it("On initial render",function(){var $commentFlag;expect($commentFlags.length).toBe(2);expect($($commentFlags[0]).find(".commentflag-count").text()).toBe("1");expect($($commentFlags[1]).find(".commentflag-count").text()).toBe("2");$commentFlag=$($rows[1]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[0]);expect($commentFlag.parents("tr").attr("line")).toBe("2");$commentFlag=$($rows[3]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[1]);expect($commentFlag.parents("tr").attr("line")).toBe("4")});it("On chunk expand",function(){expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")});it("On chunk re-expand (after collapsing)",function(){var collapsedDiffFragmentHTML=['<tbody class="diff-header">',$(view.$("tbody")[1]).html(),"</tbody>"].join("");expect($commentFlags.length).toBe(2);view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);diffFragmentHTML=collapsedDiffFragmentHTML;view.$(".diff-collapse-btn").click();expect(view.$(".commentflag").length).toBe(2);diffFragmentHTML=expandedDiffFragmentHTML;view.$(".tests-expand-chunk").click();expect(view.$(".commentflag").length).toBe(3);$commentFlags=view.$(".commentflag");$rows=view.$el.find("tbody tr");expect($commentFlags.length).toBe(3);expect($($commentFlags[2]).find(".commentflag-count").text()).toBe("1");$commentFlag=$($rows[10]).find(".commentflag");expect($commentFlag.length).toBe(1);expect($commentFlag[0]).toBe($commentFlags[2]);expect($commentFlag.parents("tr").attr("line")).toBe("11")})})});describe("Methods",function(){describe("toggleWhitespaceOnlyChunks",function(){beforeEach(function(){view=new RB.DiffReviewableView({model:new RB.DiffReviewable({reviewRequest:reviewRequest}),el:$(diffTableTemplate({chunks:[{type:"replace",startRow:1,numRows:5,extraClass:"whitespace-chunk"}]}))});view.render().$el.appendTo($container)});describe("Toggle on",function(){it("Chunk classes",function(){var $tbodies,$tbody,$children;view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(false);expect($($children[0]).hasClass("first")).toBe(true);expect($($children[$children.length-1]).hasClass("last")).toBe(true)});it("chunkDimmed event triggered",function(){spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkDimmed","0.0");

});it("Whitespace-only file classes",function(){var $tbodies=view.$el.children("tbody"),$whitespaceChunk=$("<tbody/>").addClass("whitespace-file").hide().appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(true);expect($tbodies.is(":visible")).toBe(false)})});describe("Toggle off",function(){it("Chunk classes",function(){var $tbodies,$tbody,$children;view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();$tbodies=view.$("tbody");$tbody=$($tbodies[0]);$children=$tbody.children();expect($tbody.hasClass("replace")).toBe(true);expect($($children[0]).hasClass("first")).toBe(false);expect($($children[$children.length-1]).hasClass("last")).toBe(false)});it("chunkDimmed event triggered",function(){view.toggleWhitespaceOnlyChunks();spyOn(view,"trigger");view.toggleWhitespaceOnlyChunks();expect(view.trigger).toHaveBeenCalledWith("chunkUndimmed","0.0")});it("Whitespace-only file classes",function(){var $tbodies=view.$el.children("tbody"),$whitespaceChunk=$("<tbody/>").addClass("whitespace-file").hide().appendTo(view.$el);expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true);view.toggleWhitespaceOnlyChunks();view.toggleWhitespaceOnlyChunks();expect($whitespaceChunk.is(":visible")).toBe(false);expect($tbodies.is(":visible")).toBe(true)})})})})});suite("rb/models/CommentEditor",function(){var editor,reviewRequest,comment;function createComment(){return new RB.BaseComment({parentObject:new RB.BaseResource({"public":true})})}beforeEach(function(){reviewRequest=new RB.ReviewRequest;editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest})});describe("Attribute defaults",function(){describe("canEdit",function(){it("When logged in and hasDraft=false",function(){RB.UserSession.instance.set("authenticated",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)});it("When logged in and hasDraft=true",function(){RB.UserSession.instance.set("authenticated",true);reviewRequest.set("hasDraft",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("authenticated",false);editor=new RB.CommentEditor({canEdit:true,reviewRequest:reviewRequest});expect(editor.get("canEdit")).toBe(true)})});describe("openIssue",function(){it("When user preference is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({openIssue:true,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(true)});it("When reloading the page with explicitly set value",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);comment=createComment();comment.set({loaded:false,issueOpened:false});editor=new RB.CommentEditor({comment:comment,reviewRequest:reviewRequest});expect(editor.get("openIssue")).toBe(false)})});describe("richText",function(){it("When user preference is true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)});it("When user preference is false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(false)});it("With explicitly set value",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor=new RB.CommentEditor({richText:true,reviewRequest:reviewRequest});expect(editor.get("richText")).toBe(true)})})});describe("Loading comment",function(){describe("With comment richText=true",function(){var comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:true,text:"<p>this _is_ a <em>test</em></p>",rawTextFields:{text:"this \\_is\\_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a _test_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a _test_")})});describe("With comment richText=false",function(){var comment;beforeEach(function(){comment=createComment();comment.set({id:123,loaded:true,richText:false,text:"<p>this _is_ a test</p>",rawTextFields:{text:"this _is_ a _test_"},markdownTextFields:{text:"this \\_is\\_ a \\_test\\_"}})});it("When defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(true);expect(editor.get("text")).toBe("this \\_is\\_ a \\_test\\_")});it("When defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);editor.set("comment",comment);editor.beginEdit();expect(editor.get("dirty")).toBe(false);expect(editor.get("richText")).toBe(false);expect(editor.get("text")).toBe("this _is_ a _test_")})})});describe("Capability states",function(){describe("canDelete",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canDelete")).toBe(false)});it("When editing new comment",function(){editor.set("comment",createComment());editor.beginEdit();expect(editor.get("canDelete")).toBe(false)});it("When editing existing comment",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();expect(editor.get("canDelete")).toBe(true)});it("When editing existing comment with canEdit=false",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set({canEdit:false,comment:comment});expect(function(){editor.beginEdit()}).toThrow();expect(console.assert).toHaveBeenCalled();expect(editor.get("canDelete")).toBe(false)})});describe("canSave",function(){it("When not editing",function(){expect(editor.get("editing")).toBe(false);expect(editor.get("canSave")).toBe(false)});it("When editing comment with text",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","Foo");expect(editor.get("canSave")).toBe(true)});it("When editing comment with initial state",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();expect(editor.get("canSave")).toBe(false)});it("When editing comment without text",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","");expect(editor.get("canSave")).toBe(false)})})});describe("States",function(){describe("dirty",function(){it("Initial state",function(){expect(editor.get("dirty")).toBe(false)});it("After new comment",function(){var comment=createComment();editor.set("dirty",true);editor.set("comment",comment);expect(editor.get("dirty")).toBe(false)});it("After text change",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true)});it("After toggling Open Issue",function(){editor.set("comment",createComment());editor.beginEdit();editor.set("openIssue","true");expect(editor.get("dirty")).toBe(true)});it("After saving",function(){var comment=createComment();editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"save").andCallFake(function(callbacks,context){callbacks.success.call(context)});editor.save();expect(editor.get("dirty")).toBe(false)});it("After deleting",function(){var comment=createComment();comment.set({id:123,loaded:true});editor.set("comment",comment);editor.beginEdit();editor.set("text","abc");expect(editor.get("dirty")).toBe(true);spyOn(comment,"destroy").andCallFake(function(callbacks,context){if(callbacks&&callbacks.success){callbacks.success.call(context)}});editor.deleteComment();expect(editor.get("dirty")).toBe(false)})})});describe("Operations",function(){it("setExtraData",function(){editor.setExtraData("key1","strvalue");editor.setExtraData("key2",42);expect(editor.get("extraData")).toEqual({key1:"strvalue",key2:42})});it("getExtraData",function(){editor.set("extraData",{mykey:"value"});expect(editor.getExtraData("mykey")).toBe("value")});describe("beginEdit",function(){it("With canEdit=true",function(){editor.set({comment:createComment(),canEdit:true});editor.beginEdit();expect(console.assert.calls[0].args[0]).toBeTruthy()});it("With canEdit=false",function(){editor.set({comment:createComment(),canEdit:false});expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls[0].args[0]).toBeFalsy()});it("With no comment",function(){expect(function(){editor.beginEdit()}).toThrow();expect(console.assert.calls[0].args[0]).toBeTruthy();expect(console.assert.calls[1].args[0]).toBeFalsy()})});describe("cancel",function(){beforeEach(function(){spyOn(editor,"close");spyOn(editor,"trigger")});it("With comment",function(){var comment=createComment();spyOn(comment,"destroyIfEmpty");editor.set("comment",comment);editor.cancel();expect(comment.destroyIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()});it("Without comment",function(){editor.cancel();expect(editor.trigger).not.toHaveBeenCalledWith("canceled");expect(editor.close).toHaveBeenCalled()})});describe("destroy",function(){var comment;beforeEach(function(){comment=createComment();spyOn(comment,"destroy").andCallFake(function(callbacks,context){if(callbacks&&callbacks.success){callbacks.success.call(context)}});spyOn(editor,"close");spyOn(editor,"trigger")});it("With canDelete=false",function(){editor.set("comment",comment);editor.set("canDelete",false);expect(function(){editor.deleteComment()}).toThrow();expect(console.assert.calls[0].args[0]).toBeFalsy();expect(comment.destroy).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("deleted");expect(editor.close).not.toHaveBeenCalled()});it("With canDelete=true",function(){editor.set("comment",comment);editor.set("canDelete",true);editor.deleteComment();expect(console.assert.calls[0].args[0]).toBeTruthy();expect(comment.destroy).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("deleted");expect(editor.close).toHaveBeenCalled()})});describe("save",function(){var comment;beforeEach(function(){comment=createComment();spyOn(comment,"save").andCallFake(function(options){if(options&&options.success){options.success()}});spyOn(editor,"trigger")});it("With canSave=false",function(){editor.set("comment",comment);editor.set("canSave",false);expect(function(){editor.save()}).toThrow();expect(console.assert.calls[0].args[0]).toBeFalsy();expect(comment.save).not.toHaveBeenCalled();expect(editor.trigger).not.toHaveBeenCalledWith("saved")});it("With canSave=true",function(){var text="My text",issue_opened=true;comment.set("issueOpened",false);editor.set("comment",comment);editor.set({text:text,issue_opened:issue_opened,canSave:true,richText:true});editor.setExtraData("mykey","myvalue");editor.save();expect(console.assert.calls[0].args[0]).toBeTruthy();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(text);expect(comment.get("issueOpened")).toBe(issue_opened);expect(comment.get("richText")).toBe(true);expect(comment.get("extraData")).toEqual({mykey:"myvalue"});expect(editor.get("dirty")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("saved")})})})});suite("rb/models/ReviewReplyEditor",function(){var reviewReply,review,editor;beforeEach(function(){review=new RB.Review({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}});reviewReply=review.createReply();spyOn(review,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(reviewReply,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(reviewReply,"ready").andCallFake(function(options,context){options.ready.call(context)})});describe("Event handling",function(){describe("reviewReply changes",function(){beforeEach(function(){editor=new RB.ReviewReplyEditor({contextType:"body_top",review:review,reviewReply:reviewReply,text:"My Text"})});it("Sets up events on new reviewReply",function(){var reviewReply=new RB.ReviewReply;spyOn(reviewReply,"on");editor.set("reviewReply",reviewReply);expect(reviewReply.on.calls.length).toBe(2);expect(reviewReply.on.calls[0].args[0]).toBe("destroyed");expect(reviewReply.on.calls[1].args[0]).toBe("published")});it("Removes events from old reviewReply",function(){spyOn(reviewReply,"off");editor.set("reviewReply",new RB.ReviewReply);expect(reviewReply.off).toHaveBeenCalledWith(null,null,editor)})})});describe("Methods",function(){describe("save",function(){function testBodySave(options){editor=new RB.ReviewReplyEditor({contextType:options.contextType,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(reviewReply,"save").andCallFake(function(options,context){options.success.call(context)});editor.save();expect(editor.get("replyObject")).toBe(reviewReply);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(reviewReply.get(options.textAttr)).toBe("My Text");expect(reviewReply.get(options.richTextAttr)).toBe(options.richText);expect(reviewReply.ready).toHaveBeenCalled();expect(reviewReply.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}function testCommentSave(options){var replyObject;editor=new RB.ReviewReplyEditor({contextType:options.contextType,hasDraft:false,review:review,reviewReply:reviewReply,richText:options.richText,text:"My Text"});spyOn(editor,"trigger");spyOn(options.model.prototype,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(options.model.prototype,"save").andCallFake(function(options,context){options.success.call(context)});editor.save();replyObject=editor.get("replyObject");expect(editor.get("hasDraft")).toBe(true);expect(editor.get("text")).toBe("My Text");expect(editor.get("richText")).toBe(true);expect(replyObject instanceof options.model).toBe(true);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.get("richText")).toBe(options.richText);expect(options.model.prototype.ready).toHaveBeenCalled();expect(options.model.prototype.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")}it("With existing reply object",function(){var replyObject=new RB.DiffCommentReply;editor=new RB.ReviewReplyEditor({contextType:"diff_comments",hasDraft:false,replyObject:replyObject,review:review,reviewReply:reviewReply,text:"My Text"});spyOn(editor,"trigger");spyOn(replyObject,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(replyObject,"save").andCallFake(function(options,context){options.success.call(context)});editor.save();expect(editor.get("hasDraft")).toBe(true);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("My Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("With empty text",function(){var replyObject=new RB.DiffCommentReply({text:"Orig Text"});editor=new RB.ReviewReplyEditor({contextType:"diff_comments",review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(editor,"resetStateIfEmpty");spyOn(replyObject,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(replyObject,"save");editor.set({hasDraft:false,replyObject:replyObject,text:""});editor.save();expect(editor.get("hasDraft")).toBe(false);expect(editor.get("replyObject")).toBe(replyObject);expect(replyObject.get("text")).toBe("Orig Text");expect(replyObject.ready).toHaveBeenCalled();expect(replyObject.save).not.toHaveBeenCalled();expect(editor.resetStateIfEmpty).toHaveBeenCalled();expect(editor.trigger).toHaveBeenCalledWith("saving")});describe("With body_top",function(){function testSave(richText){testBodySave({contextType:"body_top",textAttr:"bodyTop",richTextAttr:"bodyTopRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With body_bottom",function(){function testSave(richText){testBodySave({contextType:"body_bottom",textAttr:"bodyBottom",richTextAttr:"bodyBottomRichText",richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With diff comments",function(){function testSave(richText){testCommentSave({contextType:"diff_comments",model:RB.DiffCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With file attachment comments",function(){function testSave(richText){testCommentSave({contextType:"file_attachment_comments",model:RB.FileAttachmentCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})});describe("With screenshot comments",function(){function testSave(richText){testCommentSave({contextType:"screenshot_comments",model:RB.ScreenshotCommentReply,richText:richText})}it("richText=true",function(){testSave(true)});it("richText=false",function(){testSave(false)})})});describe("resetStateIfEmpty",function(){var replyObject;beforeEach(function(){replyObject=new RB.DiffCommentReply;editor=new RB.ReviewReplyEditor({contextType:"diff_comments",hasDraft:true,replyObject:replyObject,review:review,reviewReply:reviewReply});spyOn(editor,"trigger");spyOn(replyObject,"destroy").andCallFake(function(options,context){options.success.call(context)})});it("Without empty text",function(){editor.set("text","My Text");editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(true);expect(editor.trigger).not.toHaveBeenCalledWith("resetState")});describe("With empty text",function(){it("With no reply object",function(){editor.set("replyObject",null);editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With new reply object",function(){replyObject.id=null;editor.resetStateIfEmpty();expect(replyObject.destroy).not.toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")});it("With existing reply object",function(){replyObject.id=123;editor.resetStateIfEmpty();expect(replyObject.destroy).toHaveBeenCalled();expect(editor.get("hasDraft")).toBe(false);expect(editor.trigger).toHaveBeenCalledWith("resetState")})})})})});suite("rb/models/ReviewRequestEditor",function(){var reviewRequest,editor;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});describe("Methods",function(){describe("createFileAttachment",function(){it("With new FileAttachment",function(){var fileAttachments=editor.get("fileAttachments"),fileAttachment;expect(fileAttachments.length).toBe(0);fileAttachment=editor.createFileAttachment();expect(fileAttachments.length).toBe(1);expect(fileAttachments.at(0)).toBe(fileAttachment)})});describe("decr",function(){it("With integer attribute",function(){editor.set("myint",1);editor.decr("myint");expect(editor.get("myint")).toBe(0)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(function(){editor.decr("foo")}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.mostRecentCall.args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")});describe("editCount",function(){it("When > 0",function(){editor.set("editCount",1);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(null)});it("When 0",function(){editor.set("editCount",0);editor.decr("editCount");expect(editor.get("editCount")).toBe(0);expect(editor.validationError).toBe(RB.ReviewRequestEditor.strings.UNBALANCED_EDIT_COUNT)})})});describe("incr",function(){it("With integer attribute",function(){editor.set("myint",0);editor.incr("myint");expect(editor.get("myint")).toBe(1)});it("With non-integer attribute",function(){editor.set("foo","abc");expect(function(){editor.incr("foo")}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.mostRecentCall.args[0]).toBe(false);expect(editor.get("foo")).toBe("abc")})});describe("getDraftField",function(){var value;it("For closeDescription",function(){reviewRequest.set("closeDescription","Test");value=editor.getDraftField("closeDescription",{});expect(value).toBe("Test")});it("For closeDescriptionRichText",function(){reviewRequest.set("closeDescriptionRichText",true);value=editor.getDraftField("closeDescriptionRichText",{});expect(value).toBe(true)});it("For draft fields",function(){reviewRequest.draft.set("description","Test");value=editor.getDraftField("description",{});expect(value).toBe("Test")});it("For custom fields",function(){var extraData=reviewRequest.draft.get("extraData");extraData.foo="**Test**";extraData.fooRichText=true;value=editor.getDraftField("foo",{useExtraData:true});expect(value).toBe("**Test**");value=editor.getDraftField("fooRichText",{useExtraData:true});expect(value).toBe(true)})});describe("setDraftField",function(){var callbacks,draft;beforeEach(function(){callbacks={error:function(){},success:function(){}};spyOn(callbacks,"error");spyOn(callbacks,"success");draft=editor.get("reviewRequest").draft});describe("When publishing",function(){beforeEach(function(){spyOn(editor,"publishDraft");editor.set({publishing:true,pendingSaveCount:1})});it("Successful saves",function(){spyOn(draft,"save").andCallFake(function(options,context){options.success.call(context)});editor.setDraftField("summary","My Summary",callbacks);expect(callbacks.success).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled()});it("Field set errors",function(){spyOn(draft,"save").andCallFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{summary:["Something went wrong"]}}})});editor.setDraftField("summary","My Summary",_.defaults({jsonFieldName:"summary"},callbacks));expect(callbacks.error).toHaveBeenCalled();expect(editor.get("publishing")).toBe(false);expect(editor.get("pendingSaveCount")).toBe(1);expect(editor.publishDraft).not.toHaveBeenCalled()})});describe("Rich text fields",function(){describe("changeDescription",function(){describe("Draft description",function(){function testDraftDescription(richText,textType){spyOn(reviewRequest,"close");spyOn(reviewRequest.draft,"save");editor.setDraftField("changeDescription","My description",{allowMarkdown:true,fieldID:"changedescription",richText:richText,jsonFieldName:"changedescription",jsonTextTypeFieldName:"changedescription_text_type"});expect(reviewRequest.close).not.toHaveBeenCalled();expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls[0].args[0].data).toEqual({changedescription_text_type:textType,changedescription:"My description",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testDraftDescription(true,"markdown")});it("For plain text",function(){testDraftDescription(false,"plain")})})});describe("closeDescription",function(){function testCloseDescription(closeType,richText){spyOn(reviewRequest,"close").andCallFake(function(options){expect(options.type).toBe(closeType);expect(options.description).toBe("My description");expect(options.richText).toBe(richText)});editor.setDraftField("closeDescription","My description",{closeType:closeType,richText:richText});expect(reviewRequest.close).toHaveBeenCalled()}describe("Discarded description",function(){it("For Markdown",function(){testCloseDescription(RB.ReviewRequest.CLOSE_DISCARDED,true,"markdown")});it("For plain text",function(){testCloseDescription(RB.ReviewRequest.CLOSE_DISCARDED,false,"plain")})});describe("Submitted description",function(){it("For Markdown",function(){testCloseDescription(RB.ReviewRequest.CLOSE_SUBMITTED,true,"markdown")});it("For plain text",function(){testCloseDescription(RB.ReviewRequest.CLOSE_SUBMITTED,false,"plain")})})})});describe("Special list fields",function(){describe("targetGroups",function(){it("Empty",function(){spyOn(draft,"save").andCallFake(function(options,context){options.success.call(context)});editor.setDraftField("targetGroups","",callbacks);expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").andCallFake(function(options,context){options.success.call(context)});editor.setDraftField("targetGroups","group1, group2",callbacks);expect(callbacks.success).toHaveBeenCalled()});it("With invalid groups",function(){spyOn(draft,"save").andCallFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{target_groups:["group1","group2"]}}})});editor.setDraftField("targetGroups","group1, group2",_.defaults({jsonFieldName:"target_groups"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:"Groups 'group1' and 'group2' do "+"not exist."})})});describe("targetPeople",function(){it("Empty",function(){spyOn(draft,"save").andCallFake(function(options,context){options.success.call(context)});editor.setDraftField("targetPeople","",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With values",function(){spyOn(draft,"save").andCallFake(function(options,context){options.success.call(context)});editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.success).toHaveBeenCalled()});it("With invalid users",function(){spyOn(draft,"save").andCallFake(function(options,context){options.error.call(context,draft,{errorPayload:{fields:{target_people:["user1","user2"]}}})});editor.setDraftField("targetPeople","user1, user2",_.defaults({jsonFieldName:"target_people"},callbacks));expect(callbacks.error).toHaveBeenCalledWith({errorText:"Users 'user1' and 'user2' do not exist."})})})});describe("Custom fields",function(){describe("Rich text fields",function(){function testFields(richText,textType){spyOn(reviewRequest.draft,"save");editor.setDraftField("myField","Test text.",{allowMarkdown:true,useExtraData:true,fieldID:"myfield",richText:richText,jsonFieldName:"myfield",jsonTextTypeFieldName:"myfield_text_type"});expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls[0].args[0].data).toEqual({"extra_data.myfield_text_type":textType,"extra_data.myfield":"Test text.",force_text_type:"html",include_text_types:"raw"})}it("For Markdown",function(){testFields(true,"markdown")});it("For plain text",function(){testFields(false,"plain")})})})})});describe("Reviewed objects",function(){describe("File attachments",function(){it("Removed when destroyed",function(){var fileAttachments=editor.get("fileAttachments"),fileAttachment=editor.createFileAttachment(),draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});expect(fileAttachments.at(0)).toBe(fileAttachment);fileAttachment.destroy();expect(fileAttachments.length).toBe(0)})});describe("Screenshots",function(){it("Removed when destroyed",function(){var screenshots=editor.get("screenshots"),screenshot=reviewRequest.createScreenshot();screenshots.add(screenshot);expect(screenshots.at(0)).toBe(screenshot);screenshot.destroy();expect(screenshots.length).toBe(0)})})});describe("Events",function(){describe("saved",function(){it("When file attachment saved",function(){var fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saved");expect(editor.trigger).toHaveBeenCalledWith("saved")});it("When file attachment destroyed",function(){var fileAttachment=editor.createFileAttachment(),draft=editor.get("reviewRequest").draft;spyOn(draft,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(editor,"trigger");fileAttachment.destroy();expect(editor.trigger).toHaveBeenCalledWith("saved")})});describe("saving",function(){it("When file attachment saving",function(){var fileAttachment=editor.createFileAttachment();spyOn(editor,"trigger");fileAttachment.trigger("saving");expect(editor.trigger).toHaveBeenCalledWith("saving")})})})});suite("rb/models/uploadDiffModel",function(){var reviewRequest,updateDiffView;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123});updateDiffView=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:reviewRequest.get("commitID"),repository:reviewRequest.get("repository"),reviewRequest:reviewRequest}),el:$("#scratch")})});describe("Updating Review Requests",function(){it('"Start Over" doesn\'t change reviewRequest attribute',function(){spyOn(updateDiffView.model,"startOver").andCallThrough();updateDiffView.model.startOver();expect(updateDiffView.model.attributes.reviewRequest).toBe(reviewRequest)})})});suite("rb/models/UserSession",function(){describe("create",function(){it("Instance is set",function(){var session;RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect(session).toBe(RB.UserSession.instance)});it("Second attempt fails",function(){RB.UserSession.instance=null;RB.UserSession.create({username:"testuser"});expect(console.assert).toHaveBeenCalled();expect(console.assert.calls[0].args[0]).toBeTruthy();expect(function(){RB.UserSession.create({username:"foo"})}).toThrow();expect(console.assert).toHaveBeenCalled();expect(console.assert.calls[1].args[0]).toBeFalsy()})});describe("Attributes",function(){var session;beforeEach(function(){session=RB.UserSession.instance});describe("diffsShowExtraWhitespace",function(){describe("Loads from cookie",function(){it('When "true"',function(){spyOn($,"cookie").andReturn("true");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(true)});it('When "false"',function(){spyOn($,"cookie").andReturn("false");RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser"});expect($.cookie).toHaveBeenCalledWith("show_ew");expect(session.get("diffsShowExtraWhitespace")).toBe(false)})});describe("Sets cookie",function(){beforeEach(function(){spyOn($,"cookie")});it("When true",function(){session.attributes.diffsShowExtraWhitespace=false;session.set("diffsShowExtraWhitespace",true);expect($.cookie).toHaveBeenCalledWith("show_ew","true",{
path:SITE_ROOT})});it("When false",function(){session.attributes.diffsShowExtraWhitespace=true;session.set("diffsShowExtraWhitespace",false);expect($.cookie).toHaveBeenCalledWith("show_ew","false",{path:SITE_ROOT})})})})})});suite("rb/newReviewRequest/views/BranchesView",function(){var collection,view;beforeEach(function(){collection=new RB.RepositoryBranches([{name:"master",commit:"8088295174d8d46af7700ddf4522e3a703724106",isDefault:true},{name:"release-1.7.x",commit:"5e6707050f7cb29ed50fafd3b92bffb1e15df19f",isDefault:false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64",isDefault:false}]);view=new RB.BranchesView({collection:collection})});describe("Rendering",function(){it("With items",function(){view.render();expect(view.$el.html()).toBe('<option selected="selected">master</option>'+"<option>release-1.7.x</option>"+"<option>release-1.6.x</option>")})});describe("Selected event",function(){it("When clicked",function(){var children;view.render();view.on("selected",function(branch){expect(branch.get("name")).toBe("release-1.7.x")});children=view.$el.children();$(children[0]).attr("selected",false);$(children[1]).attr("selected",true);view.$el.change();expect(view.$el.html()).toBe("<option>master</option>"+'<option selected="selected">release-1.7.x</option>'+"<option>release-1.6.x</option>")})})});suite("rb/newReviewRequest/views/PostCommitView",function(){var repository,commits,model,view;beforeEach(function(){repository=new RB.Repository({name:"Repo",supportsPostCommit:true});spyOn(repository.branches,"sync").andCallFake(function(method,collection,options){options.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817","default":true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15","default":false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64","default":false}]})});spyOn(repository,"getCommits").andCallFake(function(options){commits=new RB.RepositoryCommits([],{urlBase:_.result(this,"url")+"commits/",start:options.start,branch:options.branch});spyOn(commits,"sync").andCallFake(function(method,collection,options){options.success({stat:"ok",commits:[{authorName:"Author 1",date:"2013-07-22T03:51:50Z",id:"3",message:"Summary 1\n\nMessage 1"},{authorName:"Author 2",date:"2013-07-22T03:50:46Z",id:"2",message:"Summary 2\n\nMessage 2"},{authorName:"Author 3",date:"2013-07-21T08:05:45Z",id:"1",message:"Summary 3\n\nMessage 3"}]})});return commits});model=new RB.PostCommitModel({repository:repository});view=new RB.PostCommitView({model:model});spyOn(RB.PostCommitView.prototype,"_onCreateReviewRequest").andCallThrough();expect(repository.branches.sync).toHaveBeenCalled()});it("Render",function(){view.render();expect(commits.sync).toHaveBeenCalled();expect(view._branchesView.$el.children().length).toBe(3);expect(view._commitsView.$el.children().length).toBe(3)});it("Create",function(){var commit,call;view.render();spyOn(RB.ReviewRequest.prototype,"save").andReturn();commit=commits.models[1];commit.trigger("create",commit);expect(RB.PostCommitView.prototype._onCreateReviewRequest).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save).toHaveBeenCalled();expect(RB.ReviewRequest.prototype.save.calls.length).toBe(1);call=RB.ReviewRequest.prototype.save.mostRecentCall;expect(call.object.get("commitID")).toBe(commit.get("id"))});describe("Error handling",function(){describe("Branches",function(){var xhr={errorText:"Oh no"},returnError;beforeEach(function(){spyOn(repository.branches,"fetch").andCallFake(function(options,context){if(returnError){options.error.call(context,repository.branches,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").andCallThrough();view._loadBranches()});it("UI state",function(){expect(repository.branches.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("branches",xhr);expect(view._branchesView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeFalsy();expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_branches")});it("Reloading",function(){var $reload;spyOn(view,"_loadBranches").andCallThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();$reload=view._$error.find("#reload_branches");expect($reload.length).toBe(1);$reload.click();expect(view._loadBranches).toHaveBeenCalled();expect(view._$error).toBe(null);expect(view._branchesView.$el.css("display")).not.toBe("none")})});describe("Commits",function(){var xhr={errorText:"Oh no"},returnError;beforeEach(function(){view.render();spyOn(RB.RepositoryCommits.prototype,"fetch").andCallFake(function(options,context){if(returnError){options.error.call(context,repository.commits,xhr)}else{options.success.call(context)}});returnError=true;spyOn(RB.PostCommitView.prototype,"_showLoadError").andCallThrough();view._loadCommits()});it("UI state",function(){expect(view._commitsCollection.fetch).toHaveBeenCalled();expect(view._showLoadError).toHaveBeenCalledWith("commits",xhr);expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error).toBeTruthy();expect(view._$error.length).toBe(1);expect(view._commitsView).toBeTruthy();expect(view._commitsView.$el.css("display")).toBe("none");expect(view._$error.find(".error-text").text().strip()).toBe("Oh no");expect(view._$error.find("a")[0].id).toBe("reload_commits")});it("Reloading",function(){var $reload;spyOn(view,"_loadCommits").andCallThrough();view.delegateEvents();returnError=false;expect(view._$error).toBeTruthy();$reload=view._$error.find("#reload_commits");expect($reload.length).toBe(1);$reload.click();expect(view._loadCommits).toHaveBeenCalled();expect(view._$error).toBe(null);expect(view._commitsView.$el.css("display")).toBe("block")})})})});suite("rb/newReviewRequest/views/RepositorySelectionView",function(){var collection,view;beforeEach(function(){collection=new Backbone.Collection([{name:"Repo 1"},{name:"Repo 2"},{name:"Repo 3"}],{model:RB.Repository});view=new RB.RepositorySelectionView({collection:collection})});describe("Rendering",function(){it("With items",function(){var children,i,count,name;view.render();children=view.$el.children(".repository");count=children.length;expect(count).toBe(collection.models.length);for(i=0;i<count;i++){name=collection.models[i].get("name");expect($(children[i]).text()).toBe(name)}})});describe("Selected event",function(){it("When clicked",function(){var children;view.render();view.on("selected",function(repository){expect(repository.get("name")).toBe("Repo 2")});children=view.$el.children(".repository");$(children[1]).click()})})});suite("rb/pages/models/PageManager",function(){var pageManager,page;beforeEach(function(){pageManager=new RB.PageManager;page=new Backbone.View;spyOn(page,"render")});describe("Instance",function(){var callbacks,expectedRender;beforeEach(function(){expectedRender=false;callbacks={cb:function(_page){expect(_page).toBe(page);expect(pageManager.get("rendered")).toBe(expectedRender)}};spyOn(callbacks,"cb")});describe("Methods",function(){describe("beforeReady",function(){it("Without page set",function(){pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){pageManager.set("page",page);pageManager.set("rendered",false);pageManager.beforeRender(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set({page:page,rendered:true});expect(function(){pageManager.beforeRender(callbacks.cb)}).toThrow();expect(callbacks.cb).not.toHaveBeenCalled()})});describe("ready",function(){it("Without page set",function(){pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled();pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();expect(callbacks.cb).toHaveBeenCalled()});it("With page set, not rendered",function(){spyOn(pageManager,"_renderPage");pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(false);expect(page.render).not.toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).not.toHaveBeenCalled()});it("With page set, rendered",function(){pageManager.set("page",page);expect(pageManager.get("rendered")).toBe(true);expect(page.render).toHaveBeenCalled();pageManager.ready(callbacks.cb);expect(callbacks.cb).toHaveBeenCalled()})})})});describe("Class methods",function(){var oldInstance;beforeEach(function(){oldInstance=RB.PageManager.instance;RB.PageManager.instance=pageManager});afterEach(function(){RB.PageManager.instance=oldInstance});it("beforeRender",function(){spyOn(RB.PageManager.instance,"beforeRender");RB.PageManager.beforeRender(1,2);expect(RB.PageManager.instance.beforeRender).toHaveBeenCalledWith(1,2)});it("ready",function(){spyOn(RB.PageManager.instance,"ready");RB.PageManager.ready(1,2);expect(RB.PageManager.instance.ready).toHaveBeenCalledWith(1,2)});it("setPage",function(){var page=new Backbone.View;RB.PageManager.setPage(page);expect(pageManager.get("page")).toBe(page)});it("getPage",function(){var page=new Backbone.View;pageManager.set("page",page);expect(RB.PageManager.getPage()).toBe(page)})})});suite("rb/pages/views/ReviewablePageView",function(){var $editReview,$shipIt,pageView;beforeEach(function(){var $container=$("<div/>").appendTo($testsScratch);$editReview=$('<a href="#" id="review-link">Edit Review</a>').appendTo($container);$shipIt=$('<a href="#" id="shipit-link">Ship It</a>').appendTo($container);pageView=new RB.ReviewablePageView({el:$container,reviewRequestData:{id:123,loaded:true,state:RB.ReviewRequest.PENDING},editorData:{mutableByUser:true,statusMutableByUser:true}});spyOn(pageView.reviewRequest,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(pageView.reviewRequest,"beginCheckForUpdates");pageView.render()});describe("Public objects",function(){it("reviewRequest",function(){expect(pageView.reviewRequest).not.toBe(undefined)});it("pendingReview",function(){expect(pageView.pendingReview).not.toBe(undefined);expect(pageView.pendingReview.get("parentObject")).toBe(pageView.reviewRequest)});it("commentIssueManager",function(){expect(pageView.commentIssueManager).not.toBe(undefined);expect(pageView.commentIssueManager.get("reviewRequest")).toBe(pageView.reviewRequest)});it("reviewRequestEditor",function(){expect(pageView.reviewRequestEditor).not.toBe(undefined);expect(pageView.reviewRequestEditor.get("reviewRequest")).toBe(pageView.reviewRequest);expect(pageView.reviewRequestEditor.get("commentIssueManager")).toBe(pageView.commentIssueManager);expect(pageView.reviewRequestEditor.get("editable")).toBe(true)});it("reviewRequestEditorView",function(){expect(pageView.reviewRequestEditorView).not.toBe(undefined);expect(pageView.reviewRequestEditorView.model).toBe(pageView.reviewRequestEditor)})});describe("Actions",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");$editReview.click();expect(RB.ReviewDialogView.create).toHaveBeenCalledWith({review:pageView.pendingReview,reviewRequestEditor:pageView.reviewRequestEditor})});describe("Ship It",function(){it("Confirmed",function(){spyOn(window,"confirm").andReturn(true);spyOn(pageView.pendingReview,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(pageView.pendingReview,"save").andCallFake(function(options,context){options.success.call(context)});spyOn(pageView.pendingReview,"publish").andCallThrough();spyOn(pageView.draftReviewBanner,"hideAndReload");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pageView.pendingReview.ready).toHaveBeenCalled();expect(pageView.pendingReview.publish).toHaveBeenCalled();expect(pageView.pendingReview.save).toHaveBeenCalled();expect(pageView.draftReviewBanner.hideAndReload).toHaveBeenCalled();expect(pageView.pendingReview.get("shipIt")).toBe(true);expect(pageView.pendingReview.get("bodyTop")).toBe("Ship It!")});it("Canceled",function(){spyOn(window,"confirm").andReturn(false);spyOn(pageView.pendingReview,"ready");$shipIt.click();expect(window.confirm).toHaveBeenCalled();expect(pageView.pendingReview.ready).not.toHaveBeenCalled()})})});describe("Update bubble",function(){var summary="My summary",user={url:"/users/foo/",fullname:"Mr. User",username:"user"},$bubble,bubbleView;beforeEach(function(){pageView.reviewRequest.trigger("updated",{summary:summary,user:user});$bubble=$("#updates-bubble");bubbleView=pageView._updatesBubble});it("Displays",function(){expect($bubble.length).toBe(1);expect(bubbleView.$el[0]).toBe($bubble[0]);expect($bubble.is(":visible")).toBe(true);expect($bubble.find("#updates-bubble-summary").text()).toBe(summary);expect($bubble.find("#updates-bubble-user").text()).toBe(user.fullname);expect($bubble.find("#updates-bubble-user").attr("href")).toBe(user.url)});describe("Actions",function(){it("Ignore",function(){spyOn(bubbleView,"close").andCallThrough();spyOn(bubbleView,"trigger").andCallThrough();spyOn(bubbleView,"remove").andCallThrough();$bubble.find(".ignore").click();expect(bubbleView.close).toHaveBeenCalled();expect(bubbleView.remove).toHaveBeenCalled();expect(bubbleView.trigger).toHaveBeenCalledWith("closed")});it("Update Page",function(){spyOn(bubbleView,"trigger");$bubble.find(".update-page").click();expect(bubbleView.trigger).toHaveBeenCalledWith("updatePage")})})})});suite("rb/resources/collections/RepositoryBranches",function(){var collection;beforeEach(function(){collection=new RB.RepositoryBranches;collection.url="/api/repositories/123/branches/"});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe("/api/repositories/123/branches/");expect(request.type).toBe("GET");request.success({stat:"ok",branches:[{name:"master",commit:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817","default":true},{name:"release-1.7.x",commit:"92463764015ef463b4b6d1a1825fee7aeec8cb15","default":false},{name:"release-1.6.x",commit:"a15d0e635064a2e1929ce1bf3bc8d4aa65738b64","default":false}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("name")).toBe("master");expect(collection.at(1).get("commit")).toBe("92463764015ef463b4b6d1a1825fee7aeec8cb15");expect(collection.at(2).get("isDefault")).toBe(false);expect(collection.reduce(function(memo,item){return memo+item.get("isDefault")?1:0},0)).toBe(1)})})});suite("rb/resources/collections/RepositoryCommits",function(){var collection,url="/api/repositories/123/commits/",start="859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817";beforeEach(function(){collection=new RB.RepositoryCommits([],{urlBase:url,start:start})});describe("Methods",function(){it("fetch",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe(url+"?start="+start);expect(request.type).toBe("GET");request.success({stat:"ok",commits:[{author_name:"Christian Hammond",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Merge branch 'release-1.7.x'",parent:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",review_request_url:""},{author_name:"Christian Hammond",date:"2013-06-25T23:30:59Z",id:"92463764015ef463b4b6d1a1825fee7aeec8cb15",message:"Fixed the bug number for the "+"blacktriangledown bug.",parent:"f5a35f1d8a8dcefb336a8e3211334f1f50ea7792",review_request_url:"http://example.com/r/18274/"},{author_name:"Christian Hammond",date:"2013-06-25T22:53:32Z",id:"84c730c7823b653a5bbcc007188d5c85a7c4ac58",message:["Don't expose child resources in ","ValidateDiffResource.\n\nFor convenience, ","ValidateDiffResource inherited from ","DiffResource.\nThis brought along the child ","resources, which weren't valid to have.\n","That ended up breaking docs, which tried ","to traverse them."].join(""),parent:"4150004c2f332747d92769d8133571dfac8c2803",review_request_url:""}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(3);expect(collection.at(0).get("authorName")).toBe("Christian Hammond");expect(collection.at(1).get("date").getUTCHours()).toBe(23);expect(collection.at(2).get("summary")).toBe("Don't expose child resources in ValidateDiffResource.");expect(collection.at(1).get("reviewRequestURL")).toBe("http://example.com/r/18274/")});it("url",function(){expect(_.result(collection,"url")).toBe(url+"?start="+start)})})});suite("rb/resources/collections/ResourceCollection",function(){var collection,reviewRequest;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:123,loaded:true,links:{reviews:{href:"/api/review-requests/123/reviews/"}}});spyOn(reviewRequest,"ready").andCallFake(function(options,context){options.ready.call(context)});collection=new RB.ResourceCollection([],{model:RB.Review,parentResource:reviewRequest})});describe("Methods",function(){describe("fetch",function(){it("Populates collection",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.fetch();expect($.ajax).toHaveBeenCalled();expect(collection.length).toBe(2);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(true)});it("With start=",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/");expect(request.data).not.toBe(undefined);expect(request.data.start).toBe(100)});collection.fetch({start:100});expect($.ajax).toHaveBeenCalled()});describe("With parentResource",function(){it("Calls parentResource.ready",function(){spyOn(RB.BaseCollection.prototype,"fetch");collection.fetch();expect(reviewRequest.ready).toHaveBeenCalled();expect(RB.BaseCollection.prototype.fetch).toHaveBeenCalled()})})});describe("fetchAll",function(){it("Spanning pages",function(){var numFetches=0,result;spyOn($,"ajax").andCallFake(function(request){console.assert(numFetches<2);expect(request.type).toBe("GET");numFetches++;if(numFetches===1){expect(request.url).toBe("/api/review-requests/123/reviews/");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})}else if(numFetches===2){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");request.success({stat:"ok",total_results:4,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"}},reviews:[{id:3,links:{}},{id:4,links:{}}]})}});result=collection.fetchAll();expect(result).toBe(true);expect($.ajax).toHaveBeenCalled();expect(numFetches).toBe(2);expect(collection.hasPrev).toBe(false);expect(collection.hasNext).toBe(false);expect(collection.totalResults).toBe(4);expect(collection.currentPage).toBe(0);expect(collection.length).toBe(4);expect(collection.at(0).id).toBe(1);expect(collection.at(1).id).toBe(2);expect(collection.at(2).id).toBe(3);expect(collection.at(3).id).toBe(4)})});describe("fetchNext",function(){it("With hasNext == false",function(){var result;collection.hasNext=false;spyOn(collection,"fetch");result=collection.fetchNext();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasNext == true",function(){var result;spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=50"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasNext=true;collection.currentPage=2;collection._links={next:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").andCallThrough();result=collection.fetchNext();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(3);expect(collection.models.length).toBe(2)})});describe("fetchPrev",function(){it("With hasPrev == false",function(){var result;collection.hasPrev=false;spyOn(collection,"fetch");result=collection.fetchPrev();expect(result).toBe(false);expect(collection.fetch).not.toHaveBeenCalled()});it("With hasPrev == true",function(){var result;spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe("/api/review-requests/123/reviews/?start=25");expect(request.type).toBe("GET");request.success({stat:"ok",total_results:2,links:{self:{method:"GET",href:"/api/review-requests/123/reviews/"},prev:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=0"},next:{method:"GET",href:"/api/review-requests/123/reviews/"+"?start=25"}},reviews:[{id:1,links:{}},{id:2,links:{}}]})});collection.hasPrev=true;collection.currentPage=2;collection._links={prev:{method:"GET",href:"/api/review-requests/123/reviews/?start=25"}};spyOn(collection,"fetch").andCallThrough();result=collection.fetchPrev();expect(result).toBe(true);expect(collection.fetch).toHaveBeenCalled();expect(collection.hasPrev).toBe(true);expect(collection.hasNext).toBe(true);expect(collection.currentPage).toBe(1);expect(collection.models.length).toBe(2)})});describe("parse",function(){var payload;beforeEach(function(){payload={links:{},total_results:5,reviews:[]}});it("Resources returned",function(){var results;payload.reviews=[{id:1},{id:2},{id:3}];results=collection.parse(payload);expect(results.length).toBe(3);expect(results[0].id).toBe(1);expect(results[1].id).toBe(2);expect(results[2].id).toBe(3)});it("totalResults set",function(){collection.parse(payload);expect(collection.totalResults).toBe(5)});describe("With fetchingAll",function(){var options={fetchingAll:true};it("currentPage = 0",function(){collection.parse(payload,options);expect(collection.currentPage).toBe(0)});it("hasPrev disabled",function(){collection.parse(payload,options);expect(collection.hasPrev).toBe(false)});it("hasNext disabled",function(){collection.parse(payload,options);expect(collection.hasNext).toBe(false)})});describe("Without fetchingAll",function(){describe("currentPage",function(){it("undefined when not options.page",function(){collection.parse(payload);expect(collection.currentPage).toBe(undefined)});it("Set when options.page",function(){collection.parse(payload,{page:4});expect(collection.currentPage).toBe(4)})});describe("hasPrev",function(){it("true with rsp.links.prev",function(){payload.links={prev:{href:"blah"}};collection.parse(payload);expect(collection.hasPrev).toBe(true)});it("false without rsp.links.prev",function(){collection.parse(payload);expect(collection.hasPrev).toBe(false)})});describe("hasNext",function(){it("true with rsp.links.next",function(){payload.links={next:{href:"blah"}};collection.parse(payload);expect(collection.hasNext).toBe(true)});it("false without rsp.links.next",function(){collection.parse(payload);expect(collection.hasNext).toBe(false)})})})});describe("url",function(){it("With parentResource",function(){expect(collection.url()).toBe("/api/review-requests/123/reviews/")});it("With _fetchURL",function(){collection._fetchURL="/api/foo/";expect(collection.url()).toBe("/api/foo/")});it("Without _fetchURL or parentResource",function(){collection.parentResource=null;expect(collection.url()).toBe(null)})})})});suite("rb/resources/models/BaseComment",function(){var strings=RB.BaseComment.strings,parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.BaseComment({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("State values",function(){it("STATE_DROPPED",function(){expect(RB.BaseComment.STATE_DROPPED).toBe("dropped")});it("STATE_OPEN",function(){expect(RB.BaseComment.STATE_OPEN).toBe("open")});it("STATE_RESOLVED",function(){expect(RB.BaseComment.STATE_RESOLVED).toBe("resolved")})});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){var data=model.parse({stat:"ok",my_comment:{id:42,issue_opened:true,issue_status:"resolved",text:"foo"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.text).toBe("foo")})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("issue_opened field",function(){it("Default",function(){var data=model.toJSON();expect(data.issue_opened).toBe(null)});it("With value",function(){var data;model.set("issueOpened",false);data=model.toJSON();expect(data.issue_opened).toBe(false);model.set("issueOpened",true);data=model.toJSON();expect(data.issue_opened).toBe(true)})});describe("issue_status field",function(){it("When not loaded",function(){var data;model.set("issueStatus",RB.BaseComment.STATE_DROPPED);data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is not public",function(){var data;parentObject.set("public",false);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});data=model.toJSON();expect(data.issue_status).toBe(undefined)});it("When loaded and parent is public",function(){var data;parentObject.set("public",true);model.set({loaded:true,issueStatus:RB.BaseComment.STATE_DROPPED,parentObject:parentObject});data=model.toJSON();expect(data.issue_status).toBe(RB.BaseComment.STATE_DROPPED)})});describe("richText field",function(){it("With true",function(){var data;model.set("richText",true);data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){var data;model.set("richText",false);data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){var data;model.set("text","foo");data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("issueState",function(){it("STATE_DROPPED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_DROPPED})).toBe(undefined)});it("STATE_OPEN",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_OPEN})).toBe(undefined)});it("STATE_RESOLVED",function(){expect(model.validate({issueStatus:RB.BaseComment.STATE_RESOLVED})).toBe(undefined)});it("Unset",function(){expect(model.validate({issueStatus:""})).toBe(undefined);expect(model.validate({issueStatus:undefined})).toBe(undefined);expect(model.validate({issueStatus:null})).toBe(undefined)});it("Invalid values",function(){expect(model.validate({issueStatus:"foobar"})).toBe(strings.INVALID_ISSUE_STATUS)})});describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});suite("rb/resources/models/BaseCommentReply",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.BaseCommentReply({parentObject:parentObject});expect(model.validate(model.attributes)).toBe(undefined)});describe("destroyIfEmpty",function(){beforeEach(function(){spyOn(model,"destroy")});it("Destroying when text is empty",function(){model.set("text","");model.destroyIfEmpty();expect(model.destroy).toHaveBeenCalled()});it("Not destroying when text is not empty",function(){model.set("text","foo");model.destroyIfEmpty();expect(model.destroy).not.toHaveBeenCalled()})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_comment"});it("API payloads",function(){var data=model.parse({stat:"ok",my_comment:{id:42,text:"foo",text_type:"markdown"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.text).toBe("foo");expect(data.richText).toBe(true)})});describe("toJSON",function(){describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("reply_to_id field",function(){it("When loaded",function(){var data;model.set({replyToID:10,loaded:true});data=model.toJSON();expect(data.reply_to_id).toBe(undefined)});it("When not loaded",function(){var data;model.set({replyToID:10,loaded:false});data=model.toJSON();expect(data.reply_to_id).toBe(10)})});describe("richText field",function(){it("With true",function(){var data;model.set("richText",true);data=model.toJSON();expect(data.text_type).toBe("markdown")});it("With false",function(){var data;model.set("richText",false);data=model.toJSON();expect(data.text_type).toBe("plain")})});describe("text field",function(){it("With value",function(){var data;model.set("text","foo");data=model.toJSON();expect(data.text).toBe("foo")})})});describe("validate",function(){describe("parentObject",function(){it("With value",function(){expect(model.validate({parentObject:parentObject})).toBe(undefined)});it("Unset",function(){expect(model.validate({parentObject:null})).toBe(RB.BaseResource.strings.UNSET_PARENT_OBJECT)})})})});suite("rb/resources/models/BaseResource",function(){var model,parentObject;beforeEach(function(){model=new RB.BaseResource;model.rspNamespace="foo";parentObject=new RB.BaseResource({links:{foos:{href:"/api/foos/"}}})});describe("ensureCreated",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"save").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"fetch").andCallFake(function(options,context){options.success.call(context)});spyOn(model,"ready").andCallThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With loaded=true",function(){beforeEach(function(){model.set("loaded",true)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled();

expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).not.toHaveBeenCalled()})});describe("With loaded=false, isNew=true",function(){beforeEach(function(){model.set("loaded",false)});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).not.toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})});describe("With loaded=false, isNew=false",function(){beforeEach(function(){model.set({loaded:false,id:1})});it("With callbacks",function(){model.ensureCreated(callbacks);expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Without callbacks",function(){model.ensureCreated();expect(model.ready).toHaveBeenCalled();expect(model.fetch).toHaveBeenCalled();expect(model.save).toHaveBeenCalled()})})})});describe("fetch",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123)});it("With callbacks",function(){model.fetch(callbacks);expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").andCallFake(function(options,context){options.ready.call(context)})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled()})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}})});it("With callbacks",function(){model.fetch(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()});it("Without callbacks",function(){model.fetch();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled()})})});describe("Response handling",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})});it("Custom response parsing",function(){spyOn(model,"parse").andCallFake(function(rsp){return{a:rsp.a+1,b:rsp.b,c:true}});spyOn($,"ajax").andCallFake(function(request){request.success({a:10,b:20,d:30})});model.fetch();expect(model.get("a")).toBe(11);expect(model.get("b")).toBe(20);expect(model.get("c")).toBe(true);expect(model.get("d")).toBe(undefined)});it("Default response parsing",function(){spyOn(model,"parse").andCallThrough();spyOn($,"ajax").andCallFake(function(request){request.success({stat:"ok",foo:{id:42,links:{foo:{href:"bar"}},a:20}})});model.fetch();expect(model.get("a")).toBe(undefined);expect(model.id).toBe(42);expect(model.get("links").foo).not.toBe(undefined);expect(model.get("loaded")).toBe(true)})});describe("Request payload",function(){beforeEach(function(){model.set({id:123,links:{self:{href:"/api/foo/"}}})});describe("GET",function(){it("No contentType sent",function(){spyOn(Backbone,"sync").andCallFake(function(method,model,options){expect(options.contentType).toBe(undefined)});model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("No model data sent",function(){spyOn(Backbone,"sync").andCallFake(function(method,model,options){expect(_.isEmpty(options.data)).toBe(true)});model.toJSON=function(){return{a:1,b:2}};model.fetch();expect(Backbone.sync).toHaveBeenCalled()});it("Query attributes sent",function(){spyOn(Backbone,"sync").andCallFake(function(method,model,options){expect(_.isEmpty(options.data)).toBe(false);expect(options.data.foo).toBe("bar")});model.toJSON=function(){return{a:1,b:2}};model.fetch({data:{foo:"bar"}});expect(Backbone.sync).toHaveBeenCalled()})})})});describe("ready",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(model,"fetch").andCallFake(function(options){options.success()});spyOn(callbacks,"ready");spyOn(callbacks,"error")});it("With loaded=true",function(){model.set("loaded",true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=true",function(){model.set("loaded",false);expect(model.isNew()).toBe(true);model.ready(callbacks);expect(model.fetch).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With loaded=false and isNew=false",function(){model.set({loaded:false,id:123});expect(model.isNew()).toBe(false);model.ready(callbacks);expect(model.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("save",function(){var callbacks;describe("Callback handling",function(){beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(model,"trigger")});describe("With isNew=true and parentObject",function(){beforeEach(function(){spyOn(parentObject,"ensureCreated").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(Backbone.Model.prototype,"save").andCallThrough();model.set("parentObject",parentObject);spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");request.success({foo:{},stat:"ok"})})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(parentObject.ensureCreated).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=true and no parentObject",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"save").andCallThrough();spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(){})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})});describe("With isNew=false and no parentObject",function(){beforeEach(function(){model.set("id",123);model.url="/api/foos/1/";spyOn(Backbone.Model.prototype,"save").andCallFake(function(attrs,options){if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject",function(){beforeEach(function(){spyOn(parentObject,"ensureCreated").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(Backbone.Model.prototype,"save").andCallThrough();model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("PUT");request.success({foo:{},stat:"ok"})})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",callbacks)});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("saved",{})})});describe("With isNew=false and parentObject with error",function(){beforeEach(function(){model.set({parentObject:parentObject,id:123});spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.error)){options.error.call(context,"Oh nosers.")}});spyOn(Backbone.Model.prototype,"save").andCallFake(function(attrs,options){if(options&&_.isFunction(options.success)){options.success()}})});it("With callbacks",function(){model.save(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")});it("Without callbacks",function(){model.save();expect(parentObject.ready).toHaveBeenCalled();expect(Backbone.Model.prototype.save).not.toHaveBeenCalled();expect(model.trigger).not.toHaveBeenCalledWith("saved")})})});describe("Request payload",function(){it("Saved data",function(){model.set("id",1);model.url="/api/foos/";expect(model.isNew()).toBe(false);spyOn(model,"toJSON").andCallFake(function(){return{a:10,b:20,c:30}});spyOn(model,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.url).toBe(model.url);expect(request.contentType).toBe("application/x-www-form-urlencoded");expect(request.processData).toBe(true);expect(request.data.a).toBe(10);expect(request.data.b).toBe(20);expect(request.data.c).toBe(30);request.success({stat:"ok",foo:{id:1,a:10,b:20,c:30,links:{}}})});model.save();expect(model.toJSON).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})});describe("With file upload support",function(){beforeEach(function(){model.payloadFileKeys=["file"];model.url="/api/foos/";model.toJSON=function(){return{file:this.get("file"),myfield:"myvalue"}};spyOn(Backbone.Model.prototype,"save").andCallThrough();spyOn(RB,"apiCall").andCallThrough()});it("With file",function(){var seenComplete=false,boundary="-----multipartformboundary";runs(function(){var blob=new Blob(["Hello world!"],{type:"text/plain"});blob.name="myfile";spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);expect(request.data).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file"'+'; filename="myfile"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})});model.set("file",blob);model.save({success:function(){seenComplete=true},boundary:boundary})});waitsFor(function(){return seenComplete});runs(function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})});it("With multiple files",function(){var seenComplete=false,boundary="-----multipartformboundary";runs(function(){var blob1=new Blob(["Hello world!"],{type:"text/plain"}),blob2=new Blob(["Goodbye world!"],{type:"text/plain"});blob1.name="myfile1";blob2.name="myfile2";model.payloadFileKeys=["file1","file2"];model.toJSON=function(){return{file1:this.get("file1"),file2:this.get("file2"),myfield:"myvalue"}};spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.processData).toBe(false);expect(request.contentType.indexOf("multipart/form-data; boundary=")).toBe(0);expect(request.data).toBe("--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file1"'+'; filename="myfile1"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Hello world!"+"\r\n"+"--"+boundary+"\r\n"+'Content-Disposition: form-data; name="file2"'+'; filename="myfile2"\r\n'+"Content-Type: text/plain\r\n\r\n"+"Goodbye world!"+"\r\n"+"--"+boundary+"\r\n"+"Content-Disposition: form-data; "+'name="myfield"\r\n\r\n'+"myvalue\r\n"+"--"+boundary+"--\r\n\r\n");request.success({stat:"ok",foo:{id:42}})});model.set("file1",blob1);model.set("file2",blob2);model.save({success:function(){seenComplete=true},boundary:boundary})});waitsFor(function(){return seenComplete});runs(function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})});it("Without file",function(){runs(function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.processData).toBe(true);expect(request.contentType).toBe("application/x-www-form-urlencoded");request.success({stat:"ok",foo:{id:42}})});model.save({success:function(){seenComplete=true}})});waitsFor(function(){return seenComplete});runs(function(){expect(Backbone.Model.prototype.save).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()})})});describe("With form upload support",function(){beforeEach(function(){model.url="/api/foos/"});it("Overriding toJSON attributes",function(){var form=$("<form/>").append($('<input name="foo"/>'));model.toJSON=function(){return{myfield:"myvalue"}};spyOn(Backbone,"sync").andCallThrough();spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls[0].args[2].data).toBe(null);expect(RB.apiCall.calls[0].args[0].data).toBe(null)});it("Overriding file attributes",function(){var form=$("<form/>").append($('<input name="foo"/>'));model.payloadFileKey="file";model.toJSON=function(){return{file:this.get("file")}};spyOn(model,"_saveWithFiles").andCallThrough();spyOn(Backbone,"sync").andCallThrough();spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax");spyOn(form,"ajaxSubmit");model.save({form:form});expect(model._saveWithFiles).not.toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect(form.ajaxSubmit).toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(Backbone.sync.calls[0].args[2].data).toBe(null);expect(RB.apiCall.calls[0].args[0].data).toBe(null)})})});describe("url",function(){it("With self link",function(){var url="/api/base-resource/";model.set("links",{self:{href:url}});expect(model.url()).toBe(url)});it("With parentObject and model ID",function(){model.set({parentObject:parentObject,id:123});expect(model.url()).toBe("/api/foos/123/")});it("With parentObject, no links",function(){model.set("parentObject",parentObject);expect(model.url()).toBe("/api/foos/")});it("With no parentObject, no links",function(){expect(model.url()).toBe(null)})})});suite("rb/resources/models/DefaultReviewer",function(){var model;beforeEach(function(){model=new RB.DefaultReviewer});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",default_reviewer:{id:42,name:"my-default-reviewer",file_regex:"/foo/.*"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.name).toBe("my-default-reviewer");expect(data.fileRegex).toBe("/foo/.*")})});describe("toJSON",function(){describe("name field",function(){it("With value",function(){var data;model.set("name","foo");data=model.toJSON();expect(data.name).toBe("foo")})});describe("fileRegex field",function(){it("With value",function(){var data;model.set("fileRegex","/foo/.*");data=model.toJSON();expect(data.file_regex).toBe("/foo/.*")})})})});suite("rb/resources/models/DiffComment",function(){var model;beforeEach(function(){model=new RB.DiffComment({fileDiffID:16,parentObject:new RB.BaseResource({"public":true})})});it("getNumLines",function(){model.set({beginLineNum:5,endLineNum:10});expect(model.getNumLines()).toBe(6)});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",diff_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file"},interfilediff:{id:2,source_file:"my-file"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.beginLineNum).toBe(10);expect(data.endLineNum).toBe(14);expect(data.fileDiff).not.toBe(undefined);expect(data.fileDiff.id).toBe(1);expect(data.fileDiff.get("sourceFilename")).toBe("my-file");expect(data.interFileDiff).not.toBe(undefined);expect(data.interFileDiff.id).toBe(2);expect(data.interFileDiff.get("sourceFilename")).toBe("my-file")})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").andCallThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("first_line field",function(){var data;model.set({beginLineNum:100,endLineNum:100});data=model.toJSON();expect(data.first_line).toBe(100)});it("num_lines field",function(){var data;model.set({beginLineNum:100,endLineNum:105});data=model.toJSON();expect(data.num_lines).toBe(6)});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("filediff_id field",function(){it("When loaded",function(){var data;model.set("loaded",true);data=model.toJSON();expect(data.filediff_id).toBe(undefined)});it("When not loaded",function(){var data=model.toJSON();expect(data.filediff_id).toBe(16)})});describe("interfilediff_id field",function(){it("When loaded",function(){var data;model.set("loaded",true);data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)});it("When not loaded",function(){var data;model.set("interFileDiffID",50);data=model.toJSON();expect(data.interfilediff_id).toBe(50)});it("When not loaded and unset",function(){var data;data=model.toJSON();expect(data.interfilediff_id).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("beginLineNum/endLineNum",function(){describe("Valid values",function(){it("beginLineNum == 0, endLineNum == 0",function(){expect(model.validate({beginLineNum:0,endLineNum:0})).toBe(undefined)});it("beginLineNum > 0, endLineNum == beginLineNum",function(){expect(model.validate({beginLineNum:10,endLineNum:10})).toBe(undefined)});it("beginLineNum > 0, endLineNum > 0",function(){expect(model.validate({beginLineNum:10,endLineNum:11})).toBe(undefined)})});describe("Invalid values",function(){it("beginLineNum < 0",function(){expect(model.validate({beginLineNum:-1})).toBe(RB.DiffComment.strings.BEGINLINENUM_GTE_0)});it("endLineNum < 0",function(){expect(model.validate({endLineNum:-1})).toBe(RB.DiffComment.strings.ENDLINENUM_GTE_0)});it("endLineNum < beginLineNum",function(){expect(model.validate({beginLineNum:20,endLineNum:10})).toBe(RB.DiffComment.strings.BEGINLINENUM_LTE_ENDLINENUM)})})});describe("fileDiffID",function(){it("With value",function(){expect(model.validate({fileDiffID:42})).toBe(undefined)});it("Unset",function(){expect(model.validate({fileDiffID:null})).toBe(RB.DiffComment.strings.INVALID_FILEDIFF_ID)})})})});suite("rb/resources/models/DraftReview",function(){var model,parentObject;beforeEach(function(){parentObject=new RB.BaseResource({links:{reviews:{href:"/api/foos/"}}});model=new RB.DraftReview({parentObject:parentObject});model.rspNamespace="foo"});describe("Methods",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},success:function(){},error:function(){}};spyOn(callbacks,"ready");spyOn(callbacks,"success");spyOn(callbacks,"error")});describe("ready",function(){beforeEach(function(){spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"_retrieveDraft").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false)});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})})});describe("publish",function(){beforeEach(function(){spyOn(model,"save").andCallFake(function(options,context){options.success.call(context)})});it('Triggers "publishing" event before publish',function(){spyOn(model,"trigger");spyOn(model,"ready");model.publish();expect(model.trigger).toHaveBeenCalledWith("publishing")});it('Triggers "published" event after publish',function(){spyOn(model,"trigger");spyOn(model,"ready").andCallFake(function(options,context){options.ready.call(context)});model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.trigger).toHaveBeenCalledWith("published")});it('Sets "public" to true',function(){spyOn(model,"ready").andCallFake(function(options,context){options.ready.call(context)});expect(model.get("public")).toBe(false);model.publish(callbacks);expect(callbacks.success).toHaveBeenCalled();expect(model.get("public")).toBe(true)})})})});suite("rb/resources/models/DraftReviewRequest",function(){var draft,callbacks;beforeEach(function(){var reviewRequest=new RB.ReviewRequest({id:1,links:{draft:{href:"/api/review-requests/123/draft/"}}});draft=reviewRequest.draft;callbacks={success:function(){},error:function(){}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(reviewRequest,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(draft,"ready").andCallFake(function(options,context){options.ready.call(context)})});it("url",function(){expect(draft.url()).toBe("/api/review-requests/123/draft/")});it("publish",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.data["public"]).toBe(1);request.success({stat:"ok",draft:{id:1,links:{}}})});draft.set({targetGroups:[{name:"mygroup",url:"/groups/mygroup"}],summary:"My summary",description:"My description"});draft.publish({success:callbacks.success,error:callbacks.error});expect(callbacks.error).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled()});it("parse",function(){var data=draft.parse({stat:"ok",draft:{id:1,branch:"branch",bugs_closed:"bugsClosed",changedescription:"changeDescription",changedescription_text_type:"markdown",description:"description","public":"public",description_text_type:"markdown",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.changeDescription).toBe("changeDescription");expect(data.changeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data["public"]).toBe("public");expect(data.summary).toBe("summary");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)});describe("validate",function(){describe("When publishing",function(){var options={publishing:true},attrs;beforeEach(function(){attrs={targetGroups:[{name:"mygroup",url:"/groups/mygroup/"}],targetPeople:[{username:"myuser",url:"/users/myuser/"}],summary:"summary",description:"description"}});describe("Description",function(){it("Has description",function(){expect(draft.validate(attrs,options)).toBe(undefined)});it("No description",function(){attrs.description="";expect(draft.validate(attrs,options)).toBe(RB.DraftReviewRequest.strings.DESCRIPTION_REQUIRED)});it("No description (after trim)",function(){attrs.description="    ";expect(draft.validate(attrs,options)).toBe(RB.DraftReviewRequest.strings.DESCRIPTION_REQUIRED)})});describe("Summary",function(){it("Has summary",function(){expect(draft.validate(attrs,options)).toBe(undefined)});it("No summary",function(){attrs.summary="";expect(draft.validate(attrs,options)).toBe(RB.DraftReviewRequest.strings.SUMMARY_REQUIRED)});it("No summary (after trim)",function(){attrs.summary="    ";expect(draft.validate(attrs,options)).toBe(RB.DraftReviewRequest.strings.SUMMARY_REQUIRED)})});describe("Reviewers",function(){it("Has groups and no users",function(){attrs.targetPeople=[];expect(draft.validate(attrs,options)).toBe(undefined)});it("Has users and no groups",function(){attrs.targetGroups=[];expect(draft.validate(attrs,options)).toBe(undefined)});it("No reviewers",function(){attrs.targetGroups=[];attrs.targetPeople=[];expect(draft.validate(attrs,options)).toBe(RB.DraftReviewRequest.strings.REVIEWERS_REQUIRED)})})})})});suite("rb/resources/models/FileAttachment",function(){beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.FileAttachment({parentObject:parentObject})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){var data;model.set("caption","foo");data=model.toJSON();expect(data.caption).toBe("foo")})});describe("file field",function(){it("With new file attachment",function(){var data;expect(model.isNew()).toBe(true);model.set("file","abc");data=model.toJSON();expect(data.path).toBe("abc")});it("With existing file attachment",function(){var data;model.id=123;expect(model.isNew()).toBe(false);model.set("file","abc");data=model.toJSON();expect(data.path).toBe(undefined)})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",file_attachment:{id:42,caption:"caption",url:"downloadURL",filename:"filename",review_url:"reviewURL",revision:123,thumbnail:"thumbnailHTML"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("caption");expect(data.downloadURL).toBe("downloadURL");expect(data.filename).toBe("filename");expect(data.reviewURL).toBe("reviewURL");expect(data.revision).toBe(123);expect(data.thumbnailHTML).toBe("thumbnailHTML")})})});suite("rb/resources/models/FileAttachmentComment",function(){var baseStrings=RB.BaseResource.strings,model;beforeEach(function(){model=new RB.FileAttachmentComment({fileAttachmentID:16,parentObject:new RB.BaseResource({"public":true})})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",file_attachment_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",extra_data:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.extraData).not.toBe(undefined);expect(data.extraData.my_int).toBe(123);expect(data.extraData.my_bool).toBe(true);expect(data.extraData.my_str).toBe("strvalue");expect(data.extraData.my_null).toBe(null);expect(data.linkText).toBe("my-link-text");expect(data.thumbnailHTML).toBe("<blink>Boo</blink>");expect(data.reviewURL).toBe("/review-ui/");expect(data.fileAttachment).not.toBe(undefined);expect(data.fileAttachment.id).toBe(10);expect(data.fileAttachment.get("filename")).toBe("file.txt");expect(data.fileAttachmentID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").andCallThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});describe("diff_against_file_attachment_id field",function(){it("When loaded",function(){var data;model.set({loaded:true,diffAgainstFileAttachmentID:123});data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined);

});describe("When not loaded",function(){it("With value",function(){var data;model.set("diffAgainstFileAttachmentID",123);data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(123)});it("Without value",function(){var data;data=model.toJSON();expect(data.diff_against_file_attachment_id).toBe(undefined)})})});describe("file_attachment_id field",function(){it("When loaded",function(){var data;model.set({loaded:true,fileAttachmentID:123});data=model.toJSON();expect(data.file_attachment_id).toBe(undefined)});it("When not loaded",function(){var data;model.set("fileAttachmentID",123);data=model.toJSON();expect(data.file_attachment_id).toBe(123)})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});it("extra_data field",function(){var data;model.set({extraData:{my_int:123,my_bool:true,my_str:"strvalue",my_null:null}});data=model.toJSON();expect(data["extra_data.my_int"]).toBe(123);expect(data["extra_data.my_bool"]).toBe(true);expect(data["extra_data.my_str"]).toBe("strvalue");expect(data["extra_data.my_null"]).toBe(null)})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("extraData",function(){describe("Valid values",function(){it("Empty object",function(){expect(model.validate({extraData:{}})).toBe(undefined)});it("Populated object",function(){expect(model.validate({extraData:{a:42}})).toBe(undefined)});it("Undefined",function(){expect(model.validate({extraData:undefined})).toBe(undefined)})});describe("Invalid values",function(){var errStr=baseStrings.INVALID_EXTRADATA_TYPE;it("Array",function(){expect(model.validate({extraData:""})).toBe(errStr)});it("Boolean",function(){expect(model.validate({extraData:false})).toBe(errStr)});it("Integer",function(){expect(model.validate({extraData:0})).toBe(errStr)});it("Null",function(){expect(model.validate({extraData:null})).toBe(errStr)});it("String",function(){expect(model.validate({extraData:""})).toBe(errStr)})})});describe("extraData entries",function(){describe("Valid values",function(){it("Booleans",function(){expect(model.validate({extraData:{value:true}})).toBe(undefined)});it("Integers",function(){expect(model.validate({extraData:{value:42}})).toBe(undefined)});it("Null",function(){expect(model.validate({extraData:{value:null}})).toBe(undefined)});it("Strings",function(){expect(model.validate({extraData:{value:"foo"}})).toBe(undefined)})});describe("Invalid values",function(){var errStr=baseStrings.INVALID_EXTRADATA_VALUE_TYPE.replace("{key}","value");it("Arrays",function(){expect(model.validate({extraData:{value:[1,2,3]}})).toBe(errStr)});it("NaN",function(){expect(model.validate({extraData:{value:NaN}})).toBe(errStr)});it("Objects",function(){expect(model.validate({extraData:{value:{a:1}}})).toBe(errStr)});it("Undefined",function(){expect(model.validate({extraData:{value:undefined}})).toBe(errStr)})})})})});suite("rb/resources/models/FileDiff",function(){var model;beforeEach(function(){model=new RB.FileDiff({destFilename:"dest-file",sourceFilename:"source-file",sourceRevision:"source-revision"})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",filediff:{id:42,dest_file:"my-dest-file",source_file:"my-source-file",source_revision:"my-source-revision"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.destFilename).toBe("my-dest-file");expect(data.sourceFilename).toBe("my-source-file");expect(data.sourceRevision).toBe("my-source-revision")})})});suite("rb/resources/models/Screenshot",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true});model=new RB.Screenshot({parentObject:parentObject})});describe("getDisplayName",function(){it("With caption",function(){model.set("caption","My Caption");expect(model.getDisplayName()).toBe("My Caption")});it("With filename",function(){model.set("filename","myfile.png");expect(model.getDisplayName()).toBe("myfile.png")});it("With caption and filename",function(){model.set({caption:"My Caption",filename:"myfile.png"});expect(model.getDisplayName()).toBe("My Caption")})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",screenshot:{id:42,caption:"my-caption",filename:"my-filename",review_url:"/review-ui/"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.caption).toBe("my-caption");expect(data.filename).toBe("my-filename");expect(data.reviewURL).toBe("/review-ui/")})});describe("toJSON",function(){describe("caption field",function(){it("With value",function(){var data;model.set("caption","foo");data=model.toJSON();expect(data.caption).toBe("foo")})})})});suite("rb/resources/models/ScreenshotComment",function(){var strings=RB.ScreenshotComment.strings,model;beforeEach(function(){model=new RB.ScreenshotComment({screenshotID:16,parentObject:new RB.BaseResource({"public":true}),x:0,y:0,width:1,height:1})});describe("parse",function(){it("API payloads",function(){var data=model.parse({stat:"ok",screenshot_comment:{id:42,issue_opened:true,issue_status:"resolved",text_type:"markdown",text:"foo",x:10,y:20,w:30,h:40,thumbnail_url:"/thumbnail.png",screenshot:{id:10,filename:"image.png"}}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.issueOpened).toBe(true);expect(data.issueStatus).toBe(RB.BaseComment.STATE_RESOLVED);expect(data.richText).toBe(true);expect(data.text).toBe("foo");expect(data.x).toBe(10);expect(data.y).toBe(20);expect(data.width).toBe(30);expect(data.height).toBe(40);expect(data.thumbnailURL).toBe("/thumbnail.png");expect(data.screenshot).not.toBe(undefined);expect(data.screenshot.id).toBe(10);expect(data.screenshot.get("filename")).toBe("image.png");expect(data.screenshotID).toBe(10)})});describe("toJSON",function(){it("BaseComment.toJSON called",function(){spyOn(RB.BaseComment.prototype,"toJSON").andCallThrough();model.toJSON();expect(RB.BaseComment.prototype.toJSON).toHaveBeenCalled()});it("x field",function(){var data;model.set("x",10);data=model.toJSON();expect(data.x).toBe(10)});it("y field",function(){var data;model.set("y",10);data=model.toJSON();expect(data.y).toBe(10)});it("w field",function(){var data;model.set("width",10);data=model.toJSON();expect(data.w).toBe(10)});it("h field",function(){var data;model.set("height",10);data=model.toJSON();expect(data.h).toBe(10)});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})})});describe("validate",function(){it("Inherited behavior",function(){spyOn(RB.BaseComment.prototype,"validate");model.validate({});expect(RB.BaseComment.prototype.validate).toHaveBeenCalled()});describe("x",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({x:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({x:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({x:-1})).toBe(strings.INVALID_X)})})});describe("y",function(){describe("Valid values",function(){it("0",function(){expect(model.validate({y:0})).toBe(undefined)});it("> 0",function(){expect(model.validate({y:10})).toBe(undefined)})});describe("Invalid values",function(){it("< 0",function(){expect(model.validate({y:-1})).toBe(strings.INVALID_Y)})})});describe("width",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({width:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({width:0})).toBe(strings.INVALID_WIDTH)});it("< 0",function(){expect(model.validate({width:-1})).toBe(strings.INVALID_WIDTH)})})});describe("height",function(){describe("Valid values",function(){it("> 0",function(){expect(model.validate({height:10})).toBe(undefined)})});describe("Invalid values",function(){it("0",function(){expect(model.validate({height:0})).toBe(strings.INVALID_HEIGHT)});it("< 0",function(){expect(model.validate({height:-1})).toBe(strings.INVALID_HEIGHT)})})})})});suite("rb/resources/models/RepositoryBranch",function(){var model;beforeEach(function(){model=new RB.RepositoryBranch});describe("parse",function(){it("API payloads",function(){var data=model.parse({name:"master",commit:"c8ffef025488802a77f499d7f0d24579d858b07e","default":true});expect(data).not.toBe(undefined);expect(data.name).toBe("master");expect(data.commit).toBe("c8ffef025488802a77f499d7f0d24579d858b07e");expect(data.isDefault).toBe(true)})})});suite("rb/resources/models/RepositoryCommit",function(){var model;beforeEach(function(){model=new RB.RepositoryCommit});describe("parse",function(){it("API payloads",function(){var data=model.parse({author_name:"Sneezy",date:"2013-06-25T23:31:22Z",id:"859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817",message:"Here's a commit message\n\nWith a description",review_request_url:"http://example.com/r/12/"});expect(data).not.toBe(undefined);expect(data.authorName).toBe("Sneezy");expect(data.id).toBe("859d4e148ce3ce60bbda6622cdbe5c2c2f8d9817");expect(data.date.getUTCFullYear()).toBe(2013);expect(data.date.getUTCDate()).toBe(25);expect(data.message).toBe("Here's a commit message\n\nWith a description");expect(data.summary).toBe("Here's a commit message");expect(data.reviewRequestURL).toBe("http://example.com/r/12/")})})});suite("rb/resources/models/ReviewGroup",function(){describe("setStarred",function(){var url="/api/users/testuser/watched/groups/",callbacks,session,group;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewGroupsURL:url});group=new RB.ReviewGroup({id:1});callbacks={success:function(){},error:function(){}};spyOn(session.watchedGroups,"addImmediately").andCallThrough();spyOn(session.watchedGroups,"removeImmediately").andCallThrough();spyOn(RB,"apiCall").andCallThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("true",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});group.setStarred(true,callbacks);expect(session.watchedGroups.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});group.setStarred(false,callbacks);expect(session.watchedGroups.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("addUser",function(){var callbacks,group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").andCallThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.data.username).toBe("my-user");request.success({stat:"ok"})});group.addUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.addUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})});describe("removeUser",function(){var callbacks,group;beforeEach(function(){group=new RB.ReviewGroup({id:1,name:"test-group"});callbacks={success:function(){},error:function(){}};spyOn(RB,"apiCall").andCallThrough();spyOn(callbacks,"success");spyOn(callbacks,"error")});it("Loaded group",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("DELETE");request.success()});group.removeUser("my-user",callbacks);expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled()});it("Unloaded group",function(){spyOn($,"ajax");group.set("id",null);expect(group.isNew()).toBe(true);group.removeUser("my-user",callbacks);expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.error).toHaveBeenCalled()})})});suite("rb/resources/models/Review",function(){var model;beforeEach(function(){model=new RB.Review({parentObject:new RB.ReviewRequest})});describe("createReply",function(){it("Returns cached draft reply",function(){var reviewReply,reviewReply2;expect(model.get("draftReply")).toBe(null);reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);reviewReply2=model.createReply();expect(reviewReply).toBe(reviewReply2)});it("Cached draft reply resets on publish",function(){var reviewReply;reviewReply=model.createReply();expect(model.get("draftReply")).toBe(reviewReply);reviewReply.trigger("published");expect(model.get("draftReply")).toBe(null)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_review"});it("API payloads",function(){var data=model.parse({stat:"ok",my_review:{id:42,body_top:"foo",body_bottom:"bar","public":false,body_top_text_type:"markdown",body_bottom_text_type:"plain",ship_it:false}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("foo");expect(data.bodyBottom).toBe("bar");expect(data["public"]).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false);expect(data.shipIt).toBe(false)})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){var data;model.set("bodyTop","foo");data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){var data;model.set("bodyBottom","foo");data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){var data;model.set("public",true);data=model.toJSON();expect(data["public"]).toBe(1)});it("Without value",function(){var data=model.toJSON();expect(data["public"]).toBe(undefined)})});describe("bodyTopRichText field",function(){it("With true",function(){var data;model.set("bodyTopRichText",true);data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyTopRichText",false);data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){var data;model.set("bodyBottomRichText",true);data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyBottomRichText",false);data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("shipIt field",function(){it("With value",function(){var data;model.set("shipIt",true);data=model.toJSON();expect(data.ship_it).toBe(true)})})})});suite("rb/resources/models/ReviewReply",function(){var parentObject,model;beforeEach(function(){parentObject=new RB.BaseResource({"public":true,links:{replies:{href:"/api/foos/replies/"}}});model=new RB.ReviewReply({parentObject:parentObject})});describe("destroy",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(Backbone.Model.prototype,"destroy").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").andCallThrough();spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.error(model,{status:404})}})});it("With callbacks",function(){model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123,loaded:true});spyOn(Backbone.Model.prototype,"fetch")});it("With callbacks",function(){model.destroy(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).not.toHaveBeenCalled();expect(Backbone.Model.prototype.destroy).toHaveBeenCalled()})})});describe("discardIfEmpty",function(){var callbacks;beforeEach(function(){callbacks={success:function(){},error:function(){}};spyOn(model,"destroy").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(model,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"success");spyOn(callbacks,"error")});it("With isNew=true",function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled()});describe("With isNew=false",function(){var commentsData={};beforeEach(function(){model.set({id:123,loaded:true,links:{self:{href:"/api/foos/replies/123/"},diff_comments:{href:"/api/diff-comments/"},screenshot_comments:{href:"/api/screenshot-comments/"},file_attachment_comments:{href:"/api/file-attachment-comments/"}}});spyOn(RB,"apiCall").andCallFake(function(options){var links=model.get("links"),data={},key=_.find(RB.ReviewReply.prototype.COMMENT_LINK_NAMES,function(name){return options.url===links[name].href});if(key){data[key]=commentsData[key]||[];options.success(data)}else{options.error({status:404})}});spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}})});it("With no comments or body replies",function(){model.discardIfEmpty(callbacks);expect(model.destroy).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(true)});it("With bodyTop",function(){model.set({bodyTop:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With bodyBottom",function(){model.set({bodyBottom:"hi"});model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With diff comment",function(){commentsData.diff_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With screenshot comment",function(){commentsData.screenshot_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)});it("With file attachment comment",function(){commentsData.file_attachment_comments=[{id:1}];model.discardIfEmpty(callbacks);expect(model.destroy).not.toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalledWith(false)})})});describe("ready",function(){var callbacks;beforeEach(function(){callbacks={ready:function(){},error:function(){}};spyOn(parentObject,"ready").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}});spyOn(callbacks,"ready");spyOn(callbacks,"error")});describe("With isNew=true",function(){beforeEach(function(){expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});describe("With isNew=false",function(){beforeEach(function(){model.set({id:123});spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){if(options&&_.isFunction(options.success)){options.success()}});spyOn(model,"_retrieveDraft").andCallFake(function(options,context){if(options&&_.isFunction(options.ready)){options.ready.call(context)}})});it("With callbacks",function(){model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).not.toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled()})});it("After destruction",function(){spyOn(model,"_retrieveDraft").andCallThrough();spyOn(Backbone.Model.prototype,"fetch").andCallFake(function(options){model.set({id:123,links:{self:{href:"/api/foos/replies/123/"}},loaded:true});options.success()});spyOn(Backbone.Model.prototype,"destroy").andCallFake(function(options){options.success()});expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(undefined);model.ready(callbacks);expect(parentObject.ready).toHaveBeenCalled();expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model.isNew()).toBe(false);expect(model.get("loaded")).toBe(true);expect(model._needDraft).toBe(false);model.destroy(callbacks);expect(model.isNew()).toBe(true);expect(model.get("loaded")).toBe(false);expect(model._needDraft).toBe(true);parentObject.ready.reset();model._retrieveDraft.reset();callbacks.ready.reset();model.ready(callbacks);expect(model._retrieveDraft).toHaveBeenCalled();expect(Backbone.Model.prototype.fetch).toHaveBeenCalled();expect(callbacks.ready).toHaveBeenCalled();expect(model._needDraft).toBe(false)})});describe("parse",function(){beforeEach(function(){model.rspNamespace="my_reply"});it("API payloads",function(){var data=model.parse({stat:"ok",my_reply:{id:42,body_top:"foo",body_bottom:"bar","public":false,body_top_text_type:"markdown",body_bottom_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(42);expect(data.bodyTop).toBe("foo");expect(data.bodyBottom).toBe("bar");expect(data["public"]).toBe(false);expect(data.bodyTopRichText).toBe(true);expect(data.bodyBottomRichText).toBe(false)})});describe("toJSON",function(){describe("bodyTop field",function(){it("With value",function(){var data;model.set("bodyTop","foo");data=model.toJSON();expect(data.body_top).toBe("foo")})});describe("bodyBottom field",function(){it("With value",function(){var data;model.set("bodyBottom","foo");data=model.toJSON();expect(data.body_bottom).toBe("foo")})});describe("bodyTopRichText field",function(){it("With true",function(){var data;model.set("bodyTopRichText",true);data=model.toJSON();expect(data.body_top_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyTopRichText",false);data=model.toJSON();expect(data.body_top_text_type).toBe("plain")})});describe("bodyBottomRichText field",function(){it("With true",function(){var data;model.set("bodyBottomRichText",true);data=model.toJSON();expect(data.body_bottom_text_type).toBe("markdown")});it("With false",function(){var data;model.set("bodyBottomRichText",false);data=model.toJSON();expect(data.body_bottom_text_type).toBe("plain")})});describe("force_text_type field",function(){it("With value",function(){var data;model.set("forceTextType","html");data=model.toJSON();expect(data.force_text_type).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.force_text_type).toBe(undefined)})});describe("include_text_types field",function(){it("With value",function(){var data;model.set("includeTextTypes","html");data=model.toJSON();expect(data.include_text_types).toBe("html")});it("Without value",function(){var data=model.toJSON();expect(data.include_text_types).toBe(undefined)})});describe("public field",function(){it("With value",function(){var data;model.set("public",true);data=model.toJSON();expect(data["public"]).toBe(true)})})})});suite("rb/resources/models/ReviewRequest",function(){var reviewRequest,callbacks;beforeEach(function(){reviewRequest=new RB.ReviewRequest({id:1});callbacks={success:function(){},error:function(){}};spyOn(callbacks,"success");spyOn(callbacks,"error");spyOn(reviewRequest,"ready").andCallFake(function(options,context){options.ready.call(context)})});it("createDiff",function(){var diff=reviewRequest.createDiff();expect(diff.get("parentObject")).toBe(reviewRequest)});it("createScreenshot",function(){var screenshot=reviewRequest.createScreenshot(42);expect(screenshot.get("parentObject")).toBe(reviewRequest);expect(screenshot.id).toBe(42)});it("createFileAttachment",function(){var fileAttachment=reviewRequest.createFileAttachment({id:42});expect(fileAttachment.get("parentObject")).toBe(reviewRequest);expect(fileAttachment.id).toBe(42)});it("parse",function(){var data=reviewRequest.parse({stat:"ok",review_request:{id:1,branch:"branch",bugs_closed:"bugsClosed",close_description:"closeDescription",close_description_text_type:"markdown",description:"description",description_text_type:"markdown",last_updated:"lastUpdated","public":"public",summary:"summary",target_groups:"targetGroups",target_people:"targetPeople",testing_done:"testingDone",testing_done_text_type:"plain"}});expect(data).not.toBe(undefined);expect(data.id).toBe(1);expect(data.branch).toBe("branch");expect(data.bugsClosed).toBe("bugsClosed");expect(data.closeDescription).toBe("closeDescription");expect(data.closeDescriptionRichText).toBe(true);expect(data.description).toBe("description");expect(data.descriptionRichText).toBe(true);expect(data.lastUpdated).toBe("lastUpdated");expect(data["public"]).toBe("public");expect(data.summary).toBe("summary");expect(data.targetGroups).toBe("targetGroups");expect(data.targetPeople).toBe("targetPeople");expect(data.testingDone).toBe("testingDone");expect(data.testingDoneRichText).toBe(false)});it("reopen",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("pending");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.reopen({success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});describe("createReview",function(){it("With review ID",function(){var review=reviewRequest.createReview(42);expect(review.get("parentObject")).toBe(reviewRequest);expect(review.get("id")).toBe(42);expect(reviewRequest.get("draftReview")).toBe(null);expect(reviewRequest.reviews.length).toBe(1);expect(reviewRequest.reviews.get(42)).toBe(review)});it("Without review ID",function(){var review1=reviewRequest.createReview(),review2=reviewRequest.createReview();expect(review1.get("parentObject")).toBe(reviewRequest);expect(review1.id).toBeFalsy();expect(reviewRequest.get("draftReview")).toBe(review1);expect(review1).toBe(review2);expect(reviewRequest.reviews.length).toBe(0)})});describe("setStarred",function(){var url="/api/users/testuser/watched/review-requests/",session;beforeEach(function(){RB.UserSession.instance=null;session=RB.UserSession.create({username:"testuser",watchedReviewRequestsURL:url});spyOn(session.watchedReviewRequests,"addImmediately").andCallThrough();spyOn(session.watchedReviewRequests,"removeImmediately").andCallThrough();spyOn(RB,"apiCall").andCallThrough()});it("true",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("POST");expect(request.url).toBe(url);request.success({stat:"ok"})});reviewRequest.setStarred(true,callbacks);expect(session.watchedReviewRequests.addImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("false",function(){spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("DELETE");expect(request.url).toBe(url+"1/");request.success({stat:"ok"})});reviewRequest.setStarred(false,callbacks);expect(session.watchedReviewRequests.removeImmediately).toHaveBeenCalled();expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})});describe("close",function(){it("With type=CLOSE_DISCARDED",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("discarded");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With type=CLOSE_SUBMITTED",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.description).toBe(undefined);request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()});it("With invalid type",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax");reviewRequest.close({type:"foo",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).not.toHaveBeenCalled();expect($.ajax).not.toHaveBeenCalled();expect(callbacks.success).not.toHaveBeenCalled();

expect(callbacks.error).toHaveBeenCalled()});it("With description",function(){spyOn(RB,"apiCall").andCallThrough();spyOn($,"ajax").andCallFake(function(request){expect(request.type).toBe("PUT");expect(request.data.status).toBe("submitted");expect(request.data.close_description).toBe("test");request.success({stat:"ok",review_request:{id:1,links:{}}})});reviewRequest.close({type:RB.ReviewRequest.CLOSE_SUBMITTED,description:"test",success:callbacks.success,error:callbacks.error});expect(RB.apiCall).toHaveBeenCalled();expect($.ajax).toHaveBeenCalled();expect(callbacks.success).toHaveBeenCalled();expect(callbacks.error).not.toHaveBeenCalled()})})});suite("rb/resources/models/ValidateDiffModel",function(){var model;beforeEach(function(){model=new RB.ValidateDiffModel});describe("methods",function(){describe("url",function(){it("Without local site",function(){expect(_.result(model,"url")).toBe("/api/validation/diffs/")});it("With local site",function(){model.set("localSitePrefix","s/test-site/");expect(_.result(model,"url")).toBe("/s/test-site/api/validation/diffs/")})})});describe("toJSON",function(){it("repository field",function(){var data;model.set("repository",123);data=model.toJSON();expect(model.get("repository")).toBe(123)})})});suite("rb/ui/views/DialogView",function(){describe("Buttons",function(){describe("Settings",function(){it("Default",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test"}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(false);expect(buttons[0].hasClass("danger")).toBe(false)});it("Primary",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test",primary:true}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(true);expect(buttons[0].hasClass("danger")).toBe(false)});it("Danger",function(){var dialogView=new RB.DialogView({buttons:[{label:"Test",danger:true}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");expect(buttons[0].hasClass("primary")).toBe(false);expect(buttons[0].hasClass("danger")).toBe(true)})});describe("Events",function(){describe("Click",function(){it("When function",function(){var myFunc=jasmine.createSpy("cb"),dialogView=new RB.DialogView({buttons:[{label:"Test",onClick:myFunc}]}),buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");buttons[0].click();expect(myFunc).toHaveBeenCalled()});it("When string on subclass",function(){var MyDialogView=RB.DialogView.extend({buttons:[{label:"Test",onClick:"_onClicked"}],_onClicked:jasmine.createSpy("cb")}),dialogView=new MyDialogView,buttons=dialogView._getButtons();expect(buttons.length).toBe(1);expect(buttons[0].val()).toBe("Test");buttons[0].click();expect(dialogView._onClicked).toHaveBeenCalled()})})})})});suite("rb/ui/views/TextEditorView",function(){var view;describe("Construction",function(){it("Initial text",function(){view=new RB.TextEditorView({text:"Test"});view.render();expect(view.getText()).toBe("Test")});describe("Text field wrapper",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("Default richText",function(){describe("If user default is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)})});describe("If user default is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("And richText unset",function(){view=new RB.TextEditorView;view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("And richText=true",function(){view=new RB.TextEditorView({richText:true});view.render();view.show();expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("And richText=false",function(){view=new RB.TextEditorView({richText:false});view.render();view.show();expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)})})})});describe("Operations",function(){describe("bindRichTextAttr",function(){var myModel;beforeEach(function(){myModel=new Backbone.Model({richText:false});view=new RB.TextEditorView});it("Updates on change",function(){view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false);myModel.set("richText",true);expect(view.richText).toBe(true)});describe("Initial richText value",function(){it("true",function(){myModel.set("richText",true);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(true)});it("false",function(){myModel.set("richText",false);view.bindRichTextAttr(myModel,"richText");expect(view.richText).toBe(false)})})});describe("bindRichTextCheckbox",function(){var $checkbox;beforeEach(function(){$checkbox=$('<input type="checkbox"/>');view=new RB.TextEditorView;view.setRichText(false)});it("Checkbox reflects richText",function(){view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false);view.setRichText(true);expect($checkbox.prop("checked")).toBe(true)});describe("richText reflects checkbox",function(){it("Checked",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",true).triggerHandler("change");expect(view.richText).toBe(true)});it("Unchecked",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);$checkbox.prop("checked",false).triggerHandler("change");expect(view.richText).toBe(false)})});describe("Initial checked state",function(){it("richText=true",function(){view.setRichText(true);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(true)});it("richText=false",function(){view.setRichText(false);view.bindRichTextCheckbox($checkbox);expect($checkbox.prop("checked")).toBe(false)})})});describe("bindRichTextVisibility",function(){var $el;beforeEach(function(){$el=$("<div/>");view=new RB.TextEditorView;view.setRichText(false)});describe("Initial visibility",function(){it("richText=true",function(){$el.hide();view.setRichText(true);view.bindRichTextVisibility($el);expect($el.css("display")).toBe("block")});it("richText=false",function(){view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none")})});describe("Toggles visibility on change",function(){it("richText=true",function(){$el.hide();view.bindRichTextVisibility($el);expect($el.css("display")).toBe("none");view.setRichText(true);expect($el.css("display")).toBe("block")});it("richText=false",function(){view.setRichText(true);view.bindRichTextVisibility($el);expect($el.css("display")).toBe("block");view.setRichText(false);expect($el.css("display")).toBe("none")})})});describe("setRichText",function(){it("Emits change:richText",function(){var emitted=false;view.on("change:richText",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Emits change",function(){var emitted=false;view.on("change",function(){emitted=true});view.show();view.richText=false;view.setRichText(true);expect(emitted).toBe(true)});it("Marks dirty",function(){view.show();view.richText=false;expect(view.isDirty()).toBe(false);view.setRichText(true);expect(view.isDirty()).toBe(true)});describe("Markdown to Text",function(){beforeEach(function(){view=new RB.TextEditorView({richText:true});view.render()});it("If shown",function(){view.show();view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(1);expect(view.$el.children(".CodeMirror").length).toBe(0)});it("If hidden",function(){view.setRichText(false);expect(view.richText).toBe(false);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})});describe("Text to Markdown",function(){beforeEach(function(){view=new RB.TextEditorView({richText:false});view.render()});it("If shown",function(){view.show();view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(1)});it("If hidden",function(){view.setRichText(true);expect(view.richText).toBe(true);expect(view.$el.children("textarea").length).toBe(0);expect(view.$el.children(".CodeMirror").length).toBe(0)})})});describe("setText",function(){describe("If shown",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.$("textarea").val()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view._editor._codeMirror.getValue()).toBe("Test")})});it("If hidden",function(){view=new RB.TextEditorView;view.setText("Test");expect(view.getText()).toBe("Test")})});describe("getText",function(){it("If plain text",function(){view=new RB.TextEditorView({richText:false});view.show();view.setText("Test");expect(view.getText()).toBe("Test")});it("If Markdown",function(){view=new RB.TextEditorView({richText:true});view.show();view.setText("Test");expect(view.getText()).toBe("Test")})})});describe("Events",function(){});describe("inlineEditor options",function(){var $el,$buttons,$markdownCheckbox;function setupEditor(options){$el=$("<textarea>").inlineEditor(RB.TextEditorView.getInlineEditorOptions(options));view=$el.inlineEditor("field").data("text-editor");$el.inlineEditor("startEdit");$buttons=$el.inlineEditor("buttons");expect($buttons.length).toBe(1);$markdownCheckbox=$buttons.find("input[type=checkbox]");expect($markdownCheckbox.length).toBe(1)}describe("Rich text checkbox",function(){function setChecked(checked){$markdownCheckbox.click().prop("checked",checked).trigger("change")}it("Checking",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false);setChecked(true);expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true)});it("Unchecking",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true);setChecked(false);expect($markdownCheckbox.prop("checked")).toBe(false);expect(view.richText).toBe(false)});it("Resets after cancel",function(){setupEditor({richText:true});setChecked(false);$el.inlineEditor("cancel");expect($markdownCheckbox.prop("checked")).toBe(true);expect(view.richText).toBe(true);expect(view.isDirty()).toBe(false)});describe("Initial state",function(){it("If plain text",function(){setupEditor({richText:false});expect($markdownCheckbox.prop("checked")).toBe(false)});it("If Markdown",function(){setupEditor({richText:true});expect($markdownCheckbox.prop("checked")).toBe(true)})})})})});suite("rb/utils/keyBindingUtils",function(){describe("KeyBindingsMixin",function(){var MyView,view;function sendKeyPress($el,keyCode,handled){var evt=jQuery.Event("keypress");evt.which=keyCode.charCodeAt(0);$el.trigger(evt);expect(evt.isDefaultPrevented()).toBe(handled);expect(evt.isPropagationStopped()).toBe(handled)}it("Registered on create",function(){MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);spyOn(MyView.prototype,"delegateKeyBindings");view=new MyView;expect(MyView.prototype.delegateKeyBindings).toHaveBeenCalled()});it("Unregistered on undelegateEvents",function(){MyView=Backbone.View.extend({keyBindings:{}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;spyOn(MyView.prototype,"undelegateKeyBindings");view.undelegateEvents();expect(MyView.prototype.undelegateKeyBindings).toHaveBeenCalled()});it("Keys to function name",function(){MyView=Backbone.View.extend({keyBindings:{abc:"myFunc1",def:"myFunc2"},myFunc1:function(){},myFunc2:function(){}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view,"myFunc1");spyOn(view,"myFunc2");sendKeyPress(view.$el,"e",true);expect(view.myFunc1).not.toHaveBeenCalled();expect(view.myFunc2).toHaveBeenCalled()});it("Keys to function",function(){MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"b",true);expect(view.keyBindings.abc).toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()});it("Unmatched keys",function(){MyView=Backbone.View.extend({keyBindings:{abc:function(){},def:function(){}}});_.extend(MyView.prototype,RB.KeyBindingsMixin);view=new MyView;view.render().$el.appendTo($testsScratch);spyOn(view.keyBindings,"abc");spyOn(view.keyBindings,"def");sendKeyPress(view.$el,"!",false);expect(view.keyBindings.abc).not.toHaveBeenCalled();expect(view.keyBindings.def).not.toHaveBeenCalled()})})});suite("rb/utils/linkifyUtils",function(){var bugTrackerURL="http://issues/?id=--bug_id--";describe("linkifyChildren",function(){it("URLs",function(){var $el=$("<p><span>http://example.com</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe('<span><a target="_blank" href="http://example.com">'+"http://example.com</a></span>")});it("Bugs",function(){var $el=$("<p><span>Bug #123</span></p>");RB.LinkifyUtils.linkifyChildren($el[0],bugTrackerURL);expect($el.html()).toBe('<span><a target="_blank" href="http://issues/?id=123">'+"Bug #123</a></span>")});it("/r/ paths",function(){var $el=$("<p><span>/r/123/</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe('<span><a target="_blank" href="/r/123/">'+"/r/123/</a></span>")});it("Skips <a> elements",function(){var $el=$('<p><span><a href="http://example.com">/r/123</a>'+"</span></p>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe('<span><a href="http://example.com">/r/123</a></span>')});it("Skips <pre> elements",function(){var $el=$("<div><pre>/r/123</pre></div>");RB.LinkifyUtils.linkifyChildren($el[0]);expect($el.html()).toBe("<pre>/r/123</pre>")})});describe("linkifyText",function(){describe("URLs",function(){it("http-based URLs",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com")).toBe('<a target="_blank" href="http://example.com">'+"http://example.com</a>")});it("https-based URLs",function(){expect(RB.LinkifyUtils.linkifyText("https://example.com")).toBe('<a target="_blank" href="https://example.com">'+"https://example.com</a>")});it("Trailing slashes",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/foo/")).toBe('<a target="_blank" href="http://example.com/foo/">'+"http://example.com/foo/</a>")});it("Anchors",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/#my-anchor")).toBe('<a target="_blank" href="'+'http://example.com/#my-anchor">'+"http://example.com/#my-anchor</a>")});it("Query strings",function(){expect(RB.LinkifyUtils.linkifyText("http://example.com/?a=b&c=d")).toBe('<a target="_blank" href="'+'http://example.com/?a=b&amp;c=d">'+"http://example.com/?a=b&amp;c=d</a>")});describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(http://example.com/)")).toBe('(<a target="_blank" href="http://example.com/">'+"http://example.com/</a>)")});it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[http://example.com/]")).toBe('[<a target="_blank" href="http://example.com/">'+"http://example.com/</a>]")});it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{http://example.com/}")).toBe('{<a target="_blank" href="http://example.com/">'+"http://example.com/</a>}")});it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("<http://example.com/>")).toBe('&lt;<a target="_blank" href="'+'http://example.com/">http://example.com/</a>&gt;')})})});describe("/r/ paths",function(){describe("Review requests",function(){it("/r/123",function(){expect(RB.LinkifyUtils.linkifyText("/r/123")).toBe('<a target="_blank" href="/r/123/">/r/123</a>')});it("/r/123/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/")).toBe('<a target="_blank" href="/r/123/">/r/123/</a>')});it("/r/123/ in MD format",function(){expect(RB.LinkifyUtils.linkifyReviewRequests("/r/123/",true)).toBe("[/r/123/](/r/123/)")})});describe("Diffs",function(){it("/r/123/diff",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff")).toBe('<a target="_blank" href="/r/123/diff/">'+"/r/123/diff</a>")});it("/r/123/diff/",function(){expect(RB.LinkifyUtils.linkifyText("/r/123/diff/")).toBe('<a target="_blank" href="/r/123/diff/">'+"/r/123/diff/</a>")});it("/r/123/diff/ in MD format",function(){expect(RB.LinkifyUtils.linkifyReviewRequests("/r/123/diff/",true)).toBe("[/r/123/diff/](/r/123/diff/)")})})});describe("Surrounded by",function(){it("(...)",function(){expect(RB.LinkifyUtils.linkifyText("(/r/123/)")).toBe('(<a target="_blank" href="/r/123/">/r/123/</a>)')});it("[...]",function(){expect(RB.LinkifyUtils.linkifyText("[/r/123/]")).toBe('[<a target="_blank" href="/r/123/">/r/123/</a>]')});it("{...}",function(){expect(RB.LinkifyUtils.linkifyText("{/r/123/}")).toBe('{<a target="_blank" href="/r/123/">/r/123/</a>}')});it("<...>",function(){expect(RB.LinkifyUtils.linkifyText("</r/123/>")).toBe('&lt;<a target="_blank" href="/r/123/">/r/123/</a>&gt;')});it("text",function(){expect(RB.LinkifyUtils.linkifyText("foo/r/123/bar")).toBe("foo/r/123/bar")})})});describe("Bug References",function(){describe("With bugTrackerURL",function(){it("bug 123",function(){expect(RB.LinkifyUtils.linkifyText("bug 123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug 123</a>")});it("bug #123",function(){expect(RB.LinkifyUtils.linkifyText("bug #123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"bug #123</a>")});it("issue 123",function(){expect(RB.LinkifyUtils.linkifyText("issue 123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue 123</a>")});it("issue #123",function(){expect(RB.LinkifyUtils.linkifyText("issue #123",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=123">'+"issue #123</a>")});it("bug #abc",function(){expect(RB.LinkifyUtils.linkifyText("bug #abc",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+"bug #abc</a>")});it("issue #abc",function(){expect(RB.LinkifyUtils.linkifyText("issue #abc",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+"issue #abc</a>")});it("issue #abc, issue 2",function(){expect(RB.LinkifyUtils.linkifyText("issue #abc, issue 2",bugTrackerURL)).toBe('<a target="_blank" href="http://issues/?id=abc">'+'issue #abc</a>, <a target="_blank" '+'href="http://issues/?id=2">issue 2</a>')});it("issue #abc in MD format",function(){expect(RB.LinkifyUtils.linkifyBugs("issue #abc",bugTrackerURL,true)).toBe("[issue #abc](http://issues/?id=abc)")})});describe("Without bugTrackerURL",function(){it("bug 123",function(){expect(RB.LinkifyUtils.linkifyText("bug 123")).toBe("bug 123")});it("issue 123",function(){expect(RB.LinkifyUtils.linkifyText("issue 123")).toBe("issue 123")})})})});suite("rb/views/CollectionView",function(){var TestModel,TestCollection,TestModelView,TestCollectionView,collection,view;TestModel=Backbone.Model.extend({defaults:_.defaults({data:""})});TestCollection=Backbone.Collection.extend({model:TestModel});TestModelView=Backbone.View.extend({className:"test-class",render:function(){this.$el.text(this.model.get("data"));return this}});TestCollectionView=RB.CollectionView.extend({itemViewType:TestModelView});beforeEach(function(){collection=new TestCollection;view=new TestCollectionView({collection:collection})});describe("Rendering",function(){it("When empty",function(){view.render();expect(view.$el.children().length).toBe(0)});it("With items",function(){var $children;collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();$children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2")});it("Item model type",function(){collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().hasClass("test-class")).toBe(true)})});describe("Live updating",function(){it("Adding items after rendering",function(){var $children;collection.add([{data:"Item 1"}]);view.render();expect(view.$el.children().length).toBe(1);collection.add([{data:"Item 2"},{data:"Item 3"}]);$children=view.$el.children();expect($children.length).toBe(3);expect($children[2].innerHTML).toBe("Item 3")});it("Removing items after rendering",function(){var model1=new TestModel({data:"Item 1"}),model2=new TestModel({data:"Item 2"}),model3=new TestModel({data:"Item 3"}),$children;collection.add([model1,model2,model3]);view.render();expect(view.$el.children().length).toBe(3);collection.remove([model1,model3]);$children=view.$el.children();expect($children.length).toBe(1);expect($children[0].innerHTML).toBe("Item 2")});it("Changing sort order",function(){var $children;collection.add([{data:"Item 2"},{data:"Item 3"},{data:"Item 1"}]);view.render();$children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 2");expect($children[1].innerHTML).toBe("Item 3");expect($children[2].innerHTML).toBe("Item 1");collection.comparator="data";collection.sort();$children=view.$el.children();expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");expect($children[2].innerHTML).toBe("Item 3")});it("When reset",function(){var $children;collection.add([{data:"Item 1"},{data:"Item 2"}]);view.render();$children=view.$el.children();expect($children.length).toBe(2);expect($children[0].innerHTML).toBe("Item 1");expect($children[1].innerHTML).toBe("Item 2");collection.reset([{data:"Item 3"},{data:"Item 4"},{data:"Item 5"}]);$children=view.$el.children();expect($children.length).toBe(3);expect($children[0].innerHTML).toBe("Item 3");expect($children[1].innerHTML).toBe("Item 4");expect($children[2].innerHTML).toBe("Item 5")})})});suite("rb/views/CommentDialogView",function(){var reviewRequestEditor,reviewRequest;beforeEach(function(){reviewRequest=new RB.ReviewRequest;reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest})});describe("Class methods",function(){describe("create",function(){it("Without a comment",function(){expect(function(){RB.CommentDialogView.create({animate:false,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}).toThrow();expect(RB.CommentDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a comment",function(){var dlg=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg).toBeTruthy();expect(RB.CommentDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(1)});it("Replacing an open dialog",function(){var dlg1,dlg2;dlg1=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg1).toBeTruthy();dlg2=RB.CommentDialogView.create({animate:false,comment:new RB.DiffComment,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg2).toBeTruthy();expect(dlg2).not.toBe(dlg1);expect(dlg1.$el.parents().length).toBe(0);expect(RB.CommentDialogView._instance).toBe(dlg2);expect($testsScratch.children().length).toBe(1)})})});describe("Instances",function(){var editor,dlg;beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,canEdit:true,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.on("closed",function(){dlg=null});dlg.render().$el.appendTo($testsScratch)});afterEach(function(){if(dlg){dlg.close()}});describe("Buttons",function(){beforeEach(function(){dlg.open()});describe("Cancel",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .cancel")});it("Enabled",function(){expect($button.is(":disabled")).toBe(false)});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});it("Confirms before cancelling unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").andReturn(true);editor.set("dirty",true);$button.click();expect(dlg.close).toHaveBeenCalled()});it("Cancel close when unsaved comment",function(){spyOn(editor,"cancel");spyOn(dlg,"close");spyOn(window,"confirm").andReturn(false);editor.set("dirty",true);$button.click();expect(dlg.close).not.toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})});describe("Close",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .close")});it("Cancels editor when clicked",function(){spyOn(editor,"cancel");$button.click();expect(editor.cancel).toHaveBeenCalled()});it("Closes dialog when clicked",function(){spyOn(editor,"cancel");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Visibility",function(){it("Shown when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(false)})})});describe("Delete",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .delete")});it("Cancels editor when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");$button.click();expect(editor.deleteComment).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canDelete",true);spyOn(editor,"deleteComment");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canDelete=false",function(){editor.set("canDelete",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canDelete=true",function(){editor.set("canDelete",true);expect($button.is(":visible")).toBe(true)});it("Hidden when caDelete=false",function(){editor.set("canDelete",false);expect($button.is(":visible")).toBe(false)})})});describe("Save",function(){var $button;beforeEach(function(){$button=dlg.$el.find(".buttons .save")});it("Cancels editor when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");$button.click();expect(editor.save).toHaveBeenCalled()});it("Closes dialog when clicked",function(){editor.set("canSave",true);spyOn(editor,"save");spyOn(dlg,"close");$button.click();expect(dlg.close).toHaveBeenCalled()});describe("Enabled state",function(){it("Enabled when editor.canSave=true",function(){editor.set("canSave",true);expect($button.is(":disabled")).toBe(false)});it("Disabled when editor.canSave=false",function(){editor.set("canSave",false);expect($button.is(":disabled")).toBe(true)})});describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect($button.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect($button.is(":visible")).toBe(false)})})})});describe("Fields",function(){beforeEach(function(){dlg.open()});describe("Open an Issue checkbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._$issueOptions.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._$issueOptions.is(":visible")).toBe(false)})})});describe("Textbox",function(){describe("Visibility",function(){it("Shown when canEdit=true",function(){editor.set("canEdit",true);expect(dlg._textEditor.$el.is(":visible")).toBe(true)});it("Hidden when canEdit=false",function(){editor.set("canEdit",false);expect(dlg._textEditor.$el.is(":visible")).toBe(false)})})})});describe("Height",function(){beforeEach(function(){editor=new RB.CommentEditor({comment:new RB.DiffComment,reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor})});it("When canEdit=true",function(){editor.set("canEdit",true);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_TOTAL_HEIGHT)});it("When canEdit=false",function(){editor.set("canEdit",false);dlg.render();dlg.open();expect(dlg.$el.height()).toBe(RB.CommentDialogView.prototype.DIALOG_NON_EDITABLE_HEIGHT)})});describe("Other published comments list",function(){var $commentsList,$commentsPane;beforeEach(function(){$commentsPane=dlg.$el.find(".other-comments");$commentsList=$commentsPane.children("ul");expect($commentsList.length).toBe(1)});describe("Empty list",function(){it("Hidden pane",function(){expect($commentsPane.is(":visible")).toBe(false)})});describe("Populated list",function(){var comment,commentReply,parentCommentReplyLink;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=false;parentCommentReplyLink="/?reply_id="+comment.comment_id;commentReply=new RB.DiffComment;commentReply.user={name:"Test User"};commentReply.url="http://example.com/";commentReply.comment_id=2;commentReply.text="Sample comment.";commentReply.issue_opened=false;commentReply.reply_to_id=1});describe("Visible pane",function(){it("Setting list before opening dialog",function(){editor.set("publishedComments",[comment]);dlg.open();expect($commentsPane.is(":visible")).toBe(true)});it("Setting list after opening dialog",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsPane.is(":visible")).toBe(true)})});it("List items added",function(){dlg.open();editor.set("publishedComments",[comment]);expect($commentsList.children().length).toBe(1)});it("Parent comment reply link links to itself",function(){var $replyLink;editor.set("publishedComments",[comment]);dlg.open();$replyLink=$commentsList.find(".comment-list-reply-action");expect($replyLink[0].href).toContain(parentCommentReplyLink)});it("Both parent and reply comment reply links link to parent comment",function(){var $replyLinks;

editor.set("publishedComments",[comment,commentReply]);dlg.open();$replyLinks=$commentsList.find(".comment-list-reply-action");expect($replyLinks.length).toEqual(2);expect($replyLinks[0].href).toContain(parentCommentReplyLink);expect($replyLinks[1].href).toContain(parentCommentReplyLink)})});describe("Issue bar buttons",function(){var comment;beforeEach(function(){comment=new RB.DiffComment;comment.user={name:"Test User"};comment.url="http://example.com/";comment.comment_id=1;comment.text="Sample comment.";comment.issue_opened=true;comment.issue_status="open"});it("When interactive",function(){var $buttons;reviewRequestEditor.set("editable",true);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();$buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(3);expect($buttons.is(":visible")).toBe(true)});it("When not interactive",function(){var $buttons;reviewRequestEditor.set("editable",false);editor.set("publishedComments",[comment]);dlg=new RB.CommentDialogView({animate:false,model:editor,commentIssueManager:new RB.CommentIssueManager});dlg.render().$el.appendTo($testsScratch);dlg.open();$buttons=dlg.$el.find(".other-comments .issue-button");expect($buttons.length).toBe(0)})})});describe("Methods",function(){describe("close",function(){it("Editor state",function(){dlg.open();expect(editor.get("editing")).toBe(true);dlg.close();expect(editor.get("editing")).toBe(false)});it("Dialog removed",function(){dlg.open();spyOn(dlg,"trigger");dlg.close();expect(dlg.trigger).toHaveBeenCalledWith("closed");expect(dlg.$el.parents().length).toBe(0);expect($testsScratch.children().length).toBe(0)})});describe("open",function(){it("Editor state",function(){expect(editor.get("editing")).toBe(false);dlg.open();expect(editor.get("editing")).toBe(true)});it("Visibility",function(){expect(dlg.$el.is(":visible")).toBe(false);dlg.open();expect(dlg.$el.is(":visible")).toBe(true)});it("Default focus",function(){var $textarea=dlg.$el.find("textarea");expect($textarea.is(":focus")).toBe(false);spyOn($textarea[0],"focus");dlg.open();expect($textarea[0].focus).toHaveBeenCalled()})})});describe("Special keys",function(){var $textarea;function simulateKeyPress(c,altKey,ctrlKey,metaKey){var e;$textarea.focus();_.each(["keydown","keypress","keyup"],function(type){e=$.Event(type);e.which=c;e.altKey=altKey;e.ctrlKey=ctrlKey;e.metaKey=metaKey;$textarea.trigger(e)})}function setupForRichText(richText,canSave){editor.set("richText",richText);editor.set("canSave",!!canSave);$textarea=dlg.$("textarea")}beforeEach(function(){dlg.open();$textarea=dlg.$("textarea")});describe("Control-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Command-Enter to save",function(){beforeEach(function(){spyOn(editor,"save");spyOn(dlg,"close")});describe("With editor.canSave=true",function(){describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(10,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false,true);simulateKeyPress(13,false,false,true);expect(editor.save).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()})})});describe("With editor.canSave=false",function(){beforeEach(function(){editor.set("canSave",false)});describe("Keycode 10",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(10,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})});describe("Keycode 13",function(){it("If Markdown",function(){setupForRichText(true);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress(13,false,false,true);expect(editor.save).not.toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})})});describe("Escape to cancel",function(){describe("Pressing escape in text area",function(){beforeEach(function(){spyOn(editor,"cancel");spyOn(dlg,"close")});it("If Markdown",function(){spyOn(window,"confirm").andReturn(true);setupForRichText(true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If plain text",function(){setupForRichText(false);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment",function(){spyOn(window,"confirm").andReturn(true);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).toHaveBeenCalled()});it("If unsaved comment, do not close",function(){spyOn(window,"confirm").andReturn(false);editor.set("dirty",true);simulateKeyPress($.ui.keyCode.ESCAPE,false,false);expect(editor.cancel).not.toHaveBeenCalled();expect(window.confirm).toHaveBeenCalled();expect(dlg.close).not.toHaveBeenCalled()})})});describe("Toggle open issue",function(){var $checkbox;function runToggleIssueTest(richText,startState,keyCode){setupForRichText(richText);$checkbox.prop("checked",startState);editor.set("openIssue",startState);simulateKeyPress(keyCode.charCodeAt(0),true,false);expect($checkbox.prop("checked")).toBe(!startState);expect(editor.get("openIssue")).toBe(!startState);expect($textarea.val()).toBe("")}beforeEach(function(){$checkbox=dlg.$el.find("input[type=checkbox]")});describe("Alt-I",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"I")});it("If Markdown",function(){runToggleIssueTest(false,true,"I")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"I")});it("If plain text",function(){runToggleIssueTest(false,false,"I")})})});describe("Alt-i",function(){describe("Checked to unchecked",function(){it("If Markdown",function(){runToggleIssueTest(true,true,"i")});it("If plain text",function(){runToggleIssueTest(false,true,"i")})});describe("Unchecked to checked",function(){it("If Markdown",function(){runToggleIssueTest(true,false,"i")});it("If plain text",function(){runToggleIssueTest(false,false,"i")})})})})});describe("Title text",function(){var $title;beforeEach(function(){dlg.open();$title=dlg.$el.find("form .title")});it("Default state",function(){expect($title.text()).toBe("Your comment")});it("Setting dirty=true",function(){editor.set("dirty",true);expect($title.text()).toBe("Your comment (unsaved)")});it("Setting dirty=false",function(){editor.set("dirty",true);editor.set("dirty",false);expect($title.text()).toBe("Your comment")})});describe("State synchronization",function(){describe("Comment text",function(){var $textarea;function simulateTyping(text){runs(function(){var i,c,e;dlg._textEditor.on("change",function(){changed=true});$textarea.focus();for(i=0;i<text.length;i++){c=text.charCodeAt(i);e=$.Event("keydown");e.which=c;$textarea.trigger(e);e=$.Event("keypress");e.which=c;$textarea.trigger(e);dlg._textEditor.setText(dlg._textEditor.getText()+text[i]);e=$.Event("keyup");e.which=c;$textarea.trigger(e)}});waitsFor(function(){return dlg._textEditor.getText()===text})}beforeEach(function(){dlg.open();$textarea=$(dlg._textEditor.$("textarea"))});it("Dialog to editor",function(){var text="foo";simulateTyping(text);runs(function(){expect(editor.get("text")).toEqual(text)})});it("Editor to dialog",function(){var text="bar";editor.set("text",text);expect(dlg._textEditor.getText()).toEqual(text)})});describe("Open Issue checkbox",function(){var $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#comment_issue");$checkbox.prop("checked",false);editor.set("openIssue",false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("openIssue")).toBe(true)});it("Editor to dialog",function(){editor.set("openIssue",true);expect($checkbox.prop("checked")).toBe(true)})});describe("Enable Markdown checkbox",function(){var $checkbox;beforeEach(function(){dlg.open();$checkbox=dlg.$("#enable_markdown");$checkbox.prop("checked",false);editor.set("richText",false);expect(dlg._textEditor.richText).toBe(false)});it("Dialog to editor",function(){$checkbox.click();expect(editor.get("richText")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Editor to dialog",function(){editor.set("richText",true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})})});describe("User preference defaults",function(){describe("Open Issue checkbox",function(){it("When commentsOpenAnIssue is true",function(){RB.UserSession.instance.set("commentsOpenAnIssue",true);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(true);expect($checkbox.prop("checked")).toBe(true)});it("When commentsOpenAnIssue is false",function(){RB.UserSession.instance.set("commentsOpenAnIssue",false);editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#comment_issue");expect(editor.get("openIssue")).toBe(false);expect($checkbox.prop("checked")).toBe(false)})});describe("Enable Markdown checkbox",function(){describe("When defaultUseRichText is true",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",true)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)})});describe("When defaultUseRichText is false",function(){beforeEach(function(){RB.UserSession.instance.set("defaultUseRichText",false)});it("New comment",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)});it("Existing comment with richText=true",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:true})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(true);expect($checkbox.prop("checked")).toBe(true);expect(dlg._textEditor.richText).toBe(true)});it("Existing comment with richText=false",function(){editor=new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor,comment:new RB.DiffComment({richText:false})});dlg=new RB.CommentDialogView({animate:false,model:editor});dlg.render();$checkbox=dlg.$("#enable_markdown");expect(editor.get("richText")).toBe(false);expect($checkbox.prop("checked")).toBe(false);expect(dlg._textEditor.richText).toBe(false)})})})});describe("Logged Out indicator",function(){it("When logged in",function(){RB.UserSession.instance.set("authenticated",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(0)});it("When logged out",function(){RB.UserSession.instance.set("authenticated",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="login-text"]').length).toBe(1)})});describe("In Draft indicator",function(){it("Shown when hasDraft=true",function(){reviewRequest.set("hasDraft",true);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(1)});it("Hidden when hasDraft=false",function(){reviewRequest.set("hasDraft",false);dlg=new RB.CommentDialogView({animate:false,model:new RB.CommentEditor({reviewRequest:reviewRequest,reviewRequestEditor:reviewRequestEditor})});dlg.render();expect(dlg.$el.find('p[class="draft-warning"]').length).toBe(0)})})})});suite("rb/views/CommentIssueBarView",function(){var commentIssueManager,statuses=RB.CommentIssueBarView.prototype,view,$dropButton,$reopenButton,$fixedButton;beforeEach(function(){commentIssueManager=new RB.CommentIssueManager;view=new RB.CommentIssueBarView({commentIssueManager:commentIssueManager,issueStatus:"open",reviewID:1,commentID:2,commentType:"diff",interactive:true});view.render().$el.appendTo($testsScratch);$dropButton=view._$buttons.filter(".drop");$reopenButton=view._$buttons.filter(".reopen");$fixedButton=view._$buttons.filter(".resolve")});describe("Actions",function(){beforeEach(function(){spyOn(commentIssueManager,"setCommentState");expect(view._$buttons.prop("disabled")).toBe(false)});it("Resolving as fixed",function(){$fixedButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff","resolved")});it("Dropping",function(){$dropButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff","dropped")});it("Re-opening",function(){view._showStatus(statuses.STATUS_FIXED);$reopenButton.click();expect(view._$buttons.prop("disabled")).toBe(true);expect(commentIssueManager.setCommentState).toHaveBeenCalledWith(1,2,"diff","open")})});describe("Event handling",function(){describe("CommentIssueManager.issueStatusUpdated",function(){beforeEach(function(){spyOn(view,"_showStatus")});it("When comment updated",function(){var comment=new RB.DiffComment({id:2,issueStatus:"resolved"});commentIssueManager.trigger("issueStatusUpdated",comment);expect(view._showStatus).toHaveBeenCalledWith("resolved")});it("When different comment updated",function(){var comment=new RB.DiffComment({id:10,issueStatus:"resolved"});commentIssueManager.trigger("issueStatusUpdated",comment);expect(view._showStatus).not.toHaveBeenCalled()})})});describe("Issue states",function(){describe("Open",function(){beforeEach(function(){view._showStatus(statuses.STATUS_OPEN)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(true);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("An issue was opened.")});describe("Button visibility",function(){it('"Drop" shown',function(){expect($dropButton.is(":visible")).toBe(true)});it('"Fixed" shown',function(){expect($fixedButton.is(":visible")).toBe(true)});it('"Re-open" hidden',function(){expect($reopenButton.is(":visible")).toBe(false)})})});describe("Fixed",function(){beforeEach(function(){view._showStatus(statuses.STATUS_FIXED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(true);expect(view._$state.hasClass("dropped")).toBe(false)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been resolved.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)})})});describe("Dropped",function(){beforeEach(function(){view._showStatus(statuses.STATUS_DROPPED)});it("CSS class",function(){expect(view._$state.hasClass("open")).toBe(false);expect(view._$state.hasClass("resolved")).toBe(false);expect(view._$state.hasClass("dropped")).toBe(true)});it("Text",function(){expect(view._$message.text()).toBe("The issue has been dropped.")});describe("Button visibility",function(){it('"Drop" hidden',function(){expect($dropButton.is(":visible")).toBe(false)});it('"Fixed" hidden',function(){expect($fixedButton.is(":visible")).toBe(false)});it('"Re-open" shown',function(){expect($reopenButton.is(":visible")).toBe(true)})})})})});suite("rb/views/DiffFragmentQueueView",function(){var fragmentQueue;beforeEach(function(){fragmentQueue=new RB.DiffFragmentQueueView({containerPrefix:"container1",reviewRequestPath:"/r/123/",queueName:"diff_fragments"})});describe("Diff fragment loading",function(){beforeEach(function(){fragmentQueue.queueLoad("123","key1");fragmentQueue.queueLoad("124","key1");fragmentQueue.queueLoad("125","key2")});it("Fragment queueing",function(){var queue=fragmentQueue._queue;expect(queue.length).not.toBe(0);expect(queue.key1.length).toBe(2);expect(queue.key1).toContain("123");expect(queue.key1).toContain("124");expect(queue.key2.length).toBe(1);expect(queue.key2).toContain("125")});it("Batch loading",function(){spyOn(fragmentQueue,"_addScript");fragmentQueue.loadFragments();expect(fragmentQueue._addScript.mostRecentCall.args[0]).toBe("/r/123/fragments/diff-comments/"+"123,124/?queue=diff_fragments&"+"container_prefix=container1&"+TEMPLATE_SERIAL)})})});suite("rb/views/DraftReviewBannerView",function(){var model,view,template=_.template(['<div id="review-banner" style="display: none;">',' <div class="banner">',"  <h1>You have a pending review.</h1>",'  <input id="review-banner-edit" type="button" ','         value="Edit Review" />','  <input id="review-banner-publish" type="button" ','         value="Publish" />','  <input id="review-banner-discard" type="button" ','         value="Discard" />'," </div>","</div>"].join(""));beforeEach(function(){var $el=$(template()).appendTo($testsScratch);model=new RB.DraftReview;view=new RB.DraftReviewBannerView({el:$el,model:model});view.render()});describe("Button states",function(){var $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Enabled",function(){it("Default",function(){expect($buttons.prop("disabled")).toBe(false)});it("When saved",function(){$buttons.prop("disabled",true);model.trigger("saved");expect($buttons.prop("disabled")).toBe(false)});it("When destroyed",function(){$buttons.prop("disabled",true);model.trigger("destroyed");expect($buttons.prop("disabled")).toBe(false)})});describe("Disabled",function(){it("When saving",function(){model.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){model.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})})});describe("Button events",function(){it("Edit Review",function(){spyOn(RB.ReviewDialogView,"create");view.$("#review-banner-edit").click();expect(RB.ReviewDialogView.create).toHaveBeenCalled();expect(RB.ReviewDialogView.create.calls[0].args[0].review).toBe(model)});it("Publish",function(){spyOn(model,"publish");view.$("#review-banner-publish").click();expect(model.publish).toHaveBeenCalled()});it("Discard",function(){var $buttons=$();spyOn(model,"destroy");spyOn($.fn,"modalBox").andCallFake(function(options){_.each(options.buttons,function($btn){$buttons=$buttons.add($btn)});return{modalBox:function(cmd){expect(cmd).toBe("buttons");return $buttons}}});view.$("#review-banner-discard").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Discard"]').click();expect(model.destroy).toHaveBeenCalled()})});describe("Methods",function(){it("show",function(){expect(view.$el.is(":visible")).toBe(false);view.show();expect(view.$el.is(":visible")).toBe(true)});it("hide",function(){view.$el.show();expect(view.$el.is(":visible")).toBe(true);view.hide();expect(view.$el.is(":visible")).toBe(false)})})});suite("rb/views/FileAttachmentThumbnail",function(){var reviewRequest,model,view;beforeEach(function(){reviewRequest=new RB.ReviewRequest;model=new RB.FileAttachment({downloadURL:"http://example.com/file.png",filename:"file.png"});spyOn(model,"trigger").andCallThrough()});describe("Rendering",function(){function expectElements(){expect(view.$("a.edit").length).toBe(1);expect(view.$(".file-caption").length).toBe(1);expect(view.$(".file-actions").length).toBe(1);expect(view.$(".file-delete").length).toBe(view.options.canEdit&&model.get("loaded")?1:0);expect(view.$(".file-update").length).toBe(view.options.canEdit&&model.get("loaded")?1:0)}function expectAttributeMatches(){expect(view.$(".file-download").attr("href")).toBe(model.get("downloadURL"));expect(view.$(".file-caption .edit").text()).toBe(model.get("caption"))}it("Using existing elements",function(){var $el=$("<div/>").addClass(RB.FileAttachmentThumbnail.prototype.className).html(RB.FileAttachmentThumbnail.prototype.template(_.defaults({caption:"No caption",captionClass:"edit empty-caption"},model.attributes)));model.set("loaded",true);view=new RB.FileAttachmentThumbnail({renderThumbnail:true,reviewRequest:reviewRequest,el:$el,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").is(":visible")).toBe(true);expect(view.$(".fa-spinner").length).toBe(0)});it("Rendered thumbnail with unloaded model",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expect(view.$(".file-actions").children().length).toBe(0);expect(view.$(".fa-spinner").length).toBe(1)});describe("Rendered thumbnail with loaded model",function(){beforeEach(function(){model.id=123;model.set("caption","My Caption");model.set("loaded",true);model.url="/api/file-attachments/123/"});it("With review UI",function(){model.set("reviewURL","/review/");view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(1);expect(view.$(".file-add-comment").length).toBe(0)});it("No review UI",function(){view=new RB.FileAttachmentThumbnail({reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();expectElements();expectAttributeMatches();expect(view.$(".file-actions").children().length).toBe(2);expect(view.$(".fa-spinner").length).toBe(0);expect(view.$(".file-review").length).toBe(0);expect(view.$(".file-add-comment").length).toBe(1)})})});describe("Actions",function(){beforeEach(function(){model.id=123;model.set("loaded",true);model.url="/api/file-attachments/123/";view=new RB.FileAttachmentThumbnail({canEdit:true,reviewRequest:reviewRequest,renderThumbnail:true,model:model});$testsScratch.append(view.$el);view.render();spyOn(view,"trigger").andCallThrough()});it("Begin caption editing",function(){view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view._$caption.inlineEditor("cancel");expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view._$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$("input").val("Foo").triggerHandler("keyup");view._$caption.inlineEditor("submit");expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").andCallThrough();spyOn($,"ajax").andCallFake(function(options){options.success()});spyOn(view.$el,"fadeOut").andCallFake(function(done){done()});spyOn(view,"remove");view.$(".file-delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls[2].args[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})});suite("rb/views/ReviewBoxView",function(){var view,reviewReply,template=_.template(["<div>",' <div class="box">','  <div class="collapse-button"></div>','  <div class="banners">','   <input type="button" value="Publish" />','   <input type="button" value="Discard" />',"  </div>",'  <div class="comment-section" data-context-type="body_top">','   <a class="add_comment_link"></a>','   <ul class="reply-comments">','    <li class="draft" data-comment-id="456">','     <pre class="reviewtext"></pre>',"    </li>","   </ul>","  </div>",'  <div class="comment-section" data-context-id="123" ','       data-context-type="diff_comments">','   <a class="add_comment_link"></a>','   <ul class="reply-comments"></ul>',"  </div>",'  <div class="comment-section" data-context-type="body_bottom">','   <a class="add_comment_link"></a>','   <ul class="reply-comments"></ul>',"  </div>"," </div>","</div>"].join(""));beforeEach(function(){var reviewRequest=new RB.ReviewRequest,editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest}),review=reviewRequest.createReview({loaded:true,links:{replies:{href:"/api/review/123/replies/"}}}),$el=$(template()).appendTo($testsScratch);reviewReply=review.createReply();view=new RB.ReviewBoxView({el:$el,model:review,pageEditState:editor,reviewReply:reviewReply});spyOn(view,"_showReplyDraftBanner");view.render()});describe("Actions",function(){it("Toggle collapse",function(){var $box=view.$(".box"),$collapseButton=view.$(".collapse-button");$collapseButton.click();expect($box.hasClass("collapsed")).toBe(true);$collapseButton.click();expect($box.hasClass("collapsed")).toBe(false)})});describe("Reply editors",function(){it("Views created",function(){expect(view._replyEditorViews.length).toBe(3)});it("Initial state populated",function(){var model=view._replyEditorViews[0].model;expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_top");model=view._replyEditorViews[1].model;expect(model.get("contextID")).toBe(123);expect(model.get("contextType")).toBe("diff_comments");model=view._replyEditorViews[2].model;expect(model.get("contextID")).toBe(null);expect(model.get("contextType")).toBe("body_bottom")});it("Draft banner when draft comment exists",function(){expect(view._showReplyDraftBanner).toHaveBeenCalled()});describe("reviewReply changes on",function(){it("Discard",function(){spyOn(view,"_setupNewReply");spyOn(reviewReply,"discardIfEmpty").andCallFake(function(options,context){options.success.call(context)});reviewReply.trigger("destroyed");expect(view._setupNewReply).toHaveBeenCalled()});it("Publish",function(){spyOn(view,"_setupNewReply");_.each(view._replyEditors,function(editor){spyOn(editor,"_resetState")});reviewReply.trigger("published");expect(view._setupNewReply).toHaveBeenCalled()})});describe("When reviewReply changes",function(){it("Signals connected",function(){var reviewReply=new RB.ReviewReply;spyOn(view,"listenTo").andCallThrough();view._setupNewReply(reviewReply);expect(view.listenTo.calls[0].args[1]).toBe("destroyed published")});it("Signals disconnected from old reviewReply",function(){spyOn(view,"stopListening").andCallThrough();view._setupNewReply();expect(view.stopListening).toHaveBeenCalledWith(reviewReply)});it("Draft banner hidden",function(){spyOn(view,"_hideReplyDraftBanner");view._setupNewReply();expect(view._hideReplyDraftBanner).toHaveBeenCalled()});it("Editors updated",function(){spyOn(view,"_hideReplyDraftBanner");view._setupNewReply();_.each(view._replyEditors,function(editor){expect(editor.get("reviewReply")).toBe(view._reviewReply)})})})});describe("Draft banner",function(){describe("Visibility",function(){it("Shown on hasDraft",function(){var editor=view._replyEditorViews[1].model;view._showReplyDraftBanner.reset();expect(editor.get("hasDraft")).toBe(false);expect(view._showReplyDraftBanner).not.toHaveBeenCalled();editor.set("hasDraft",true);expect(view._showReplyDraftBanner).toHaveBeenCalled()})})});describe("Methods",function(){it("collapse",function(){view.collapse();expect(view.$(".box").hasClass("collapsed")).toBe(true)});it("expand",function(){var $box=view.$(".box");$box.addClass("collapsed");view.expand();expect($box.hasClass("collapsed")).toBe(false)});describe("getReviewReplyEditorView",function(){it("With body_top",function(){var editorView=view.getReviewReplyEditorView("body_top");expect(editorView).not.toBe(undefined);expect(editorView).toBe(view._replyEditorViews[0]);

});it("With body_bottom",function(){var editorView=view.getReviewReplyEditorView("body_bottom");expect(editorView).not.toBe(undefined);expect(editorView).toBe(view._replyEditorViews[2])});it("With comments",function(){var editorView=view.getReviewReplyEditorView("diff_comments",123);expect(editorView).not.toBe(undefined);expect(editorView).toBe(view._replyEditorViews[1])})})})});suite("rb/views/ReviewBoxListView",function(){var template=_.template(["<div>",' <a id="collapse-all"></a>',' <a id="expand-all"></a>',' <div class="review" data-review-id="123" data-ship-it="true">','  <div class="box">','   <div class="body">','    <pre class="body_top">Body Top</pre>','    <div class="comment-section" data-context-type="body_top">',"    </div>",'    <div class="comment-section" data-context-id="123" ','         data-context-type="diff_comments">',"    </div>",'    <pre class="body_bottom">Body Bottom</pre>','    <div class="comment-section" data-context-type="body_bottom">',"    </div>","   </div>"," </div>"," </div>",' <div class="review" data-review-id="124" data-ship-it="false">','  <div class="box">','   <div class="body">','    <pre class="body_top">Body Top</pre>','    <div class="comment-section" data-context-type="body_top">',"    </div>",'    <pre class="body_bottom">Body Bottom</pre>','    <div class="comment-section" data-context-type="body_bottom">',"    </div>","   </div>","  </div>"," </div>","</div>"].join("")),view,box1,box2;beforeEach(function(){var reviewRequest=new RB.ReviewRequest,editor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest}),$el=$(template()).appendTo($testsScratch);view=new RB.ReviewBoxListView({el:$el,reviewRequest:reviewRequest,pageEditState:editor});view.render();expect(view._boxes.length).toBe(2);box1=view._boxes[0];box2=view._boxes[1]});describe("Actions",function(){it("Collapse all",function(){view.$("#collapse-all").click();expect(box1.$el.find(".box").hasClass("collapsed")).toBe(true);expect(box2.$el.find(".box").hasClass("collapsed")).toBe(true)});it("Expand all",function(){var $el1=box1.$el.find(".box"),$el2=box2.$el.find(".box");$el1.addClass("collapsed");$el2.addClass("collapsed");view.$("#expand-all").click();expect($el1.hasClass("collapsed")).toBe(false);expect($el2.hasClass("collapsed")).toBe(false)})});describe("Loading",function(){it("Body Bottom",function(){expect(box1.model.get("bodyBottom")).toBe("Body Bottom")});it("Body Top",function(){expect(box1.model.get("bodyTop")).toBe("Body Top")});it("Public",function(){expect(box1.model.get("public")).toBe(true)});it("Review ID",function(){expect(box1.model.id).toBe(123);expect(box2.model.id).toBe(124)});it("Ship It",function(){expect(box1.model.get("shipIt")).toBe(true);expect(box2.model.get("shipIt")).toBe(false)})});describe("Methods",function(){describe("openCommentEditor",function(){beforeEach(function(){spyOn(RB.ReviewReplyEditorView.prototype,"openCommentEditor");spyOn(box1,"getReviewReplyEditorView").andCallThrough();spyOn(box2,"getReviewReplyEditorView").andCallThrough()});it("With body_top",function(){view.openCommentEditor("body_top");expect(box1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(box2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With body_bottom",function(){view.openCommentEditor("body_bottom");expect(box1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(box2.getReviewReplyEditorView).not.toHaveBeenCalled()});it("With comments",function(){view.openCommentEditor("diff_comments",123);expect(box1.getReviewReplyEditorView).toHaveBeenCalled();expect(RB.ReviewReplyEditorView.prototype.openCommentEditor).toHaveBeenCalled();expect(box2.getReviewReplyEditorView).not.toHaveBeenCalled()})})})});suite("rb/views/ReviewDialogView",function(){var baseEmptyCommentListPayload={stat:"ok",total_results:0,links:{}},emptyDiffCommentsPayload=_.defaults({diff_comments:[]},baseEmptyCommentListPayload),emptyFileAttachmentCommentsPayload=_.defaults({file_attachment_comments:[]},baseEmptyCommentListPayload),emptyScreenshotCommentsPayload=_.defaults({screenshot_comments:[]},baseEmptyCommentListPayload),baseCommentPayload={id:1,issue_opened:true,issue_status:"opened",text:"My comment"},diffCommentPayload=_.defaults({first_line:10,num_lines:5,filediff:{id:1,source_file:"my-file",dest_file:"my-file",source_revision:"1"},interfilediff:{id:2,source_file:"my-file",dest_file:"my-file",source_revision:"2"}},baseCommentPayload),fileAttachmentCommentPayload=_.defaults({extra_data:{},link_text:"my-link-text",thumbnail_html:"<blink>Boo</blink>",review_url:"/review-ui/",file_attachment:{id:10,filename:"file.txt",icon_url:"data:image/gif;base64,"}},baseCommentPayload),screenshotCommentPayload=_.defaults({x:10,y:20,w:30,h:40,thumbnail_url:"data:image/gif;base64,",screenshot:{id:10,caption:"My caption",filename:"image.png",review_url:"/review-ui/"}},baseCommentPayload),reviewRequestEditor,review,dlg;function createReviewDialog(){return RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}beforeEach(function(){var origMove=$.fn.move,reviewRequest=new RB.ReviewRequest({summary:"My Review Request"});reviewRequestEditor=new RB.ReviewRequestEditor({reviewRequest:reviewRequest});review=new RB.Review({parentObject:reviewRequest});spyOn(review,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn($.fn,"move").andCallFake(function(x,y,pos){if(pos==="fixed"){pos="absolute"}return origMove.call(this,x,y,pos)});spyOn(RB.DiffFragmentQueueView.prototype,"queueLoad");spyOn(RB.DiffFragmentQueueView.prototype,"loadFragments")});afterEach(function(){RB.ReviewDialogView._instance=null});describe("Class methods",function(){describe("create",function(){it("Without a review",function(){expect(function(){RB.ReviewDialogView.create({container:$testsScratch,reviewRequestEditor:reviewRequestEditor})}).toThrow();expect(RB.ReviewDialogView._instance).toBeFalsy();expect($testsScratch.children().length).toBe(0)});it("With a review",function(){dlg=createReviewDialog();expect(dlg).toBeTruthy();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)});it("With existing instance",function(){dlg=createReviewDialog();expect(createReviewDialog).toThrow();expect(RB.ReviewDialogView._instance).toBe(dlg);expect($testsScratch.children().length).toBe(2)})})});describe("Instances",function(){describe("Methods",function(){it("close",function(){dlg=createReviewDialog();expect($testsScratch.children().length).toBe(2);dlg.close();expect($testsScratch.children().length).toBe(0);expect(RB.ReviewDialogView._instance).toBe(null)})});describe("Loading",function(){it("With new review",function(){expect(review.isNew()).toBe(true);dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$editor.text()).toBe("");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false);expect(dlg._$shipIt.prop("checked")).toBe(false);expect(dlg._$spinner).toBe(null)});describe("With body and top text",function(){var bodyTopText="My body top",bodyBottomText="My body bottom";beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,loaded:true})});it("Clearing body bottom hides footer",function(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);review.set("bodyBottom","");expect(dlg._bodyBottomView.$el.is(":visible")).toBe(false)})});describe("With existing review",function(){var bodyTopText="My body top",bodyBottomText="My body bottom",shipIt=true,fileAttachmentCommentsPayload,diffCommentsPayload,screenshotCommentsPayload,commentView,ajaxData;beforeEach(function(){review.set({bodyTop:bodyTopText,bodyBottom:bodyBottomText,shipIt:shipIt,loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);spyOn($,"ajax").andCallFake(function(options){if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}})});describe("Review properties",function(){function testLoadReview(){dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect(dlg._bodyTopView.$editor.text()).toBe(bodyTopText);expect(dlg._bodyBottomView.$editor.text()).toBe(bodyBottomText);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$shipIt.prop("checked")).toBe(shipIt);expect(dlg._$comments.children().length).toBe(0);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadReview();expect(review.ready.calls[0].args[0].data).toEqual({"force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadReview();expect(review.ready.calls[0].args[0].data).toEqual({"force-text-type":"html","include-text-types":"raw"})})});describe("Diff comments",function(){function testLoadDiffComments(){var diffQueueProto=RB.DiffFragmentQueueView.prototype;diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls[2].args[0].url).toBe("/diff-comments/");ajaxData=$.ajax.calls[2].args[0].data;expect(diffQueueProto.queueLoad.calls.length).toBe(1);expect(diffQueueProto.loadFragments).toHaveBeenCalled();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(diffCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(diffCommentPayload.issue_opened);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadDiffComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"filediff,interfilediff","order-by":"filediff,first_line","force-text-type":"html","include-text-types":"raw"})})});describe("File attachment comments",function(){function testLoadFileAttachmentComments(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload];dlg=RB.ReviewDialogView.create({review:review,container:$testsScratch,reviewRequestEditor:reviewRequestEditor});expect($.ajax).toHaveBeenCalled();expect($.ajax.calls[1].args[0].url).toBe("/file-attachment-comments/");ajaxData=$.ajax.calls[1].args[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(fileAttachmentCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(fileAttachmentCommentPayload.issue_opened);expect(commentView.$(".filename a").attr("href")).toBe(fileAttachmentCommentPayload.review_url);expect(commentView.$(".filename a").text()).toBe(fileAttachmentCommentPayload.link_text);expect(commentView.$(".thumbnail").html()).toBe(fileAttachmentCommentPayload.thumbnail_html);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadFileAttachmentComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"diff_against_file_attachment,"+"file_attachment","force-text-type":"html","include-text-types":"raw"})})});describe("Screenshot comments",function(){function testLoadScreenshotComments(){var $img,$filenameA;screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload];dlg=createReviewDialog();expect($.ajax).toHaveBeenCalled();expect($.ajax.calls[0].args[0].url).toBe("/screenshot-comments/");ajaxData=$.ajax.calls[0].args[0].data;expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];expect(commentView.$editor.text()).toBe(screenshotCommentPayload.text);expect(commentView.$issueOpened.prop("checked")).toBe(screenshotCommentPayload.issue_opened);$img=commentView.$("img");expect($img.attr("src")).toBe(screenshotCommentPayload.thumbnail_url);expect($img.attr("width")).toBe(screenshotCommentPayload.w.toString());expect($img.attr("height")).toBe(screenshotCommentPayload.h.toString());expect($img.attr("alt")).toBe(screenshotCommentPayload.screenshot.caption);$filenameA=commentView.$(".filename a");expect($filenameA.attr("href")).toBe(screenshotCommentPayload.screenshot.review_url);expect($filenameA.text()).toBe(screenshotCommentPayload.screenshot.caption);expect(dlg._bodyBottomView.$el.is(":visible")).toBe(true);expect(dlg._$spinner).toBe(null)}it("With defaultUseRichText=true",function(){RB.UserSession.instance.set("defaultUseRichText",true);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw,markdown"})});it("With defaultUseRichText=false",function(){RB.UserSession.instance.set("defaultUseRichText",false);testLoadScreenshotComments();expect(ajaxData).toEqual({api_format:"json","max-results":50,expand:"screenshot","force-text-type":"html","include-text-types":"raw"})})})})});describe("Saving",function(){var fileAttachmentCommentsPayload,diffCommentsPayload,screenshotCommentsPayload,commentView,comment;function testSaveComment(richText){var newCommentText="New comment text";dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.$editor.inlineEditor("startEdit").inlineEditor("setValue",newCommentText);commentView.textEditor.setRichText(richText);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(comment.get("richText")).toBe(richText)}function testSaveCommentPreventsXSS(richText){var newCommentText='"><script>window.rbTestFoundXSS = true;</script>';delete window.rbTestFoundXSS;dlg=createReviewDialog();expect(dlg._commentViews.length).toBe(1);commentView=dlg._commentViews[0];comment=commentView.model;spyOn(comment,"save");commentView.$editor.inlineEditor("startEdit").inlineEditor("setValue",newCommentText);commentView.textEditor.setRichText(true);commentView.save();expect(comment.save).toHaveBeenCalled();expect(comment.get("text")).toBe(newCommentText);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){review.set({loaded:true,id:42,links:{diff_comments:{href:"/diff-comments/"},file_attachment_comments:{href:"/file-attachment-comments/"},screenshot_comments:{href:"/screenshot-comments/"}}});diffCommentsPayload=_.clone(emptyDiffCommentsPayload);screenshotCommentsPayload=_.clone(emptyScreenshotCommentsPayload);fileAttachmentCommentsPayload=_.clone(emptyFileAttachmentCommentsPayload);spyOn(review,"save").andCallFake(function(options,context){if(options&&options.success){options.success.call(context)}});spyOn($,"ajax").andCallFake(function(options){if(options.url==="/file-attachment-comments/"){options.success(fileAttachmentCommentsPayload)}else if(options.url==="/diff-comments/"){options.success(diffCommentsPayload)}else if(options.url==="/screenshot-comments/"){options.success(screenshotCommentsPayload)}})});describe("Review properties",function(){function testSelfXSS(bodyView,attrName){var text='"><script>window.rbTestFoundXSS = true;'+"</script>",editor=bodyView.textEditor;delete window.rbTestFoundXSS;bodyView.openEditor();editor.setText(text);editor.setRichText(true);bodyView.save();expect(editor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get(attrName)).toBe(text);expect(window.rbTestFoundXSS).toBe(undefined)}beforeEach(function(){dlg=createReviewDialog()});describe("Body Top",function(){function runTest(richText){var text="My new text",bodyTopEditor=dlg._bodyTopView.textEditor;dlg._bodyTopView.openEditor();bodyTopEditor.setText(text);bodyTopEditor.setRichText(richText);dlg._bodyTopView.save();expect(bodyTopEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyTop")).toBe(text);expect(review.get("bodyTopRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyTopView,"bodyTop")})});describe("Body Bottom",function(){function runTest(richText){var text="My new text",bodyBottomEditor=dlg._bodyBottomView.textEditor;dlg._bodyBottomView.openEditor();bodyBottomEditor.setText(text);bodyBottomEditor.setRichText(richText);dlg._bodyBottomView.save();expect(bodyBottomEditor.getText()).toBe(text);expect(review.save).toHaveBeenCalled();expect(review.get("bodyBottom")).toBe(text);expect(review.get("bodyBottomRichText")).toBe(richText)}it("For Markdown",function(){runTest(true)});it("For plain text",function(){runTest(false)});it("Prevents Self-XSS",function(){testSelfXSS(dlg._bodyBottomView,"bodyBottom")})});describe("Ship It",function(){function runTest(shipIt){dlg._$shipIt.prop("checked",shipIt);dlg._saveReview();expect(dlg._$shipIt.prop("checked")).toBe(shipIt)}it("Checked",function(){runTest(true)});it("Unchecked",function(){runTest(false)})})});describe("Diff comments",function(){beforeEach(function(){diffCommentsPayload.total_results=1;diffCommentsPayload.diff_comments=[diffCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("File attachment comments",function(){beforeEach(function(){fileAttachmentCommentsPayload.total_results=1;fileAttachmentCommentsPayload.file_attachment_comments=[fileAttachmentCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})});describe("Screenshot comments",function(){beforeEach(function(){screenshotCommentsPayload.total_results=1;screenshotCommentsPayload.screenshot_comments=[screenshotCommentPayload]});it("For Markdown",function(){testSaveComment(true)});it("For plain text",function(){testSaveComment(false)});it("Prevents Self-XSS",function(){testSaveCommentPreventsXSS()})})})})});suite("rb/views/ReviewRequestEditorView",function(){var reviewRequest,editor,view,template=_.template(["<div>",' <div id="review_request_banners"></div>',' <div id="review-request-warning"></div>',' <div class="actions">','  <a href="#" id="discard-review-request-link"></a>','  <a href="#" id="link-review-request-close-submitted"></a>','  <a href="#" id="delete-review-request-link"></a>'," </div>",' <div class="review-request">','  <div id="review_request_main">','   <span id="field_summary"','         data-field-id="summary"','         class="field editable"></span>','   <span id="field_branch"','         data-field-id="branch"','         class="field editable"></span>','   <span id="field_bugs_closed"','         data-field-id="bugs_closed"','         class="field editable comma-editable"></span>','   <span id="field_target_groups"','         data-field-id="target_groups"','         class="field editable comma-editable"></span>','   <span id="field_target_people"','         data-field-id="target_people"','         class="field editable"></span>','   <div class="content">','    <pre id="field_description"','         data-field-id="description"','         class="field field-text-area editable"></pre>',"   </div>",'   <div class="content">','    <pre id="field_testing_done"','         data-field-id="testing_done"','         class="field field-text-area editable"></pre>',"   </div>",'   <div class="content">','    <div class="field-container">','     <pre id="field_my_custom"','          data-field-id="my_custom"','          class="field editable"></pre>','     <pre id="field_my_rich_text_custom"','          data-field-id="my_rich_text_custom"','          class="field field-text-area editable rich-text"','          data-allow-markdown="True"></pre>','     <pre id="field_text"','          data-field-id="text"','          class="field field-text-area editable"','          data-allow-markdown="True"></pre>',"    </div>","   </div>","  </div>"," </div>",' <div id="review_request_extra">',"  <div>",'   <div id="file-list"><br /></div>',"  </div>","  <div>",'   <div id="screenshot-thumbnails"><br /></div>',"  </div>"," </div>","</div>"].join("")),screenshotThumbnailTemplate=_.template(['<div class="screenshot-container" data-screenshot-id="<%= id %>">',' <div class="screenshot-caption">','  <a class="edit"></a>'," </div>",' <a class="delete">X</a>',"</div>"].join("")),$warning,$filesContainer,$screenshotsContainer;beforeEach(function(){var $el=$(template()).appendTo($testsScratch);reviewRequest=new RB.ReviewRequest({id:123,"public":true,state:RB.ReviewRequest.PENDING});editor=new RB.ReviewRequestEditor({mutableByUser:true,statusMutableByUser:true,reviewRequest:reviewRequest,commentIssueManager:new RB.CommentIssueManager});view=new RB.ReviewRequestEditorView({el:$el,model:editor});$warning=$testsScratch.find("#review-request-warning");$filesContainer=$testsScratch.find("#file-list");$screenshotsContainer=$testsScratch.find("#screenshot-thumbnails");spyOn(view,"_refreshPage");spyOn(reviewRequest.draft,"ready").andCallFake(function(options,context){options.ready.call(context)})});describe("Actions bar",function(){beforeEach(function(){view.render()});describe("Close",function(){it("Delete Permanently",function(){var $buttons=$();spyOn(reviewRequest,"destroy");spyOn($.fn,"modalBox").andCallFake(function(options){_.each(options.buttons,function($btn){$buttons=$buttons.add($btn)});return{modalBox:function(cmd){expect(cmd).toBe("buttons");return $buttons}}});$("#delete-review-request-link").click();expect($.fn.modalBox).toHaveBeenCalled();$buttons.filter('input[value="Delete"]').click();expect(reviewRequest.destroy).toHaveBeenCalled()});it("Discarded",function(){spyOn(reviewRequest,"close").andCallFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED)});spyOn(window,"confirm").andReturn(true);$("#discard-review-request-link").click();expect(reviewRequest.close).toHaveBeenCalled()});it("Submitted",function(){spyOn(reviewRequest,"close").andCallFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_SUBMITTED)});$("#link-review-request-close-submitted").click();expect(reviewRequest.close).toHaveBeenCalled()})})});describe("Banners",function(){beforeEach(function(){view.render()});describe("Draft banner",function(){describe("Visibility",function(){it("Hidden when saving",function(){expect(view.banner).toBe(null);editor.trigger("saving");expect(view.banner).toBe(null)});it("Show when saved",function(){var $summary=view.$el.find("#field_summary");expect(view.banner).toBe(null);spyOn(reviewRequest.draft,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(reviewRequest.draft,"save").andCallFake(function(options,context){options.success.call(context)});$summary.inlineEditor("startEdit").inlineEditor("setValue","New summary").inlineEditor("save");expect(view.banner).not.toBe(null);expect(view.banner.$el.is(":visible")).toBe(true)})});describe("Buttons actions",function(){it("Discard Draft",function(){view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest.draft,"destroy");$("#btn-draft-discard").click();expect(reviewRequest.draft.destroy).toHaveBeenCalled()});it("Discard Review Request",function(){reviewRequest.set("public",false);view.model.set("hasDraft",true);view.showBanner();spyOn(reviewRequest,"close").andCallFake(function(options){expect(options.type).toBe(RB.ReviewRequest.CLOSE_DISCARDED)});$("#btn-review-request-discard").click();expect(reviewRequest.close).toHaveBeenCalled()});describe("Publish",function(){beforeEach(function(){view.model.set("hasDraft",true);spyOn(editor,"publishDraft").andCallThrough();spyOn(reviewRequest.draft,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(reviewRequest.draft,"publish");reviewRequest.draft.set({targetGroups:[{name:"foo",url:"/groups/foo"}],summary:"foo",description:"foo"})});it("Basic publishing",function(){view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled()});it("With Send E-Mail turned on",function(){view.model.set("showSendEmail",true);view.showBanner();$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls[0].args[0].trivial).toBe(0)});it("With Send E-Mail turned off",function(){view.model.set("showSendEmail",true);view.showBanner();$(".send-email").prop("checked",false);$("#btn-draft-publish").click();expect(editor.get("publishing")).toBe(true);expect(editor.get("pendingSaveCount")).toBe(0);expect(editor.publishDraft).toHaveBeenCalled();expect(reviewRequest.draft.publish).toHaveBeenCalled();expect(reviewRequest.draft.publish.calls[0].args[0].trivial).toBe(1)})})});describe("Button states",function(){var $buttons;beforeEach(function(){view.model.set("hasDraft",true);view.showBanner();$buttons=view.banner.$buttons});it("Enabled by default",function(){expect($buttons.prop("disabled")).toBe(false)});it("Disabled when saving",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("Enabled when saved",function(){expect($buttons.prop("disabled")).toBe(false);editor.trigger("saving");expect($buttons.prop("disabled")).toBe(true);editor.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})});describe("Discarded banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_DISCARDED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("discard-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})})});describe("Submitted banner",function(){beforeEach(function(){reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED)});it("Visibility",function(){expect(view.banner).toBe(null);view.showBanner();expect(view.banner).not.toBe(null);expect(view.banner.el.id).toBe("submitted-banner");expect(view.banner.$el.is(":visible")).toBe(true)});describe("Buttons actions",function(){beforeEach(function(){expect(view.banner).toBe(null);reviewRequest.set("state",RB.ReviewRequest.CLOSE_SUBMITTED);view.showBanner()});it("Reopen",function(){spyOn(reviewRequest,"reopen");$("#btn-review-request-reopen").click();expect(reviewRequest.reopen).toHaveBeenCalled()})})})});describe("Fields",function(){var saveSpyFunc,fieldName,jsonFieldName,jsonTextTypeFieldName,supportsRichText,useExtraData,$field,$input;beforeEach(function(){if(!saveSpyFunc){saveSpyFunc=function(options,context){expect(options.data[jsonFieldName]).toBe("My Value");options.success.call(context)}}spyOn(reviewRequest.draft,"save").andCallFake(saveSpyFunc);view.render()});function setupFieldTests(options){beforeEach(function(){fieldName=options.fieldName;jsonFieldName=options.jsonFieldName;jsonTextTypeFieldName=jsonFieldName==="text"?"text_type":jsonFieldName+"_text_type";supportsRichText=!!options.supportsRichText;useExtraData=options.useExtraData;$field=view.$(options.selector);$input=$field.inlineEditor("field")})}function hasAutoCompleteTest(){it("Has auto-complete",function(){expect($input.data("rbautocomplete")).not.toBe(undefined)})}function hasEditorTest(){it("Has editor",function(){expect($field.data("inlineEditor")).not.toBe(undefined)})}function runSavingTest(richText,textType){runs(function(){var textEditor;$field.inlineEditor("startEdit");if(supportsRichText){expect($field.hasClass("field-text-area")).toBe(true);textEditor=$input.data("text-editor");textEditor.setText("My Value");textEditor.setRichText(richText)}else{$input.val("My Value")}$input.triggerHandler("keyup");expect($field.inlineEditor("value")).toBe("My Value")});waitsFor(function(){return $field.inlineEditor("dirty")});runs(function(){var expectedData={},fieldPrefix=useExtraData?"extra_data.":"";expectedData[fieldPrefix+jsonFieldName]="My Value";if(supportsRichText){expectedData[fieldPrefix+jsonTextTypeFieldName]=textType;expectedData.force_text_type="html";expectedData.include_text_types="raw"}expect($field.inlineEditor("dirty")).toBe(true);$field.inlineEditor("submit");expect(reviewRequest.draft.save).toHaveBeenCalled();expect(reviewRequest.draft.save.calls[0].args[0].data).toEqual(expectedData)})}function savingTest(){it("Saves",function(){expect(supportsRichText).toBe(false);runSavingTest()})}function richTextSavingTest(){describe("Saves",function(){it("For Markdown",function(){expect(supportsRichText).toBe(true);runSavingTest(true,"markdown")});it("For plain text",function(){expect(supportsRichText).toBe(true);runSavingTest(false,"plain")})})}function editCountTests(){describe("Edit counts",function(){it("When opened",function(){expect(editor.get("editCount")).toBe(0);$field.inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)});it("When canceled",function(){$field.inlineEditor("startEdit");$field.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("When submitted",function(){$field.inlineEditor("startEdit");$input.val("My Value").triggerHandler("keyup");$field.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})}function securityTests(options){options=options||{};if(options.supportsRichText){describe("Security measures",function(){it("No self-XSS when draft field changes",function(){var fieldOwner;delete window.rbTestFoundXSS;if(options.fieldOnReviewRequest){fieldOwner=reviewRequest}else{fieldOwner=reviewRequest.draft}fieldOwner.set(fieldName,'"><script>window.rbTestFoundXSS = true;</script>');fieldOwner.trigger("change:"+fieldName);fieldOwner.trigger("fieldChange:"+fieldName);

expect(window.rbTestFoundXSS).toBe(undefined)})})}}describe("Branch",function(){setupFieldTests({fieldName:"branch",jsonFieldName:"branch",selector:"#field_branch"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Bugs Closed",function(){setupFieldTests({fieldName:"bugsClosed",jsonFieldName:"bugs_closed",selector:"#field_bugs_closed"});hasEditorTest();savingTest();describe("Formatting",function(){it("With bugTrackerURL",function(){var $links,$link;reviewRequest.set("bugTrackerURL","http://issues/?id=--bug_id--");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.text()).toBe("1, 2, 3");$links=$field.children("a");expect($links.length).toBe(3);$link=$links.eq(0);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("1");expect($link.attr("href")).toBe("http://issues/?id=1");$link=$links.eq(1);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("2");expect($link.attr("href")).toBe("http://issues/?id=2");$link=$links.eq(2);expect($link.hasClass("bug")).toBe(true);expect($link.text()).toBe("3");expect($link.attr("href")).toBe("http://issues/?id=3")});it("Without bugTrackerURL",function(){reviewRequest.set("bugTrackerURL","");reviewRequest.draft.set("bugsClosed",[1,2,3]);editor.trigger("fieldChanged:bugsClosed");expect($field.html()).toBe("1, 2, 3")})});editCountTests();securityTests()});describe("Change Descriptions",function(){function closeDescriptionTests(options){beforeEach(function(){reviewRequest.set("state",options.closeType);view.showBanner();spyOn(reviewRequest,"close").andCallThrough();spyOn(reviewRequest,"save")});setupFieldTests({fieldName:"closeDescription",jsonFieldName:"changedescription",selector:options.bannerSel+" #field_changedescription"});hasEditorTest();it("Starts closed",function(){expect($input.is(":visible")).toBe(false)});describe("Saves",function(){function testSave(richText,textType,setRichText){var textEditor,expectedData={status:options.jsonCloseType,force_text_type:"html",include_text_types:"raw"};expectedData[options.jsonTextTypeFieldName]=textType;expectedData[options.jsonFieldName]="My Value";$field.inlineEditor("startEdit");textEditor=$input.data("text-editor");textEditor.setText("My Value");if(setRichText!==false){textEditor.setRichText(richText)}$input.triggerHandler("keyup");$field.inlineEditor("submit");expect(reviewRequest.close).toHaveBeenCalled();expect(reviewRequest.save).toHaveBeenCalled();expect(reviewRequest.save.calls[0].args[0].data).toEqual(expectedData)}it("For Markdown",function(){testSave(true,"markdown")});it("For plain text",function(){testSave(false,"plain")})});describe("State when statusEditable",function(){it("Disabled when false",function(){editor.set("statusEditable",false);expect($field.inlineEditor("option","enabled")).toBe(false)});it("Enabled when true",function(){editor.set("statusEditable",true);expect($field.inlineEditor("option","enabled")).toBe(true)})});describe("Formatting",function(){it("Links",function(){reviewRequest.set("closeDescription","Testing /r/123");editor.trigger("fieldChanged:closeDescription");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})}describe("Discarded review requests",function(){closeDescriptionTests({bannerSel:"#discard-banner",closeType:RB.ReviewRequest.CLOSE_DISCARDED,jsonCloseType:"discarded",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})});describe("Draft review requests",function(){beforeEach(function(){view.model.set("hasDraft",true);view.showBanner()});setupFieldTests({supportsRichText:true,fieldName:"closeDescription",jsonFieldName:"changedescription",selector:"#draft-banner #field_changedescription"});hasEditorTest();richTextSavingTest();editCountTests();securityTests({fieldOnReviewRequest:true,supportsRichText:true})});describe("Submitted review requests",function(){closeDescriptionTests({bannerSel:"#submitted-banner",closeType:RB.ReviewRequest.CLOSE_SUBMITTED,jsonCloseType:"submitted",jsonFieldName:"close_description",jsonTextTypeFieldName:"close_description_text_type"})})});describe("Description",function(){setupFieldTests({supportsRichText:true,fieldName:"description",jsonFieldName:"description",selector:"#field_description"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("description","Testing /r/123");editor.trigger("fieldChanged:description");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({supportsRichText:true})});describe("Summary",function(){setupFieldTests({fieldName:"summary",jsonFieldName:"summary",selector:"#field_summary"});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Testing Done",function(){setupFieldTests({supportsRichText:true,fieldName:"testingDone",jsonFieldName:"testing_done",selector:"#field_testing_done"});hasEditorTest();richTextSavingTest();describe("Formatting",function(){it("Links",function(){reviewRequest.draft.set("testingDone","Testing /r/123");editor.trigger("fieldChanged:testingDone");expect($field.text()).toBe("Testing /r/123");expect($field.find("a").attr("href")).toBe("/r/123/")})});editCountTests();securityTests({supportsRichText:true})});describe("Reviewers",function(){describe("Groups",function(){setupFieldTests({fieldName:"targetGroups",jsonFieldName:"target_groups",selector:"#field_target_groups"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetGroups",[{name:"group1",url:"/groups/group1/"},{name:"group2",url:"/groups/group2/"}]);editor.trigger("fieldChanged:targetGroups");expect($field.html()).toBe('<a href="/groups/group1/">group1</a>, '+'<a href="/groups/group2/">group2</a>')});editCountTests();securityTests()});describe("People",function(){setupFieldTests({fieldName:"targetPeople",jsonFieldName:"target_people",selector:"#field_target_people"});hasAutoCompleteTest();hasEditorTest();savingTest();it("Formatting",function(){reviewRequest.draft.set("targetPeople",[{username:"user1",url:"/users/user1/"},{username:"user2",url:"/users/user2/"}]);editor.trigger("fieldChanged:targetPeople");expect($field.text()).toBe("user1, user2");expect($($field.children()[0]).attr("href")).toBe("/users/user1/");expect($($field.children()[1]).attr("href")).toBe("/users/user2/")});editCountTests();securityTests()})});describe("Custom fields",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({fieldID:"my_custom",jsonFieldName:"my_custom",selector:"#field_my_custom",useExtraData:true});hasEditorTest();savingTest();editCountTests();securityTests()});describe("Custom rich-text field",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"my_rich_text_custom",jsonFieldName:"my_rich_text_custom",selector:"#field_my_rich_text_custom",useExtraData:true});it("Initial rich text state",function(){expect($input.data("text-editor").richText).toBe(true)});hasEditorTest();richTextSavingTest();editCountTests();securityTests()});describe("Custom rich-text field with special name",function(){beforeEach(function(){saveSpyFunc=function(options,context){expect(options.data["extra_data."+jsonFieldName]).toBe("My Value");options.success.call(context)}});setupFieldTests({supportsRichText:true,fieldID:"text",jsonFieldName:"text",selector:"#field_text",useExtraData:true});hasEditorTest();richTextSavingTest();editCountTests();securityTests()})});describe("File attachments",function(){it("Rendering when added",function(){spyOn(RB.FileAttachmentThumbnail.prototype,"render").andCallThrough();expect($filesContainer.find(".file-container").length).toBe(0);view.render();editor.createFileAttachment();expect(RB.FileAttachmentThumbnail.prototype.render).toHaveBeenCalled();expect($filesContainer.find(".file-container").length).toBe(1)});describe("Events",function(){var $thumbnail,fileAttachment;beforeEach(function(){view.render();fileAttachment=editor.createFileAttachment();$thumbnail=$($filesContainer.find(".file-container")[0]);expect($thumbnail.length).toBe(1)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".file-caption .edit").inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){var $caption;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".file-caption .edit").inlineEditor("startEdit")});it("On cancel",function(){$caption.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(fileAttachment,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(fileAttachment,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");$caption.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})})})});describe("Screenshots",function(){describe("Importing on render",function(){it("No screenshots",function(){view.render();expect(editor.get("screenshots").length).toBe(0)});it("With screenshots",function(){var screenshots=editor.get("screenshots");$screenshotsContainer.append(screenshotThumbnailTemplate({id:42}));spyOn(RB.ScreenshotThumbnail.prototype,"render").andCallThrough();view.render();expect(RB.ScreenshotThumbnail.prototype.render).toHaveBeenCalled();expect(screenshots.length).toBe(1);expect(screenshots.at(0).id).toBe(42)})});describe("Events",function(){var $thumbnail,screenshot;beforeEach(function(){$thumbnail=$(screenshotThumbnailTemplate({id:42})).appendTo($screenshotsContainer);view.render();screenshot=editor.get("screenshots").at(0)});describe("beginEdit",function(){it("Increment edit count",function(){expect(editor.get("editCount")).toBe(0);$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit");expect(editor.get("editCount")).toBe(1)})});describe("endEdit",function(){describe("Decrement edit count",function(){var $caption;beforeEach(function(){expect(editor.get("editCount")).toBe(0);$caption=$thumbnail.find(".screenshot-caption .edit").inlineEditor("startEdit")});it("On cancel",function(){$caption.inlineEditor("cancel");expect(editor.get("editCount")).toBe(0)});it("On submit",function(){spyOn(screenshot,"ready").andCallFake(function(options,context){options.ready.call(context)});spyOn(screenshot,"save");$thumbnail.find("input").val("Foo").triggerHandler("keyup");$caption.inlineEditor("submit");expect(editor.get("editCount")).toBe(0)})})})})})});suite("rb/views/ReviewReplyDraftBannerView",function(){var reviewReply,view;beforeEach(function(){reviewReply=new RB.ReviewReply;view=new RB.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch});view.render().$el.appendTo($testsScratch)});describe("Actions",function(){it("Discard",function(){spyOn(reviewReply,"destroy");view.$(".discard-button").click();expect(reviewReply.destroy).toHaveBeenCalled()});it("Publish",function(){spyOn(reviewReply,"publish");view.$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled()})});describe("Event Handling",function(){describe("Buttons",function(){var $buttons;beforeEach(function(){$buttons=view.$("input")});describe("Disabled",function(){it("When saving",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("saving");expect($buttons.prop("disabled")).toBe(true)});it("When destroying",function(){expect($buttons.prop("disabled")).toBe(false);reviewReply.trigger("destroying");expect($buttons.prop("disabled")).toBe(true)})});describe("Enabled",function(){it("When saved",function(){$buttons.prop("disabled",true);reviewReply.trigger("saved");expect($buttons.prop("disabled")).toBe(false)})})})});describe("Publish",function(){beforeEach(function(){spyOn(reviewReply,"ensureCreated").andCallFake(function(options,context){options.success.call(context)});spyOn(reviewReply,"publish")});describe("With Send E-Mail shown",function(){beforeEach(function(){view.remove();view=new RB.ReviewReplyDraftBannerView({model:reviewReply,$floatContainer:$testsScratch,showSendEmail:true});view.render().$el.appendTo($testsScratch)});it("Send E-Mail true",function(){$(".send-email").prop("checked",true);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls[0].args[0].trivial).toBe(false)});it("Send E-Mail false",function(){$(".send-email").prop("checked",false);$(".publish-button").click();expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls[0].args[0].trivial).toBe(true)})});it("Without Send E-Mail shown",function(){$(".publish-button").click();expect($(".send-email").length).toEqual(0);expect(reviewReply.publish).toHaveBeenCalled();expect(reviewReply.publish.calls[0].args[0].trivial).toBe(false)})})});suite("rb/views/ReviewReplyEditorView",function(){var reviewReply,editor,view;beforeEach(function(){var $container=$("<div/>").appendTo($testsScratch);reviewReply=new RB.ReviewReply;spyOn(reviewReply,"discardIfEmpty").andCallFake(function(options,context){options.success.call(context)});editor=new RB.ReviewReplyEditor({review:new RB.Review({id:42,parentObject:new RB.ReviewRequest}),reviewReply:reviewReply,contextType:"rcbt",contextID:"100"});view=new RB.ReviewReplyEditorView({model:editor,el:$testsScratch});view._$commentsList=$('<ul class="reply-comments"/>');$container.append(view._$commentsList).append($('<a href="#" class="add_comment_link">New Comment</a>'))});describe("Construction",function(){it("Populate from draft comment",function(){var commentText="Test comment",now=moment(),$el=view._makeCommentElement({commentID:16,now:now,text:commentText});view.render();expect(editor.get("commentID")).toBe(16);expect(editor.get("text")).toBe(commentText);expect(editor.get("hasDraft")).toBe(true);expect(editor.get("timestamp").valueOf()).toBe(now.milliseconds(0).valueOf());expect(view._$draftComment[0]).toBe($el[0]);expect(view._$addCommentLink.is(":visible")).toBe(false)})});describe("Actions",function(){it("Add comment link",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);view._$addCommentLink.click();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Event handling",function(){it("Comment discarded",function(){var $el;view._makeCommentElement({text:"Test comment"});view.render();$el=view.$(".reply-comments li");expect($el.length).toBe(1);reviewReply.trigger("destroyed");$el=view.$(".reply-comments li");expect($el.length).toBe(0);expect(view._$draftComment).toBe(null)});it("Comment published",function(){var $draftEl=view._makeCommentElement({commentID:16}),$el;spyOn($.fn,"user_infobox").andCallThrough();spyOn($.fn,"timesince").andCallThrough();view.render();editor.set("text","Test **comment**");reviewReply.trigger("published");$el=view.$(".reply-comments li");expect($el.length).toBe(1);expect($draftEl).not.toBe($el);expect($el.hasClass("draft")).toBe(false);expect($el.data("comment-id")).toBe(16);expect(view._$draftComment).toBe(null);expect($.fn.user_infobox).toHaveBeenCalled();expect($.fn.timesince).toHaveBeenCalled()})});describe("Methods",function(){it("openCommentEditor",function(){view.render();expect(view._$addCommentLink.is(":visible")).toBe(true);expect(view._$draftComment).toBe(null);view.openCommentEditor();expect(view._$addCommentLink.is(":visible")).toBe(false);expect(view._$draftComment).not.toBe(null);expect(view._$draftComment.hasClass("draft")).toBe(true)})});describe("Text rendering",function(){function testRendering(richText,expectedHTML){var $comment,$reviewText;view.render();$comment=view._makeCommentElement({text:"<p><strong>Test</strong> &amp;lt;</p>",richText:richText});$reviewText=$comment.find(".reviewtext");expect($reviewText.length).toBe(1);expect($reviewText.hasClass("rich-text")).toBe(richText);expect($reviewText.html()).toBe(expectedHTML)}it("richText=true",function(){testRendering(true,"<p><strong>Test</strong> &amp;lt;</p>")});it("richText=false",function(){testRendering(false,"&lt;p&gt;&lt;strong&gt;Test&lt;/strong&gt; "+"&amp;amp;lt;&lt;/p&gt;")})})});suite("rb/views/ScreenshotThumbnail",function(){var model,view,template=_.template(["<div>",'<a class="edit"></a>','<a class="delete">X</a>',"</div>"].join(""));beforeEach(function(){var $el=$(template()).appendTo($testsScratch);model=new RB.Screenshot;model.url="/screenshots/123/";model.id=123;model.set("loaded",true);view=new RB.ScreenshotThumbnail({el:$el,model:model});view.render();spyOn(model,"trigger").andCallThrough();spyOn(view,"trigger").andCallThrough()});describe("Actions",function(){it("Begin caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit")});it("Cancel caption editing",function(){view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$caption.inlineEditor("cancel");expect(view.trigger).toHaveBeenCalledWith("endEdit")});it("Save caption",function(){spyOn(model,"save");view.$caption.inlineEditor("startEdit");expect(view.trigger).toHaveBeenCalledWith("beginEdit");view.$el.find("input").val("Foo").triggerHandler("keyup");view.$caption.inlineEditor("submit");expect(view.trigger).toHaveBeenCalledWith("endEdit");expect(model.get("caption")).toBe("Foo");expect(model.save).toHaveBeenCalled()});it("Delete",function(){spyOn(model,"destroy").andCallThrough();spyOn($,"ajax").andCallFake(function(options){options.success()});spyOn(view.$el,"fadeOut").andCallFake(function(done){done()});spyOn(view,"remove");view.$el.find("a.delete").click();expect($.ajax).toHaveBeenCalled();expect(model.destroy).toHaveBeenCalled();expect(model.trigger.calls[0].args[0]).toBe("destroying");expect(view.$el.fadeOut).toHaveBeenCalled();expect(view.remove).toHaveBeenCalled()})})})}).call(this);