/**
 * Validates that the length of an array falls within optional minimum and/or maximum bounds.
 *
 * @param value - The array to validate.
 * @param min - (Optional) Minimum allowed length of the array.
 * @param max - (Optional) Maximum allowed length of the array.
 * @param message - (Optional) Custom error message to use if the validation fails.
 * @param messagePrefix - (Optional) String to prepend to the error message(s).
 * @returns An array of error messages. Returns an empty array if the length is valid or no bounds are specified.
 *
 * @throws Error if both `min` and `max` are provided and `min` is greater than `max`.
 */
export declare function validateArrayLength({ value, min, max, message, messagePrefix, }: {
    value: unknown[];
    min?: number;
    max?: number;
    message?: string;
    messagePrefix?: string;
}): string[];
/**
 * Validates that a number falls within optional minimum and/or maximum bounds.
 *
 * @param value - The number to validate.
 * @param min - (Optional) Minimum allowed value of the number.
 * @param max - (Optional) Maximum allowed value of the number.
 * @param message - (Optional) Custom error message to use if the validation fails.
 * @param messagePrefix - (Optional) String to prepend to the error message(s).
 * @returns An array of error messages. Returns an empty array if the number is valid or no bounds are specified.
 *
 * @throws Error if both `min` and `max` are provided and `min` is greater than `max`.
 *
 */
export declare function validateNumberRange({ value, min, max, message, messagePrefix, }: {
    value: number;
    min?: number;
    max?: number;
    message?: string;
    messagePrefix?: string;
}): string[];
/**
 * Validates that an object contains only the specified mandatory and optional attributes.
 *
 * @param inputObject - The object to validate.
 * @param mandatoryAttributes - An array of mandatory attribute names.
 * @param optionalAttributes - An array of optional attribute names.
 * @param message - (Optional) Custom error message to use if the validation fails.
 * @param messagePrefix - (Optional) String to prepend to the error message(s).
 * @returns An array of error messages. Returns an empty array if the object is valid.
 */
export declare function validateObjectAttributes({ inputObject, mandatoryAttributes, optionalAttributes, message, messagePrefix, }: {
    inputObject: object;
    mandatoryAttributes: string[];
    optionalAttributes: string[];
    message?: string;
    messagePrefix?: string;
}): string[];
/**
 * Validates that a string falls within optional minimum and/or maximum length bounds.
 *
 * @param value - The string to validate.
 * @param min - (Optional) Minimum allowed length of the string.
 * @param max - (Optional) Maximum allowed length of the string.
 * @param message - (Optional) Custom error message to use if the validation fails.
 * @param messagePrefix - (Optional) String to prepend to the error message(s).
 * @returns An array of error messages. Returns an empty array if the length is valid or no bounds are specified.
 *
 * @throws Error if both `min` and `max` are provided and `min` is greater than `max`.
 */
export declare function validateStringLength({ value, min, max, message, messagePrefix, }: {
    value: string;
    min?: number;
    max?: number;
    message?: string;
    messagePrefix?: string;
}): string[];
/**
 * Validates that a string matches a regular expression.
 *
 * @param value - The string to validate.
 * @param regExp - The regular expression to match.
 * @param message - (Optional) Custom error message to use if the validation fails.
 * @param messagePrefix - (Optional) String to prepend to the error message(s).
 * @returns An array of error messages. Returns an empty array if the string matches the regular expression.
 */
export declare function validateRegExp({ value, regExp, message, messagePrefix, }: {
    value: string;
    regExp: RegExp;
    message?: string;
    messagePrefix?: string;
}): string[];
