import sqlite3
import re as РегВыр

Ошибка = sqlite3.Error

Разбор_объявленных_типов = sqlite3.PARSE_DECLTYPES
Разбор_названий_столбцов = sqlite3.PARSE_COLNAMES
Успешно = sqlite3.SQLITE_OK
Отказ = sqlite3.SQLITE_DENY
Игнорировать = sqlite3.SQLITE_IGNORE
Уровень_интерфейса_взаимодействия = sqlite3.apilevel
Стиль_параметров = sqlite3.paramstyle
Потокобезопасность = sqlite3.threadsafety

Словарь_перевода = {
    'НАЧАТЬ': 'BEGIN',
    'ЗАВЕРШИТЬ': 'END',
    'ТРАНЗАКЦИЮ': 'TRANSACTION',
    'УТВЕРДИТЬ': 'COMMIT',
    'ОТЛОЖЕННО': 'DEFERRED',
    'НЕМЕДЛЕННО': 'IMMEDIATE',
    'ИСКЛЮЧИТЕЛЬНО': 'EXCLUSIVE',
    'ОТКАТИТЬ': 'ROLLBACK',
    'ТОЧКА_СОХРАНЕНИЯ': 'SAVEPOINT',
    'НАСТРОИТЬ': 'PRAGMA',

    'ВЫБРАТЬ': 'SELECT',
    'ИЗ': 'FROM',
    'ГДЕ': 'WHERE',
    'УПОРЯДОЧИВ ПО': 'ORDER BY',
    'ПО ВОЗРАСТАНИЮ': 'ASC',
    'ПО УБЫВАНИЮ': 'DESC',
    'ГРУППАМИ ПО': 'GROUP BY',
    'ИМЕЮЩИМИ': 'HAVING',
    'РАЗЛИЧАЮЩИЕСЯ': 'DISTINCT',
    'ОБЪЕДИНИВ С': 'UNION',
    'СОДЕРЖАЩИЕСЯ В': 'INTERSECT',
    'ВСЕ': 'ALL',
    'НЕКОТОРЫЕ': 'ANY',
    'ИСКЛЮЧАЯ': 'EXCEPT',
    'НЕ БОЛЕЕ': 'LIMIT',
    'СО СМЕЩЕНИЕМ': 'OFFSET',
    'ПРИСОЕДИНИВ': 'JOIN',
    'ВНУТРЕННЕ': 'INNER',
    'ВНЕШНЕ': 'OUTER',
    'ПО ЛЕВОЙ': 'LEFT',
    'ПО ПРАВОЙ': 'RIGHT',
    'ПОЛНОСТЬЮ': 'FULL',
    'ПО': 'ON',
    'ПЕРЕКРЁСТНО': 'CROSS',
    'ИСПОЛЬЗУЯ': 'USING',

    'ВСТАВИТЬ ИЛИ ___ В': 'INSERT OR ___ INTO',
    'ДОБАВИТЬ В': 'INSERT INTO',
    'ЗНАЧЕНИЯ': 'VALUES',
    'ИЗМЕНИТЬ': 'UPDATE',
    'УСТАНОВИВ': 'SET',
    'УДАЛИТЬ': 'DELETE',
    'ПРИ КОНФЛИКТЕ': 'ON CONFLICT',
    'ВЫПОЛНЯТЬ': 'DO',
    'НИЧЕГО': 'NOTHING',
    'ПРОПУСТИТЬ': 'IGNORE',
    'ПРЕРВАТЬ': 'ABORT',
    'ЗАМЕНИТЬ': 'REPLACE',
    'ОТКАТИТЬ': 'ROLLBACK',
    'СБОЙ': 'FAIL',

    'ИЗМЕНИТЬ ТАБЛИЦУ': 'ALTER TABLE',
    'ИЗМЕНИТЬ СТОЛБЕЦ': 'ALTER COLUMN',
    'СОЗДАТЬ': 'CREATE',
    'БАЗУ ДАННЫХ': 'DATABASE',
    'ТАБЛИЦУ': 'TABLE',
    'ВРЕМЕННУЮ': 'TEMPORARY',
    'ДОБАВИВ': 'ADD',
    'УДАЛИВ': 'DROP',
    'ИНДЕКС': 'INDEX',
    'СХЕМУ': 'SCHEME',
    'ТАБЛИЦУ': 'TABLE',
    'УНИКАЛЬНЫЙ': 'UNIQUE',
    'ПРЕДСТАВЛЕНИЕ': 'VIEW',
    'СТОЛБЕЦ': 'COLUMN',
    'СТРОГО': 'STRICT',

    'ЯВЛЯЕТСЯ ПУСТЫМ': 'IS NULL',
    'НЕ ЯВЛЯЕТСЯ ПУСТЫМ': 'IS NOT NULL',
    'ПУСТО': 'NULL',
    'И': 'AND',
    'ИЛИ': 'OR',
    'НЕ': 'NOT',
    'ПОДОБНО': 'LIKE',
    'МЕЖДУ': 'BETWEEN',
    'В': 'IN',
    'ЕСЛИ': 'IF',
    'СУЩЕСТВУЕТ': 'EXISTS',
    'БЕЗ': 'WITHOUT',

    'ОПРЕДЕЛИВ': 'WITH',
    'ВЫБОР': 'CASE',
    'ПРИ': 'WHEN',
    'ЭТО': 'THEN',
    'КОНЕЦ': 'END',
    'РЕКУРСИВНО': 'RECURSIVE',

    'ЦЕЛОЕ': 'INTEGER',
    'ВЕЩЕСТВЕННОЕ': 'REAL',
    'ТЕКСТ': 'TEXT',
    'ДАННЫЕ': 'BLOB',
    'ДАТА': 'DATE',
    'ВРЕМЯ': 'TIME',
    'ВРЕМЕННАЯ_МЕТКА': 'TIMESTAMP',
    'ЛОГИЧЕСКОЕ': 'BOOLEAN',

    'КЛЮЧ': 'KEY',
    'ПЕРВИЧНЫЙ': 'PRIMARY',
    'ВНЕШНИЙ': 'FOREIGN',
    'ПРОВЕРЯТЬ': 'CHECK',
    'КАК': 'AS',
    'ДА': 'TRUE',
    'НЕТ': 'FALSE',
    'ПО_УМОЛЧАНИЮ': 'DEFAULT',
    'САМОУВЕЛИЧИВАЮЩЕЕСЯ': 'AUTO_INCREMENT',
    'ССЫЛАЕТСЯ НА': 'REFERENCES',

    'ОТОБРАВ': 'FILTER',
    'КОЛИЧЕСТВО': 'COUNT',
    'СУММА': 'SUM',
    'СРЕДНЕЕ': 'AVG',
    'НАИМЕНЬШЕЕ': 'MIN',
    'НАИБОЛЬШЕЕ': 'MAX',
    'СЦЕПИТЬ': 'CONCAT',
    'ДЛИНА': 'LENGTH',
    'В_ЗАГЛАВНЫЕ': 'UPPER',
    'В_СТРОЧНЫЕ': 'LOWER',
    'ПОДСТРОКА': 'SUBSTRING',
    'ЗАМЕНИТЬ': 'REPLACE',
    'ОКРУГЛИТЬ': 'ROUND',
    'ОКРУГЛИТЬ_ВНИЗ': 'FLOOR',
    'ОКРУГЛИТЬ_ВВЕРХ': 'CEIL',
    'МОДУЛЬ': 'ABS',
    'ТЕКУЩАЯ_ДАТА': 'CURRENT_DATE',
    'ТЕКУЩЕЕ_ВРЕМЯ': 'CURRENT_TIME',
    'ТЕКУЩАЯ_ВРЕМЕННАЯ_МЕТКА': 'CURRENT_TIMESTAMP',
    'ИЗВЛЕЧЬ': 'EXTRACT',
    'ГОД': 'YEAR',
    'МЕСЯЦ': 'MONTH',
    'ДЕНЬ': 'DAY'
}

def Получить_токены(запрос):
    токены = []
    текущий_токен = ''
    в_строке = False
    в_комментарии = False
    строка_символ = None
    i = 0

    while i < len(запрос):
        символ = запрос[i]

        if символ in ('"', "'") and not в_комментарии:
            if в_строке and символ == строка_символ:
                в_строке = False
                текущий_токен += символ
                токены.append(текущий_токен)
                текущий_токен = ''
                i += 1
                continue
            elif not в_строке:
                в_строке = True
                строка_символ = символ
                if текущий_токен:
                    токены.append(текущий_токен)
                    текущий_токен = ''
                текущий_токен = символ
                i += 1
                continue

        if символ == '-' and i + 1 < len(запрос) and запрос[i + 1] == '-' and not в_строке:
            if текущий_токен:
                токены.append(текущий_токен)
                текущий_токен = ''
            в_комментарии = True
            текущий_токен = '--'
            i += 2
            while i < len(запрос) and запрос[i] != '\n':
                текущий_токен += запрос[i]
                i += 1
            токены.append(текущий_токен)
            текущий_токен = ''
            в_комментарии = False
            continue

        if символ == '/' and i + 1 < len(запрос) and запрос[i + 1] == '*' and not в_строке:
            if текущий_токен:
                токены.append(текущий_токен)
                текущий_токен = ''
            в_комментарии = True
            текущий_токен = '/*'
            i += 2
            while i < len(запрос) - 1 and not (запрос[i] == '*' and запрос[i + 1] == '/'):
                текущий_токен += запрос[i]
                i += 1
            if i < len(запрос) - 1:
                текущий_токен += '*/'
                i += 2
            токены.append(текущий_токен)
            текущий_токен = ''
            в_комментарии = False
            continue

        if в_строке or в_комментарии:
            текущий_токен += символ
            i += 1
            continue

        if символ.isspace() or символ in (',', ';', '(', ')', '=', '<', '>', '!'):
            if текущий_токен:
                токены.append(текущий_токен)
                текущий_токен = ''
            if not символ.isspace():
                токены.append(символ)
            i += 1
            continue
        
        текущий_токен += символ
        i += 1
    
    if текущий_токен:
        токены.append(текущий_токен)
    
    return токены

def Перевести_токены(токены):
    переведённые_токены = []
    i = 0
    
    while i < len(токены):
        токен = токены[i]

        if (токен.startswith('"') or токен.startswith("'") or 
            токен.startswith('--') or токен.startswith('/*') or
            токен in (',', ';', '(', ')', '=', '<', '>', '!')):
            переведённые_токены.append(токен)
            i += 1
            continue

        найдено_ключевое_слово = False
        for длина in range(5, 0, -1):
            if i + длина <= len(токены):
                фраза = ' '.join(токены[i:i + длина]).upper()

                for ключ, значение in Словарь_перевода.items():
                    if '___' in ключ:
                        шаблон = '^' + ключ.replace('___', r'(\S+)') + '$'
                        совпадение = РегВыр.match(шаблон, фраза)
                        if совпадение:
                            переменная = совпадение.group(1).upper()
                            if переменная in Словарь_перевода:
                                переведённая_переменная = Словарь_перевода[переменная]
                                переведённая_фраза = значение.replace('___', переведённая_переменная)
                                переведённые_токены.append(переведённая_фраза)
                                i += длина
                                найдено_ключевое_слово = True
                                break
                
                if найдено_ключевое_слово:
                    break

                if фраза in Словарь_перевода:
                    переведённые_токены.append(Словарь_перевода[фраза])
                    i += длина
                    найдено_ключевое_слово = True
                    break
        
        if not найдено_ключевое_слово:
            переведённые_токены.append(токен)
            i += 1
    
    return переведённые_токены

def Собрать_запрос(токены):
    запрос = ''
    for i, токен in enumerate(токены):
        if токен in (',', ';', '(', ')', '=', '<', '>', '!'):
            запрос += токен
        else:
            if i > 0 and токены[i - 1] not in (' ', ',', ';', '(', '=', '<', '>', '!'):
                запрос += ' '
            запрос += токен
    return запрос.strip()

def Перевести_код_запроса(текст):
    токены = Получить_токены(текст)
    переведённые_токены = Перевести_токены(токены)
    запрос = Собрать_запрос(переведённые_токены)
    return запрос

Переводы_ошибок = {
    r"no such table: (.+)": r'Таблица "\1" не существует.',
    r"database is locked": r'База данных заблокована.',
    r"near \"(.+)\": syntax error": r'Синтаксическая ошибка около "\1".',
    r"table (.+) already exists": r'Таблица "\1" уже существует.',
    r"no such column: (.+)": r'Столбец "\1" не существует.',
    r"(.+) has no column named (.+)": r'Таблица "\1" не имеет столбца "\2".',
    r"cannot open database file": r'Не удалось открыть файл базы данных.',
    r"database or disk is full": r'База данных или диск переполнены.',
    r"attempt to write a readonly database": r'Попытка записи в базу данных, доступную только для чтения.',
    r"no such index: (.+)": r'Индекс "\1" не существует.',
    r"too many SQL variables": r'Слишком много переменных в запросе.',
    r"maximum recursion depth exceeded": r'Превышена максимальная глубина рекурсии в запросе.',
    r"incomplete input": r'Неполный запрос.',
    r"malformed database schema \((.+)\)": r'Некорректная схема базы данных: \1.',
    r"file is not a database": r'Файл не является базой данных.',
    r"database disk image is malformed": r'Образ диска базы данных повреждён.',
    r"incorrect number of bindings supplied. The statement has (\d+) parameters, and (\d+) were supplied": r'Неверное количество переданных параметров. Ожидаемых запросом параметров - \1, передано - \2.',
    r"You did not supply a value for binding (\d+)": r'Не указано значение для параметра \1.',
    r"Cannot operate on a closed database": r'Невозможно выполнить операцию на закрытой базе данных.',
    r"Cannot operate on a closed cursor": r'Невозможно выполнить операцию на закрытом указателе.',
    r"column (.+) is not unique": r'Столбец "\1" должен быть уникальным.',
    r"number of bound variables does not match number of parameters": r'Количество привязанных переменных не соответствует количеству параметров.',
    r"only one statement is allowed": r'Разрешено выполнять только один запрос за раз.',
    r"NOT NULL constraint failed: (.+)": r'Нарушение ограничения НЕ ПУСТО для столбца "\1".',
    r"UNIQUE constraint failed: (.+)": r'Нарушение ограничения УНИКАЛЬНЫЙ для столбца "\1".',
    r"FOREIGN KEY constraint failed": r'Нарушение ограничения ВНЕШНИЙ КЛЮЧ.',
    r"CHECK constraint failed: (.+)": r'Нарушение ограничения ПРОВЕРЯТЬ: \1.',
    r"PRIMARY KEY must be unique": r'Первичный ключ должен быть уникальным.',
    r"Error binding parameter (\d+) - probably unsupported type": r'Ошибка привязки параметра \1 - вероятно, неподдерживаемый тип.',
    r"Cursor needed to be reset because of commit/rollback and can no longer be fetched from": r'Указатель должен быть сброшен из-за утверждения или отката и больше не может быть использован.',
    r"Warning: You can only execute one statement at a time": r'Можно выполнять только один запрос за раз.',
    r"(.+) not supported by this database": r'Операция "\1" не поддерживается этой базой данных.',
    r"too many connections": r'Слишком много активных подключений к базе данных.',
    r"no such function: (.+)": r'Функция "\1" не существует.',
    r"no such module: (.+)": r'Модуль "\1" не существует.',
    r"parameters are of unsupported type": r'Параметры имеют неподдерживаемый тип.',
    r"interrupted": r'Операция была прервана.',
    r"out of memory": r'Недостаточно памяти для выполнения операции.'
}

def Перевести_ошибку(исключение):
    сообщение = str(исключение)
    for шаблон, перевод in Переводы_ошибок.items():
        совпадение = РегВыр.match(шаблон, сообщение)
        if совпадение:
            return РегВыр.sub(шаблон, перевод, сообщение)
    return f"Неизвестная ошибка: {сообщение}"

class Указатель():
    def __init__(здесь, курсор):
        здесь._курсор = курсор

    def Выполнить_запрос(здесь, запрос, параметры=()):
        try:
            запрос = Перевести_код_запроса(запрос)
            здесь._курсор.execute(запрос, параметры)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Выполнить_запросы(здесь, запрос, последовательность_параметров):
        try:
            запрос = Перевести_код_запроса(запрос)
            здесь._курсор.executemany(запрос, последовательность_параметров)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Выполнить_сценарий(здесь, сценарий):
        try:
            скрипт = Перевести_код_запроса(сценарий)
            здесь._курсор.executescript(скрипт)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Извлечь_запись(здесь):
        return здесь._курсор.fetchone()

    def Извлечь_записи(здесь, количество):
        return здесь._курсор.fetchmany(количество)

    def Извлечь_все_записи(здесь):
        return здесь._курсор.fetchall()

    def Закрыть(здесь): здесь._курсор.close()

    @property
    def Описание(здесь): return здесь._курсор.description

    @property
    def Количество_строк(здесь): return здесь._курсор.rowcount

    @property
    def Последний_идентификатор(здесь): return здесь._курсор.lastrowid

class Соединение():
    def __init__(здесь,
        путь, *,
        таймаут = 5.0,
        обнаружение_типов = 0,
        уровень_изоляции = None,
        проверять_тот_же_ли_поток = True,
        кэш_инструкций = 128,
        является_ссылкой = False
    ):
        if уровень_изоляции == 'ОТЛОЖЕННО': уровень_изоляции = 'DEFERRED'
        elif уровень_изоляции == 'НЕМЕДЛЕННО': уровень_изоляции = 'IMMEDIATE'
        elif уровень_изоляции == 'ИСКЛЮЧИТЕЛЬНО': уровень_изоляции = 'EXCLUSIVE'
        else: уровень_изоляции = None

        try:
            здесь._соединение = sqlite3.connect(
                путь,
                timeout=таймаут,
                detect_types=обнаружение_типов,
                isolation_level=уровень_изоляции,
                check_same_thread=проверять_тот_же_ли_поток,
                cached_statements=кэш_инструкций,
                uri=является_ссылкой
            )
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Создать_указатель(здесь):
        try:
            курсор = здесь._соединение.cursor()
            return Указатель(курсор)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Выполнить_запрос(здесь, запрос, параметры=()):
        try:
            запрос = Перевести_код_запроса(запрос)
            указатель = здесь._соединение.execute(запрос, параметры)
            return Указатель(указатель)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Выполнить_запросы(здесь, запрос, параметры):
        try:
            запрос = Перевести_код_запроса(запрос)
            указатель = здесь._соединение.executemany(запрос, параметры)
            return Указатель(указатель)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Выполнить_сценарий(здесь, сценарий):
        try:
            скрипт = Перевести_код_запроса(сценарий)
            здесь._соединение.executescript(скрипт)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Создать_функцию(здесь, имя, количество_параметров, функция):
        try: здесь._соединение.create_function(имя, количество_параметров, функция)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Создать_агрегатную_функцию(здесь, имя, число_аргументов, класс):
        try: здесь._соединение.create_aggregate(имя, число_аргументов)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Создать_сопоставление(здесь, имя, функция):
        try: здесь._соединение.create_collation(имя, функция)
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Закрыть(здесь):
        try: здесь._соединение.close()
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Утвердить(здесь):
        try: здесь._соединение.commit()
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    def Откатить(здесь):
        try: здесь._соединение.rollback()
        except Ошибка as ош: raise Ошибка(Перевести_ошибку(ош)) from ош

    @property
    def В_транзакции(здесь): return здесь._соединение.in_transaction

    @property
    def Изоляция(здесь): return здесь._соединение.isolation_level

    @Изоляция.setter
    def Изоляция(здесь, значение): здесь._соединение.isolation_level = значение
