"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC1jb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkZXBsb3ltZW50LWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSxvQ0FBa0Q7QUFnQmxEOzs7Ozs7OztHQVFHO0FBQ0gsTUFBYSxtQkFBbUI7SUFlOUI7UUFDRSx3RUFBd0U7SUFDMUUsQ0FBQztJQWREOzs7Ozs7O09BT0c7SUFDSSxNQUFNLENBQUMsMkJBQTJCLENBQUMsTUFBcUIsRUFBRSxHQUFXLEVBQUUsdUJBQStCO1FBQzNHLE9BQU8sZ0JBQWdCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUNuRCxDQUFDOztBQWJILGtEQWtCQztBQWpCd0IsK0JBQVcsR0FBRyxnQkFBZ0IsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0FBbUIxRixTQUFTLGdCQUFnQixDQUFDLElBQVk7SUFDcEMsT0FBTztRQUNMLG9CQUFvQixFQUFFLElBQUk7UUFDMUIsbUJBQW1CLEVBQUUsOEJBQXNCLENBQUMsSUFBSSxDQUFDO0tBQ2xELENBQUM7QUFDSixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgYXJuRm9yRGVwbG95bWVudENvbmZpZyB9IGZyb20gJy4uL3V0aWxzJztcblxuLyoqXG4gKiBUaGUgRGVwbG95bWVudCBDb25maWd1cmF0aW9uIG9mIGFuIEVDUyBEZXBsb3ltZW50IEdyb3VwLlxuICogVGhlIGRlZmF1bHQsIHByZS1kZWZpbmVkIENvbmZpZ3VyYXRpb25zIGFyZSBhdmFpbGFibGUgYXMgY29uc3RhbnRzIG9uIHRoZSB7QGxpbmsgRWNzRGVwbG95bWVudENvbmZpZ30gY2xhc3NcbiAqIChmb3IgZXhhbXBsZSwgYEVjc0RlcGxveW1lbnRDb25maWcuQWxsQXRPbmNlYCkuXG4gKlxuICogTm90ZTogQ2xvdWRGb3JtYXRpb24gZG9lcyBub3QgY3VycmVudGx5IHN1cHBvcnQgY3JlYXRpbmcgY3VzdG9tIEVDUyBjb25maWdzIG91dHNpZGVcbiAqIG9mIHVzaW5nIGEgY3VzdG9tIHJlc291cmNlLiBZb3UgY2FuIGltcG9ydCBjdXN0b20gZGVwbG95bWVudCBjb25maWcgY3JlYXRlZCBvdXRzaWRlIHRoZVxuICogQ0RLIG9yIHZpYSBhIGN1c3RvbSByZXNvdXJjZSB3aXRoIHtAbGluayBFY3NEZXBsb3ltZW50Q29uZmlnI2Zyb21FY3NEZXBsb3ltZW50Q29uZmlnTmFtZX0uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUVjc0RlcGxveW1lbnRDb25maWcge1xuICByZWFkb25seSBkZXBsb3ltZW50Q29uZmlnTmFtZTogc3RyaW5nO1xuICByZWFkb25seSBkZXBsb3ltZW50Q29uZmlnQXJuOiBzdHJpbmc7XG59XG5cbi8qKlxuICogQSBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uIGZvciBhbiBFQ1MgRGVwbG95bWVudCBHcm91cC5cbiAqXG4gKiBOb3RlOiBUaGlzIGNsYXNzIGN1cnJlbnRseSBzdGFuZHMgYXMgbmFtZXNwYWNlZCBjb250YWluZXIgb2YgdGhlIGRlZmF1bHQgY29uZmlndXJhdGlvbnNcbiAqIHVudGlsIENsb3VkRm9ybWF0aW9uIHN1cHBvcnRzIGN1c3RvbSBFQ1MgRGVwbG95bWVudCBDb25maWdzLiBVbnRpbCB0aGVuIGl0IGlzIGNsb3NlZFxuICogKHByaXZhdGUgY29uc3RydWN0b3IpIGFuZCBkb2VzIG5vdCBleHRlbmQge0BsaW5rIGNkay5Db25zdHJ1Y3R9XG4gKlxuICogQHJlc291cmNlIEFXUzo6Q29kZURlcGxveTo6RGVwbG95bWVudENvbmZpZ1xuICovXG5leHBvcnQgY2xhc3MgRWNzRGVwbG95bWVudENvbmZpZyB7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQUxMX0FUX09OQ0UgPSBkZXBsb3ltZW50Q29uZmlnKCdDb2RlRGVwbG95RGVmYXVsdC5FQ1NBbGxBdE9uY2UnKTtcblxuICAvKipcbiAgICogSW1wb3J0IGEgY3VzdG9tIERlcGxveW1lbnQgQ29uZmlndXJhdGlvbiBmb3IgYW4gRUNTIERlcGxveW1lbnQgR3JvdXAgZGVmaW5lZCBvdXRzaWRlIHRoZSBDREsuXG4gICAqXG4gICAqIEBwYXJhbSBfc2NvcGUgdGhlIHBhcmVudCBDb25zdHJ1Y3QgZm9yIHRoaXMgbmV3IENvbnN0cnVjdFxuICAgKiBAcGFyYW0gX2lkIHRoZSBsb2dpY2FsIElEIG9mIHRoaXMgbmV3IENvbnN0cnVjdFxuICAgKiBAcGFyYW0gZWNzRGVwbG95bWVudENvbmZpZ05hbWUgdGhlIG5hbWUgb2YgdGhlIHJlZmVyZW5jZWQgY3VzdG9tIERlcGxveW1lbnQgQ29uZmlndXJhdGlvblxuICAgKiBAcmV0dXJucyBhIENvbnN0cnVjdCByZXByZXNlbnRpbmcgYSByZWZlcmVuY2UgdG8gYW4gZXhpc3RpbmcgY3VzdG9tIERlcGxveW1lbnQgQ29uZmlndXJhdGlvblxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRWNzRGVwbG95bWVudENvbmZpZ05hbWUoX3Njb3BlOiBjZGsuQ29uc3RydWN0LCBfaWQ6IHN0cmluZywgZWNzRGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZyk6IElFY3NEZXBsb3ltZW50Q29uZmlnIHtcbiAgICByZXR1cm4gZGVwbG95bWVudENvbmZpZyhlY3NEZXBsb3ltZW50Q29uZmlnTmFtZSk7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkge1xuICAgIC8vIG5vdGhpbmcgdG8gZG8gdW50aWwgQ0ZOIHN1cHBvcnRzIGN1c3RvbSBFQ1MgZGVwbG95bWVudCBjb25maWd1cmF0aW9uc1xuICB9XG59XG5cbmZ1bmN0aW9uIGRlcGxveW1lbnRDb25maWcobmFtZTogc3RyaW5nKTogSUVjc0RlcGxveW1lbnRDb25maWcge1xuICByZXR1cm4ge1xuICAgIGRlcGxveW1lbnRDb25maWdOYW1lOiBuYW1lLFxuICAgIGRlcGxveW1lbnRDb25maWdBcm46IGFybkZvckRlcGxveW1lbnRDb25maWcobmFtZSksXG4gIH07XG59XG4iXX0=