#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface
ctypedef void (*CallbackType) (Model)  noexcept nogil
cdef class CallbackWrapper:
    cdef CallbackType callback
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
@cython.final
cdef class ControlParameters:
    cdef public double responses
@cython.final
cdef class DerivedParameters:
    cdef public numpy.int64_t nmb
    cdef public double[:] maxq
    cdef public double[:] diffq
    cdef public numpy.int64_t[:] ar_order
    cdef public numpy.int64_t[:] ma_order
    cdef public double[:,:] ar_coefs
    cdef public double[:,:] ma_coefs
@cython.final
cdef class Sequences:
    cdef public InletSequences inlets
    cdef public FluxSequences fluxes
    cdef public LogSequences logs
    cdef public OutletSequences outlets
@cython.final
cdef class InletSequences:
    cdef double **q
    cdef public numpy.int64_t len_q
    cdef public numpy.int64_t[:] _q_ready
    cdef public numpy.int64_t _q_ndim
    cdef public numpy.int64_t _q_length
    cdef public numpy.int64_t _q_length_0
    cpdef inline alloc(self, name, numpy.int64_t length)
    cpdef inline dealloc(self, name)
    cpdef inline set_pointer1d(self, str name, pointerutils.Double value, numpy.int64_t idx)
    cpdef get_value(self, str name)
    cpdef set_value(self, str name, value)
@cython.final
cdef class FluxSequences:
    cdef public double qin
    cdef public numpy.int64_t _qin_ndim
    cdef public numpy.int64_t _qin_length
    cdef public bint _qin_ramflag
    cdef public double[:] _qin_array
    cdef public bint _qin_diskflag_reading
    cdef public bint _qin_diskflag_writing
    cdef public double[:] _qin_ncarray
    cdef public bint _qin_outputflag
    cdef double *_qin_outputpointer
    cdef public double[:] qpin
    cdef public numpy.int64_t _qpin_ndim
    cdef public numpy.int64_t _qpin_length
    cdef public numpy.int64_t _qpin_length_0
    cdef public bint _qpin_ramflag
    cdef public double[:,:] _qpin_array
    cdef public bint _qpin_diskflag_reading
    cdef public bint _qpin_diskflag_writing
    cdef public double[:] _qpin_ncarray
    cdef public double[:] qma
    cdef public numpy.int64_t _qma_ndim
    cdef public numpy.int64_t _qma_length
    cdef public numpy.int64_t _qma_length_0
    cdef public bint _qma_ramflag
    cdef public double[:,:] _qma_array
    cdef public bint _qma_diskflag_reading
    cdef public bint _qma_diskflag_writing
    cdef public double[:] _qma_ncarray
    cdef public double[:] qar
    cdef public numpy.int64_t _qar_ndim
    cdef public numpy.int64_t _qar_length
    cdef public numpy.int64_t _qar_length_0
    cdef public bint _qar_ramflag
    cdef public double[:,:] _qar_array
    cdef public bint _qar_diskflag_reading
    cdef public bint _qar_diskflag_writing
    cdef public double[:] _qar_ncarray
    cdef public double[:] qpout
    cdef public numpy.int64_t _qpout_ndim
    cdef public numpy.int64_t _qpout_length
    cdef public numpy.int64_t _qpout_length_0
    cdef public bint _qpout_ramflag
    cdef public double[:,:] _qpout_array
    cdef public bint _qpout_diskflag_reading
    cdef public bint _qpout_diskflag_writing
    cdef public double[:] _qpout_ncarray
    cdef public double qout
    cdef public numpy.int64_t _qout_ndim
    cdef public numpy.int64_t _qout_length
    cdef public bint _qout_ramflag
    cdef public double[:] _qout_array
    cdef public bint _qout_diskflag_reading
    cdef public bint _qout_diskflag_writing
    cdef public double[:] _qout_ncarray
    cdef public bint _qout_outputflag
    cdef double *_qout_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class LogSequences:
    cdef public double[:,:] login
    cdef public numpy.int64_t _login_ndim
    cdef public numpy.int64_t _login_length
    cdef public numpy.int64_t _login_length_0
    cdef public numpy.int64_t _login_length_1
    cdef public double[:,:] logout
    cdef public numpy.int64_t _logout_ndim
    cdef public numpy.int64_t _logout_length
    cdef public numpy.int64_t _logout_length_0
    cdef public numpy.int64_t _logout_length_1
@cython.final
cdef class OutletSequences:
    cdef double *q
    cdef public numpy.int64_t _q_ndim
    cdef public numpy.int64_t _q_length
    cpdef inline set_pointer0d(self, str name, pointerutils.Double value)
    cpdef get_value(self, str name)
    cpdef set_value(self, str name, value)
@cython.final
cdef class Model:
    cdef public numpy.int64_t idx_sim
    cdef public Parameters parameters
    cdef public Sequences sequences
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil
    cpdef void reset_reuseflags(self) noexcept nogil
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void run(self) noexcept nogil
    cpdef inline void update_inlets(self) noexcept nogil
    cpdef inline void update_outlets(self) noexcept nogil
    cpdef inline void update_receivers(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void update_senders(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void update_outputs(self) noexcept nogil
    cpdef inline void pick_q_v1(self) noexcept nogil
    cpdef inline void calc_qpin_v1(self) noexcept nogil
    cpdef inline void update_login_v1(self) noexcept nogil
    cpdef inline void calc_qma_v1(self) noexcept nogil
    cpdef inline void calc_qar_v1(self) noexcept nogil
    cpdef inline void calc_qpout_v1(self) noexcept nogil
    cpdef inline void update_logout_v1(self) noexcept nogil
    cpdef inline void calc_qout_v1(self) noexcept nogil
    cpdef inline void pass_q_v1(self) noexcept nogil
    cpdef inline void pick_q(self) noexcept nogil
    cpdef inline void calc_qpin(self) noexcept nogil
    cpdef inline void update_login(self) noexcept nogil
    cpdef inline void calc_qma(self) noexcept nogil
    cpdef inline void calc_qar(self) noexcept nogil
    cpdef inline void calc_qpout(self) noexcept nogil
    cpdef inline void update_logout(self) noexcept nogil
    cpdef inline void calc_qout(self) noexcept nogil
    cpdef inline void pass_q(self) noexcept nogil
