"""The namespace contains classes suitable for export, save or creation of different file formats."""
from typing import List, Optional, Dict, Iterable, Any, overload
import enum
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime, timedelta
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.avif
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.metadata
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class ApngOptions(PngOptions):
    '''The API for Animated PNG (Animated Portable Network Graphics) image file format
    creation is a dynamic tool for developers seeking to generate captivating
    animated images. With customizable options such as frame duration and the
    number of times to loop, this API allows for fine-tuning animated content
    according to specific needs. Whether creating engaging web graphics or
    interactive visuals, you can leverage this API to seamlessly incorporate
    APNG images with precise control over animation parameters.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.ApngOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.imaging.fileformats.png.PngColorType:
        '''Gets the type of the color.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.imaging.fileformats.png.PngColorType) -> None:
        '''Sets the type of the color.'''
        raise NotImplementedError()
    
    @property
    def progressive(self) -> bool:
        '''Gets a value indicating whether a :py:class:`aspose.imaging.fileformats.png.PngImage` is progressive.'''
        raise NotImplementedError()
    
    @progressive.setter
    def progressive(self, value : bool) -> None:
        '''Sets a value indicating whether a :py:class:`aspose.imaging.fileformats.png.PngImage` is progressive.'''
        raise NotImplementedError()
    
    @property
    def filter_type(self) -> aspose.imaging.fileformats.png.PngFilterType:
        '''Gets the filter type used during png file save process.'''
        raise NotImplementedError()
    
    @filter_type.setter
    def filter_type(self, value : aspose.imaging.fileformats.png.PngFilterType) -> None:
        '''Sets the filter type used during png file save process.'''
        raise NotImplementedError()
    
    @property
    def compression_level(self) -> int:
        '''Gets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @compression_level.setter
    def compression_level(self, value : int) -> None:
        '''Sets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @property
    def png_compression_level(self) -> aspose.imaging.imageoptions.PngCompressionLevel:
        '''Gets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @png_compression_level.setter
    def png_compression_level(self, value : aspose.imaging.imageoptions.PngCompressionLevel) -> None:
        '''Sets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @property
    def bit_depth(self) -> int:
        '''Gets the bit depth values in range of 1, 2, 4, 8, 16.
        
        
        Mind the next limits:
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.INDEXED_COLOR` supports bit depth of 1, 2, 4, 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE_WITH_ALPHA` support bit depth of 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR_WITH_ALPHA` support bit depth of 8, 16.'''
        raise NotImplementedError()
    
    @bit_depth.setter
    def bit_depth(self, value : int) -> None:
        '''Sets the bit depth values in range of 1, 2, 4, 8, 16.
        
        
        Mind the next limits:
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.INDEXED_COLOR` supports bit depth of 1, 2, 4, 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE_WITH_ALPHA` support bit depth of 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR_WITH_ALPHA` support bit depth of 8, 16.'''
        raise NotImplementedError()
    
    @staticmethod
    @property
    def DEFAULT_COMPRESSION_LEVEL() -> aspose.imaging.imageoptions.PngCompressionLevel:
        '''The default compression level.'''
        raise NotImplementedError()

    @property
    def num_plays(self) -> int:
        '''Gets the number of times to loop animation.
        0 indicates infinite looping.'''
        raise NotImplementedError()
    
    @num_plays.setter
    def num_plays(self, value : int) -> None:
        '''Sets the number of times to loop animation.
        0 indicates infinite looping.'''
        raise NotImplementedError()
    
    @property
    def default_frame_time(self) -> int:
        '''Gets the default frame duration.'''
        raise NotImplementedError()
    
    @default_frame_time.setter
    def default_frame_time(self, value : int) -> None:
        '''Sets the default frame duration.'''
        raise NotImplementedError()
    

class BigTiffOptions(TiffOptions):
    '''The API for BigTIFF raster image format creation is specifically designed
    to serve to the unique requirements of applications utilizing large-scale
    imaging data from scanners. This API facilitates the seamless generation
    of BigTIFF format, which combines multiple TIFF images into a single,
    comprehensive image. It ensures efficient processing of extensive image
    data, providing developers with a powerful tool for creating and
    manipulating high-resolution, multi-image formats.'''
    
    @overload
    def __init__(self, expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class. By default little endian convention is used.
        
        :param expected_format: The expected Tiff file format.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, options : aspose.imaging.imageoptions.TiffOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class.
        
        :param options: The options source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class.
        
        :param tags: The tags for options initialization.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat, byte_order : aspose.imaging.fileformats.tiff.enums.TiffByteOrder) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class.
        
        :param expected_format: The expected Tiff file format.
        :param byte_order: The tiff file format byte order to use.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Clones this instance.
        
        :returns: Returns a deep clone.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_format(expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat) -> aspose.imaging.imageoptions.BigTiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class. By default little endian convention is used.
        
        :param expected_format: The expected Tiff file format.
        :returns: A new BigTiffOptions object.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_options(options : aspose.imaging.imageoptions.TiffOptions) -> aspose.imaging.imageoptions.BigTiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class.
        
        :param options: The options source.
        :returns: A copy of options.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_tags(tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> aspose.imaging.imageoptions.BigTiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BigTiffOptions` class.
        
        :param tags: The tags for options initialization.
        :returns: A new BigTiffOptions object with tags.'''
        raise NotImplementedError()
    
    def is_tag_present(self, tag : aspose.imaging.fileformats.tiff.enums.TiffTags) -> bool:
        '''Determines whether tag is present in the options or not.
        
        :param tag: The tag id to check.
        :returns: ``true`` if tag is present; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_valid_tags_count(tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> int:
        '''Gets the valid tags count.
        
        :param tags: The tags to validate.
        :returns: The valid tags count.'''
        raise NotImplementedError()
    
    def remove_tag(self, tag : aspose.imaging.fileformats.tiff.enums.TiffTags) -> bool:
        '''Removes the tag.
        
        :param tag: The tag to remove.
        :returns: true if successfully removed'''
        raise NotImplementedError()
    
    def remove_tags(self, tags : List[aspose.imaging.fileformats.tiff.enums.TiffTags]) -> bool:
        '''Removes the tags.
        
        :param tags: The tags to remove.
        :returns: if tag collection size changed.'''
        raise NotImplementedError()
    
    def validate(self) -> None:
        '''Validates if options have valid combination of tags'''
        raise NotImplementedError()
    
    def add_tags(self, tags_to_add : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Adds the tags.
        
        :param tags_to_add: The tags to add.'''
        raise NotImplementedError()
    
    def add_tag(self, tag_to_add : aspose.imaging.fileformats.tiff.TiffDataType) -> None:
        '''Adds a new tag.
        
        :param tag_to_add: The tag to add.'''
        raise NotImplementedError()
    
    def get_tag_by_type(self, tag_key : aspose.imaging.fileformats.tiff.enums.TiffTags) -> aspose.imaging.fileformats.tiff.TiffDataType:
        '''Gets the instance of the tag by type.
        
        :param tag_key: The tag key.
        :returns: Instance of the tag if exists or null otherwise.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def tag_count(self) -> int:
        '''Gets the tag count.'''
        raise NotImplementedError()
    
    @property
    def file_standard(self) -> aspose.imaging.fileformats.tiff.enums.TiffFileStandards:
        '''Gets the TIFF file standard.'''
        raise NotImplementedError()
    
    @file_standard.setter
    def file_standard(self, value : aspose.imaging.fileformats.tiff.enums.TiffFileStandards) -> None:
        '''Sets the TIFF file standard.'''
        raise NotImplementedError()
    
    @property
    def default_memory_allocation_limit(self) -> int:
        '''Gets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @default_memory_allocation_limit.setter
    def default_memory_allocation_limit(self, value : int) -> None:
        '''Sets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @property
    def premultiply_components(self) -> bool:
        '''Gets a value indicating whether components must be premultiplied.'''
        raise NotImplementedError()
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool) -> None:
        '''Sets a value indicating whether components must be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def is_valid(self) -> bool:
        '''Gets a value indicating whether the :py:class:`aspose.imaging.imageoptions.TiffOptions` have been properly configured. Use Validate method as to find the failure reason.'''
        raise NotImplementedError()
    
    @property
    def y_cb_cr_subsampling(self) -> List[int]:
        '''Gets the subsampling factors for YCbCr photometric.'''
        raise NotImplementedError()
    
    @y_cb_cr_subsampling.setter
    def y_cb_cr_subsampling(self, value : List[int]) -> None:
        '''Sets the subsampling factors for YCbCr photometric.'''
        raise NotImplementedError()
    
    @property
    def y_cb_cr_coefficients(self) -> List[aspose.imaging.fileformats.tiff.TiffRational]:
        '''Gets the YCbCrCoefficients.'''
        raise NotImplementedError()
    
    @y_cb_cr_coefficients.setter
    def y_cb_cr_coefficients(self, value : List[aspose.imaging.fileformats.tiff.TiffRational]) -> None:
        '''Sets the YCbCrCoefficients.'''
        raise NotImplementedError()
    
    @property
    def is_tiled(self) -> bool:
        '''Gets a value indicating whether image is tiled.'''
        raise NotImplementedError()
    
    @property
    def artist(self) -> str:
        '''Gets the artist.'''
        raise NotImplementedError()
    
    @artist.setter
    def artist(self, value : str) -> None:
        '''Sets the artist.'''
        raise NotImplementedError()
    
    @property
    def byte_order(self) -> aspose.imaging.fileformats.tiff.enums.TiffByteOrder:
        '''Gets a value indicating the tiff byte order.'''
        raise NotImplementedError()
    
    @byte_order.setter
    def byte_order(self, value : aspose.imaging.fileformats.tiff.enums.TiffByteOrder) -> None:
        '''Sets a value indicating the tiff byte order.'''
        raise NotImplementedError()
    
    @property
    def disable_icc_export(self) -> bool:
        '''Gets a value indicating whether ICC profile export is disabled (ICC profile is applied to the source pixels beforehand).'''
        raise NotImplementedError()
    
    @disable_icc_export.setter
    def disable_icc_export(self, value : bool) -> None:
        '''Sets a value indicating whether ICC profile export is disabled (ICC profile is applied to the source pixels beforehand).'''
        raise NotImplementedError()
    
    @property
    def bits_per_sample(self) -> List[int]:
        '''Gets the bits per sample.'''
        raise NotImplementedError()
    
    @bits_per_sample.setter
    def bits_per_sample(self, value : List[int]) -> None:
        '''Sets the bits per sample.'''
        raise NotImplementedError()
    
    @property
    def extra_samples(self) -> List[int]:
        '''Gets the extra samples values.'''
        raise NotImplementedError()
    
    @property
    def compression(self) -> aspose.imaging.fileformats.tiff.enums.TiffCompressions:
        '''Gets the compression.'''
        raise NotImplementedError()
    
    @compression.setter
    def compression(self, value : aspose.imaging.fileformats.tiff.enums.TiffCompressions) -> None:
        '''Sets the compression.'''
        raise NotImplementedError()
    
    @property
    def compressed_quality(self) -> int:
        '''Gets compressed image quality.
        Used with the Jpeg compression.'''
        raise NotImplementedError()
    
    @compressed_quality.setter
    def compressed_quality(self, value : int) -> None:
        '''Sets compressed image quality.
        Used with the Jpeg compression.'''
        raise NotImplementedError()
    
    @property
    def copyright(self) -> str:
        '''Gets the copyright.'''
        raise NotImplementedError()
    
    @copyright.setter
    def copyright(self, value : str) -> None:
        '''Sets the copyright.'''
        raise NotImplementedError()
    
    @property
    def color_map(self) -> List[int]:
        '''Gets the color map.'''
        raise NotImplementedError()
    
    @color_map.setter
    def color_map(self, value : List[int]) -> None:
        '''Sets the color map.'''
        raise NotImplementedError()
    
    @property
    def date_time(self) -> str:
        '''Gets the date and time.'''
        raise NotImplementedError()
    
    @date_time.setter
    def date_time(self, value : str) -> None:
        '''Sets the date and time.'''
        raise NotImplementedError()
    
    @property
    def document_name(self) -> str:
        '''Gets the name of the document.'''
        raise NotImplementedError()
    
    @document_name.setter
    def document_name(self, value : str) -> None:
        '''Sets the name of the document.'''
        raise NotImplementedError()
    
    @property
    def alpha_storage(self) -> aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage:
        '''Gets the alpha storage option. Options other than :py:attr:`aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage.UNSPECIFIED`
        are used when there are more than 3 :py:attr:`aspose.imaging.imageoptions.TiffOptions.samples_per_pixel` defined.'''
        raise NotImplementedError()
    
    @alpha_storage.setter
    def alpha_storage(self, value : aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage) -> None:
        '''Sets the alpha storage option. Options other than :py:attr:`aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage.UNSPECIFIED`
        are used when there are more than 3 :py:attr:`aspose.imaging.imageoptions.TiffOptions.samples_per_pixel` defined.'''
        raise NotImplementedError()
    
    @property
    def is_extra_samples_present(self) -> bool:
        '''Gets a value indicating whether the extra samples is present.'''
        raise NotImplementedError()
    
    @property
    def fill_order(self) -> aspose.imaging.fileformats.tiff.enums.TiffFillOrders:
        '''Gets the byte bits fill order.'''
        raise NotImplementedError()
    
    @fill_order.setter
    def fill_order(self, value : aspose.imaging.fileformats.tiff.enums.TiffFillOrders) -> None:
        '''Sets the byte bits fill order.'''
        raise NotImplementedError()
    
    @property
    def half_tone_hints(self) -> List[int]:
        '''Gets the halftone hints.'''
        raise NotImplementedError()
    
    @half_tone_hints.setter
    def half_tone_hints(self, value : List[int]) -> None:
        '''Sets the halftone hints.'''
        raise NotImplementedError()
    
    @property
    def image_description(self) -> str:
        '''Gets the image description.'''
        raise NotImplementedError()
    
    @image_description.setter
    def image_description(self, value : str) -> None:
        '''Sets the image description.'''
        raise NotImplementedError()
    
    @property
    def ink_names(self) -> str:
        '''Gets the ink names.'''
        raise NotImplementedError()
    
    @ink_names.setter
    def ink_names(self, value : str) -> None:
        '''Sets the ink names.'''
        raise NotImplementedError()
    
    @property
    def scanner_manufacturer(self) -> str:
        '''Gets the scanner manufacturer.'''
        raise NotImplementedError()
    
    @scanner_manufacturer.setter
    def scanner_manufacturer(self, value : str) -> None:
        '''Sets the scanner manufacturer.'''
        raise NotImplementedError()
    
    @property
    def max_sample_value(self) -> List[int]:
        '''Gets the max sample value.'''
        raise NotImplementedError()
    
    @max_sample_value.setter
    def max_sample_value(self, value : List[int]) -> None:
        '''Sets the max sample value.'''
        raise NotImplementedError()
    
    @property
    def min_sample_value(self) -> List[int]:
        '''Gets the min sample value.'''
        raise NotImplementedError()
    
    @min_sample_value.setter
    def min_sample_value(self, value : List[int]) -> None:
        '''Sets the min sample value.'''
        raise NotImplementedError()
    
    @property
    def scanner_model(self) -> str:
        '''Gets the scanner model.'''
        raise NotImplementedError()
    
    @scanner_model.setter
    def scanner_model(self, value : str) -> None:
        '''Sets the scanner model.'''
        raise NotImplementedError()
    
    @property
    def orientation(self) -> aspose.imaging.fileformats.tiff.enums.TiffOrientations:
        '''Gets the orientation.'''
        raise NotImplementedError()
    
    @orientation.setter
    def orientation(self, value : aspose.imaging.fileformats.tiff.enums.TiffOrientations) -> None:
        '''Sets the orientation.'''
        raise NotImplementedError()
    
    @property
    def page_name(self) -> str:
        '''Gets the page name.'''
        raise NotImplementedError()
    
    @page_name.setter
    def page_name(self, value : str) -> None:
        '''Sets the page name.'''
        raise NotImplementedError()
    
    @property
    def page_number(self) -> List[int]:
        '''Gets the page number tag.'''
        raise NotImplementedError()
    
    @page_number.setter
    def page_number(self, value : List[int]) -> None:
        '''Sets the page number tag.'''
        raise NotImplementedError()
    
    @property
    def photometric(self) -> aspose.imaging.fileformats.tiff.enums.TiffPhotometrics:
        '''Gets the photometric.'''
        raise NotImplementedError()
    
    @photometric.setter
    def photometric(self, value : aspose.imaging.fileformats.tiff.enums.TiffPhotometrics) -> None:
        '''Sets the photometric.'''
        raise NotImplementedError()
    
    @property
    def planar_configuration(self) -> aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs:
        '''Gets the planar configuration.'''
        raise NotImplementedError()
    
    @planar_configuration.setter
    def planar_configuration(self, value : aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs) -> None:
        '''Sets the planar configuration.'''
        raise NotImplementedError()
    
    @property
    def resolution_unit(self) -> aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits:
        '''Gets the resolution unit.'''
        raise NotImplementedError()
    
    @resolution_unit.setter
    def resolution_unit(self, value : aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits) -> None:
        '''Sets the resolution unit.'''
        raise NotImplementedError()
    
    @property
    def rows_per_strip(self) -> int:
        '''Gets the rows per strip.'''
        raise NotImplementedError()
    
    @rows_per_strip.setter
    def rows_per_strip(self, value : int) -> None:
        '''Sets the rows per strip.'''
        raise NotImplementedError()
    
    @property
    def tile_width(self) -> int:
        '''Gets ot sets tile width.'''
        raise NotImplementedError()
    
    @tile_width.setter
    def tile_width(self, value : int) -> None:
        '''Gets ot sets tile width.'''
        raise NotImplementedError()
    
    @property
    def tile_length(self) -> int:
        '''Gets ot sets tile length.'''
        raise NotImplementedError()
    
    @tile_length.setter
    def tile_length(self, value : int) -> None:
        '''Gets ot sets tile length.'''
        raise NotImplementedError()
    
    @property
    def sample_format(self) -> List[aspose.imaging.fileformats.tiff.enums.TiffSampleFormats]:
        '''Gets the sample format.'''
        raise NotImplementedError()
    
    @sample_format.setter
    def sample_format(self, value : List[aspose.imaging.fileformats.tiff.enums.TiffSampleFormats]) -> None:
        '''Sets the sample format.'''
        raise NotImplementedError()
    
    @property
    def samples_per_pixel(self) -> int:
        '''Gets the samples per pixel. To change this property value use the :py:attr:`aspose.imaging.imageoptions.TiffOptions.bits_per_sample` property setter.'''
        raise NotImplementedError()
    
    @property
    def smax_sample_value(self) -> List[int]:
        '''Gets the max sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @smax_sample_value.setter
    def smax_sample_value(self, value : List[int]) -> None:
        '''Sets the max sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @property
    def smin_sample_value(self) -> List[int]:
        '''Gets the min sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @smin_sample_value.setter
    def smin_sample_value(self, value : List[int]) -> None:
        '''Sets the min sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @property
    def software_type(self) -> str:
        '''Gets the software type.'''
        raise NotImplementedError()
    
    @software_type.setter
    def software_type(self, value : str) -> None:
        '''Sets the software type.'''
        raise NotImplementedError()
    
    @property
    def strip_byte_counts(self) -> List[int]:
        '''Gets the strip byte counts.'''
        raise NotImplementedError()
    
    @strip_byte_counts.setter
    def strip_byte_counts(self, value : List[int]) -> None:
        '''Sets the strip byte counts.'''
        raise NotImplementedError()
    
    @property
    def strip_offsets(self) -> List[int]:
        '''Gets the strip offsets.'''
        raise NotImplementedError()
    
    @strip_offsets.setter
    def strip_offsets(self, value : List[int]) -> None:
        '''Sets the strip offsets.'''
        raise NotImplementedError()
    
    @property
    def tile_byte_counts(self) -> List[int]:
        '''Gets the tile byte counts.'''
        raise NotImplementedError()
    
    @tile_byte_counts.setter
    def tile_byte_counts(self, value : List[int]) -> None:
        '''Sets the tile byte counts.'''
        raise NotImplementedError()
    
    @property
    def tile_offsets(self) -> List[int]:
        '''Gets the tile offsets.'''
        raise NotImplementedError()
    
    @tile_offsets.setter
    def tile_offsets(self, value : List[int]) -> None:
        '''Sets the tile offsets.'''
        raise NotImplementedError()
    
    @property
    def sub_file_type(self) -> aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes:
        '''Gets a general indication of the kind of data contained in this subfile.'''
        raise NotImplementedError()
    
    @sub_file_type.setter
    def sub_file_type(self, value : aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes) -> None:
        '''Sets a general indication of the kind of data contained in this subfile.'''
        raise NotImplementedError()
    
    @property
    def target_printer(self) -> str:
        '''Gets the target printer.'''
        raise NotImplementedError()
    
    @target_printer.setter
    def target_printer(self, value : str) -> None:
        '''Sets the target printer.'''
        raise NotImplementedError()
    
    @property
    def threshholding(self) -> aspose.imaging.fileformats.tiff.enums.TiffThresholds:
        '''Gets the threshholding.'''
        raise NotImplementedError()
    
    @threshholding.setter
    def threshholding(self, value : aspose.imaging.fileformats.tiff.enums.TiffThresholds) -> None:
        '''Sets the threshholding.'''
        raise NotImplementedError()
    
    @property
    def total_pages(self) -> int:
        '''Gets the total pages.'''
        raise NotImplementedError()
    
    @property
    def xposition(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the x position.'''
        raise NotImplementedError()
    
    @xposition.setter
    def xposition(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the x position.'''
        raise NotImplementedError()
    
    @property
    def xresolution(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the x resolution.'''
        raise NotImplementedError()
    
    @xresolution.setter
    def xresolution(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the x resolution.'''
        raise NotImplementedError()
    
    @property
    def yposition(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the y position.'''
        raise NotImplementedError()
    
    @yposition.setter
    def yposition(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the y position.'''
        raise NotImplementedError()
    
    @property
    def yresolution(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the y resolution.'''
        raise NotImplementedError()
    
    @yresolution.setter
    def yresolution(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the y resolution.'''
        raise NotImplementedError()
    
    @property
    def fax_t4_options(self) -> aspose.imaging.fileformats.tiff.enums.Group3Options:
        '''Gets the fax t4 options.'''
        raise NotImplementedError()
    
    @fax_t4_options.setter
    def fax_t4_options(self, value : aspose.imaging.fileformats.tiff.enums.Group3Options) -> None:
        '''Sets the fax t4 options.'''
        raise NotImplementedError()
    
    @property
    def predictor(self) -> aspose.imaging.fileformats.tiff.enums.TiffPredictor:
        '''Gets the predictor for LZW compression.'''
        raise NotImplementedError()
    
    @predictor.setter
    def predictor(self, value : aspose.imaging.fileformats.tiff.enums.TiffPredictor) -> None:
        '''Sets the predictor for LZW compression.'''
        raise NotImplementedError()
    
    @property
    def image_length(self) -> int:
        '''Gets the image length.'''
        raise NotImplementedError()
    
    @image_length.setter
    def image_length(self, value : int) -> None:
        '''Sets the image length.'''
        raise NotImplementedError()
    
    @property
    def image_width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @image_width.setter
    def image_width(self, value : int) -> None:
        '''Sets the image width.'''
        raise NotImplementedError()
    
    @property
    def exif_ifd(self) -> aspose.imaging.fileformats.tiff.TiffExifIfd:
        '''Gets the pointer to EXIF IFD.'''
        raise NotImplementedError()
    
    @property
    def tags(self) -> List[aspose.imaging.fileformats.tiff.TiffDataType]:
        '''Gets the tags.'''
        raise NotImplementedError()
    
    @tags.setter
    def tags(self, value : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Sets the tags.'''
        raise NotImplementedError()
    
    @property
    def valid_tag_count(self) -> int:
        '''Gets the valid tag count. This is not the total tags count but the number of tags which may be preserved.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the bits per pixel.'''
        raise NotImplementedError()
    
    @property
    def xp_title(self) -> str:
        '''Gets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_title.setter
    def xp_title(self, value : str) -> None:
        '''Sets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_comment(self) -> str:
        '''Gets comment on image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_comment.setter
    def xp_comment(self, value : str) -> None:
        '''Sets comment on image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_author(self) -> str:
        '''Gets image author, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_author.setter
    def xp_author(self, value : str) -> None:
        '''Sets image author, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_keywords(self) -> str:
        '''Gets subject image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_keywords.setter
    def xp_keywords(self, value : str) -> None:
        '''Sets subject image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_subject(self) -> str:
        '''Gets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_subject.setter
    def xp_subject(self, value : str) -> None:
        '''Sets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    

class BmpOptions(aspose.imaging.ImageOptionsBase):
    '''The API for BMP and DIB raster image format creation options provides developers
    with a versatile toolset for generating custom Bitmap (BMP) and Device
    Independent Bitmap (DIB) images. With this API, you can precisely define
    image characteristics such as bits per pixel, compression level and compression
    type, tailoring the output to meet specific requirements. This feature-rich
    API empowers developers to create high-quality, customized raster images
    with ease and flexibility for diverse applications.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BmpOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, bmp_options : aspose.imaging.imageoptions.BmpOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.BmpOptions` class.
        
        :param bmp_options: The BMP options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @bits_per_pixel.setter
    def bits_per_pixel(self, value : int) -> None:
        '''Sets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def compression(self) -> aspose.imaging.fileformats.bmp.BitmapCompression:
        '''Gets the compression type. The default compression type is :py:attr:`aspose.imaging.fileformats.bmp.BitmapCompression.BITFIELDS`, that allows saving a :py:class:`aspose.imaging.fileformats.bmp.BmpImage` with transparency.'''
        raise NotImplementedError()
    
    @compression.setter
    def compression(self, value : aspose.imaging.fileformats.bmp.BitmapCompression) -> None:
        '''Sets the compression type. The default compression type is :py:attr:`aspose.imaging.fileformats.bmp.BitmapCompression.BITFIELDS`, that allows saving a :py:class:`aspose.imaging.fileformats.bmp.BmpImage` with transparency.'''
        raise NotImplementedError()
    

class CdrRasterizationOptions(VectorRasterizationOptions):
    '''With the ability to perform CDR image rasterization and set scale factors
    for both X and Y dimensions, this API provides precise control over the
    transformation process. Whether scaling for specific output requirements
    or converting vector graphics to raster formats, you can leverage this
    API for efficient and customizable CDR vector to raster image conversion.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.CdrRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def scale_x(self) -> float:
        '''Gets the scale x.'''
        raise NotImplementedError()
    
    @scale_x.setter
    def scale_x(self, value : float) -> None:
        '''Sets the scale x.'''
        raise NotImplementedError()
    
    @property
    def scale_y(self) -> float:
        '''Gets the scale y.'''
        raise NotImplementedError()
    
    @scale_y.setter
    def scale_y(self, value : float) -> None:
        '''Sets the scale y.'''
        raise NotImplementedError()
    

class CmxRasterizationOptions(VectorRasterizationOptions):
    '''the CMX exporter options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.CmxRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    

class DicomOptions(aspose.imaging.ImageOptionsBase):
    '''The API for Digital Imaging and Communications in Medicine (DICOM) raster image
    format creation is a specialized tool tailored for medical device applications.
    It enables the seamless generation of DICOM images, crucial for storing medical
    data and containing vital identification information. With features to
    and set compression, define color types, and embed XMP metadata, developers
    can ensure compliance and flexibility in managing DICOM images for medical
    imaging purposes.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DicomOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def compression(self) -> aspose.imaging.fileformats.dicom.Compression:
        '''Gets the compression.'''
        raise NotImplementedError()
    
    @compression.setter
    def compression(self, value : aspose.imaging.fileformats.dicom.Compression) -> None:
        '''Sets the compression.'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.imaging.fileformats.dicom.ColorType:
        '''Gets the type of the color.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.imaging.fileformats.dicom.ColorType) -> None:
        '''Sets the type of the color.'''
        raise NotImplementedError()
    

class DjvuMultiPageOptions(MultiPageOptions):
    '''The API for DjVu graphics file format provides developers with seamless access
    to DjVu documents, ideal for scanned documents and books. With image loading
    options, developers can effortlessly integrate DjVu files into their applications,
    unlocking the potential to work with multi-page content, including text,
    drawings, and images, for versatile document processing solutions.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, pages : List[int]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param pages: The pages indexes.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, pages : List[int], export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param pages: The pages indexes.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, range : aspose.imaging.IntRange) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param range: The range.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, range : aspose.imaging.IntRange, export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param range: The range.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, ranges : List[aspose.imaging.IntRange]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param ranges: The range.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, ranges : List[aspose.imaging.IntRange], export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param ranges: The range.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param page: The page index.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page : int, export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param page: The page index.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_numbers(pages : List[int]) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param pages: The pages indexes.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_numbers_rect(pages : List[int], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param pages: The pages indexes.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_titles(page_titles : List[str]) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_titles_rect(page_titles : List[str], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_ranges(ranges : List[aspose.imaging.IntRange]) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param ranges: The range.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_ranges_rect(ranges : List[aspose.imaging.IntRange], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param ranges: The range.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_range(range : aspose.imaging.IntRange) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param range: The range.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_range_rect(range : aspose.imaging.IntRange, export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param range: The range.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_number(page : int) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param page: The page index.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_number_rect(page : int, export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.DjvuMultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.DjvuMultiPageOptions` class.
        
        :param page: The page index.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    def init_pages(self, ranges : List[aspose.imaging.IntRange]) -> None:
        '''Initializes the pages from ranges array
        
        :param ranges: The ranges.'''
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[int]:
        '''Gets the pages.'''
        raise NotImplementedError()
    
    @pages.setter
    def pages(self, value : List[int]) -> None:
        '''Sets the pages.'''
        raise NotImplementedError()
    
    @property
    def page_titles(self) -> List[str]:
        '''Gets the page titles.'''
        raise NotImplementedError()
    
    @page_titles.setter
    def page_titles(self, value : List[str]) -> None:
        '''Sets the page titles.'''
        raise NotImplementedError()
    
    @property
    def time_interval(self) -> aspose.imaging.imageoptions.TimeInterval:
        '''Gets the time interval.'''
        raise NotImplementedError()
    
    @time_interval.setter
    def time_interval(self, value : aspose.imaging.imageoptions.TimeInterval) -> None:
        '''Sets the time interval.'''
        raise NotImplementedError()
    
    @property
    def page_rasterization_options(self) -> List[aspose.imaging.imageoptions.VectorRasterizationOptions]:
        '''Gets the page rasterization options.'''
        raise NotImplementedError()
    
    @page_rasterization_options.setter
    def page_rasterization_options(self, value : List[aspose.imaging.imageoptions.VectorRasterizationOptions]) -> None:
        '''Sets the page rasterization options.'''
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.imaging.Rectangle:
        '''Gets the export area.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets the export area.'''
        raise NotImplementedError()
    
    @property
    def mode(self) -> aspose.imaging.imageoptions.MultiPageMode:
        '''Gets the mode.'''
        raise NotImplementedError()
    
    @mode.setter
    def mode(self, value : aspose.imaging.imageoptions.MultiPageMode) -> None:
        '''Sets the mode.'''
        raise NotImplementedError()
    
    @property
    def output_layers_names(self) -> List[str]:
        '''Gets the output layers names(Works if export format supports layers naming, for example for Psd)'''
        raise NotImplementedError()
    
    @output_layers_names.setter
    def output_layers_names(self, value : List[str]) -> None:
        '''Sets the output layers names(Works if export format supports layers naming, for example for Psd)'''
        raise NotImplementedError()
    
    @property
    def merge_layers(self) -> bool:
        '''Gets a value indicating whether [merege layers].'''
        raise NotImplementedError()
    
    @merge_layers.setter
    def merge_layers(self, value : bool) -> None:
        '''Sets a value indicating whether [merege layers].'''
        raise NotImplementedError()
    

class DxfOptions(aspose.imaging.ImageOptionsBase):
    '''API for Drawing Interchange Format (DXF) vector image creation offers
    tailored solutions for generating AutoCAD drawing files with precision and
    flexibility. Designed specifically for working with text lines and Bezier
    curves, developers can efficiently manipulate these elements, count Bezier
    points, and convert curves into polylines for seamless exporting, ensuring
    compatibility and fidelity in DXF vector images.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ImageOptionsBase` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def bezier_point_count(self) -> int:
        '''How many points to generate when converting Bezier curves to polylines, minimum 4. Used when :py:attr:`aspose.imaging.imageoptions.DxfOptions.text_as_lines` and :py:attr:`aspose.imaging.imageoptions.DxfOptions.convert_text_beziers` are both  	/// set to ``true``'''
        raise NotImplementedError()
    
    @bezier_point_count.setter
    def bezier_point_count(self, value : int) -> None:
        '''How many points to generate when converting Bezier curves to polylines, minimum 4. Used when :py:attr:`aspose.imaging.imageoptions.DxfOptions.text_as_lines` and :py:attr:`aspose.imaging.imageoptions.DxfOptions.convert_text_beziers` are both  	/// set to ``true``'''
        raise NotImplementedError()
    
    @property
    def convert_text_beziers(self) -> bool:
        '''Works when :py:attr:`aspose.imaging.imageoptions.DxfOptions.text_as_lines` is set to ``true``. Wether to convert Bezier curves in text contours to multipoint polylines.'''
        raise NotImplementedError()
    
    @convert_text_beziers.setter
    def convert_text_beziers(self, value : bool) -> None:
        '''Works when :py:attr:`aspose.imaging.imageoptions.DxfOptions.text_as_lines` is set to ``true``. Wether to convert Bezier curves in text contours to multipoint polylines.'''
        raise NotImplementedError()
    
    @property
    def text_as_lines(self) -> bool:
        '''Whether text should be exported as contours consisting of polylines (default) or as editable Autocad TEXT entities.
        If this option set'''
        raise NotImplementedError()
    
    @text_as_lines.setter
    def text_as_lines(self, value : bool) -> None:
        '''Whether text should be exported as contours consisting of polylines (default) or as editable Autocad TEXT entities.
        If this option set'''
        raise NotImplementedError()
    

class EmfOptions(MetafileOptions):
    '''The Emf options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MetafileOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def compress(self) -> bool:
        '''Gets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    
    @compress.setter
    def compress(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    

class EmfRasterizationOptions(MetafileRasterizationOptions):
    '''The Emf rasterization options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MetafileRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies this to ``vectorRasterizationOptions``.
        
        :param vector_rasterization_options: vectorRasterizationOptions'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def render_mode(self) -> aspose.imaging.fileformats.emf.EmfRenderMode:
        '''Gets the render mode.'''
        raise NotImplementedError()
    
    @render_mode.setter
    def render_mode(self, value : aspose.imaging.fileformats.emf.EmfRenderMode) -> None:
        '''Sets the render mode.'''
        raise NotImplementedError()
    

class EpsRasterizationOptions(VectorRasterizationOptions):
    '''The Eps rasterization options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.EpsRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def preview_to_export(self) -> aspose.imaging.fileformats.eps.EpsPreviewFormat:
        '''Use :py:func:`aspose.imaging.fileformats.eps.EpsImage.get_preview_image` for preview export.'''
        raise NotImplementedError()
    
    @preview_to_export.setter
    def preview_to_export(self, value : aspose.imaging.fileformats.eps.EpsPreviewFormat) -> None:
        '''Use :py:func:`aspose.imaging.fileformats.eps.EpsImage.get_preview_image` for preview export.'''
        raise NotImplementedError()
    

class GifOptions(aspose.imaging.ImageOptionsBase):
    '''The API for Graphical Interchange Format (GIF) raster image file creation offers
    developers comprehensive options for generating GIF images with precise
    control. With features to set background color, color palette, resolution,
    interlaced type, transparent color, XMP metadata container, and image
    compression, this API ensures flexibility and efficiency in creating optimized
    and visually appealing GIFs tailored to specific application requirements.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.GifOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, gif_options : aspose.imaging.imageoptions.GifOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.GifOptions` class.
        
        :param gif_options: The GIF Options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def do_palette_correction(self) -> bool:
        '''Gets a value indicating whether palette correction is applied.'''
        raise NotImplementedError()
    
    @do_palette_correction.setter
    def do_palette_correction(self, value : bool) -> None:
        '''Sets a value indicating whether palette correction is applied.'''
        raise NotImplementedError()
    
    @property
    def loops_count(self) -> int:
        '''Gets the loops count (Default 1 loop)'''
        raise NotImplementedError()
    
    @loops_count.setter
    def loops_count(self, value : int) -> None:
        '''Sets the loops count (Default 1 loop)'''
        raise NotImplementedError()
    
    @property
    def color_resolution(self) -> int:
        '''Gets the GIF color resolution.'''
        raise NotImplementedError()
    
    @color_resolution.setter
    def color_resolution(self, value : int) -> None:
        '''Sets the GIF color resolution.'''
        raise NotImplementedError()
    
    @property
    def is_palette_sorted(self) -> bool:
        '''Gets a value indicating whether palette entries are sorted.'''
        raise NotImplementedError()
    
    @is_palette_sorted.setter
    def is_palette_sorted(self, value : bool) -> None:
        '''Sets a value indicating whether palette entries are sorted.'''
        raise NotImplementedError()
    
    @property
    def pixel_aspect_ratio(self) -> int:
        '''Gets the GIF pixel aspect ratio.'''
        raise NotImplementedError()
    
    @pixel_aspect_ratio.setter
    def pixel_aspect_ratio(self, value : int) -> None:
        '''Sets the GIF pixel aspect ratio.'''
        raise NotImplementedError()
    
    @property
    def background_color_index(self) -> int:
        '''Gets the GIF background color index.'''
        raise NotImplementedError()
    
    @background_color_index.setter
    def background_color_index(self, value : int) -> None:
        '''Sets the GIF background color index.'''
        raise NotImplementedError()
    
    @property
    def has_trailer(self) -> bool:
        '''Gets a value indicating whether GIF has trailer.'''
        raise NotImplementedError()
    
    @has_trailer.setter
    def has_trailer(self, value : bool) -> None:
        '''Sets a value indicating whether GIF has trailer.'''
        raise NotImplementedError()
    
    @property
    def interlaced(self) -> bool:
        '''True if image should be interlaced.'''
        raise NotImplementedError()
    
    @interlaced.setter
    def interlaced(self, value : bool) -> None:
        '''True if image should be interlaced.'''
        raise NotImplementedError()
    
    @property
    def max_diff(self) -> int:
        '''Gets the maximum allowed pixel difference. If greater than zero, lossy compression will be used.
        Recommended value for optimal lossy compression is 80. 30 is very light compression, 200 is heavy.
        It works best when only little loss is introduced, and due to limitation of the compression algorithm very high loss levels won\'t give as much gain.
        The range of allowed values is [0, 1000].'''
        raise NotImplementedError()
    
    @max_diff.setter
    def max_diff(self, value : int) -> None:
        '''Sets the maximum allowed pixel difference. If greater than zero, lossy compression will be used.
        Recommended value for optimal lossy compression is 80. 30 is very light compression, 200 is heavy.
        It works best when only little loss is introduced, and due to limitation of the compression algorithm very high loss levels won\'t give as much gain.
        The range of allowed values is [0, 1000].'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets the background color.'''
        raise NotImplementedError()
    
    @property
    def has_transparent_color(self) -> Optional[bool]:
        '''Gets a value indicating whether a GIF image has transparent color.
        If the return value is , this property is overridden by the source image context.'''
        raise NotImplementedError()
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : Optional[bool]) -> None:
        '''Sets a value indicating whether a GIF image has transparent color.
        If the return value is , this property is overridden by the source image context.'''
        raise NotImplementedError()
    

class Html5CanvasOptions(aspose.imaging.ImageOptionsBase):
    '''Create HTML5 Canvas files effortlessly with our API, allowing you to seamlessly
    combine elements like forms, text, images, animations, and links. Benefit from
    robust features including tag identifier and encoding settings support,
    ensuring optimal performance and customization for your web projects.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.Html5CanvasOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def canvas_tag_id(self) -> str:
        '''Gets the canvas tag identifier.'''
        raise NotImplementedError()
    
    @canvas_tag_id.setter
    def canvas_tag_id(self, value : str) -> None:
        '''Sets the canvas tag identifier.'''
        raise NotImplementedError()
    
    @property
    def full_html_page(self) -> bool:
        '''Gets a value indicating whether the full HTML page should be generated.'''
        raise NotImplementedError()
    
    @full_html_page.setter
    def full_html_page(self, value : bool) -> None:
        '''Sets a value indicating whether the full HTML page should be generated.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets the encoding.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Sets the encoding.'''
        raise NotImplementedError()
    

class IcoOptions(aspose.imaging.ImageOptionsBase):
    '''Create custom ICO image files for application icons effortlessly with our API,
    empowering you to represent your software seamlessly. Our API supports PNG and
    BMP image frames with various bits per pixel values, ensuring versatility and
    compatibility for your icon creation needs.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.IcoOptions` class with the ICO frame format equals to Png and
        bitsPerPixel equals to 32.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, format : aspose.imaging.FileFormat, bits_per_pixel : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.IcoOptions` class.
        
        :param format: The ICO frame format.
        Note that ICO image supports only :py:attr:`aspose.imaging.FileFormat.PNG` and :py:attr:`aspose.imaging.FileFormat.BMP` images as entries.
        :param bits_per_pixel: The bits-per-pixel value.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def format(self) -> aspose.imaging.FileFormat:
        '''Gets the ICO frame format.'''
        raise NotImplementedError()
    
    @format.setter
    def format(self, value : aspose.imaging.FileFormat) -> None:
        '''Sets the ICO frame format.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the bits-per-pixel value.'''
        raise NotImplementedError()
    
    @bits_per_pixel.setter
    def bits_per_pixel(self, value : int) -> None:
        '''Sets the bits-per-pixel value.'''
        raise NotImplementedError()
    

class Jpeg2000Options(aspose.imaging.ImageOptionsBase):
    '''Create JPEG2000 (JP2) image files with our API, utilizing advanced wavelet technology
    for coding lossless content. Benefit from support for various codecs, including
    irreversible and lossless compression, as well as XMP metadata containers, ensuring
    versatility and high-quality image creation tailored to your needs.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.Jpeg2000Options` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, jpeg_2000_options : aspose.imaging.imageoptions.Jpeg2000Options) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.Jpeg2000Options` class.
        
        :param jpeg_2000_options: The Jpeg2000 file format options to copy settings from.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def comments(self) -> List[str]:
        '''Gets the Jpeg comment markers.'''
        raise NotImplementedError()
    
    @comments.setter
    def comments(self, value : List[str]) -> None:
        '''Sets the Jpeg comment markers.'''
        raise NotImplementedError()
    
    @property
    def codec(self) -> aspose.imaging.fileformats.jpeg2000.Jpeg2000Codec:
        '''Gets the JPEG2000 codec'''
        raise NotImplementedError()
    
    @codec.setter
    def codec(self, value : aspose.imaging.fileformats.jpeg2000.Jpeg2000Codec) -> None:
        '''Sets the JPEG2000 codec'''
        raise NotImplementedError()
    
    @property
    def compression_ratios(self) -> List[int]:
        '''Gets the Array of compression ratio.
        Different compression ratios for successive layers.
        The rate specified for each quality level is the desired
        compression factor.
        Decreasing ratios required.'''
        raise NotImplementedError()
    
    @compression_ratios.setter
    def compression_ratios(self, value : List[int]) -> None:
        '''Sets the Array of compression ratio.
        Different compression ratios for successive layers.
        The rate specified for each quality level is the desired
        compression factor.
        Decreasing ratios required.'''
        raise NotImplementedError()
    
    @property
    def irreversible(self) -> bool:
        '''Gets a value indicating whether use the irreversible DWT 9-7 (true) or use lossless DWT 5-3 compression (default).'''
        raise NotImplementedError()
    
    @irreversible.setter
    def irreversible(self, value : bool) -> None:
        '''Sets a value indicating whether use the irreversible DWT 9-7 (true) or use lossless DWT 5-3 compression (default).'''
        raise NotImplementedError()
    

class JpegOptions(aspose.imaging.ImageOptionsBase):
    '''Create high-quality JPEG images effortlessly with our API, offering adjustable
    levels of compression to optimize storage size without compromising image quality.
    Benefit from support for various compression types, near lossless coding,
    RGB and CMYK color profiles, as well as EXIF, JFIF image data, and XMP
    containers, ensuring versatile and customizable options for your image creation needs.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.JpegOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, jpeg_options : aspose.imaging.imageoptions.JpegOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.JpegOptions` class.
        
        :param jpeg_options: The JPEG options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.JpegExifData:
        '''Get or set Exif data container.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.JpegExifData) -> None:
        '''Get or set Exif data container.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def default_memory_allocation_limit(self) -> int:
        '''Gets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @default_memory_allocation_limit.setter
    def default_memory_allocation_limit(self, value : int) -> None:
        '''Sets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @property
    def jfif(self) -> aspose.imaging.fileformats.jpeg.JFIFData:
        '''Gets the jfif.'''
        raise NotImplementedError()
    
    @jfif.setter
    def jfif(self, value : aspose.imaging.fileformats.jpeg.JFIFData) -> None:
        '''Sets the jfif.'''
        raise NotImplementedError()
    
    @property
    def comment(self) -> str:
        '''Gets the jpeg file comment.'''
        raise NotImplementedError()
    
    @comment.setter
    def comment(self, value : str) -> None:
        '''Sets the jpeg file comment.'''
        raise NotImplementedError()
    
    @property
    def compression_type(self) -> aspose.imaging.fileformats.jpeg.JpegCompressionMode:
        '''Gets the compression type.'''
        raise NotImplementedError()
    
    @compression_type.setter
    def compression_type(self, value : aspose.imaging.fileformats.jpeg.JpegCompressionMode) -> None:
        '''Sets the compression type.'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.imaging.fileformats.jpeg.JpegCompressionColorMode:
        '''Gets the color type for jpeg image.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.imaging.fileformats.jpeg.JpegCompressionColorMode) -> None:
        '''Sets the color type for jpeg image.'''
        raise NotImplementedError()
    
    @property
    def bits_per_channel(self) -> int:
        '''Gets bits per channel for lossless jpeg image. Now we support from 2 to 8 bits per channel.'''
        raise NotImplementedError()
    
    @bits_per_channel.setter
    def bits_per_channel(self, value : int) -> None:
        '''Sets bits per channel for lossless jpeg image. Now we support from 2 to 8 bits per channel.'''
        raise NotImplementedError()
    
    @property
    def quality(self) -> int:
        '''Gets image quality.'''
        raise NotImplementedError()
    
    @quality.setter
    def quality(self, value : int) -> None:
        '''Sets image quality.'''
        raise NotImplementedError()
    
    @property
    def scaled_quality(self) -> int:
        '''The scaled quality.'''
        raise NotImplementedError()
    
    @property
    def rd_opt_settings(self) -> aspose.imaging.imageoptions.RdOptimizerSettings:
        '''Gets the RD optimizer settings.'''
        raise NotImplementedError()
    
    @rd_opt_settings.setter
    def rd_opt_settings(self, value : aspose.imaging.imageoptions.RdOptimizerSettings) -> None:
        '''Sets the RD optimizer settings.'''
        raise NotImplementedError()
    
    @property
    def rgb_color_profile(self) -> aspose.imaging.sources.StreamSource:
        '''The destination RGB color profile for CMYK jpeg images. Use for saving images. Must be in pair with CMYKColorProfile for correct color conversion.'''
        raise NotImplementedError()
    
    @rgb_color_profile.setter
    def rgb_color_profile(self, value : aspose.imaging.sources.StreamSource) -> None:
        '''The destination RGB color profile for CMYK jpeg images. Use for saving images. Must be in pair with CMYKColorProfile for correct color conversion.'''
        raise NotImplementedError()
    
    @property
    def cmyk_color_profile(self) -> aspose.imaging.sources.StreamSource:
        '''The destination CMYK color profile for CMYK jpeg images. Use for saving images. Must be in pair with RGBColorProfile for correct color conversion.'''
        raise NotImplementedError()
    
    @cmyk_color_profile.setter
    def cmyk_color_profile(self, value : aspose.imaging.sources.StreamSource) -> None:
        '''The destination CMYK color profile for CMYK jpeg images. Use for saving images. Must be in pair with RGBColorProfile for correct color conversion.'''
        raise NotImplementedError()
    
    @property
    def jpeg_ls_allowed_lossy_error(self) -> int:
        '''Gets the JPEG-LS difference bound for near-lossless coding (NEAR parameter from the JPEG-LS specification).'''
        raise NotImplementedError()
    
    @jpeg_ls_allowed_lossy_error.setter
    def jpeg_ls_allowed_lossy_error(self, value : int) -> None:
        '''Sets the JPEG-LS difference bound for near-lossless coding (NEAR parameter from the JPEG-LS specification).'''
        raise NotImplementedError()
    
    @property
    def jpeg_ls_interleave_mode(self) -> aspose.imaging.fileformats.jpeg.JpegLsInterleaveMode:
        '''Gets the JPEG-LS interleave mode.'''
        raise NotImplementedError()
    
    @jpeg_ls_interleave_mode.setter
    def jpeg_ls_interleave_mode(self, value : aspose.imaging.fileformats.jpeg.JpegLsInterleaveMode) -> None:
        '''Sets the JPEG-LS interleave mode.'''
        raise NotImplementedError()
    
    @property
    def jpeg_ls_preset(self) -> aspose.imaging.fileformats.jpeg.JpegLsPresetCodingParameters:
        '''Gets the JPEG-LS preset parameters.'''
        raise NotImplementedError()
    
    @jpeg_ls_preset.setter
    def jpeg_ls_preset(self, value : aspose.imaging.fileformats.jpeg.JpegLsPresetCodingParameters) -> None:
        '''Sets the JPEG-LS preset parameters.'''
        raise NotImplementedError()
    
    @property
    def horizontal_sampling(self) -> List[int]:
        '''Gets the horizontal subsamplings for each component.'''
        raise NotImplementedError()
    
    @horizontal_sampling.setter
    def horizontal_sampling(self, value : List[int]) -> None:
        '''Sets the horizontal subsamplings for each component.'''
        raise NotImplementedError()
    
    @property
    def vertical_sampling(self) -> List[int]:
        '''Gets the vertical subsamplings for each component.'''
        raise NotImplementedError()
    
    @vertical_sampling.setter
    def vertical_sampling(self, value : List[int]) -> None:
        '''Sets the vertical subsamplings for each component.'''
        raise NotImplementedError()
    
    @property
    def sample_rounding_mode(self) -> aspose.imaging.fileformats.jpeg.SampleRoundingMode:
        '''Gets the sample rounding mode to fit an 8-bit value to an n-bit value. :py:attr:`aspose.imaging.imageoptions.JpegOptions.BitsPerChannel`'''
        raise NotImplementedError()
    
    @sample_rounding_mode.setter
    def sample_rounding_mode(self, value : aspose.imaging.fileformats.jpeg.SampleRoundingMode) -> None:
        '''Sets the sample rounding mode to fit an 8-bit value to an n-bit value. :py:attr:`aspose.imaging.imageoptions.JpegOptions.BitsPerChannel`'''
        raise NotImplementedError()
    
    @property
    def preblend_alpha_if_present(self) -> bool:
        '''Gets a value indicating whether red, green and blue components should be mixed with a background color, if alpha channel is present.'''
        raise NotImplementedError()
    
    @preblend_alpha_if_present.setter
    def preblend_alpha_if_present(self, value : bool) -> None:
        '''Sets a value indicating whether red, green and blue components should be mixed with a background color, if alpha channel is present.'''
        raise NotImplementedError()
    
    @property
    def resolution_unit(self) -> aspose.imaging.ResolutionUnit:
        '''Gets the resolution unit.'''
        raise NotImplementedError()
    
    @resolution_unit.setter
    def resolution_unit(self, value : aspose.imaging.ResolutionUnit) -> None:
        '''Sets the resolution unit.'''
        raise NotImplementedError()
    

class MetafileOptions(aspose.imaging.ImageOptionsBase):
    '''The Metafiles base options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MetafileOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def compress(self) -> bool:
        '''Gets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    
    @compress.setter
    def compress(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    

class MetafileRasterizationOptions(VectorRasterizationOptions):
    '''The metafile rasterization options'''
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    

class MultiPageOptions:
    '''Base class for multiple pages supported formats'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, pages : List[int]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param pages: The pages.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, pages : List[int], export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param pages: The array of pages.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page_titles : List[str]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page_titles : List[str], export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, ranges : List[aspose.imaging.IntRange]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param ranges: The :py:class:`aspose.imaging.IntRange`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, ranges : List[aspose.imaging.IntRange], export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param ranges: The :py:class:`aspose.imaging.IntRange`.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, range : aspose.imaging.IntRange) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param range: The :py:class:`aspose.imaging.IntRange`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, range : aspose.imaging.IntRange, export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param range: The :py:class:`aspose.imaging.IntRange`.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page: The page index.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, page : int, export_area : aspose.imaging.Rectangle) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page: The page index.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_numbers(pages : List[int]) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param pages: The pages.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_numbers_rect(pages : List[int], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param pages: The array of pages.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_titles(page_titles : List[str]) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_titles_rect(page_titles : List[str], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page_titles: The page titles.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_ranges(ranges : List[aspose.imaging.IntRange]) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param ranges: The :py:class:`aspose.imaging.IntRange`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_ranges_rect(ranges : List[aspose.imaging.IntRange], export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param ranges: The :py:class:`aspose.imaging.IntRange`.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_range(range : aspose.imaging.IntRange) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param range: The :py:class:`aspose.imaging.IntRange`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_int_range_rect(range : aspose.imaging.IntRange, export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param range: The :py:class:`aspose.imaging.IntRange`.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_number(page : int) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page: The page index.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_page_number_rect(page : int, export_area : aspose.imaging.Rectangle) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MultiPageOptions` class.
        
        :param page: The page index.
        :param export_area: The export area.'''
        raise NotImplementedError()
    
    def init_pages(self, ranges : List[aspose.imaging.IntRange]) -> None:
        '''Initializes the pages from ranges array
        
        :param ranges: The ranges.'''
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[int]:
        '''Gets the pages.'''
        raise NotImplementedError()
    
    @pages.setter
    def pages(self, value : List[int]) -> None:
        '''Sets the pages.'''
        raise NotImplementedError()
    
    @property
    def page_titles(self) -> List[str]:
        '''Gets the page titles.'''
        raise NotImplementedError()
    
    @page_titles.setter
    def page_titles(self, value : List[str]) -> None:
        '''Sets the page titles.'''
        raise NotImplementedError()
    
    @property
    def time_interval(self) -> aspose.imaging.imageoptions.TimeInterval:
        '''Gets the time interval.'''
        raise NotImplementedError()
    
    @time_interval.setter
    def time_interval(self, value : aspose.imaging.imageoptions.TimeInterval) -> None:
        '''Sets the time interval.'''
        raise NotImplementedError()
    
    @property
    def page_rasterization_options(self) -> List[aspose.imaging.imageoptions.VectorRasterizationOptions]:
        '''Gets the page rasterization options.'''
        raise NotImplementedError()
    
    @page_rasterization_options.setter
    def page_rasterization_options(self, value : List[aspose.imaging.imageoptions.VectorRasterizationOptions]) -> None:
        '''Sets the page rasterization options.'''
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.imaging.Rectangle:
        '''Gets the export area.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets the export area.'''
        raise NotImplementedError()
    
    @property
    def mode(self) -> aspose.imaging.imageoptions.MultiPageMode:
        '''Gets the mode.'''
        raise NotImplementedError()
    
    @mode.setter
    def mode(self, value : aspose.imaging.imageoptions.MultiPageMode) -> None:
        '''Sets the mode.'''
        raise NotImplementedError()
    
    @property
    def output_layers_names(self) -> List[str]:
        '''Gets the output layers names(Works if export format supports layers naming, for example for Psd)'''
        raise NotImplementedError()
    
    @output_layers_names.setter
    def output_layers_names(self, value : List[str]) -> None:
        '''Sets the output layers names(Works if export format supports layers naming, for example for Psd)'''
        raise NotImplementedError()
    
    @property
    def merge_layers(self) -> bool:
        '''Gets a value indicating whether [merege layers].'''
        raise NotImplementedError()
    
    @merge_layers.setter
    def merge_layers(self, value : bool) -> None:
        '''Sets a value indicating whether [merege layers].'''
        raise NotImplementedError()
    

class MultipageCreateOptions:
    '''The multipage create options'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the page count.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the page count.'''
        raise NotImplementedError()
    

class OdRasterizationOptions(VectorRasterizationOptions):
    '''The Od rasterization options'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    

class OdgRasterizationOptions(OdRasterizationOptions):
    '''The Odg rasterization options'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    

class OtgRasterizationOptions(OdRasterizationOptions):
    '''The Otg rasterization options'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    

class PdfOptions(aspose.imaging.ImageOptionsBase):
    '''The PDF options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PdfOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def use_original_image_resolution(self) -> bool:
        '''Gets a value indicating to use the original image DPI resolution'''
        raise NotImplementedError()
    
    @use_original_image_resolution.setter
    def use_original_image_resolution(self, value : bool) -> None:
        '''Sets a value indicating to use the original image DPI resolution'''
        raise NotImplementedError()
    
    @property
    def pdf_document_info(self) -> aspose.imaging.fileformats.pdf.PdfDocumentInfo:
        '''Gets metadata for document.'''
        raise NotImplementedError()
    
    @pdf_document_info.setter
    def pdf_document_info(self, value : aspose.imaging.fileformats.pdf.PdfDocumentInfo) -> None:
        '''Sets metadata for document.'''
        raise NotImplementedError()
    
    @property
    def pdf_core_options(self) -> aspose.imaging.fileformats.pdf.PdfCoreOptions:
        '''The PDF core options'''
        raise NotImplementedError()
    
    @pdf_core_options.setter
    def pdf_core_options(self, value : aspose.imaging.fileformats.pdf.PdfCoreOptions) -> None:
        '''The PDF core options'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the size of the page.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the size of the page.'''
        raise NotImplementedError()
    

class PngOptions(aspose.imaging.ImageOptionsBase):
    '''Create high-quality Portable Network Graphics (PNG) raster images effortlessly
    with our API, offering customizable options for compression levels,
    bits per pixel depths, and alpha bits. Seamlessly process XMP metadata containers,
    ensuring comprehensive image metadata management, and empowering you to tailor
    PNG images to your exact specifications with ease.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PngOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, png_options : aspose.imaging.imageoptions.PngOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PngOptions` class.
        
        :param png_options: The PNG options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.imaging.fileformats.png.PngColorType:
        '''Gets the type of the color.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.imaging.fileformats.png.PngColorType) -> None:
        '''Sets the type of the color.'''
        raise NotImplementedError()
    
    @property
    def progressive(self) -> bool:
        '''Gets a value indicating whether a :py:class:`aspose.imaging.fileformats.png.PngImage` is progressive.'''
        raise NotImplementedError()
    
    @progressive.setter
    def progressive(self, value : bool) -> None:
        '''Sets a value indicating whether a :py:class:`aspose.imaging.fileformats.png.PngImage` is progressive.'''
        raise NotImplementedError()
    
    @property
    def filter_type(self) -> aspose.imaging.fileformats.png.PngFilterType:
        '''Gets the filter type used during png file save process.'''
        raise NotImplementedError()
    
    @filter_type.setter
    def filter_type(self, value : aspose.imaging.fileformats.png.PngFilterType) -> None:
        '''Sets the filter type used during png file save process.'''
        raise NotImplementedError()
    
    @property
    def compression_level(self) -> int:
        '''Gets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @compression_level.setter
    def compression_level(self, value : int) -> None:
        '''Sets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @property
    def png_compression_level(self) -> aspose.imaging.imageoptions.PngCompressionLevel:
        '''Gets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @png_compression_level.setter
    def png_compression_level(self, value : aspose.imaging.imageoptions.PngCompressionLevel) -> None:
        '''Sets the :py:class:`aspose.imaging.fileformats.png.PngImage` compression level.'''
        raise NotImplementedError()
    
    @property
    def bit_depth(self) -> int:
        '''Gets the bit depth values in range of 1, 2, 4, 8, 16.
        
        
        Mind the next limits:
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.INDEXED_COLOR` supports bit depth of 1, 2, 4, 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE_WITH_ALPHA` support bit depth of 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR_WITH_ALPHA` support bit depth of 8, 16.'''
        raise NotImplementedError()
    
    @bit_depth.setter
    def bit_depth(self, value : int) -> None:
        '''Sets the bit depth values in range of 1, 2, 4, 8, 16.
        
        
        Mind the next limits:
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.INDEXED_COLOR` supports bit depth of 1, 2, 4, 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.GRAYSCALE_WITH_ALPHA` support bit depth of 8.
        
        
        :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR`, :py:attr:`aspose.imaging.fileformats.png.PngColorType.TRUECOLOR_WITH_ALPHA` support bit depth of 8, 16.'''
        raise NotImplementedError()
    
    @staticmethod
    @property
    def DEFAULT_COMPRESSION_LEVEL() -> aspose.imaging.imageoptions.PngCompressionLevel:
        '''The default compression level.'''
        raise NotImplementedError()


class PsdOptions(aspose.imaging.ImageOptionsBase):
    '''Create Photoshop Document (PSD) images with our API, offering versatile options
    with different format versions, compression methods, color modes, and
    bits counts per color channel. Seamlessly handle XMP metadata containers,
    ensuring comprehensive image processing with the power of PSD format features
    like image layers, layer masks, and file information for customization
    and creativity in your designs.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PsdOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, options : aspose.imaging.imageoptions.PsdOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PsdOptions` class.
        
        :param options: The options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Get or set XMP data container'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Get or set XMP data container'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def version(self) -> int:
        '''Gets the psd file version.'''
        raise NotImplementedError()
    
    @version.setter
    def version(self, value : int) -> None:
        '''Sets the psd file version.'''
        raise NotImplementedError()
    
    @property
    def compression_method(self) -> aspose.imaging.fileformats.psd.CompressionMethod:
        '''Gets the psd compression method.'''
        raise NotImplementedError()
    
    @compression_method.setter
    def compression_method(self, value : aspose.imaging.fileformats.psd.CompressionMethod) -> None:
        '''Sets the psd compression method.'''
        raise NotImplementedError()
    
    @property
    def psd_version(self) -> aspose.imaging.fileformats.psd.PsdVersion:
        '''Gets the file format version. It can be PSD or PSB.'''
        raise NotImplementedError()
    
    @psd_version.setter
    def psd_version(self, value : aspose.imaging.fileformats.psd.PsdVersion) -> None:
        '''Sets the file format version. It can be PSD or PSB.'''
        raise NotImplementedError()
    
    @property
    def color_mode(self) -> aspose.imaging.fileformats.psd.ColorModes:
        '''Gets the psd color mode.'''
        raise NotImplementedError()
    
    @color_mode.setter
    def color_mode(self, value : aspose.imaging.fileformats.psd.ColorModes) -> None:
        '''Sets the psd color mode.'''
        raise NotImplementedError()
    
    @property
    def channel_bits_count(self) -> int:
        '''Gets the bits count per color channel.'''
        raise NotImplementedError()
    
    @channel_bits_count.setter
    def channel_bits_count(self, value : int) -> None:
        '''Sets the bits count per color channel.'''
        raise NotImplementedError()
    
    @property
    def channels_count(self) -> int:
        '''Gets the color channels count.'''
        raise NotImplementedError()
    
    @channels_count.setter
    def channels_count(self, value : int) -> None:
        '''Sets the color channels count.'''
        raise NotImplementedError()
    
    @property
    def remove_global_text_engine_resource(self) -> bool:
        '''Gets a value indicating whether - Remove the global text engine resource - Used for some text-layered psd files, in only case, when they can not be opened in Adobe Photoshop after processing (mostly for absent fonts text layers related).
        After using this option, user need to Make next in opened in Photoshop file: Menu "Text" -> "Process absent fonts". After that operation all text will appear again.
        Please note, that this operation may cause some final layout changes.'''
        raise NotImplementedError()
    
    @remove_global_text_engine_resource.setter
    def remove_global_text_engine_resource(self, value : bool) -> None:
        '''Sets a value indicating whether - Remove the global text engine resource - Used for some text-layered psd files, in only case, when they can not be opened in Adobe Photoshop after processing (mostly for absent fonts text layers related).
        After using this option, user need to Make next in opened in Photoshop file: Menu "Text" -> "Process absent fonts". After that operation all text will appear again.
        Please note, that this operation may cause some final layout changes.'''
        raise NotImplementedError()
    
    @property
    def refresh_image_preview_data(self) -> bool:
        '''Gets a value indicating whether [refresh image preview data] - option used to maximize compatibility with another PSD image viewers.
        Please note, text layers drawing to final layout is not supported for Compact Framework platform'''
        raise NotImplementedError()
    
    @refresh_image_preview_data.setter
    def refresh_image_preview_data(self, value : bool) -> None:
        '''Sets a value indicating whether [refresh image preview data] - option used to maximize compatibility with another PSD image viewers.
        Please note, text layers drawing to final layout is not supported for Compact Framework platform'''
        raise NotImplementedError()
    
    @property
    def vectorization_options(self) -> aspose.imaging.imageoptions.PsdVectorizationOptions:
        '''Gets the PSD vectorization options.'''
        raise NotImplementedError()
    
    @vectorization_options.setter
    def vectorization_options(self, value : aspose.imaging.imageoptions.PsdVectorizationOptions) -> None:
        '''Sets the PSD vectorization options.'''
        raise NotImplementedError()
    

class PsdVectorizationOptions:
    '''The vectorized PSD rasterization options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.PsdVectorizationOptions` class.'''
        raise NotImplementedError()
    
    @property
    def vector_data_composition_mode(self) -> aspose.imaging.fileformats.psd.VectorDataCompositionMode:
        '''Gets the vector data composition mode. Defines the vector data composition mode that is used on export from vector formats to PSD.'''
        raise NotImplementedError()
    
    @vector_data_composition_mode.setter
    def vector_data_composition_mode(self, value : aspose.imaging.fileformats.psd.VectorDataCompositionMode) -> None:
        '''Sets the vector data composition mode. Defines the vector data composition mode that is used on export from vector formats to PSD.'''
        raise NotImplementedError()
    

class RdOptimizerSettings:
    '''RD optimizer settings class'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.RdOptimizerSettings` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create() -> aspose.imaging.imageoptions.RdOptimizerSettings:
        '''Creates this instance.
        
        :returns: returns RDOptimizerSettings class instance'''
        raise NotImplementedError()
    
    @property
    def bpp_scale(self) -> int:
        '''Gets the BPP (bits per pixel) scale factor.'''
        raise NotImplementedError()
    
    @bpp_scale.setter
    def bpp_scale(self, value : int) -> None:
        '''Sets the BPP (bits per pixel) scale factor.'''
        raise NotImplementedError()
    
    @property
    def bpp_max(self) -> float:
        '''Gets the maximum R value for consideration in  in bits per pixel'''
        raise NotImplementedError()
    
    @bpp_max.setter
    def bpp_max(self, value : float) -> None:
        '''Sets the maximum R value for consideration in  in bits per pixel'''
        raise NotImplementedError()
    
    @property
    def max_q(self) -> int:
        '''Gets the maximum quantization value.'''
        raise NotImplementedError()
    
    @max_q.setter
    def max_q(self, value : int) -> None:
        '''Sets the maximum quantization value.'''
        raise NotImplementedError()
    
    @property
    def min_q(self) -> int:
        '''Gets the minimum allowed quantization value.'''
        raise NotImplementedError()
    
    @property
    def max_pixel_value(self) -> int:
        '''Gets the maximum pixel value.'''
        raise NotImplementedError()
    
    @property
    def psnr_max(self) -> int:
        '''Gets the PSNR maximum expected value.'''
        raise NotImplementedError()
    
    @property
    def discretized_bpp_max(self) -> int:
        '''Gets the maximum R value for consideration.'''
        raise NotImplementedError()
    

class RenderResult:
    '''Represents information with results of rendering'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def message(self) -> str:
        '''Gets string message'''
        raise NotImplementedError()
    
    @message.setter
    def message(self, value : str) -> None:
        '''Sets string message'''
        raise NotImplementedError()
    
    @property
    def render_code(self) -> aspose.imaging.imageoptions.RenderErrorCode:
        '''Gets code of error'''
        raise NotImplementedError()
    
    @render_code.setter
    def render_code(self, value : aspose.imaging.imageoptions.RenderErrorCode) -> None:
        '''Sets code of error'''
        raise NotImplementedError()
    

class SvgOptions(aspose.imaging.ImageOptionsBase):
    '''Create Scalar Vector Graphics (SVG) image files with our API, utilizing versatile
    options for color types and compression levels. Seamlessly customize your
    SVG images with precision, ensuring optimal quality and compatibility for your design needs.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.SvgOptions`.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.imaging.fileformats.svg.SvgColorMode:
        '''Gets the color type for SVG image.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.imaging.fileformats.svg.SvgColorMode) -> None:
        '''Sets the color type for SVG image.'''
        raise NotImplementedError()
    
    @property
    def text_as_shapes(self) -> bool:
        '''Gets a value indicating whether text must be rendered as shapes.'''
        raise NotImplementedError()
    
    @text_as_shapes.setter
    def text_as_shapes(self, value : bool) -> None:
        '''Sets a value indicating whether text must be rendered as shapes.'''
        raise NotImplementedError()
    
    @property
    def callback(self) -> aspose.imaging.fileformats.svg.ISvgResourceKeeperCallback:
        '''Gets the storing strategy for embedded resousces of :py:class:`aspose.imaging.fileformats.svg.SvgImage` such as fonts, nested rasters.'''
        raise NotImplementedError()
    
    @callback.setter
    def callback(self, value : aspose.imaging.fileformats.svg.ISvgResourceKeeperCallback) -> None:
        '''Sets the storing strategy for embedded resousces of :py:class:`aspose.imaging.fileformats.svg.SvgImage` such as fonts, nested rasters.'''
        raise NotImplementedError()
    
    @property
    def compress(self) -> bool:
        '''Gets a value indicating whether the output image must to be compressed.'''
        raise NotImplementedError()
    
    @compress.setter
    def compress(self, value : bool) -> None:
        '''Sets a value indicating whether the output image must to be compressed.'''
        raise NotImplementedError()
    

class SvgRasterizationOptions(VectorRasterizationOptions):
    '''The SVG rasterization options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.SvgRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies this instance to ``vectorRasterizationOptions``.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def scale_x(self) -> float:
        '''Gets the scale x.'''
        raise NotImplementedError()
    
    @scale_x.setter
    def scale_x(self, value : float) -> None:
        '''Sets the scale x.'''
        raise NotImplementedError()
    
    @property
    def scale_y(self) -> float:
        '''Gets the scale y.'''
        raise NotImplementedError()
    
    @scale_y.setter
    def scale_y(self, value : float) -> None:
        '''Sets the scale y.'''
        raise NotImplementedError()
    

class TgaOptions(aspose.imaging.ImageOptionsBase):
    '''The TGA file format create options.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TgaOptions` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, tga_options : aspose.imaging.imageoptions.TgaOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TgaOptions` class.
        
        :param tga_options: The TGA options.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    

class TiffOptions(aspose.imaging.ImageOptionsBase):
    '''The tiff file format options.
    Note that width and height tags will get overwritten on image creation by width and height parameters so there is no need to specify them directly.
    Note that many options return a default value but that does not mean that this option is set explicitly as a tag value. To verify the tag is present use Tags property or the corresponding IsTagPresent method.'''
    
    @overload
    def __init__(self, expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat, byte_order : aspose.imaging.fileformats.tiff.enums.TiffByteOrder) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class.
        
        :param expected_format: The expected tiff file format.
        :param byte_order: The tiff file format byte order to use.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class. By default little endian convention is used.
        
        :param expected_format: The expected tiff file format.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, options : aspose.imaging.imageoptions.TiffOptions) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class.
        
        :param options: The options to copy from.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class.
        
        :param tags: The tags to initialize options with.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Clones this instance.
        
        :returns: Returns a deep clone.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_format(expected_format : aspose.imaging.fileformats.tiff.enums.TiffExpectedFormat) -> aspose.imaging.imageoptions.TiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class. By default little endian convention is used.
        
        :param expected_format: The expected tiff file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_options(options : aspose.imaging.imageoptions.TiffOptions) -> aspose.imaging.imageoptions.TiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class.
        
        :param options: The options to copy from.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_tags(tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> aspose.imaging.imageoptions.TiffOptions:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TiffOptions` class.
        
        :param tags: The tags to initialize options with.'''
        raise NotImplementedError()
    
    def is_tag_present(self, tag : aspose.imaging.fileformats.tiff.enums.TiffTags) -> bool:
        '''Determines whether tag is present in the options or not.
        
        :param tag: The tag id to check.
        :returns: ``true`` if tag is present; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_valid_tags_count(tags : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> int:
        '''Gets the valid tags count.
        
        :param tags: The tags to validate.
        :returns: The valid tags count.'''
        raise NotImplementedError()
    
    def remove_tag(self, tag : aspose.imaging.fileformats.tiff.enums.TiffTags) -> bool:
        '''Removes the tag.
        
        :param tag: The tag to remove.
        :returns: true if successfully removed'''
        raise NotImplementedError()
    
    def remove_tags(self, tags : List[aspose.imaging.fileformats.tiff.enums.TiffTags]) -> bool:
        '''Removes the tags.
        
        :param tags: The tags to remove.
        :returns: if tag collection size changed.'''
        raise NotImplementedError()
    
    def validate(self) -> None:
        '''Validates if options have valid combination of tags'''
        raise NotImplementedError()
    
    def add_tags(self, tags_to_add : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Adds the tags.
        
        :param tags_to_add: The tags to add.'''
        raise NotImplementedError()
    
    def add_tag(self, tag_to_add : aspose.imaging.fileformats.tiff.TiffDataType) -> None:
        '''Adds a new tag.
        
        :param tag_to_add: The tag to add.'''
        raise NotImplementedError()
    
    def get_tag_by_type(self, tag_key : aspose.imaging.fileformats.tiff.enums.TiffTags) -> aspose.imaging.fileformats.tiff.TiffDataType:
        '''Gets the instance of the tag by type.
        
        :param tag_key: The tag key.
        :returns: Instance of the tag if exists or null otherwise.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def tag_count(self) -> int:
        '''Gets the tag count.'''
        raise NotImplementedError()
    
    @property
    def file_standard(self) -> aspose.imaging.fileformats.tiff.enums.TiffFileStandards:
        '''Gets the TIFF file standard.'''
        raise NotImplementedError()
    
    @file_standard.setter
    def file_standard(self, value : aspose.imaging.fileformats.tiff.enums.TiffFileStandards) -> None:
        '''Sets the TIFF file standard.'''
        raise NotImplementedError()
    
    @property
    def default_memory_allocation_limit(self) -> int:
        '''Gets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @default_memory_allocation_limit.setter
    def default_memory_allocation_limit(self, value : int) -> None:
        '''Sets the default memory allocation limit.'''
        raise NotImplementedError()
    
    @property
    def premultiply_components(self) -> bool:
        '''Gets a value indicating whether components must be premultiplied.'''
        raise NotImplementedError()
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool) -> None:
        '''Sets a value indicating whether components must be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def is_valid(self) -> bool:
        '''Gets a value indicating whether the :py:class:`aspose.imaging.imageoptions.TiffOptions` have been properly configured. Use Validate method as to find the failure reason.'''
        raise NotImplementedError()
    
    @property
    def y_cb_cr_subsampling(self) -> List[int]:
        '''Gets the subsampling factors for YCbCr photometric.'''
        raise NotImplementedError()
    
    @y_cb_cr_subsampling.setter
    def y_cb_cr_subsampling(self, value : List[int]) -> None:
        '''Sets the subsampling factors for YCbCr photometric.'''
        raise NotImplementedError()
    
    @property
    def y_cb_cr_coefficients(self) -> List[aspose.imaging.fileformats.tiff.TiffRational]:
        '''Gets the YCbCrCoefficients.'''
        raise NotImplementedError()
    
    @y_cb_cr_coefficients.setter
    def y_cb_cr_coefficients(self, value : List[aspose.imaging.fileformats.tiff.TiffRational]) -> None:
        '''Sets the YCbCrCoefficients.'''
        raise NotImplementedError()
    
    @property
    def is_tiled(self) -> bool:
        '''Gets a value indicating whether image is tiled.'''
        raise NotImplementedError()
    
    @property
    def artist(self) -> str:
        '''Gets the artist.'''
        raise NotImplementedError()
    
    @artist.setter
    def artist(self, value : str) -> None:
        '''Sets the artist.'''
        raise NotImplementedError()
    
    @property
    def byte_order(self) -> aspose.imaging.fileformats.tiff.enums.TiffByteOrder:
        '''Gets a value indicating the tiff byte order.'''
        raise NotImplementedError()
    
    @byte_order.setter
    def byte_order(self, value : aspose.imaging.fileformats.tiff.enums.TiffByteOrder) -> None:
        '''Sets a value indicating the tiff byte order.'''
        raise NotImplementedError()
    
    @property
    def disable_icc_export(self) -> bool:
        '''Gets a value indicating whether ICC profile export is disabled (ICC profile is applied to the source pixels beforehand).'''
        raise NotImplementedError()
    
    @disable_icc_export.setter
    def disable_icc_export(self, value : bool) -> None:
        '''Sets a value indicating whether ICC profile export is disabled (ICC profile is applied to the source pixels beforehand).'''
        raise NotImplementedError()
    
    @property
    def bits_per_sample(self) -> List[int]:
        '''Gets the bits per sample.'''
        raise NotImplementedError()
    
    @bits_per_sample.setter
    def bits_per_sample(self, value : List[int]) -> None:
        '''Sets the bits per sample.'''
        raise NotImplementedError()
    
    @property
    def extra_samples(self) -> List[int]:
        '''Gets the extra samples values.'''
        raise NotImplementedError()
    
    @property
    def compression(self) -> aspose.imaging.fileformats.tiff.enums.TiffCompressions:
        '''Gets the compression.'''
        raise NotImplementedError()
    
    @compression.setter
    def compression(self, value : aspose.imaging.fileformats.tiff.enums.TiffCompressions) -> None:
        '''Sets the compression.'''
        raise NotImplementedError()
    
    @property
    def compressed_quality(self) -> int:
        '''Gets compressed image quality.
        Used with the Jpeg compression.'''
        raise NotImplementedError()
    
    @compressed_quality.setter
    def compressed_quality(self, value : int) -> None:
        '''Sets compressed image quality.
        Used with the Jpeg compression.'''
        raise NotImplementedError()
    
    @property
    def copyright(self) -> str:
        '''Gets the copyright.'''
        raise NotImplementedError()
    
    @copyright.setter
    def copyright(self, value : str) -> None:
        '''Sets the copyright.'''
        raise NotImplementedError()
    
    @property
    def color_map(self) -> List[int]:
        '''Gets the color map.'''
        raise NotImplementedError()
    
    @color_map.setter
    def color_map(self, value : List[int]) -> None:
        '''Sets the color map.'''
        raise NotImplementedError()
    
    @property
    def date_time(self) -> str:
        '''Gets the date and time.'''
        raise NotImplementedError()
    
    @date_time.setter
    def date_time(self, value : str) -> None:
        '''Sets the date and time.'''
        raise NotImplementedError()
    
    @property
    def document_name(self) -> str:
        '''Gets the name of the document.'''
        raise NotImplementedError()
    
    @document_name.setter
    def document_name(self, value : str) -> None:
        '''Sets the name of the document.'''
        raise NotImplementedError()
    
    @property
    def alpha_storage(self) -> aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage:
        '''Gets the alpha storage option. Options other than :py:attr:`aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage.UNSPECIFIED`
        are used when there are more than 3 :py:attr:`aspose.imaging.imageoptions.TiffOptions.samples_per_pixel` defined.'''
        raise NotImplementedError()
    
    @alpha_storage.setter
    def alpha_storage(self, value : aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage) -> None:
        '''Sets the alpha storage option. Options other than :py:attr:`aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage.UNSPECIFIED`
        are used when there are more than 3 :py:attr:`aspose.imaging.imageoptions.TiffOptions.samples_per_pixel` defined.'''
        raise NotImplementedError()
    
    @property
    def is_extra_samples_present(self) -> bool:
        '''Gets a value indicating whether the extra samples is present.'''
        raise NotImplementedError()
    
    @property
    def fill_order(self) -> aspose.imaging.fileformats.tiff.enums.TiffFillOrders:
        '''Gets the byte bits fill order.'''
        raise NotImplementedError()
    
    @fill_order.setter
    def fill_order(self, value : aspose.imaging.fileformats.tiff.enums.TiffFillOrders) -> None:
        '''Sets the byte bits fill order.'''
        raise NotImplementedError()
    
    @property
    def half_tone_hints(self) -> List[int]:
        '''Gets the halftone hints.'''
        raise NotImplementedError()
    
    @half_tone_hints.setter
    def half_tone_hints(self, value : List[int]) -> None:
        '''Sets the halftone hints.'''
        raise NotImplementedError()
    
    @property
    def image_description(self) -> str:
        '''Gets the image description.'''
        raise NotImplementedError()
    
    @image_description.setter
    def image_description(self, value : str) -> None:
        '''Sets the image description.'''
        raise NotImplementedError()
    
    @property
    def ink_names(self) -> str:
        '''Gets the ink names.'''
        raise NotImplementedError()
    
    @ink_names.setter
    def ink_names(self, value : str) -> None:
        '''Sets the ink names.'''
        raise NotImplementedError()
    
    @property
    def scanner_manufacturer(self) -> str:
        '''Gets the scanner manufacturer.'''
        raise NotImplementedError()
    
    @scanner_manufacturer.setter
    def scanner_manufacturer(self, value : str) -> None:
        '''Sets the scanner manufacturer.'''
        raise NotImplementedError()
    
    @property
    def max_sample_value(self) -> List[int]:
        '''Gets the max sample value.'''
        raise NotImplementedError()
    
    @max_sample_value.setter
    def max_sample_value(self, value : List[int]) -> None:
        '''Sets the max sample value.'''
        raise NotImplementedError()
    
    @property
    def min_sample_value(self) -> List[int]:
        '''Gets the min sample value.'''
        raise NotImplementedError()
    
    @min_sample_value.setter
    def min_sample_value(self, value : List[int]) -> None:
        '''Sets the min sample value.'''
        raise NotImplementedError()
    
    @property
    def scanner_model(self) -> str:
        '''Gets the scanner model.'''
        raise NotImplementedError()
    
    @scanner_model.setter
    def scanner_model(self, value : str) -> None:
        '''Sets the scanner model.'''
        raise NotImplementedError()
    
    @property
    def orientation(self) -> aspose.imaging.fileformats.tiff.enums.TiffOrientations:
        '''Gets the orientation.'''
        raise NotImplementedError()
    
    @orientation.setter
    def orientation(self, value : aspose.imaging.fileformats.tiff.enums.TiffOrientations) -> None:
        '''Sets the orientation.'''
        raise NotImplementedError()
    
    @property
    def page_name(self) -> str:
        '''Gets the page name.'''
        raise NotImplementedError()
    
    @page_name.setter
    def page_name(self, value : str) -> None:
        '''Sets the page name.'''
        raise NotImplementedError()
    
    @property
    def page_number(self) -> List[int]:
        '''Gets the page number tag.'''
        raise NotImplementedError()
    
    @page_number.setter
    def page_number(self, value : List[int]) -> None:
        '''Sets the page number tag.'''
        raise NotImplementedError()
    
    @property
    def photometric(self) -> aspose.imaging.fileformats.tiff.enums.TiffPhotometrics:
        '''Gets the photometric.'''
        raise NotImplementedError()
    
    @photometric.setter
    def photometric(self, value : aspose.imaging.fileformats.tiff.enums.TiffPhotometrics) -> None:
        '''Sets the photometric.'''
        raise NotImplementedError()
    
    @property
    def planar_configuration(self) -> aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs:
        '''Gets the planar configuration.'''
        raise NotImplementedError()
    
    @planar_configuration.setter
    def planar_configuration(self, value : aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs) -> None:
        '''Sets the planar configuration.'''
        raise NotImplementedError()
    
    @property
    def resolution_unit(self) -> aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits:
        '''Gets the resolution unit.'''
        raise NotImplementedError()
    
    @resolution_unit.setter
    def resolution_unit(self, value : aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits) -> None:
        '''Sets the resolution unit.'''
        raise NotImplementedError()
    
    @property
    def rows_per_strip(self) -> int:
        '''Gets the rows per strip.'''
        raise NotImplementedError()
    
    @rows_per_strip.setter
    def rows_per_strip(self, value : int) -> None:
        '''Sets the rows per strip.'''
        raise NotImplementedError()
    
    @property
    def tile_width(self) -> int:
        '''Gets ot sets tile width.'''
        raise NotImplementedError()
    
    @tile_width.setter
    def tile_width(self, value : int) -> None:
        '''Gets ot sets tile width.'''
        raise NotImplementedError()
    
    @property
    def tile_length(self) -> int:
        '''Gets ot sets tile length.'''
        raise NotImplementedError()
    
    @tile_length.setter
    def tile_length(self, value : int) -> None:
        '''Gets ot sets tile length.'''
        raise NotImplementedError()
    
    @property
    def sample_format(self) -> List[aspose.imaging.fileformats.tiff.enums.TiffSampleFormats]:
        '''Gets the sample format.'''
        raise NotImplementedError()
    
    @sample_format.setter
    def sample_format(self, value : List[aspose.imaging.fileformats.tiff.enums.TiffSampleFormats]) -> None:
        '''Sets the sample format.'''
        raise NotImplementedError()
    
    @property
    def samples_per_pixel(self) -> int:
        '''Gets the samples per pixel. To change this property value use the :py:attr:`aspose.imaging.imageoptions.TiffOptions.bits_per_sample` property setter.'''
        raise NotImplementedError()
    
    @property
    def smax_sample_value(self) -> List[int]:
        '''Gets the max sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @smax_sample_value.setter
    def smax_sample_value(self, value : List[int]) -> None:
        '''Sets the max sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @property
    def smin_sample_value(self) -> List[int]:
        '''Gets the min sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @smin_sample_value.setter
    def smin_sample_value(self, value : List[int]) -> None:
        '''Sets the min sample value. The value has a field type which best matches the sample data (Byte, Short or Long type).'''
        raise NotImplementedError()
    
    @property
    def software_type(self) -> str:
        '''Gets the software type.'''
        raise NotImplementedError()
    
    @software_type.setter
    def software_type(self, value : str) -> None:
        '''Sets the software type.'''
        raise NotImplementedError()
    
    @property
    def strip_byte_counts(self) -> List[int]:
        '''Gets the strip byte counts.'''
        raise NotImplementedError()
    
    @strip_byte_counts.setter
    def strip_byte_counts(self, value : List[int]) -> None:
        '''Sets the strip byte counts.'''
        raise NotImplementedError()
    
    @property
    def strip_offsets(self) -> List[int]:
        '''Gets the strip offsets.'''
        raise NotImplementedError()
    
    @strip_offsets.setter
    def strip_offsets(self, value : List[int]) -> None:
        '''Sets the strip offsets.'''
        raise NotImplementedError()
    
    @property
    def tile_byte_counts(self) -> List[int]:
        '''Gets the tile byte counts.'''
        raise NotImplementedError()
    
    @tile_byte_counts.setter
    def tile_byte_counts(self, value : List[int]) -> None:
        '''Sets the tile byte counts.'''
        raise NotImplementedError()
    
    @property
    def tile_offsets(self) -> List[int]:
        '''Gets the tile offsets.'''
        raise NotImplementedError()
    
    @tile_offsets.setter
    def tile_offsets(self, value : List[int]) -> None:
        '''Sets the tile offsets.'''
        raise NotImplementedError()
    
    @property
    def sub_file_type(self) -> aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes:
        '''Gets a general indication of the kind of data contained in this subfile.'''
        raise NotImplementedError()
    
    @sub_file_type.setter
    def sub_file_type(self, value : aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes) -> None:
        '''Sets a general indication of the kind of data contained in this subfile.'''
        raise NotImplementedError()
    
    @property
    def target_printer(self) -> str:
        '''Gets the target printer.'''
        raise NotImplementedError()
    
    @target_printer.setter
    def target_printer(self, value : str) -> None:
        '''Sets the target printer.'''
        raise NotImplementedError()
    
    @property
    def threshholding(self) -> aspose.imaging.fileformats.tiff.enums.TiffThresholds:
        '''Gets the threshholding.'''
        raise NotImplementedError()
    
    @threshholding.setter
    def threshholding(self, value : aspose.imaging.fileformats.tiff.enums.TiffThresholds) -> None:
        '''Sets the threshholding.'''
        raise NotImplementedError()
    
    @property
    def total_pages(self) -> int:
        '''Gets the total pages.'''
        raise NotImplementedError()
    
    @property
    def xposition(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the x position.'''
        raise NotImplementedError()
    
    @xposition.setter
    def xposition(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the x position.'''
        raise NotImplementedError()
    
    @property
    def xresolution(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the x resolution.'''
        raise NotImplementedError()
    
    @xresolution.setter
    def xresolution(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the x resolution.'''
        raise NotImplementedError()
    
    @property
    def yposition(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the y position.'''
        raise NotImplementedError()
    
    @yposition.setter
    def yposition(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the y position.'''
        raise NotImplementedError()
    
    @property
    def yresolution(self) -> aspose.imaging.fileformats.tiff.TiffRational:
        '''Gets the y resolution.'''
        raise NotImplementedError()
    
    @yresolution.setter
    def yresolution(self, value : aspose.imaging.fileformats.tiff.TiffRational) -> None:
        '''Sets the y resolution.'''
        raise NotImplementedError()
    
    @property
    def fax_t4_options(self) -> aspose.imaging.fileformats.tiff.enums.Group3Options:
        '''Gets the fax t4 options.'''
        raise NotImplementedError()
    
    @fax_t4_options.setter
    def fax_t4_options(self, value : aspose.imaging.fileformats.tiff.enums.Group3Options) -> None:
        '''Sets the fax t4 options.'''
        raise NotImplementedError()
    
    @property
    def predictor(self) -> aspose.imaging.fileformats.tiff.enums.TiffPredictor:
        '''Gets the predictor for LZW compression.'''
        raise NotImplementedError()
    
    @predictor.setter
    def predictor(self, value : aspose.imaging.fileformats.tiff.enums.TiffPredictor) -> None:
        '''Sets the predictor for LZW compression.'''
        raise NotImplementedError()
    
    @property
    def image_length(self) -> int:
        '''Gets the image length.'''
        raise NotImplementedError()
    
    @image_length.setter
    def image_length(self, value : int) -> None:
        '''Sets the image length.'''
        raise NotImplementedError()
    
    @property
    def image_width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @image_width.setter
    def image_width(self, value : int) -> None:
        '''Sets the image width.'''
        raise NotImplementedError()
    
    @property
    def exif_ifd(self) -> aspose.imaging.fileformats.tiff.TiffExifIfd:
        '''Gets the pointer to EXIF IFD.'''
        raise NotImplementedError()
    
    @property
    def tags(self) -> List[aspose.imaging.fileformats.tiff.TiffDataType]:
        '''Gets the tags.'''
        raise NotImplementedError()
    
    @tags.setter
    def tags(self, value : List[aspose.imaging.fileformats.tiff.TiffDataType]) -> None:
        '''Sets the tags.'''
        raise NotImplementedError()
    
    @property
    def valid_tag_count(self) -> int:
        '''Gets the valid tag count. This is not the total tags count but the number of tags which may be preserved.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the bits per pixel.'''
        raise NotImplementedError()
    
    @property
    def xp_title(self) -> str:
        '''Gets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_title.setter
    def xp_title(self, value : str) -> None:
        '''Sets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_comment(self) -> str:
        '''Gets comment on image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_comment.setter
    def xp_comment(self, value : str) -> None:
        '''Sets comment on image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_author(self) -> str:
        '''Gets image author, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_author.setter
    def xp_author(self, value : str) -> None:
        '''Sets image author, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_keywords(self) -> str:
        '''Gets subject image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_keywords.setter
    def xp_keywords(self, value : str) -> None:
        '''Sets subject image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @property
    def xp_subject(self) -> str:
        '''Gets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    
    @xp_subject.setter
    def xp_subject(self, value : str) -> None:
        '''Sets information about image, which used by Windows Explorer.'''
        raise NotImplementedError()
    

class TimeInterval:
    '''Represents the time interval in milliseconds'''
    
    def __init__(self, from_address : int, to : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.TimeInterval` class.
        
        :param from_address: From milliseconds.
        :param to: To milliseconds.'''
        raise NotImplementedError()
    
    @property
    def from_address(self) -> int:
        '''Gets From milliseconds.'''
        raise NotImplementedError()
    
    @from_address.setter
    def from_address(self, value : int) -> None:
        '''Sets From milliseconds.'''
        raise NotImplementedError()
    
    @property
    def to(self) -> int:
        '''Gets To milliseconds.'''
        raise NotImplementedError()
    
    @to.setter
    def to(self, value : int) -> None:
        '''Sets To milliseconds.'''
        raise NotImplementedError()
    

class VectorRasterizationOptions:
    '''The vector rasterization options.
    Please note that :py:class:`aspose.imaging.imageoptions.VectorRasterizationOptions` will no longer derive from :py:class:`aspose.imaging.ImageOptionsBase`
    since Aspose.Imaging 24.12 version.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies to.
        
        :param vector_rasterization_options: The vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    

class WebPOptions(aspose.imaging.ImageOptionsBase):
    '''Create modern WebP raster web images using our API, featuring robust support for
    lossless and lossy compression, as well as alpha channels and animation loops.
    Enhance your web content with dynamic visuals while optimizing file sizes
    for improved loading speeds and user experience.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.WebPOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def lossless(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.imageoptions.WebPOptions` is lossless.'''
        raise NotImplementedError()
    
    @lossless.setter
    def lossless(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.imageoptions.WebPOptions` is lossless.'''
        raise NotImplementedError()
    
    @property
    def quality(self) -> float:
        '''Gets the quality.'''
        raise NotImplementedError()
    
    @quality.setter
    def quality(self, value : float) -> None:
        '''Sets the quality.'''
        raise NotImplementedError()
    
    @property
    def anim_loop_count(self) -> int:
        '''Gets the animation loop count.'''
        raise NotImplementedError()
    
    @anim_loop_count.setter
    def anim_loop_count(self, value : int) -> None:
        '''Sets the animation loop count.'''
        raise NotImplementedError()
    
    @property
    def anim_background_color(self) -> int:
        '''Gets the color of the animation background.'''
        raise NotImplementedError()
    
    @anim_background_color.setter
    def anim_background_color(self, value : int) -> None:
        '''Sets the color of the animation background.'''
        raise NotImplementedError()
    

class WmfOptions(MetafileOptions):
    '''The wmf options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.MetafileOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @property
    def compress(self) -> bool:
        '''Gets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    
    @compress.setter
    def compress(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`Aspose.FileFormats.Core.ImageOptions.ICompressedOptions` is compressed.'''
        raise NotImplementedError()
    

class WmfRasterizationOptions(MetafileRasterizationOptions):
    '''The Wmf rasterization options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.imageoptions.WmfRasterizationOptions` class.'''
        raise NotImplementedError()
    
    def clone(self) -> Any:
        '''Creates a new object that is a shallow copy of the current instance.
        
        :returns: A new object that is a shallow copy of this instance.'''
        raise NotImplementedError()
    
    def copy_to(self, vector_rasterization_options : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Copies this to ``vectorRasterizationOptions``.
        
        :param vector_rasterization_options: vectorRasterizationOptions'''
        raise NotImplementedError()
    
    @property
    def border_x(self) -> float:
        '''Gets the border X.'''
        raise NotImplementedError()
    
    @border_x.setter
    def border_x(self, value : float) -> None:
        '''Sets the border X.'''
        raise NotImplementedError()
    
    @property
    def border_y(self) -> float:
        '''Gets the border Y.'''
        raise NotImplementedError()
    
    @border_y.setter
    def border_y(self, value : float) -> None:
        '''Sets the border Y.'''
        raise NotImplementedError()
    
    @property
    def center_drawing(self) -> bool:
        '''Gets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @center_drawing.setter
    def center_drawing(self, value : bool) -> None:
        '''Sets a value indicating whether center drawing.'''
        raise NotImplementedError()
    
    @property
    def page_height(self) -> float:
        '''Gets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_height.setter
    def page_height(self, value : float) -> None:
        '''Sets the page height.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_size(self) -> aspose.imaging.SizeF:
        '''Gets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_size.setter
    def page_size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the page size.
        If one of :py:class:`aspose.imaging.SizeF` dimensions is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def page_width(self) -> float:
        '''Gets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @page_width.setter
    def page_width(self, value : float) -> None:
        '''Sets the page width.
        If the value is 0, the source image aspect ratio will be preserved.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a background color.'''
        raise NotImplementedError()
    
    @property
    def draw_color(self) -> aspose.imaging.Color:
        '''Gets a foreground color.'''
        raise NotImplementedError()
    
    @draw_color.setter
    def draw_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a foreground color.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def positioning(self) -> aspose.imaging.imageoptions.PositioningTypes:
        '''Gets the positioning.'''
        raise NotImplementedError()
    
    @positioning.setter
    def positioning(self, value : aspose.imaging.imageoptions.PositioningTypes) -> None:
        '''Sets the positioning.'''
        raise NotImplementedError()
    
    @property
    def render_mode(self) -> aspose.imaging.fileformats.wmf.WmfRenderMode:
        '''Gets the WMF render mode.'''
        raise NotImplementedError()
    
    @render_mode.setter
    def render_mode(self, value : aspose.imaging.fileformats.wmf.WmfRenderMode) -> None:
        '''Sets the WMF render mode.'''
        raise NotImplementedError()
    

class MultiPageMode(enum.Enum):
    PAGES = enum.auto()
    '''Used page indicies'''
    TITLES = enum.auto()
    '''Used page titles'''
    RANGE = enum.auto()
    '''Used range of pages'''
    TIME_INTERVAL = enum.auto()
    '''Used pages in time interval'''
    ALL_PAGES = enum.auto()
    '''Used all pages'''

class PdfImageCompressionOptions(enum.Enum):
    AUTO = enum.auto()
    '''Automatically selects the most appropriate compression for each image.'''
    NONE = enum.auto()
    '''Saves raw image bytes resulting in bigger pdf file sizes.'''
    RLE = enum.auto()
    '''Run Length compression.'''
    FLATE = enum.auto()
    '''Flate compression.'''
    LZW_BASELINE_PREDICTOR = enum.auto()
    '''Predictor selection is restricted to PNG Paeth predictor to speed-up the process. In practice
    performs surprisingly good. Better than :py:attr:`aspose.imaging.imageoptions.PdfImageCompressionOptions.LZW_OPTIMIZED_PREDICTOR`.'''
    LZW_OPTIMIZED_PREDICTOR = enum.auto()
    '''Predictor selection is more complicated and should result in smaller image sizes but
    taking more time. RFC 2083 says it is the best way to go. But on the test data baseline predictor
    :py:attr:`aspose.imaging.imageoptions.PdfImageCompressionOptions.LZW_BASELINE_PREDICTOR` kicks ass leaving optimized predictor behing
    by 25-40% compression rate gains.'''
    JPEG = enum.auto()
    '''Jpeg compression.
    Does not support transparency.'''
    CCITT3 = enum.auto()
    '''/CCITTFaxDecode/DecodeParms/K 0/Columns 173
    Does not support transparency.'''
    CCITT4 = enum.auto()
    '''/CCITTFaxDecode/DecodeParms/K -1/Columns 173
    Does not support transparency.'''

class PngCompressionLevel(enum.Enum):
    ZIP_LEVEL0 = enum.auto()
    '''The data will be simply stored, with no change at all.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL1 = enum.auto()
    '''The fastest but least effective compression.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL2 = enum.auto()
    '''A little slower, but better, than level 1.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL3 = enum.auto()
    '''A little slower, but better, than level 2.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL4 = enum.auto()
    '''A little slower, but better, than level 3.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL5 = enum.auto()
    '''A little slower than level 4, but with better compression.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL6 = enum.auto()
    '''A little slower than level 5, but with better compression.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL7 = enum.auto()
    '''Better compression than level 6, but even slower.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL8 = enum.auto()
    '''Better compression than level 7, but even slower.
    Uses a slower deflate implementation with a compression scale.'''
    ZIP_LEVEL9 = enum.auto()
    '''The "best" compression, where best means greatest reduction in size of the input data stream.
    This is also the slowest compression.
    Uses a slower deflate implementation with a compression scale.'''
    DEFLATE_RECOMENDED = enum.auto()
    '''The most optimised compression, with a good balance of speed and compression efficiency.
    Uses a faster deflate implementation with no compression scale.'''

class PositioningTypes(enum.Enum):
    DEFINED_BY_DOCUMENT = enum.auto()
    '''The absolute positioning on the page that is defined by document page settings.'''
    DEFINED_BY_OPTIONS = enum.auto()
    '''The absolute positioning on the page that is defined by options page settings.'''
    RELATIVE = enum.auto()
    '''The relative positioning and size. Determined by the boundary of all graphics objects.'''

class RenderErrorCode(enum.Enum):
    MISSING_HEADER = enum.auto()
    '''Header is missing'''
    MISSING_LAYOUTS = enum.auto()
    '''Layouts information is missing'''
    MISSING_BLOCKS = enum.auto()
    '''Block information is missing'''
    MISSING_DIMENSION_STYLES = enum.auto()
    '''Dimension styles information is missing'''
    MISSING_STYLES = enum.auto()
    '''Styles information is missing'''

class TiffOptionsError(enum.Enum):
    NO_ERROR = enum.auto()
    '''No error code.'''
    NO_COLOR_MAP = enum.auto()
    '''The color map is not defined.'''
    COLOR_MAP_LENGTH_INVALID = enum.auto()
    '''The color map length is invalid.'''
    COMPRESSION_SPP_MISMATCH = enum.auto()
    '''The compression does not match the samples per pixel count.'''
    PHOTOMETRIC_COMPRESSION_MISMATCH = enum.auto()
    '''The compression does not match the photometric settings.'''
    PHOTOMETRIC_SPP_MISMATCH = enum.auto()
    '''The photometric does not match the samples per pixel count.'''
    NOT_SUPPORTED_ALPHA_STORAGE = enum.auto()
    '''The alpha storage is not supported.'''
    PHOTOMETRIC_BITS_PER_SAMPLE_MISMATCH = enum.auto()
    '''The photometric bits per sample is invalid'''
    BASELINE_6_OPTIONS_MISMATCH = enum.auto()
    '''The specified TIFF options parameters don\'t conform to TIFF Baseline 6.0 standard'''

class TypeOfEntities(enum.Enum):
    ENTITIES_2D = enum.auto()
    '''Render 2D entities'''
    ENTITIES_3D = enum.auto()
    '''Render 3D entities'''

