/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.antlr4;

import com.alibaba.graphscope.common.antlr4.ExprVisitorResult;
import com.alibaba.graphscope.common.ir.rex.RexGraphDynamicParam;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphRexBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Utils {
    public static List<SqlOperator> getOperators(List<ParseTree> trees, List<String> opSigns, boolean isPrefix) {
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        for (ParseTree tree : trees) {
            if (!(tree instanceof TerminalNode) || !opSigns.contains(tree.getText())) continue;
            if (tree.getText().equals("+")) {
                if (isPrefix) {
                    operators.add((SqlOperator)GraphStdOperatorTable.UNARY_PLUS);
                    continue;
                }
                operators.add((SqlOperator)GraphStdOperatorTable.PLUS);
                continue;
            }
            if (tree.getText().equals("-")) {
                if (isPrefix) {
                    operators.add((SqlOperator)GraphStdOperatorTable.UNARY_MINUS);
                    continue;
                }
                operators.add((SqlOperator)GraphStdOperatorTable.MINUS);
                continue;
            }
            if (tree.getText().equals("*")) {
                operators.add((SqlOperator)GraphStdOperatorTable.MULTIPLY);
                continue;
            }
            if (tree.getText().equals("/")) {
                operators.add((SqlOperator)GraphStdOperatorTable.DIVIDE);
                continue;
            }
            if (tree.getText().equals("%")) {
                operators.add((SqlOperator)GraphStdOperatorTable.MOD);
                continue;
            }
            if (tree.getText().equals("=")) {
                operators.add((SqlOperator)GraphStdOperatorTable.EQUALS);
                continue;
            }
            if (tree.getText().equals("<>")) {
                operators.add((SqlOperator)GraphStdOperatorTable.NOT_EQUALS);
                continue;
            }
            if (tree.getText().equals("<")) {
                operators.add((SqlOperator)GraphStdOperatorTable.LESS_THAN);
                continue;
            }
            if (tree.getText().equals(">")) {
                operators.add((SqlOperator)GraphStdOperatorTable.GREATER_THAN);
                continue;
            }
            if (tree.getText().equals("<=")) {
                operators.add((SqlOperator)GraphStdOperatorTable.LESS_THAN_OR_EQUAL);
                continue;
            }
            if (tree.getText().equals(">=")) {
                operators.add((SqlOperator)GraphStdOperatorTable.GREATER_THAN_OR_EQUAL);
                continue;
            }
            if (tree.getText().equals("&")) {
                operators.add((SqlOperator)GraphStdOperatorTable.BIT_AND);
                continue;
            }
            if (tree.getText().equals("|")) {
                operators.add((SqlOperator)GraphStdOperatorTable.BIT_OR);
                continue;
            }
            if (tree.getText().equals("^")) {
                operators.add((SqlOperator)GraphStdOperatorTable.BIT_XOR);
                continue;
            }
            if (tree.getText().equals("<<")) {
                operators.add((SqlOperator)GraphStdOperatorTable.BIT_LEFT_SHIFT);
                continue;
            }
            if (tree.getText().equals(">>")) {
                operators.add((SqlOperator)GraphStdOperatorTable.BIT_RIGHT_SHIFT);
                continue;
            }
            throw new UnsupportedOperationException("operator " + tree.getText() + " is unsupported yet");
        }
        return operators;
    }

    public static TimeUnit createDurationUnit(String fieldName) {
        switch (fieldName.toUpperCase()) {
            case "YEARS": {
                return TimeUnit.YEAR;
            }
            case "QUARTERS": {
                return TimeUnit.QUARTER;
            }
            case "MONTHS": {
                return TimeUnit.MONTH;
            }
            case "WEEKS": {
                return TimeUnit.WEEK;
            }
            case "DAYS": {
                return TimeUnit.DAY;
            }
            case "HOURS": {
                return TimeUnit.HOUR;
            }
            case "MINUTES": {
                return TimeUnit.MINUTE;
            }
            case "SECONDS": {
                return TimeUnit.SECOND;
            }
            case "MILLISECONDS": {
                return TimeUnit.MILLISECOND;
            }
            case "MICROSECONDS": {
                return TimeUnit.MICROSECOND;
            }
            case "NANOSECONDS": {
                return TimeUnit.NANOSECOND;
            }
        }
        throw new UnsupportedOperationException("duration field name " + fieldName + " is unsupported yet");
    }

    public static RexNode createIntervalExpr(@Nullable RexNode value, TimeUnit unit, GraphBuilder builder) {
        SqlIntervalQualifier intervalQualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
        if (value == null) {
            return builder.getRexBuilder().makeIntervalLiteral(null, intervalQualifier);
        }
        if (value instanceof RexLiteral) {
            return builder.getRexBuilder().makeIntervalLiteral(new BigDecimal(((Number)((RexLiteral)value).getValueAs(Number.class)).toString()), intervalQualifier);
        }
        if (value instanceof RexGraphDynamicParam) {
            RexGraphDynamicParam param = (RexGraphDynamicParam)value;
            return ((GraphRexBuilder)builder.getRexBuilder()).makeGraphDynamicParam(builder.getTypeFactory().createSqlIntervalType(intervalQualifier), param.getName(), param.getIndex());
        }
        throw new IllegalArgumentException("cannot create interval expression from value " + value);
    }

    public static TimeUnit createExtractUnit(String fieldName) {
        return TimeUnit.valueOf((String)fieldName.toUpperCase());
    }

    public static ExprVisitorResult binaryCall(List<SqlOperator> operators, List<ExprVisitorResult> operands, GraphBuilder builder) {
        ObjectUtils.requireNonEmpty(operands, (String)"operands count should not be 0");
        if (operators.size() != operands.size() - 1) {
            throw new IllegalArgumentException("invalid operators count, should be equal with the count of operands minus 1");
        }
        RexNode expr = operands.get(0).getExpr();
        ArrayList<RelBuilder.AggCall> aggCalls = new ArrayList<RelBuilder.AggCall>();
        aggCalls.addAll(operands.get(0).getAggCalls());
        for (int i = 1; i < operands.size(); ++i) {
            expr = Utils.binaryCall(expr, operands.get(i).getExpr(), operators.get(i - 1), builder);
            aggCalls.addAll(operands.get(i).getAggCalls());
        }
        return new ExprVisitorResult(aggCalls, expr);
    }

    public static ExprVisitorResult binaryCall(SqlOperator operator, List<ExprVisitorResult> operands, GraphBuilder builder) {
        ObjectUtils.requireNonEmpty(operands, (String)"operands count should not be 0");
        RexNode expr = operands.get(0).getExpr();
        ArrayList<RelBuilder.AggCall> aggCalls = new ArrayList<RelBuilder.AggCall>();
        aggCalls.addAll(operands.get(0).getAggCalls());
        for (int i = 1; i < operands.size(); ++i) {
            expr = Utils.binaryCall(expr, operands.get(i).getExpr(), operator, builder);
            aggCalls.addAll(operands.get(i).getAggCalls());
        }
        return new ExprVisitorResult(aggCalls, expr);
    }

    private static RexNode binaryCall(RexNode left, RexNode right, SqlOperator operator, GraphBuilder builder) {
        if (operator.getKind() == SqlKind.MINUS && SqlTypeUtil.isOfSameTypeName((Collection)SqlTypeName.DATETIME_TYPES, (RelDataType)left.getType()) && SqlTypeUtil.isOfSameTypeName((Collection)SqlTypeName.DATETIME_TYPES, (RelDataType)right.getType())) {
            return builder.call(GraphStdOperatorTable.DATETIME_MINUS, left, right, Utils.createIntervalExpr(null, TimeUnit.MILLISECOND, builder));
        }
        return builder.call(operator, left, right);
    }

    public static ExprVisitorResult unaryCall(List<SqlOperator> operators, ExprVisitorResult operand, GraphBuilder builder) {
        return operators.isEmpty() ? operand : new ExprVisitorResult(operand.getAggCalls(), builder.call(operators.get(0), operand.getExpr()));
    }
}

