/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.client;

import com.alibaba.graphscope.common.client.HttpExecutionClient;
import com.alibaba.graphscope.common.client.RpcExecutionClient;
import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.client.type.ExecutionRequest;
import com.alibaba.graphscope.common.client.type.ExecutionResponseListener;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.QueryTimeoutConfig;

public abstract class ExecutionClient<C> {
    protected final ChannelFetcher<C> channelFetcher;

    public ExecutionClient(ChannelFetcher<C> channelFetcher) {
        this.channelFetcher = channelFetcher;
    }

    public abstract void submit(ExecutionRequest var1, ExecutionResponseListener var2, QueryTimeoutConfig var3) throws Exception;

    public abstract void close() throws Exception;

    public static class Factory {
        public static ExecutionClient create(Configs configs, ChannelFetcher channelFetcher) {
            switch (channelFetcher.getType()) {
                case RPC: {
                    return new RpcExecutionClient(configs, channelFetcher);
                }
                case HTTP: {
                    return new HttpExecutionClient(configs, channelFetcher);
                }
            }
            throw new IllegalArgumentException("unknown channel fetcher type");
        }
    }
}

