/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.client.channel;

import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.HiactorConfig;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HostURIChannelFetcher
implements ChannelFetcher<URI> {
    private static final String schema = "http";
    private Configs graphConfig;

    public HostURIChannelFetcher(Configs graphConfig) {
        this.graphConfig = graphConfig;
    }

    @Override
    public List<URI> fetch() {
        String hosts = HiactorConfig.HIACTOR_HOSTS.get(this.graphConfig);
        String[] hostsArr = hosts.split(",");
        return Arrays.asList(hostsArr).stream().map(k -> URI.create("http://" + k)).collect(Collectors.toList());
    }

    @Override
    public ChannelFetcher.Type getType() {
        return ChannelFetcher.Type.HTTP;
    }
}

