/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.client.channel;

import com.alibaba.graphscope.common.client.channel.ChannelFetcher;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.PegasusConfig;
import com.alibaba.graphscope.common.config.Utils;
import com.alibaba.pegasus.RpcChannel;
import java.util.ArrayList;
import java.util.List;

public class HostsRpcChannelFetcher
implements ChannelFetcher<RpcChannel> {
    private Configs config;

    public HostsRpcChannelFetcher(Configs config) {
        this.config = config;
    }

    @Override
    public List<RpcChannel> fetch() {
        List<String> hostAddresses = Utils.convertDotString(PegasusConfig.PEGASUS_HOSTS.get(this.config));
        ArrayList<RpcChannel> rpcChannels = new ArrayList<RpcChannel>();
        hostAddresses.forEach(k -> {
            String[] host = k.split(":");
            rpcChannels.add(new RpcChannel(host[0], Integer.valueOf(host[1]).intValue()));
        });
        return rpcChannels;
    }

    @Override
    public ChannelFetcher.Type getType() {
        return ChannelFetcher.Type.RPC;
    }
}

