/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.config;

import com.alibaba.graphscope.common.config.FileLoadType;
import com.alibaba.graphscope.common.config.YamlConfigs;
import com.alibaba.graphscope.common.utils.FileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.plan.Context;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Configs
implements Context {
    protected Properties properties = new Properties();

    public Configs(String file) throws IOException {
        this(file, FileLoadType.RELATIVE_PATH);
    }

    public Configs(String file, FileLoadType loadType) throws IOException, NotImplementedException {
        switch (loadType) {
            case RELATIVE_PATH: {
                this.properties.load(new FileInputStream(file));
                break;
            }
            default: {
                throw new NotImplementedException("unimplemented load type " + loadType);
            }
        }
    }

    public Configs(Map<String, String> configs) {
        if (configs != null && !configs.isEmpty()) {
            configs.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
        }
    }

    public String get(String name) {
        String value = System.getenv(name);
        if (value != null) {
            return value;
        }
        value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        return this.properties.getProperty(name);
    }

    public String get(String name, String defaultValue) {
        String value = System.getenv(name);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(name);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return this.properties.getProperty(name, defaultValue);
    }

    public Iterator<Object> getKeys() {
        return this.properties.keys().asIterator();
    }

    public String toString() {
        return this.properties.toString();
    }

    public <C> @Nullable C unwrap(Class<C> aClass) {
        return aClass.isInstance(this) ? (C)aClass.cast(this) : null;
    }

    public static class Factory {
        public static Configs create(String file) throws Exception {
            switch (FileUtils.getFormatType(file)) {
                case YAML: {
                    return new YamlConfigs(file);
                }
                case PROPERTIES: {
                    return new Configs(file);
                }
            }
            throw new UnsupportedOperationException("can not initiate Configs from the file " + file);
        }
    }
}

