/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.config;

import com.alibaba.graphscope.common.config.Config;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.config.Utils;
import java.util.Collections;
import java.util.List;

public class PlannerConfig {
    public static final Config<Boolean> GRAPH_PLANNER_IS_ON = Config.boolConfig("graph.planner.is.on", false);
    public static final Config<String> GRAPH_PLANNER_OPT = Config.stringConfig("graph.planner.opt", "RBO");
    public static final Config<String> GRAPH_PLANNER_RULES = Config.stringConfig("graph.planner.rules", "FilterIntoJoinRule,FilterMatchRule,ExtendIntersectRule,ExpandGetVFusionRule");
    public static final Config<Integer> GRAPH_PLANNER_CBO_GLOGUE_SIZE = Config.intConfig("graph.planner.cbo.glogue.size", 3);
    public static final Config<Integer> JOIN_MIN_PATTERN_SIZE = Config.intConfig("graph.planner.join.min.pattern.size", 5);
    public static final Config<Integer> JOIN_COST_FACTOR_1 = Config.intConfig("graph.planner.join.cost.factor.1", 1);
    public static final Config<Integer> JOIN_COST_FACTOR_2 = Config.intConfig("graph.planner.join.cost.factor.2", 1);
    public static final Config<Boolean> LABEL_CONSTRAINTS_ENABLED = Config.boolConfig("graph.planner.label.constraints.enabled", false);
    public static final Config<Integer> INTERSECT_COST_FACTOR = Config.intConfig("graph.planner.intersect.cost.factor", 1);
    public static final Config<Integer> JOIN_QUEUE_CAPACITY = Config.intConfig("graph.planner.join.queue.capacity", 3);
    public static final Config<Boolean> JOIN_BY_EDGE_ENABLED = Config.boolConfig("graph.planner.join.by.edge.enabled", false);
    public static final Config<Integer> GRAPH_PLANNER_GROUP_SIZE = Config.intConfig("graph.planner.group.size", 8);
    public static final Config<Integer> GRAPH_PLANNER_GROUP_CLEAR_INTERVAL_MINUTES = Config.intConfig("graph.planner.group.clear.interval.minutes", 30);
    private final Configs configs;
    private final List<String> rules;

    public PlannerConfig(Configs configs) {
        this.configs = configs;
        this.rules = Utils.convertDotString(GRAPH_PLANNER_RULES.get(configs));
    }

    public boolean isOn() {
        return GRAPH_PLANNER_IS_ON.get(this.configs);
    }

    public Opt getOpt() {
        return Opt.valueOf(GRAPH_PLANNER_OPT.get(this.configs));
    }

    public List<String> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public int getGlogueSize() {
        return GRAPH_PLANNER_CBO_GLOGUE_SIZE.get(this.configs);
    }

    public int getJoinMinPatternSize() {
        return JOIN_MIN_PATTERN_SIZE.get(this.configs);
    }

    public int getJoinCostFactor1() {
        return JOIN_COST_FACTOR_1.get(this.configs);
    }

    public int getJoinCostFactor2() {
        return JOIN_COST_FACTOR_2.get(this.configs);
    }

    public boolean labelConstraintsEnabled() {
        return LABEL_CONSTRAINTS_ENABLED.get(this.configs);
    }

    public int getIntersectCostFactor() {
        return INTERSECT_COST_FACTOR.get(this.configs);
    }

    public boolean isJoinByEdgeEnabled() {
        return JOIN_BY_EDGE_ENABLED.get(this.configs);
    }

    public int getJoinQueueCapacity() {
        return JOIN_QUEUE_CAPACITY.get(this.configs);
    }

    public String getJoinByForeignKeyUri() {
        return GraphConfig.GRAPH_FOREIGN_KEY_URI.get(this.configs);
    }

    public int getPlannerGroupSize() {
        return GRAPH_PLANNER_GROUP_SIZE.get(this.configs);
    }

    public int getPlannerGroupClearIntervalMinutes() {
        return GRAPH_PLANNER_GROUP_CLEAR_INTERVAL_MINUTES.get(this.configs);
    }

    public String toString() {
        return "PlannerConfig{isOn=" + this.isOn() + ", opt=" + this.getOpt() + ", rules=" + this.rules + ", glogueSize=" + this.getGlogueSize() + "}";
    }

    public static enum Opt {
        RBO,
        CBO;

    }
}

