/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate;

import com.alibaba.graphscope.common.exception.OpArgIllegalException;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiConst;
import com.alibaba.graphscope.common.jna.type.FfiDataType;
import com.alibaba.graphscope.common.jna.type.FfiNameIdOpt;
import com.alibaba.graphscope.common.jna.type.FfiNameOrId;
import com.alibaba.graphscope.common.jna.type.FfiProperty;
import com.alibaba.graphscope.common.jna.type.FfiPropertyOpt;
import com.alibaba.graphscope.common.jna.type.FfiVariable;

public class ArgUtils {
    public static String LABEL = "~label";
    public static String ID = "~id";
    public static String LEN = "~len";
    public static String PROPERTY_ALL = "~all";
    public static String SEED_KEY = "REPEATABLE";

    public static FfiConst.ByValue asConst(int id) {
        FfiConst.ByValue ffiConst = new FfiConst.ByValue();
        ffiConst.dataType = FfiDataType.I32;
        ffiConst.int32 = id;
        return ffiConst;
    }

    public static FfiConst.ByValue asConst(long id) {
        FfiConst.ByValue ffiConst = new FfiConst.ByValue();
        ffiConst.dataType = FfiDataType.I64;
        ffiConst.int64 = id;
        return ffiConst;
    }

    public static FfiConst.ByValue asConst(String str) {
        FfiConst.ByValue ffiConst = new FfiConst.ByValue();
        ffiConst.dataType = FfiDataType.Str;
        ffiConst.cstr = str;
        return ffiConst;
    }

    public static FfiNameOrId.ByValue asNameOrId(String tag) {
        FfiNameOrId.ByValue ffiName = new FfiNameOrId.ByValue();
        if (tag != null && !tag.isEmpty()) {
            ffiName.name = tag;
            ffiName.opt = FfiNameIdOpt.Name;
        }
        return ffiName;
    }

    public static FfiNameOrId.ByValue asNameOrId(int tag) {
        FfiNameOrId.ByValue ffiName = new FfiNameOrId.ByValue();
        ffiName.nameId = tag;
        ffiName.opt = FfiNameIdOpt.Id;
        return ffiName;
    }

    public static FfiNameOrId.ByValue asNoneNameOrId() {
        return new FfiNameOrId.ByValue();
    }

    public static FfiProperty.ByValue asKey(String property) {
        FfiProperty.ByValue ffiProperty = new FfiProperty.ByValue();
        if (property != null && !property.isEmpty()) {
            if (property.equals(LABEL)) {
                ffiProperty.opt = FfiPropertyOpt.Label;
            } else if (property.equals(ID)) {
                ffiProperty.opt = FfiPropertyOpt.Id;
            } else if (property.equals(LEN)) {
                ffiProperty.opt = FfiPropertyOpt.Len;
            } else {
                ffiProperty.opt = FfiPropertyOpt.Key;
                ffiProperty.key = ArgUtils.asNameOrId(property);
            }
        }
        return ffiProperty;
    }

    public static FfiProperty.ByValue asNoneKey() {
        return new FfiProperty.ByValue();
    }

    public static FfiVariable.ByValue asVar(String tag, String property) {
        FfiVariable.ByValue ffiVar = new FfiVariable.ByValue();
        ffiVar.tag = ArgUtils.asNameOrId(tag);
        ffiVar.property = ArgUtils.asKey(property);
        return ffiVar;
    }

    public static FfiVariable.ByValue asNoneVar() {
        return new FfiVariable.ByValue();
    }

    public static FfiAlias.ByValue asAlias(String aliasName, boolean isQueryGiven) {
        FfiAlias.ByValue ffiAlias = new FfiAlias.ByValue();
        ffiAlias.alias = ArgUtils.asNameOrId(aliasName);
        ffiAlias.isQueryGiven = isQueryGiven;
        return ffiAlias;
    }

    public static FfiAlias.ByValue asAlias(int aliasId) {
        FfiAlias.ByValue ffiAlias = new FfiAlias.ByValue();
        ffiAlias.alias = ArgUtils.asNameOrId(aliasId);
        ffiAlias.isQueryGiven = true;
        return ffiAlias;
    }

    public static FfiAlias.ByValue asNoneAlias() {
        FfiAlias.ByValue ffiAlias = new FfiAlias.ByValue();
        ffiAlias.alias = ArgUtils.asNoneNameOrId();
        ffiAlias.isQueryGiven = false;
        return ffiAlias;
    }

    public static String propertyName(FfiProperty.ByValue property) {
        switch (property.opt) {
            case None: {
                return "";
            }
            case Id: {
                return ID;
            }
            case Label: {
                return LABEL;
            }
            case Len: {
                return LEN;
            }
            case Key: {
                return property.key.name;
            }
        }
        throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "invalid type");
    }

    public static String tagName(FfiNameOrId.ByValue tag) {
        switch (tag.opt) {
            case None: {
                return "";
            }
            case Name: {
                return tag.name;
            }
        }
        throw new OpArgIllegalException(OpArgIllegalException.Cause.INVALID_TYPE, "invalid type");
    }
}

