/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate.strategy;

import com.alibaba.graphscope.common.intermediate.ArgAggFn;
import com.alibaba.graphscope.common.intermediate.InterOpCollection;
import com.alibaba.graphscope.common.intermediate.operator.GroupOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.ScanFusionOp;
import com.alibaba.graphscope.common.intermediate.strategy.InterOpStrategy;
import com.alibaba.graphscope.common.jna.type.FfiAggOpt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class SourceCountFusionStrategy
implements InterOpStrategy {
    public static SourceCountFusionStrategy INSTANCE = new SourceCountFusionStrategy();

    private SourceCountFusionStrategy() {
    }

    @Override
    public void apply(InterOpCollection opCollection) {
        List<InterOpBase> original = opCollection.unmodifiableCollection();
        for (int i = original.size() - 2; i >= 0; --i) {
            InterOpBase cur = original.get(i);
            ArgAggFn next = this.nextCount(original, i);
            if (!(cur instanceof ScanFusionOp) || cur.getAlias().isPresent() || next == null) continue;
            ((ScanFusionOp)cur).setCountOnly(true);
            opCollection.replaceInterOp(i + 1, this.createSumOp(next));
        }
    }

    private ArgAggFn nextCount(List<InterOpBase> original, int cur) {
        int next = cur + 1;
        if (next >= 0 && next < original.size() && original.get(next) instanceof GroupOp) {
            List groupValues;
            List groupKeys;
            GroupOp groupOp = (GroupOp)original.get(next);
            Optional<OpArg> groupKeysOpt = groupOp.getGroupByKeys();
            Optional<OpArg> groupValuesOpt = groupOp.getGroupByValues();
            if (groupKeysOpt.isPresent() && (groupKeys = (List)groupKeysOpt.get().applyArg()).isEmpty() && groupValuesOpt.isPresent() && (groupValues = (List)groupValuesOpt.get().applyArg()).size() == 1 && ((ArgAggFn)groupValues.get(0)).getAggregate() == FfiAggOpt.Count) {
                return (ArgAggFn)groupValues.get(0);
            }
        }
        return null;
    }

    private GroupOp createSumOp(ArgAggFn count) {
        GroupOp sum = new GroupOp();
        sum.setGroupByKeys(new OpArg(ImmutableList.of()));
        sum.setGroupByValues(new OpArg(ImmutableList.of((Object)new ArgAggFn(FfiAggOpt.Sum, count.getAlias(), count.getVar()))));
        return sum;
    }
}

