/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.function;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.ir.meta.function.BuiltInFunction;
import com.alibaba.graphscope.common.ir.meta.function.FunctionMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.type.GraphInferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.yaml.snakeyaml.Yaml;

public class GraphFunctions {
    public static final String FUNCTION_PREFIX = "gs.function.";
    private final Map<String, FunctionMeta> functionMetaMap = Maps.newHashMap();
    private static GraphFunctions instance;

    public static GraphFunctions instance(Configs configs) {
        if (instance == null) {
            instance = new GraphFunctions(configs);
        }
        return instance;
    }

    private GraphFunctions(Configs configs) {
        this.registerBuiltInFunctions();
        this.registerConfigFunctions(configs);
    }

    private void registerBuiltInFunctions() {
        for (BuiltInFunction function : BuiltInFunction.values()) {
            FunctionMeta meta = new FunctionMeta(function);
            this.functionMetaMap.put(function.getSignature(), meta);
        }
    }

    private void registerConfigFunctions(Configs configs) {
        try (InputStream stream = this.loadConfigAsStream(configs);){
            Object functions;
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(stream);
            if (map != null && (functions = map.get("graph_functions")) instanceof List) {
                for (Object function : (List)functions) {
                    String functionYaml = yaml.dump(function);
                    StoredProcedureMeta meta = StoredProcedureMeta.Deserializer.perform(new ByteArrayInputStream(functionYaml.getBytes(StandardCharsets.UTF_8)));
                    this.functionMetaMap.put(meta.getName(), new FunctionMeta(meta));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream loadConfigAsStream(Configs configs) throws Exception {
        File file;
        String functionConfig = GraphConfig.GRAPH_FUNCTIONS_URI.get(configs);
        if (!functionConfig.isEmpty() && (file = new File(functionConfig)).exists()) {
            return new FileInputStream(file);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/graph_functions.yaml");
    }

    public FunctionMeta getFunction(String functionName) {
        FunctionMeta meta = this.functionMetaMap.get(functionName);
        if (meta == null) {
            meta = new FunctionMeta(functionName, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.ANY), OperandTypes.VARIADIC, GraphInferTypes.FIRST_KNOWN);
        }
        return meta;
    }
}

