/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.glogue;

import com.alibaba.graphscope.common.ir.meta.glogue.CountHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.EdgeCostEstimator;
import com.alibaba.graphscope.common.ir.meta.glogue.Utils;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ExtendWeightEstimator {
    private final CountHandler handler;
    private final EdgeCostEstimator.Extend edgeCostEstimator;

    public ExtendWeightEstimator(CountHandler handler) {
        this.handler = handler;
        this.edgeCostEstimator = new EdgeCostEstimator.Extend(handler);
    }

    public double estimate(PatternEdge edge, PatternVertex target) {
        PatternVertex extendFrom = Utils.getExtendFromVertex(edge, target);
        Pattern vertexPattern = new Pattern(extendFrom);
        Pattern edgePattern = new Pattern();
        edgePattern.addVertex(edge.getSrcVertex());
        edgePattern.addVertex(edge.getDstVertex());
        edgePattern.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
        return this.handler.handle(edgePattern) / this.handler.handle(vertexPattern);
    }

    public double estimate(List<PatternEdge> edges, PatternVertex target) {
        Collections.sort(edges, Comparator.comparingDouble(edge -> this.estimate((PatternEdge)edge, target)));
        Pattern pattern = new Pattern();
        double totalWeight = 0.0;
        ArrayList extendFromVertices = Lists.newArrayList();
        for (PatternEdge edge2 : edges) {
            pattern.addVertex(edge2.getSrcVertex());
            pattern.addVertex(edge2.getDstVertex());
            pattern.addEdge(edge2.getSrcVertex(), edge2.getDstVertex(), edge2);
            pattern.reordering();
            extendFromVertices.add(Utils.getExtendFromVertex(edge2, target));
            double weight = edges.size() == 1 ? this.edgeCostEstimator.estimate(null, edges.get(0), target).getExpandRows() : this.handler.handle(pattern);
            for (PatternVertex vertex : extendFromVertices) {
                weight /= this.handler.handle(new Pattern(vertex));
            }
            totalWeight += weight;
        }
        return totalWeight;
    }
}

