/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.glogue;

import com.alibaba.graphscope.common.ir.meta.glogue.Utils;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueQuery;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PathExpandRange;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrimitiveCountEstimator {
    private final GlogueQuery gq;

    public PrimitiveCountEstimator(GlogueQuery gq) {
        this.gq = gq;
    }

    public @Nullable Double estimate(Pattern pattern) {
        Double countFromGlogue;
        if (Utils.canLookUpFromGlogue(pattern, this.gq.getMaxPatternSize()) && (countFromGlogue = this.gq.getRowCount(pattern, true)) != null) {
            return countFromGlogue;
        }
        PatternVertex intersect = this.getIntersectVertex(pattern);
        if (intersect != null) {
            Set<PatternEdge> edges = pattern.getEdgesOf(intersect);
            if (edges.isEmpty()) {
                return this.estimate(intersect);
            }
            double count = 1.0;
            for (PatternEdge edge : edges) {
                count *= this.estimate(edge);
            }
            double intersectCount = this.estimate(intersect);
            return count /= Math.pow(intersectCount, edges.size() - 1);
        }
        return null;
    }

    public double estimate(PatternVertex vertex) {
        double sum = 0.0;
        for (Integer typeId : vertex.getVertexTypeIds()) {
            sum += this.gq.getRowCount(new Pattern(new SinglePatternVertex(typeId)), false).doubleValue();
        }
        return sum * vertex.getElementDetails().getSelectivity();
    }

    public double estimate(PatternEdge edge) {
        double sum = 0.0;
        for (EdgeTypeId typeId : edge.getEdgeTypeIds()) {
            sum += this.estimate(edge, typeId);
        }
        if (edge.isBoth()) {
            sum *= 2.0;
        }
        PatternVertex src = edge.getSrcVertex();
        PatternVertex dst = edge.getDstVertex();
        return sum * edge.getElementDetails().getSelectivity() * src.getElementDetails().getSelectivity() * dst.getElementDetails().getSelectivity();
    }

    public double estimate(PatternEdge edge, EdgeTypeId typeId) {
        int minHop = 1;
        int maxHop = 1;
        PathExpandRange range = edge.getElementDetails().getRange();
        if (range != null) {
            minHop = range.getOffset();
            maxHop = range.getOffset() + range.getFetch() - 1;
        }
        double sum = 0.0;
        for (int hop = minHop; hop <= maxHop; ++hop) {
            sum += this.estimate(edge, typeId, hop);
        }
        return sum;
    }

    public double estimate(PatternEdge edge, EdgeTypeId typeId, int hops) {
        SinglePatternVertex srcVertex = new SinglePatternVertex(typeId.getSrcLabelId(), 0);
        SinglePatternVertex dstVertex = new SinglePatternVertex(typeId.getDstLabelId(), 1);
        if (hops == 0) {
            return this.estimate(srcVertex);
        }
        Pattern edgePattern = new Pattern();
        edgePattern.addVertex(srcVertex);
        edgePattern.addVertex(dstVertex);
        edgePattern.addEdge((PatternVertex)srcVertex, (PatternVertex)dstVertex, new SinglePatternEdge(srcVertex, dstVertex, typeId, 0));
        edgePattern.reordering();
        return Math.pow(this.gq.getRowCount(edgePattern, false), hops) / Math.pow(this.estimate(dstVertex), hops - 1);
    }

    private @Nullable PatternVertex getIntersectVertex(Pattern pattern) {
        int edgeNum = pattern.getEdgeNumber();
        for (PatternVertex vertex : pattern.getVertexSet()) {
            if (pattern.getDegree(vertex) != edgeNum) continue;
            return vertex;
        }
        return null;
    }
}

