/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.glogue;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.ElementDetails;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;

public class Utils {
    public static PatternVertex getExtendFromVertex(PatternEdge edge, PatternVertex target) {
        if (edge.getSrcVertex().equals(target)) {
            return edge.getDstVertex();
        }
        if (edge.getDstVertex().equals(target)) {
            return edge.getSrcVertex();
        }
        throw new IllegalArgumentException("target vertex must be one of the edge's src or dst, target: " + target + ", edge: " + edge);
    }

    public static PatternDirection getExtendDirection(PatternEdge edge, PatternVertex target) {
        if (edge.isBoth()) {
            return PatternDirection.BOTH;
        }
        if (edge.getSrcVertex().equals(target)) {
            return PatternDirection.IN;
        }
        if (edge.getDstVertex().equals(target)) {
            return PatternDirection.OUT;
        }
        throw new IllegalArgumentException("target vertex must be one of the edge's src or dst, target: " + target + ", edge: " + edge);
    }

    public static List<Integer> getVertexTypeIds(RelNode rel) {
        List fields = rel.getRowType().getFieldList();
        Preconditions.checkArgument((!fields.isEmpty() && ((RelDataTypeField)fields.get(0)).getType() instanceof GraphSchemaType ? 1 : 0) != 0, (Object)"graph operator should have graph schema type");
        GraphSchemaType schemaType = (GraphSchemaType)((RelDataTypeField)fields.get(0)).getType();
        GraphLabelType labelType = schemaType.getLabelType();
        return labelType.getLabelsEntry().stream().map(k -> k.getLabelId()).collect(Collectors.toList());
    }

    public static List<EdgeTypeId> getEdgeTypeIds(RelNode rel) {
        List fields = rel.getRowType().getFieldList();
        Preconditions.checkArgument((!fields.isEmpty() && ((RelDataTypeField)fields.get(0)).getType() instanceof GraphSchemaType ? 1 : 0) != 0, (Object)"graph operator should have graph schema type");
        GraphSchemaType schemaType = (GraphSchemaType)((RelDataTypeField)fields.get(0)).getType();
        GraphLabelType labelType = schemaType.getLabelType();
        return labelType.getLabelsEntry().stream().map(k -> new EdgeTypeId(Objects.requireNonNull(k.getSrcLabelId()), Objects.requireNonNull(k.getDstLabelId()), k.getLabelId())).collect(Collectors.toList());
    }

    public static boolean canLookUpFromGlogue(Pattern pattern, int maxPatternSizeInGlogue) {
        ElementDetails details;
        if (pattern.getVertexNumber() > maxPatternSizeInGlogue) {
            return false;
        }
        for (PatternVertex vertex : pattern.getVertexSet()) {
            if (vertex.getVertexTypeIds().size() != 1) {
                return false;
            }
            details = vertex.getElementDetails();
            if (details == null || Double.compare(details.getSelectivity(), 1.0) == 0 && !details.isOptional()) continue;
            return false;
        }
        for (PatternEdge edge : pattern.getEdgeSet()) {
            if (edge.getEdgeTypeIds().size() != 1) {
                return false;
            }
            if (edge.isBoth()) {
                return false;
            }
            details = edge.getElementDetails();
            if (details == null || Double.compare(details.getSelectivity(), 1.0) == 0 && details.getRange() == null && !details.isOptional()) continue;
            return false;
        }
        return true;
    }

    public static PatternEdge convert(ExtendEdge edge, PatternVertex querySrc, PatternVertex queryDst) {
        PatternVertex dst;
        PatternVertex src;
        switch (edge.getDirection()) {
            case OUT: 
            case BOTH: {
                src = querySrc;
                dst = queryDst;
                break;
            }
            default: {
                src = queryDst;
                dst = querySrc;
            }
        }
        return edge.getEdgeTypeIds().size() == 1 ? new SinglePatternEdge(src, dst, edge.getEdgeTypeId(), 0, edge.getDirection() == PatternDirection.BOTH, edge.getElementDetails()) : new FuzzyPatternEdge(src, dst, Lists.newArrayList(edge.getEdgeTypeIds()), 0, edge.getDirection() == PatternDirection.BOTH, edge.getElementDetails());
    }
}

