/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.procedure;

import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class GraphStoredProcedures {
    public static final String META_PROCEDURE_PREFIX = "gs.procedure.meta.";
    private static final Logger logger = LoggerFactory.getLogger(GraphStoredProcedures.class);
    private final Map<String, StoredProcedureMeta> storedProcedureMetaMap;
    private final IrMetaReader metaReader;

    public GraphStoredProcedures() {
        this.metaReader = null;
        this.storedProcedureMetaMap = Maps.newLinkedHashMap();
        this.registerBuiltInProcedures();
    }

    public GraphStoredProcedures(InputStream metaStream, IrMetaReader metaReader) {
        Yaml yaml = new Yaml();
        Map yamlAsMap = (Map)yaml.load(metaStream);
        List procedureList = (List)yamlAsMap.get("stored_procedures");
        this.storedProcedureMetaMap = ObjectUtils.isEmpty((Object)procedureList) ? Maps.newLinkedHashMap() : procedureList.stream().map(k -> {
            try {
                String procedureYaml = yaml.dump(k);
                return StoredProcedureMeta.Deserializer.perform(new ByteArrayInputStream(procedureYaml.getBytes()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(StoredProcedureMeta::getName, k -> k));
        this.metaReader = metaReader;
        this.registerBuiltInProcedures();
    }

    private void registerBuiltInProcedures() {
        String schemaProcedure = "gs.procedure.meta.schema";
        RelDataTypeFactory typeFactory = StoredProcedureMeta.typeFactory;
        this.storedProcedureMetaMap.put(schemaProcedure, new StoredProcedureMeta(schemaProcedure, StoredProcedureMeta.Mode.SCHEMA, "", "", typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.CHAR)), (List)ImmutableList.of((Object)"schema")), (List<StoredProcedureMeta.Parameter>)ImmutableList.of(), (Map<String, Object>)ImmutableMap.of()));
        String statsProcedure = "gs.procedure.meta.statistics";
        this.storedProcedureMetaMap.put(statsProcedure, new StoredProcedureMeta(statsProcedure, StoredProcedureMeta.Mode.SCHEMA, "", "", typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.CHAR)), (List)ImmutableList.of((Object)"statistics")), (List<StoredProcedureMeta.Parameter>)ImmutableList.of(), (Map<String, Object>)ImmutableMap.of()));
    }

    public @Nullable StoredProcedureMeta getStoredProcedure(String procedureName) {
        return this.getStoredProcedure(procedureName, true);
    }

    private @Nullable StoredProcedureMeta getStoredProcedure(String procedureName, boolean update) {
        StoredProcedureMeta cachedProcedure = this.storedProcedureMetaMap.get(procedureName);
        if (cachedProcedure == null && update) {
            try {
                IrMeta meta = this.metaReader.readMeta();
                if (meta != null && meta.getStoredProcedures() != null) {
                    return meta.getStoredProcedures().getStoredProcedure(procedureName, false);
                }
            }
            catch (Exception e) {
                logger.warn("failed to read meta data, error is {}", (Throwable)e);
            }
        }
        return cachedProcedure;
    }
}

