/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.reader;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.ir.meta.GraphId;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.SnapshotId;
import com.alibaba.graphscope.common.ir.meta.procedure.GraphStoredProcedures;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphStatistics;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaInputStream;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.javatuples.Pair;
import org.yaml.snakeyaml.Yaml;

public class HttpIrMetaReader
implements IrMetaReader {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json; utf-8";
    private final HttpClient httpClient;
    private final Configs configs;

    public HttpIrMetaReader(Configs configs) {
        this.configs = configs;
        this.httpClient = HttpClient.newBuilder().build();
    }

    @Override
    public IrMeta readMeta() throws IOException {
        try {
            HttpResponse<String> response = this.sendRequest(GraphConfig.GRAPH_META_SCHEMA_URI.get(this.configs));
            String res = response.body();
            Preconditions.checkArgument((response.statusCode() == 200 ? 1 : 0) != 0, (String)"read meta data fail, status code: %s, error message: %s", (int)response.statusCode(), (Object)res);
            Pair<GraphId, String> metaPair = this.convertMetaFromJsonToYaml(res);
            String metaInYaml = (String)metaPair.getValue1();
            return new IrMeta((GraphId)metaPair.getValue0(), SnapshotId.createEmpty(), new IrGraphSchema(new SchemaInputStream(new ByteArrayInputStream(metaInYaml.getBytes(StandardCharsets.UTF_8)), SchemaSpec.Type.FLEX_IN_YAML)), new GraphStoredProcedures(new ByteArrayInputStream(metaInYaml.getBytes(StandardCharsets.UTF_8)), this));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IrGraphStatistics readStats(GraphId graphId) throws IOException {
        try {
            Preconditions.checkArgument((graphId.getId() != null ? 1 : 0) != 0, (Object)"graph id should not be null in http meta reader");
            HttpResponse<String> response = this.sendRequest(String.format(GraphConfig.GRAPH_META_STATISTICS_URI.get(this.configs), graphId.getId()));
            String res = response.body();
            Preconditions.checkArgument((response.statusCode() == 200 ? 1 : 0) != 0, (String)"read graph statistics fail, status code: %s, error message: %s", (int)response.statusCode(), (Object)res);
            return new IrGraphStatistics(new ByteArrayInputStream(res.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean syncStatsEnabled(GraphId graphId) throws IOException {
        try {
            HttpResponse<String> response = this.sendRequest(GraphConfig.GRAPH_META_SCHEMA_URI.get(this.configs));
            String res = response.body();
            Preconditions.checkArgument((response.statusCode() == 200 ? 1 : 0) != 0, (String)"read service status fail, status code: %s, error message: %s", (int)response.statusCode(), (Object)res);
            return this.getStaticEnabled(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpResponse<String> sendRequest(String requestUri) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(requestUri)).headers(CONTENT_TYPE, APPLICATION_JSON).GET().build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private Pair<GraphId, String> convertMetaFromJsonToYaml(String metaInJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(metaInJson);
        Map rootMap = (Map)mapper.convertValue((Object)rootNode, Map.class);
        Map metaMap = (Map)rootMap.get("graph");
        GraphId graphId = new GraphId(metaMap.get("id"));
        Yaml yaml = new Yaml();
        return Pair.with(graphId, (Object)yaml.dump((Object)metaMap));
    }

    private boolean getStaticEnabled(String metaInJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(metaInJson);
        Map rootMap = (Map)mapper.convertValue((Object)rootNode, Map.class);
        if (rootMap.containsKey("statistics_enabled")) {
            return (Boolean)rootMap.get("statistics_enabled");
        }
        return false;
    }
}

