/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.reader;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.ir.meta.GraphId;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.procedure.GraphStoredProcedures;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.alibaba.graphscope.common.ir.meta.schema.FileFormatType;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphStatistics;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaInputStream;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.alibaba.graphscope.common.utils.FileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalIrMetaReader
implements IrMetaReader {
    private static final Logger logger = LoggerFactory.getLogger(LocalIrMetaReader.class);
    private final Configs configs;

    public LocalIrMetaReader(Configs configs) {
        this.configs = configs;
    }

    @Override
    public IrMeta readMeta() throws IOException {
        String schemaUri = Objects.requireNonNull(GraphConfig.GRAPH_META_SCHEMA_URI.get(this.configs), "ir meta path not exist");
        URI schemaURI = URI.create(schemaUri);
        Path schemaPath = schemaURI.getScheme() == null ? Path.of(schemaURI.getPath(), new String[0]) : Path.of(schemaURI);
        FileFormatType formatType = FileUtils.getFormatType(schemaUri);
        SchemaSpec.Type schemaSpec = formatType == FileFormatType.YAML ? SchemaSpec.Type.FLEX_IN_YAML : SchemaSpec.Type.IR_CORE_IN_JSON;
        IrGraphSchema graphSchema = new IrGraphSchema(new SchemaInputStream(new FileInputStream(schemaPath.toFile()), schemaSpec));
        IrMeta irMeta = formatType == FileFormatType.YAML ? new IrMeta(graphSchema, new GraphStoredProcedures(new FileInputStream(schemaUri), this)) : new IrMeta(graphSchema);
        return irMeta;
    }

    @Override
    public IrGraphStatistics readStats(GraphId graphId) throws IOException {
        String statsUri = GraphConfig.GRAPH_META_STATISTICS_URI.get(this.configs);
        if (statsUri.isEmpty()) {
            return null;
        }
        URI statsURI = URI.create(statsUri);
        Path statsPath = statsURI.getScheme() == null ? Path.of(statsURI.getPath(), new String[0]) : Path.of(statsURI);
        return new IrGraphStatistics(new FileInputStream(statsPath.toFile()));
    }

    @Override
    public boolean syncStatsEnabled(GraphId graphId) {
        String statsUri = GraphConfig.GRAPH_META_STATISTICS_URI.get(this.configs);
        return !statsUri.isEmpty();
    }
}

