/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.exception.FrontendException;
import com.alibaba.graphscope.common.ir.meta.schema.GraphOptTable;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.proto.frontend.Code;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphOptSchema
implements RelOptSchema {
    private RelOptCluster optCluster;
    private IrGraphSchema rootSchema;

    public GraphOptSchema(@Nullable RelOptCluster optCluster, IrGraphSchema rootSchema) {
        this.optCluster = optCluster;
        this.rootSchema = Objects.requireNonNull(rootSchema);
    }

    public RelOptTable getTableForMember(List<String> tableName) {
        ObjectUtils.requireNonEmpty(tableName);
        String labelName = tableName.get(0);
        try {
            GraphElement element = this.rootSchema.getElement(labelName);
            return this.createRelOptTable(tableName, element);
        }
        catch (TypeNotFoundException e) {
            throw new FrontendException(Code.LABEL_NOT_FOUND, "Table '" + labelName + "' not found", e);
        }
    }

    private RelOptTable createRelOptTable(List<String> tableName, GraphElement element) {
        return new GraphOptTable(this, tableName, element);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.optCluster.getTypeFactory();
    }

    public IrGraphSchema getRootSchema() {
        return this.rootSchema;
    }

    public void registerRules(RelOptPlanner relOptPlanner) {
    }
}

