/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.SchemaInputStream;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpecManager;
import com.alibaba.graphscope.groot.common.exception.PropertyNotFoundException;
import com.alibaba.graphscope.groot.common.exception.TypeNotFoundException;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class IrGraphSchema
implements GraphSchema {
    private final GraphSchema graphSchema;
    private final boolean isColumnId;
    private final SchemaSpecManager specManager;

    public IrGraphSchema(SchemaInputStream schemaInputStream) throws IOException {
        this.isColumnId = false;
        String content = new String(schemaInputStream.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        schemaInputStream.getInputStream().close();
        SchemaSpec spec = new SchemaSpec(schemaInputStream.getType(), content);
        this.graphSchema = spec.convert();
        this.specManager = new SchemaSpecManager(this, spec);
    }

    public IrGraphSchema(GraphSchema graphSchema, boolean isColumnId) {
        this.graphSchema = graphSchema;
        this.isColumnId = isColumnId;
        this.specManager = new SchemaSpecManager(this);
    }

    public boolean isColumnId() {
        return this.isColumnId;
    }

    public String getSchemaSpec(SchemaSpec.Type type) {
        return this.specManager.getSpec(type).getContent();
    }

    public GraphElement getElement(String s) throws TypeNotFoundException {
        return this.graphSchema.getElement(s);
    }

    public GraphElement getElement(int i) throws TypeNotFoundException {
        return this.graphSchema.getElement(i);
    }

    public List<GraphVertex> getVertexList() {
        return this.graphSchema.getVertexList();
    }

    public List<GraphEdge> getEdgeList() {
        return this.graphSchema.getEdgeList();
    }

    public Integer getPropertyId(String s) throws PropertyNotFoundException {
        return this.graphSchema.getPropertyId(s);
    }

    public String getPropertyName(int i) throws PropertyNotFoundException {
        return this.graphSchema.getPropertyName(i);
    }

    public Map<GraphElement, GraphProperty> getPropertyList(String s) {
        return this.graphSchema.getPropertyList(s);
    }

    public Map<GraphElement, GraphProperty> getPropertyList(int i) {
        return this.graphSchema.getPropertyList(i);
    }

    public String getVersion() {
        return this.graphSchema.getVersion();
    }

    protected GraphSchema getGraphSchema() {
        return this.graphSchema;
    }
}

