/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.alibaba.graphscope.groot.common.util.IrSchemaParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SchemaSpecManager {
    private static final Logger logger = LoggerFactory.getLogger(SchemaSpecManager.class);
    private final IrGraphSchema parent;
    private final List<SchemaSpec> specifications;

    public SchemaSpecManager(IrGraphSchema parent) {
        this.parent = parent;
        this.specifications = Lists.newArrayList((Object[])new SchemaSpec[]{this.convert(null, SchemaSpec.Type.IR_CORE_IN_JSON)});
    }

    public SchemaSpecManager(IrGraphSchema parent, SchemaSpec input) {
        this.parent = parent;
        this.specifications = Lists.newArrayList((Object[])new SchemaSpec[]{input});
    }

    public SchemaSpec getSpec(SchemaSpec.Type type) {
        for (SchemaSpec spec : this.specifications) {
            if (spec.getType() != type) continue;
            return spec;
        }
        ArrayList existing = Lists.newArrayList();
        for (SchemaSpec spec : this.specifications) {
            SchemaSpec newSpec = this.convert(spec, type);
            if (newSpec != null) {
                this.specifications.add(newSpec);
                return newSpec;
            }
            existing.add(spec.getType());
        }
        throw new IllegalArgumentException("spec type [" + type + "] cannot be converted from any existing spec types " + existing);
    }

    private @Nullable SchemaSpec convert(@Nullable SchemaSpec source, SchemaSpec.Type target) {
        try {
            if (source != null && source.getType() == target) {
                return source;
            }
            switch (target) {
                case IR_CORE_IN_JSON: {
                    return new SchemaSpec(target, IrSchemaParser.getInstance().parse(this.parent.getGraphSchema(), this.parent.isColumnId()));
                }
                case FLEX_IN_JSON: {
                    if (source.getType() == SchemaSpec.Type.FLEX_IN_YAML) {
                        Yaml yaml = new Yaml();
                        Map rootMap = (Map)yaml.load(source.getContent());
                        ObjectMapper mapper = new ObjectMapper();
                        return new SchemaSpec(target, mapper.writeValueAsString((Object)rootMap));
                    }
                    return null;
                }
            }
            if (source.getType() == SchemaSpec.Type.FLEX_IN_JSON) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree(source.getContent());
                Map rootMap = (Map)mapper.convertValue((Object)rootNode, Map.class);
                Yaml yaml = new Yaml();
                return new SchemaSpec(target, yaml.dump((Object)rootMap));
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("can not convert from {} to {} due to some unexpected exception:", new Object[]{source.getType(), target, e});
            return null;
        }
    }
}

