/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.GSDataTypeConvertor;
import com.alibaba.graphscope.common.ir.meta.schema.GSDataTypeDesc;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.alibaba.graphscope.groot.common.schema.api.GraphStatistics;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultEdgeRelation;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphEdge;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphProperty;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphSchema;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphStatistics;
import com.alibaba.graphscope.groot.common.schema.impl.DefaultGraphVertex;
import com.alibaba.graphscope.groot.common.schema.wrapper.DataType;
import com.alibaba.graphscope.groot.common.schema.wrapper.EdgeKind;
import com.alibaba.graphscope.groot.common.schema.wrapper.LabelId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public abstract class Utils {
    public static final GraphSchema buildSchemaFromYaml(String schemaYaml) {
        Yaml yaml = new Yaml();
        Map yamlAsMap = (Map)yaml.load(schemaYaml);
        Map schemaMap = (Map)Objects.requireNonNull(yamlAsMap.get("schema"), "schema not exist in yaml config");
        HashMap vertexMap = Maps.newHashMap();
        HashMap edgeMap = Maps.newHashMap();
        HashMap propNameToIdMap = Maps.newHashMap();
        GSDataTypeConvertor typeConvertor = GSDataTypeConvertor.Factory.create(DataType.class, null);
        Utils.builderGraphElementFromYaml((List)Objects.requireNonNull(schemaMap.get("vertex_types"), "vertex_types not exist in yaml config"), "VERTEX", vertexMap, edgeMap, propNameToIdMap, typeConvertor);
        if (schemaMap.get("edge_types") != null) {
            Utils.builderGraphElementFromYaml((List)Objects.requireNonNull(schemaMap.get("edge_types"), "edge_types not exist in yaml config"), "EDGE", vertexMap, edgeMap, propNameToIdMap, typeConvertor);
        }
        return new DefaultGraphSchema((Map)vertexMap, (Map)edgeMap, (Map)propNameToIdMap);
    }

    public static final void builderGraphElementFromYaml(List elementList, String type, Map<String, GraphVertex> vertexMap, Map<String, GraphEdge> edgeMap, Map<String, Integer> propNameToIdMap, GSDataTypeConvertor<DataType> typeConvertor) {
        int curVertexTypeId = 0;
        int curEdgeTypeId = 0;
        for (Object element : elementList) {
            List primaryKeyNodes;
            ImmutableList primaryKeyList;
            if (!(element instanceof Map)) continue;
            Map elementMap = (Map)element;
            String label = (String)elementMap.get("type_name");
            int labelId = 0;
            if (elementMap.get("type_id") != null) {
                labelId = (Integer)elementMap.get("type_id");
                if (type.equals("VERTEX")) {
                    if (labelId != curVertexTypeId) {
                        throw new IllegalArgumentException("vertex type id is not continuous, expect " + curVertexTypeId + " but get " + labelId);
                    }
                    ++curVertexTypeId;
                } else {
                    if (labelId != curEdgeTypeId) {
                        throw new IllegalArgumentException("edge type id is not continuous, expect " + curEdgeTypeId + " but get " + labelId);
                    }
                    ++curEdgeTypeId;
                }
            } else {
                labelId = type.equals("VERTEX") ? curVertexTypeId++ : curEdgeTypeId++;
            }
            ArrayList propertyList = Lists.newArrayList();
            List propertyNodes = (List)elementMap.get("properties");
            if (propertyNodes != null) {
                int propertyId = 0;
                for (Object property : propertyNodes) {
                    int tmpId;
                    if (!(property instanceof Map)) continue;
                    Map propertyMap = (Map)property;
                    String propertyName = (String)Objects.requireNonNull(propertyMap.get("property_name"), "property_name not exist in yaml config");
                    int curPropertyId = 0;
                    if (propertyMap.get("property_id") != null && (tmpId = ((Integer)propertyMap.get("property_id")).intValue()) != propertyId) {
                        throw new IllegalArgumentException("property id is not continuous, expect " + propertyId + " but get " + tmpId);
                    }
                    curPropertyId = propertyId++;
                    propNameToIdMap.put(propertyName, curPropertyId);
                    propertyList.add(new DefaultGraphProperty(curPropertyId, propertyName, Utils.toDataType(propertyMap.get("property_type"), typeConvertor)));
                }
            }
            Object object = primaryKeyList = (primaryKeyNodes = (List)elementMap.get("primary_keys")) == null ? ImmutableList.of() : primaryKeyNodes.stream().map(k -> k.toString()).collect(Collectors.toList());
            if (type.equals("EDGE")) {
                ArrayList relations = Lists.newArrayList();
                List relationNodes = (List)elementMap.get("vertex_type_pair_relations");
                for (Object relation : relationNodes) {
                    if (!(relation instanceof Map)) continue;
                    Map relationMap = (Map)relation;
                    String sourceLabel = relationMap.get("source_vertex").toString();
                    String dstLabel = relationMap.get("destination_vertex").toString();
                    relations.add(new DefaultEdgeRelation(vertexMap.get(sourceLabel), vertexMap.get(dstLabel)));
                }
                edgeMap.put(label, (GraphEdge)new DefaultGraphEdge(labelId, label, (List)propertyList, (List)relations));
                continue;
            }
            if (!type.equals("VERTEX")) continue;
            vertexMap.put(label, (GraphVertex)new DefaultGraphVertex(labelId, label, (List)propertyList, (List)primaryKeyList));
        }
    }

    public static DataType toDataType(Object type, GSDataTypeConvertor<DataType> typeConvertor) {
        return typeConvertor.convert(new GSDataTypeDesc((Map)type));
    }

    public static final GraphSchema buildSchemaFromJson(String schemaJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(schemaJson);
            HashMap vertexMap = Maps.newHashMap();
            HashMap edgeMap = Maps.newHashMap();
            HashMap propNameToIdMap = Maps.newHashMap();
            Utils.buildGraphElementFromJson(jsonNode.get("entities"), "VERTEX", vertexMap, edgeMap, propNameToIdMap);
            Utils.buildGraphElementFromJson(jsonNode.get("relations"), "EDGE", vertexMap, edgeMap, propNameToIdMap);
            return new DefaultGraphSchema((Map)vertexMap, (Map)edgeMap, (Map)propNameToIdMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final void buildGraphElementFromJson(JsonNode elementList, String type, Map<String, GraphVertex> vertexMap, Map<String, GraphEdge> edgeMap, Map<String, Integer> propNameToIdMap) {
        Objects.requireNonNull(elementList);
        for (JsonNode typeObject : elementList) {
            int labelId = typeObject.get("label").get("id").asInt();
            String label = typeObject.get("label").get("name").asText();
            ArrayList propertyList = Lists.newArrayList();
            ArrayList primaryKeyList = Lists.newArrayList();
            JsonNode columnArray = typeObject.get("columns");
            Objects.requireNonNull(columnArray, "There's no property def list in " + label);
            for (JsonNode column : columnArray) {
                String propName = column.get("key").get("name").asText();
                int propId = column.get("key").get("id").asInt();
                propNameToIdMap.put(propName, propId);
                int propTypeId = column.get("data_type").asInt();
                DefaultGraphProperty property = new DefaultGraphProperty(propId, propName, Utils.toDataType(propTypeId));
                propertyList.add(property);
                boolean isPrimaryKey = column.get("is_primary_key").asBoolean();
                if (!isPrimaryKey) continue;
                primaryKeyList.add(propName);
            }
            if (type.equals("EDGE")) {
                JsonNode entityPairs = typeObject.get("entity_pairs");
                Iterator var3 = entityPairs.iterator();
                ArrayList relations = Lists.newArrayList();
                while (var3.hasNext()) {
                    JsonNode pair = (JsonNode)var3.next();
                    String sourceLabel = pair.get("src").get("name").asText();
                    String dstLabel = pair.get("dst").get("name").asText();
                    relations.add(new DefaultEdgeRelation(vertexMap.get(sourceLabel), vertexMap.get(dstLabel)));
                }
                edgeMap.put(label, (GraphEdge)new DefaultGraphEdge(labelId, label, (List)propertyList, (List)relations));
                continue;
            }
            vertexMap.put(label, (GraphVertex)new DefaultGraphVertex(labelId, label, (List)propertyList, (List)primaryKeyList));
        }
    }

    public static final DataType toDataType(int ordinal) {
        switch (ordinal) {
            case 0: {
                return DataType.BOOL;
            }
            case 1: {
                return DataType.INT;
            }
            case 2: {
                return DataType.LONG;
            }
            case 3: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.STRING;
            }
            case 5: {
                return DataType.BYTES;
            }
            case 6: {
                return DataType.INT_LIST;
            }
            case 7: {
                return DataType.LONG_LIST;
            }
            case 8: {
                return DataType.DOUBLE_LIST;
            }
            case 9: {
                return DataType.STRING_LIST;
            }
            case 12: {
                return DataType.DATE;
            }
            case 13: {
                return DataType.TIME32;
            }
            case 14: {
                return DataType.TIMESTAMP;
            }
        }
        throw new UnsupportedOperationException("convert from ir core type " + ordinal + " to DataType is unsupported yet");
    }

    public static final GraphStatistics buildStatisticsFromJson(String statisticsJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(statisticsJson);
            HashMap vertexTypeCounts = Maps.newHashMap();
            HashMap edgeTypeCounts = Maps.newHashMap();
            HashMap vertexTypeNameIdMap = Maps.newHashMap();
            Long num_vertices = jsonNode.get("total_vertex_count").asLong();
            Long num_edges = jsonNode.get("total_edge_count").asLong();
            JsonNode vertexTypeCountsNode = jsonNode.get("vertex_type_statistics");
            JsonNode edgeTypeCountsNode = jsonNode.get("edge_type_statistics");
            Utils.buildGraphElementStatisticsFromJson(vertexTypeCountsNode, "VERTEX", vertexTypeCounts, edgeTypeCounts, vertexTypeNameIdMap);
            Utils.buildGraphElementStatisticsFromJson(edgeTypeCountsNode, "EDGE", vertexTypeCounts, edgeTypeCounts, vertexTypeNameIdMap);
            return new DefaultGraphStatistics((Map)vertexTypeCounts, (Map)edgeTypeCounts, num_vertices, num_edges);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final void buildGraphElementStatisticsFromJson(JsonNode typeCountsNode, String type, Map<LabelId, Long> vertexTypeCounts, Map<EdgeKind, Long> edgeTypeCounts, Map<String, Integer> vertexTypeNameIdMap) {
        for (JsonNode typeStatisticJsonNode : typeCountsNode) {
            int typeId = typeStatisticJsonNode.get("type_id").asInt();
            String typeName = typeStatisticJsonNode.get("type_name").asText();
            if (type.equals("VERTEX")) {
                Long typeCount = typeStatisticJsonNode.get("count").asLong();
                vertexTypeCounts.put(new LabelId(typeId), typeCount);
                vertexTypeNameIdMap.put(typeName, typeId);
                continue;
            }
            JsonNode entityPairs = typeStatisticJsonNode.get("vertex_type_pair_statistics");
            for (JsonNode pair : entityPairs) {
                String sourceLabel = pair.get("source_vertex").asText();
                String dstLabel = pair.get("destination_vertex").asText();
                Long typeCount = pair.get("count").asLong();
                EdgeKind edgeKind = EdgeKind.newBuilder().setEdgeLabelId(new LabelId(typeId)).setSrcVertexLabelId(new LabelId(vertexTypeNameIdMap.get(sourceLabel).intValue())).setDstVertexLabelId(new LabelId(vertexTypeNameIdMap.get(dstLabel).intValue())).build();
                edgeTypeCounts.put(edgeKind, typeCount);
            }
        }
    }
}

