/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema.foreign;

import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKey;
import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKeyEntry;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ForeignKeyMeta {
    private final Map<EdgeTypeId, ForeignKeyEntry> keyMap;

    public ForeignKeyMeta(String foreignKeyUri) {
        Preconditions.checkArgument((!foreignKeyUri.isEmpty() ? 1 : 0) != 0, (Object)"invalid foreign key uri");
        this.keyMap = this.createKeyMap(foreignKeyUri);
    }

    private Map<EdgeTypeId, ForeignKeyEntry> createKeyMap(String foreignKeyUri) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap keyMap = Maps.newHashMap();
            String foreignKeyJson = FileUtils.readFileToString((File)new File(foreignKeyUri), (Charset)StandardCharsets.UTF_8);
            JsonNode jsonNode = mapper.readTree(foreignKeyJson);
            for (JsonNode entry : jsonNode) {
                JsonNode labelNode = entry.get("label");
                EdgeTypeId edgeTypeId = new EdgeTypeId(labelNode.get("src_id").asInt(), labelNode.get("dst_id").asInt(), labelNode.get("id").asInt());
                JsonNode foreignNode = entry.get("foreign_keys");
                ForeignKeyEntry foreignKeyEntry = new ForeignKeyEntry();
                for (JsonNode keyNode : foreignNode) {
                    foreignKeyEntry.add(new ForeignKey(keyNode.get("id").asInt(), keyNode.get("key").asText()));
                }
                keyMap.put(edgeTypeId, foreignKeyEntry);
            }
            return keyMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ForeignKeyEntry getForeignKeyEntry(EdgeTypeId typeId) {
        return this.keyMap.get(typeId);
    }

    public String toString() {
        return "ForeignKeyMeta{keyMap=" + this.keyMap + "}";
    }
}

