/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalSort;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexPermuteGraphShuttle;
import com.alibaba.graphscope.common.ir.rex.RexVariableAliasCollector;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.Utils;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.LabelConfig;
import com.alibaba.graphscope.common.ir.tools.config.SourceConfig;
import com.alibaba.graphscope.common.ir.type.GraphNameOrId;
import com.alibaba.graphscope.common.ir.type.GraphProperty;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphFieldTrimmer
extends RelFieldTrimmer {
    private final ReflectUtil.MethodDispatcher<RelFieldTrimmer.TrimResult> graphTrimFieldsDispatcher;
    private final GraphBuilder graphBuilder;

    public GraphFieldTrimmer(GraphBuilder builder) {
        super(null, (RelBuilder)builder);
        this.graphBuilder = builder;
        this.graphTrimFieldsDispatcher = ReflectUtil.createMethodDispatcher(RelFieldTrimmer.TrimResult.class, (ReflectiveVisitor)this, (String)"trimFields", RelNode.class, (Class[])new Class[]{UsedFields.class});
    }

    public RelNode trim(RelNode root) {
        UsedFields fieldsUsed = this.findUsedField(root);
        return (RelNode)this.dispatchTrimFields((RelNode)root, (UsedFields)fieldsUsed).left;
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalProject project, UsedFields fieldsUsed) {
        RelDataType rowType = project.getRowType();
        List fieldList = rowType.getFieldList();
        int fieldCount = rowType.getFieldCount();
        RelDataType fullRowType = Utils.getOutputType((RelNode)project);
        List fullFields = fullRowType.getFieldList();
        int fullSize = fullRowType.getFieldCount();
        RelDataType inputRowType = Utils.getOutputType(project.getInput(0));
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fullSize, (int)fieldsUsed.size());
        ImmutableSet.Builder varUsedBuilder = ImmutableSet.builder();
        ArrayList<RexGraphVariable> newProjects = new ArrayList<RexGraphVariable>();
        ArrayList<String> aliasList = new ArrayList<String>();
        UsedFields inputFieldsUsed = new UsedFields();
        int appendSize = fullSize - project.getProjects().size();
        if (project.isAppend()) {
            for (int i = 0; i < appendSize; ++i) {
                RelDataTypeField field = (RelDataTypeField)fullFields.get(i);
                if (!fieldsUsed.containsKey(field.getIndex())) continue;
                RelDataTypeField parentsUsedField = fieldsUsed.get(field.getIndex());
                mapping.set(i, newProjects.size());
                newProjects.add(RexGraphVariable.of(field.getIndex(), i, field.getName(), parentsUsedField.getType()));
                aliasList.add(field.getName());
                inputFieldsUsed.add(parentsUsedField);
            }
        }
        for (Ord ord : Ord.zip((List)project.getProjects())) {
            RelDataTypeField field = (RelDataTypeField)fieldList.get(ord.i);
            if (!fieldsUsed.containsKey(field.getIndex())) continue;
            Object proj = (RexNode)ord.e;
            int i = ord.i + appendSize;
            mapping.set(i, newProjects.size());
            aliasList.add(field.getName());
            List list = ((List)((RexNode)ord.e).accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().collect(Collectors.toUnmodifiableList());
            if (list.size() == 1 && field.getType() instanceof GraphSchemaType) {
                RelDataTypeField parentsUsedField = fieldsUsed.get(field.getIndex());
                RexGraphVariable var = (RexGraphVariable)((Object)list.get(0));
                inputFieldsUsed.add((RelDataTypeField)new RelDataTypeFieldImpl(var.getName(), var.getAliasId(), parentsUsedField.getType()));
                RexGraphVariable oldProj = (RexGraphVariable)((Object)proj);
                proj = RexGraphVariable.of(oldProj.getAliasId(), oldProj.getIndex(), oldProj.getName(), parentsUsedField.getType());
            }
            newProjects.add((RexGraphVariable)((Object)proj));
            varUsedBuilder.addAll(list);
        }
        ImmutableSet<RelDataTypeField> currentFields = this.findUsedFieldsByVars((ImmutableSet<RexGraphVariable>)varUsedBuilder.build(), inputRowType.getFieldList());
        inputFieldsUsed.concat((Iterable<RelDataTypeField>)currentFields);
        RelNode input = project.getInput();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild(input, inputFieldsUsed);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newProjects.isEmpty()) {
            return this.dummyProject(fieldCount, newInput, (RelNode)project);
        }
        RexPermuteGraphShuttle shuttle = new RexPermuteGraphShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RelNode newProject = this.graphBuilder.push(newInput).project((Iterable)newProjects.stream().map(arg_0 -> GraphFieldTrimmer.lambda$trimFields$0((RexVisitor)shuttle, arg_0)).collect(Collectors.toList()), aliasList).build();
        return this.result(newProject, mapping, (RelNode)project);
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalAggregate aggregate, UsedFields fieldsUsed) {
        ArrayList<GraphAggCall> aggCalls = new ArrayList<GraphAggCall>();
        ImmutableSet.Builder varUsedBuilder = ImmutableSet.builder();
        UsedFields inputFieldUsed = new UsedFields(fieldsUsed);
        int keySize = aggregate.getGroupKey().groupKeyCount();
        RelDataType rowType = aggregate.getRowType();
        RelDataType inputRowType = Utils.getOutputType(aggregate.getInput());
        int fieldCount = rowType.getFieldCount();
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldsUsed.size());
        GraphGroupKeys keys = aggregate.getGroupKey();
        ArrayList<RexNode> groupVars = new ArrayList<RexNode>();
        for (Ord ord : Ord.zip(keys.getVariables())) {
            RexNode node = (RexNode)ord.e;
            List vars = ((List)node.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().collect(Collectors.toUnmodifiableList());
            mapping.set(ord.i, ord.i);
            RelDataTypeField field = (RelDataTypeField)rowType.getFieldList().get(ord.i);
            if (vars.size() == 1 && field.getType() instanceof GraphSchemaType) {
                RexGraphVariable var = (RexGraphVariable)((Object)vars.get(0));
                Object parentsUsedField = fieldsUsed.get(field.getIndex());
                parentsUsedField = parentsUsedField != null ? new RelDataTypeFieldImpl(var.getName(), var.getAliasId(), parentsUsedField.getType()) : this.emptyField(field);
                inputFieldUsed.add((RelDataTypeField)parentsUsedField);
                groupVars.add((RexNode)RexGraphVariable.of(var.getAliasId(), var.getIndex(), var.getName(), parentsUsedField.getType()));
                continue;
            }
            groupVars.add((RexNode)ord.e);
            varUsedBuilder.addAll(vars);
        }
        keys = new GraphGroupKeys(groupVars, keys.getAliases());
        for (Ord ord : Ord.zip(aggregate.getAggCalls())) {
            GraphAggCall call = (GraphAggCall)ord.e;
            RelDataTypeField field = (RelDataTypeField)rowType.getFieldList().get(ord.i);
            if (!fieldsUsed.containsKey(field.getIndex())) continue;
            for (RexNode operand : call.getOperands()) {
                ((List)operand.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
            }
            mapping.set(ord.i + keySize, aggCalls.size() + keySize);
            aggCalls.add(call);
        }
        ImmutableSet<RelDataTypeField> currentFields = this.findUsedFieldsByVars((ImmutableSet<RexGraphVariable>)varUsedBuilder.build(), inputRowType.getFieldList());
        inputFieldUsed.concat((Iterable<RelDataTypeField>)currentFields);
        RelNode input = aggregate.getInput();
        RelFieldTrimmer.TrimResult result = this.trimChild(input, inputFieldUsed);
        RelNode newInput = (RelNode)result.left;
        Mapping inputMapping = (Mapping)result.right;
        RexPermuteGraphShuttle shuttle = new RexPermuteGraphShuttle((Mappings.TargetMapping)inputMapping, newInput);
        List<RexNode> vars = keys.getVariables().stream().map(arg_0 -> GraphFieldTrimmer.lambda$trimFields$1((RexVisitor)shuttle, arg_0)).collect(Collectors.toList());
        GraphGroupKeys newKeys = new GraphGroupKeys(vars, keys.getAliases());
        List newAggCalls = aggCalls.stream().map(arg_0 -> GraphFieldTrimmer.lambda$trimFields$3((RexVisitor)shuttle, arg_0)).collect(Collectors.toList());
        RelNode newAggregate = this.graphBuilder.push(newInput).aggregate((RelBuilder.GroupKey)newKeys, (Iterable)newAggCalls).build();
        return this.result(newAggregate, mapping, (RelNode)aggregate);
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalSort sort, UsedFields fieldsUsed) {
        RexNode offset = sort.offset;
        RexNode fetch = sort.fetch;
        RelNode input = sort.getInput();
        RelDataType inputRowType = Utils.getOutputType(input);
        UsedFields inputFieldsUsed = new UsedFields(fieldsUsed);
        ImmutableSet.Builder varUsedBuilder = ImmutableSet.builder();
        if (offset != null) {
            ((List)offset.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
        }
        if (fetch != null) {
            ((List)fetch.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
        }
        for (RexNode expr : sort.getSortExps()) {
            ((List)expr.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
        }
        ImmutableSet<RelDataTypeField> current = this.findUsedFieldsByVars((ImmutableSet<RexGraphVariable>)varUsedBuilder.build(), inputRowType.getFieldList());
        inputFieldsUsed.concat((Iterable<RelDataTypeField>)current);
        RelFieldTrimmer.TrimResult trimResult = this.trimChild(input, inputFieldsUsed);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        RexPermuteGraphShuttle shuttle = new RexPermuteGraphShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RexNode newOffset = offset == null ? null : (RexNode)offset.accept((RexVisitor)shuttle);
        RexNode newFetch = fetch == null ? null : (RexNode)fetch.accept((RexVisitor)shuttle);
        List newSortExprs = sort.getSortExps().stream().map(arg_0 -> GraphFieldTrimmer.lambda$trimFields$4((RexVisitor)shuttle, arg_0)).collect(Collectors.toUnmodifiableList());
        RelNode newSort = this.graphBuilder.push(newInput).sortLimit(newOffset, newFetch, (Iterable)newSortExprs).build();
        return this.result(newSort, inputMapping, (RelNode)sort);
    }

    public RelFieldTrimmer.TrimResult trimFields(LogicalFilter filter, UsedFields fieldsUsed) {
        RelDataType inputRowType = Utils.getOutputType(filter.getInput());
        UsedFields inputFieldsUsed = new UsedFields(fieldsUsed);
        RexNode condition = filter.getCondition();
        ImmutableSet.Builder varUsedBuilder = ImmutableSet.builder();
        ((List)condition.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
        ImmutableSet<RelDataTypeField> current = this.findUsedFieldsByVars((ImmutableSet<RexGraphVariable>)varUsedBuilder.build(), inputRowType.getFieldList());
        inputFieldsUsed.concat((Iterable<RelDataTypeField>)current);
        RelNode input = filter.getInput();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild(input, inputFieldsUsed);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (Objects.equals(input, newInput)) {
            return this.result((RelNode)filter, inputMapping);
        }
        RexPermuteGraphShuttle shuttle = new RexPermuteGraphShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RexNode newCondition = (RexNode)condition.accept((RexVisitor)shuttle);
        RelNode newFilter = this.graphBuilder.push(newInput).filter(filter.getVariablesSet(), new RexNode[]{newCondition}).build();
        return this.result(newFilter, inputMapping, (RelNode)filter);
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalSingleMatch singleMatch, UsedFields fieldsUsed) {
        RelNode sentence = singleMatch.getSentence();
        int fieldCount = singleMatch.getRowType().getFieldCount();
        RelFieldTrimmer.TrimResult result = this.trimChild(sentence, fieldsUsed);
        RelNode newInput = (RelNode)result.left;
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            mapping.set(i, i);
        }
        if (Objects.equals(sentence, result)) {
            return this.result((RelNode)singleMatch, mapping);
        }
        RelNode newMatch = this.graphBuilder.match(newInput, singleMatch.getMatchOpt()).build();
        return this.result(newMatch, mapping, (RelNode)singleMatch);
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalMultiMatch multiMatch, UsedFields fieldsUsed) {
        List<RelNode> sentences = multiMatch.getSentences();
        List newInputs = Collections.emptyList();
        int fieldCount = multiMatch.getRowType().getFieldCount();
        boolean changed = false;
        for (RelNode node : sentences) {
            RelFieldTrimmer.TrimResult result = this.trimChild(node, fieldsUsed);
            newInputs.add((RelNode)result.left);
            if (changed || !Objects.equals(result.left, node)) continue;
            changed = true;
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            mapping.set(i, i);
        }
        RelNode newMatch = this.graphBuilder.match((RelNode)newInputs.get(0), newInputs.subList(1, sentences.size())).build();
        return this.result(newMatch, mapping, (RelNode)multiMatch);
    }

    public RelFieldTrimmer.TrimResult trimFields(GraphLogicalPathExpand pathExpand, UsedFields fieldsUsed) {
        RelNode input = pathExpand.getInput();
        RelNode expand = pathExpand.getExpand();
        RelNode getV = pathExpand.getGetV();
        int fieldCount = pathExpand.getRowType().getFieldCount();
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            mapping.set(i, i);
        }
        RelNode newInput = (RelNode)this.trimChild((RelNode)input, (UsedFields)fieldsUsed).left;
        RelNode newExpand = (RelNode)this.trimChild((RelNode)expand, (UsedFields)fieldsUsed).left;
        RelNode newGetV = (RelNode)this.trimChild((RelNode)getV, (UsedFields)fieldsUsed).left;
        GraphLogicalPathExpand newPathExpand = GraphLogicalPathExpand.create((GraphOptCluster)pathExpand.getCluster(), List.of(), newInput, newExpand, newGetV, pathExpand.getOffset(), pathExpand.getFetch(), pathExpand.getResultOpt(), pathExpand.getPathOpt(), pathExpand.getUntilCondition(), pathExpand.getAliasName(), pathExpand.getStartAlias());
        return this.result((RelNode)newPathExpand, mapping, (RelNode)pathExpand);
    }

    public RelFieldTrimmer.TrimResult trimFields(Join join, UsedFields fieldsUsed) {
        UsedFields inputFieldsUsed = new UsedFields(fieldsUsed);
        ImmutableSet.Builder varUsedBuilder = ImmutableSet.builder();
        ArrayList<RelDataTypeField> inputFields = new ArrayList<RelDataTypeField>(join.getLeft().getRowType().getFieldList());
        inputFields.addAll(join.getRight().getRowType().getFieldList());
        int inputFieldCount = inputFields.size();
        int newInputFieldCount = 0;
        RexNode condition = join.getCondition();
        ((List)condition.accept(new RexVariableAliasCollector<RexGraphVariable>(true, this::findInput))).stream().forEach(arg_0 -> ((ImmutableSet.Builder)varUsedBuilder).add(arg_0));
        ImmutableSet<RelDataTypeField> current = this.findUsedFieldsByVars((ImmutableSet<RexGraphVariable>)varUsedBuilder.build(), inputFields);
        inputFieldsUsed.concat((Iterable<RelDataTypeField>)current);
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        for (RelNode input : join.getInputs()) {
            RelFieldTrimmer.TrimResult result = this.trimChild(input, inputFieldsUsed);
            newInputs.add((RelNode)result.left);
            inputMappings.add((Mapping)result.right);
            newInputFieldCount += ((Mapping)result.right).getTargetCount();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)inputFieldCount, (int)newInputFieldCount);
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source, pair.target);
            }
        }
        RexPermuteGraphShuttle shuttle = new RexPermuteGraphShuttle((Mappings.TargetMapping)mapping, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1));
        RexNode newConditionExpr = (RexNode)condition.accept((RexVisitor)shuttle);
        this.graphBuilder.push((RelNode)newInputs.get(0));
        this.graphBuilder.push((RelNode)newInputs.get(1));
        if (join.getJoinType() == JoinRelType.SEMI || join.getJoinType() == JoinRelType.ANTI) {
            Mapping inputMapping = (Mapping)inputMappings.get(0);
            mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)join.getRowType().getFieldCount(), (int)inputMapping.getTargetCount());
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source, pair.target);
            }
        }
        this.graphBuilder.join(join.getJoinType(), newConditionExpr);
        return this.result(this.graphBuilder.build(), mapping, (RelNode)join);
    }

    public RelFieldTrimmer.TrimResult trimFields(AbstractBindableTableScan tableScan, UsedFields fieldsUsed) {
        RelDataTypeField field;
        RelDataType rowType = tableScan.getRowType();
        int aliasId = tableScan.getAliasId();
        int fieldCount = rowType.getFieldCount();
        LabelConfig labelConfig = new LabelConfig(false);
        tableScan.getTableConfig().getTables().stream().map(e -> (String)e.getQualifiedName().get(0)).forEach(labelConfig::addLabel);
        boolean setAlias = false;
        if (fieldsUsed.containsKey(aliasId)) {
            field = fieldsUsed.get(aliasId);
            setAlias = true;
        } else {
            RelDataTypeField origin = (RelDataTypeField)rowType.getFieldList().get(0);
            field = this.emptyField(origin);
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            mapping.set(i, i);
        }
        if (tableScan instanceof GraphLogicalSource) {
            GraphLogicalSource source = (GraphLogicalSource)tableScan;
            SourceConfig config = new SourceConfig(source.getOpt(), labelConfig, source.getAliasName());
            RelNode newSource = this.graphBuilder.source(config).build();
            ((AbstractBindableTableScan)newSource).setSchemaType((GraphSchemaType)field.getType());
            return this.result(newSource, mapping, (RelNode)source);
        }
        if (tableScan instanceof GraphLogicalExpand) {
            GraphLogicalExpand expand = (GraphLogicalExpand)tableScan;
            RelNode input = expand.getInput(0);
            RelFieldTrimmer.TrimResult result = this.trimChild(input, fieldsUsed);
            RelNode newInput = (RelNode)result.left;
            ExpandConfig config = new ExpandConfig(expand.getOpt(), labelConfig, expand.getAliasName());
            RelNode newExpand = this.graphBuilder.push(newInput).expand(config).build();
            ((AbstractBindableTableScan)newExpand).setSchemaType((GraphSchemaType)field.getType());
            return this.result(newExpand, mapping, (RelNode)expand);
        }
        if (tableScan instanceof GraphLogicalGetV) {
            GraphLogicalGetV getV = (GraphLogicalGetV)tableScan;
            RelNode input = getV.getInput(0);
            RelFieldTrimmer.TrimResult result = this.trimChild(input, fieldsUsed);
            RelNode newInput = (RelNode)result.left;
            GetVConfig config = new GetVConfig(getV.getOpt(), labelConfig, getV.getAliasName());
            RelNode newGetV = this.graphBuilder.push(newInput).getV(config).build();
            ((AbstractBindableTableScan)newGetV).setSchemaType((GraphSchemaType)field.getType());
            return this.result(newGetV, mapping, (RelNode)getV);
        }
        return this.result((RelNode)tableScan, mapping);
    }

    protected RelFieldTrimmer.TrimResult trimChild(RelNode rel, UsedFields fieldsUsed) {
        return this.dispatchTrimFields(rel, fieldsUsed);
    }

    public final RexGraphVariable findInput(RexGraphVariable var) {
        return var;
    }

    protected final RelFieldTrimmer.TrimResult dispatchTrimFields(RelNode rel, UsedFields fieldsUsed) {
        return (RelFieldTrimmer.TrimResult)this.graphTrimFieldsDispatcher.invoke(new Object[]{rel, fieldsUsed});
    }

    protected final ImmutableSet<RelDataTypeField> findUsedFieldsByVars(ImmutableSet<RexGraphVariable> vars, List<RelDataTypeField> originalFields) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Map<Integer, Set<@Nullable T>> groups = vars.stream().collect(Collectors.groupingBy(RexGraphVariable::getAliasId, Collectors.mapping(RexGraphVariable::getProperty, Collectors.toSet())));
        for (RelDataTypeField field : originalFields) {
            if (!groups.containsKey(field.getIndex())) continue;
            if (field.getType() instanceof GraphSchemaType) {
                GraphSchemaType original = (GraphSchemaType)field.getType();
                Set<@Nullable T> properties = groups.get(field.getIndex());
                List<RelDataTypeField> fields = original.getFieldList().stream().filter(e -> this.isUsedProperty(properties, (RelDataTypeField)e)).collect(Collectors.toList());
                GraphSchemaType graphSchemaType = new GraphSchemaType(original.getScanOpt(), original.getLabelType(), fields);
                builder.add((Object)new RelDataTypeFieldImpl(field.getName(), field.getIndex(), (RelDataType)graphSchemaType));
                continue;
            }
            builder.add((Object)field);
        }
        return builder.build();
    }

    private boolean isUsedProperty(Set<@Nullable GraphProperty> properties, RelDataTypeField field) {
        for (GraphProperty property : properties) {
            if (property == null) continue;
            if (property.getOpt() == GraphProperty.Opt.ALL) {
                return true;
            }
            boolean isEqual = property.getKey().getOpt() == GraphNameOrId.Opt.NAME ? Objects.equals(property.getKey().getName(), field.getName()) : property.getKey().getId() == field.getIndex();
            if (!isEqual) continue;
            return true;
        }
        return false;
    }

    protected UsedFields findUsedField(RelNode root) {
        RelDataType rowType = root.getRowType();
        List fields = rowType.getFieldList();
        Set<RelDataTypeField> set = fields.stream().map(field -> this.emptyField((RelDataTypeField)field)).collect(Collectors.toSet());
        return new UsedFields(set);
    }

    private RelDataTypeField emptyField(RelDataTypeField field) {
        if (field.getType() instanceof GraphSchemaType) {
            GraphSchemaType original = (GraphSchemaType)field.getType();
            GraphSchemaType newType = new GraphSchemaType(original.getScanOpt(), original.getLabelType(), new ArrayList<RelDataTypeField>());
            return new RelDataTypeFieldImpl(field.getName(), field.getIndex(), (RelDataType)newType);
        }
        return field;
    }

    private static /* synthetic */ RexNode lambda$trimFields$4(RexVisitor shuttle, RexNode e) {
        return (RexNode)e.accept(shuttle);
    }

    private static /* synthetic */ GraphAggCall lambda$trimFields$3(RexVisitor shuttle, GraphAggCall call) {
        List<RexNode> operands = call.getOperands().stream().map(operand -> (RexNode)operand.accept(shuttle)).collect(Collectors.toList());
        GraphAggCall newCall = new GraphAggCall(call.getCluster(), call.getAggFunction(), operands);
        newCall.as(call.getAlias());
        return newCall;
    }

    private static /* synthetic */ RexNode lambda$trimFields$1(RexVisitor shuttle, RexNode var) {
        return (RexNode)var.accept(shuttle);
    }

    private static /* synthetic */ RexNode lambda$trimFields$0(RexVisitor shuttle, RexNode e) {
        return (RexNode)e.accept(shuttle);
    }

    public class UsedFields {
        private final Map<Integer, RelDataTypeField> fieldMap;

        public UsedFields() {
            this.fieldMap = new HashMap<Integer, RelDataTypeField>();
        }

        public UsedFields(Set<RelDataTypeField> fields) {
            this.fieldMap = new HashMap<Integer, RelDataTypeField>();
            for (RelDataTypeField field : fields) {
                this.fieldMap.put(field.getIndex(), field);
            }
        }

        public UsedFields(UsedFields fields) {
            this.fieldMap = new HashMap<Integer, RelDataTypeField>(fields.fieldMap);
        }

        public void add(RelDataTypeField field) {
            if (this.fieldMap.containsKey(field.getIndex())) {
                if (field.getType() instanceof GraphSchemaType) {
                    GraphSchemaType lhs = (GraphSchemaType)this.fieldMap.get(field.getIndex()).getType();
                    GraphSchemaType rhs = (GraphSchemaType)field.getType();
                    ArrayList<RelDataTypeField> newFields = new ArrayList();
                    newFields.addAll(lhs.getFieldList());
                    newFields.addAll(rhs.getFieldList());
                    newFields = newFields.stream().distinct().collect(Collectors.toList());
                    GraphSchemaType newType = new GraphSchemaType(rhs.getScanOpt(), rhs.getLabelType(), newFields);
                    this.fieldMap.put(field.getIndex(), (RelDataTypeField)new RelDataTypeFieldImpl(field.getName(), field.getIndex(), (RelDataType)newType));
                }
            } else {
                this.fieldMap.put(field.getIndex(), field);
            }
        }

        public void concat(Iterable<RelDataTypeField> fields) {
            for (RelDataTypeField field : fields) {
                this.add(field);
            }
        }

        public final @Nullable RelDataTypeField get(int i) {
            return this.fieldMap.getOrDefault(i, null);
        }

        public final boolean containsKey(int i) {
            return this.fieldMap.containsKey(i);
        }

        public final int size() {
            return this.fieldMap.size();
        }
    }
}

