/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalSort;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import java.util.IdentityHashMap;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphHepPlanner
extends HepPlanner {
    private @Nullable RelNode originalRoot;

    public GraphHepPlanner(HepProgram program) {
        super(program);
    }

    public RelNode findBestExp() {
        return this.originalRoot.accept((RelShuttle)new PlannerVisitor(this.originalRoot));
    }

    public void setRoot(RelNode rel) {
        this.originalRoot = rel;
    }

    public RelNode findBestExpOfRoot(RelNode root) {
        super.setRoot(root);
        return super.findBestExp();
    }

    private class PlannerVisitor
    extends GraphShuttle {
        private final RelNode root;
        private final IdentityHashMap<RelNode, RelNode> commonRelVisitedMap;
        private final RexShuttle subQueryPlanner;

        public PlannerVisitor(RelNode root) {
            this.root = root;
            this.commonRelVisitedMap = new IdentityHashMap();
            this.subQueryPlanner = new RexShuttle(){

                public RexNode visitSubQuery(RexSubQuery subQuery) {
                    RelNode subRel = subQuery.rel;
                    RelNode newSubRel = subRel.accept((RelShuttle)new PlannerVisitor(subRel));
                    if (newSubRel == subRel) {
                        return subQuery;
                    }
                    return subQuery.clone(newSubRel);
                }
            };
        }

        @Override
        public RelNode visit(GraphLogicalSource source) {
            return this.findBestIfRoot((RelNode)source, (RelNode)source);
        }

        @Override
        public RelNode visit(GraphLogicalExpand expand) {
            return this.findBestIfRoot((RelNode)expand, this.visitChildren((RelNode)expand));
        }

        @Override
        public RelNode visit(GraphLogicalGetV getV) {
            return this.findBestIfRoot((RelNode)getV, this.visitChildren((RelNode)getV));
        }

        @Override
        public RelNode visit(GraphLogicalPathExpand expand) {
            return this.findBestIfRoot((RelNode)expand, this.visitChildren((RelNode)expand));
        }

        @Override
        public RelNode visit(GraphLogicalSingleMatch match) {
            return this.findBestIfRoot((RelNode)match, (RelNode)match);
        }

        @Override
        public RelNode visit(GraphLogicalMultiMatch match) {
            return this.findBestIfRoot((RelNode)match, (RelNode)match);
        }

        @Override
        public RelNode visit(GraphLogicalAggregate aggregate) {
            return this.findBestIfRoot((RelNode)aggregate, this.visitChildren((RelNode)aggregate));
        }

        @Override
        public RelNode visit(GraphLogicalProject project) {
            return this.findBestIfRoot((RelNode)project, this.visitChildren((RelNode)project));
        }

        @Override
        public RelNode visit(GraphLogicalSort sort) {
            return this.findBestIfRoot((RelNode)sort, this.visitChildren((RelNode)sort));
        }

        @Override
        public RelNode visit(GraphPhysicalExpand physicalExpand) {
            return this.findBestIfRoot((RelNode)physicalExpand, this.visitChildren((RelNode)physicalExpand));
        }

        @Override
        public RelNode visit(GraphPhysicalGetV physicalGetV) {
            return this.findBestIfRoot((RelNode)physicalGetV, this.visitChildren((RelNode)physicalGetV));
        }

        public RelNode visit(LogicalUnion union) {
            return this.findBestIfRoot((RelNode)union, this.visitChildren((RelNode)union));
        }

        public RelNode visit(LogicalFilter filter) {
            return this.findBestIfRoot((RelNode)filter, this.visitChildren((RelNode)filter));
        }

        @Override
        public RelNode visit(MultiJoin join) {
            return this.findBestIfRoot((RelNode)join, this.visitChildren((RelNode)join));
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return this.findBestIfRoot((RelNode)join, this.visitChildren((RelNode)join));
        }

        @Override
        public RelNode visit(CommonTableScan tableScan) {
            RelOptTable optTable = tableScan.getTable();
            if (optTable instanceof CommonOptTable) {
                RelNode common = ((CommonOptTable)optTable).getCommon();
                RelNode visited = this.commonRelVisitedMap.get(common);
                if (visited == null) {
                    visited = common.accept((RelShuttle)new PlannerVisitor(common));
                    this.commonRelVisitedMap.put(common, visited);
                }
                return new CommonTableScan(tableScan.getCluster(), tableScan.getTraitSet(), new CommonOptTable(visited));
            }
            return tableScan;
        }

        private RelNode findBestIfRoot(RelNode oldRel, RelNode newRel) {
            newRel = newRel.accept(this.subQueryPlanner);
            return oldRel == this.root ? GraphHepPlanner.this.findBestExpOfRoot(newRel) : newRel;
        }
    }
}

