/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.glogue.CountHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.DetailedExpandCost;
import com.alibaba.graphscope.common.ir.meta.glogue.DetailedSourceCost;
import com.alibaba.graphscope.common.ir.meta.glogue.EdgeCostEstimator;
import com.alibaba.graphscope.common.ir.meta.glogue.Utils;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.GraphRelMetadataQuery;
import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.planner.type.DataKey;
import com.alibaba.graphscope.common.ir.planner.type.DataValue;
import com.alibaba.graphscope.common.ir.planner.type.EdgeDataKey;
import com.alibaba.graphscope.common.ir.planner.type.VertexDataKey;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.GraphExtendIntersect;
import com.alibaba.graphscope.common.ir.rel.GraphJoinDecomposition;
import com.alibaba.graphscope.common.ir.rel.GraphPattern;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendStep;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueExtendIntersectEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.ElementDetails;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PathExpandRange;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.alibaba.graphscope.common.ir.rel.type.JoinVertexEntry;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.tools.config.LabelConfig;
import com.alibaba.graphscope.common.ir.tools.config.PathExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.SourceConfig;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.LocalState;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphIOProcessor {
    private final GraphBuilder builder;
    private final IrMeta irMeta;
    private final RelMetadataQuery mq;
    private final Map<DataKey, DataValue> graphDetails;

    public GraphIOProcessor(GraphBuilder builder, IrMeta irMeta) {
        this.builder = Objects.requireNonNull(builder);
        this.irMeta = Objects.requireNonNull(irMeta);
        this.mq = builder.getCluster().getMetadataQuery();
        this.graphDetails = Maps.newHashMap();
    }

    public RelNode processInput(RelNode input) {
        return this.processInput((List<RelNode>)ImmutableList.of((Object)input));
    }

    public RelNode processInput(List<RelNode> inputs) {
        InputConvertor convertor = new InputConvertor();
        RelNode processed = null;
        for (RelNode input : inputs) {
            processed = input.accept((RelShuttle)convertor);
        }
        convertor.build();
        return processed;
    }

    public RelNode processOutput(RelNode output) {
        return output.accept((RelShuttle)new OutputConvertor());
    }

    public GraphBuilder getBuilder() {
        return this.builder;
    }

    private class OutputConvertor
    extends GraphShuttle {
        private Map<DataKey, DataValue> details;

        private OutputConvertor() {
            this.details = Maps.newHashMap(GraphIOProcessor.this.graphDetails);
        }

        @Override
        public RelNode visit(GraphPattern graph) {
            Pattern pattern = graph.getPattern();
            Preconditions.checkArgument((pattern != null && pattern.getVertexNumber() == 1 ? 1 : 0) != 0, (String)"can not convert pattern %s to any logical operator", (Object)pattern);
            PatternVertex vertex = pattern.getVertexSet().iterator().next();
            VertexDataKey key = new VertexDataKey(pattern.getVertexOrder(vertex));
            DataValue value = this.getVertexValue(key, this.details, vertex);
            GraphIOProcessor.this.builder.source(new SourceConfig(GraphOpt.Source.VERTEX, this.createLabels(vertex.getVertexTypeIds(), true), value.getAlias()));
            if (value.getFilter() != null) {
                GraphIOProcessor.this.builder.filter(value.getFilter());
            }
            RelNode rel = GraphIOProcessor.this.builder.build();
            this.addCachedCost(rel, (RelOptCost)this.estimateCost(graph, vertex));
            return rel;
        }

        private DetailedSourceCost estimateCost(GraphPattern graph, PatternVertex singleVertex) {
            double selectivity = singleVertex.getElementDetails().getSelectivity();
            if (Double.compare(selectivity, 1.0) < 0) {
                PatternVertex newVertex = singleVertex instanceof SinglePatternVertex ? new SinglePatternVertex(singleVertex.getVertexTypeIds().get(0), singleVertex.getId()) : new FuzzyPatternVertex(singleVertex.getVertexTypeIds(), singleVertex.getId());
                graph = new GraphPattern(graph.getCluster(), graph.getTraitSet(), new Pattern(newVertex));
            }
            double patternCount = GraphIOProcessor.this.mq.getRowCount((RelNode)graph);
            return new DetailedSourceCost(patternCount, patternCount * selectivity);
        }

        private RelNode addCachedCost(RelNode rel, RelOptCost cost) {
            if (rel instanceof AbstractBindableTableScan) {
                ((AbstractBindableTableScan)rel).setCachedCost(cost);
            } else if (rel instanceof GraphLogicalPathExpand) {
                ((GraphLogicalPathExpand)rel).setCachedCost(cost);
            } else {
                if (rel instanceof LogicalJoin) {
                    LogicalJoin join = (LogicalJoin)rel;
                    return new LogicalJoin((RelOptCluster)((GraphOptCluster)join.getCluster()).copy(new LocalState().withCachedCost(cost)), join.getTraitSet(), (List)join.getHints(), join.getLeft(), join.getRight(), join.getCondition(), join.getVariablesSet(), join.getJoinType(), join.isSemiJoinDone(), ImmutableList.copyOf((Collection)join.getSystemFieldList()));
                }
                if (rel instanceof MultiJoin) {
                    MultiJoin join = (MultiJoin)rel;
                    return new MultiJoin((RelOptCluster)((GraphOptCluster)join.getCluster()).copy(new LocalState().withCachedCost(cost)), join.getInputs(), join.getJoinFilter(), join.getRowType(), false, join.getOuterJoinConditions(), join.getJoinTypes(), join.getProjFields(), join.getJoinFieldRefCountsMap(), null);
                }
            }
            if (rel instanceof GraphLogicalGetV) {
                this.addCachedCost(rel.getInput(0), cost);
            }
            return rel;
        }

        private RelOptCost estimateCost(Pattern original, final GraphExtendIntersect intersect, int idx) {
            GlogueExtendIntersectEdge edge = intersect.getGlogueEdge();
            ExtendEdge extendEdge = edge.getExtendStep().getExtendEdges().get(idx);
            PatternVertex start = edge.getSrcPattern().getVertexByOrder(extendEdge.getSrcVertexOrder());
            PatternVertex target = edge.getDstPattern().getVertexByOrder(edge.getExtendStep().getTargetVertexOrder());
            PatternEdge patternEdge = Utils.convert(extendEdge, start, target);
            EdgeCostEstimator.Extend estimator = new EdgeCostEstimator.Extend(new CountHandler(){

                @Override
                public double handle(Pattern pattern) {
                    return GraphIOProcessor.this.mq.getRowCount((RelNode)new GraphPattern(intersect.getCluster(), intersect.getTraitSet(), pattern));
                }

                @Override
                public double labelConstraintsDeltaCost(PatternEdge edge, PatternVertex target) {
                    return ((GraphRelMetadataQuery)GraphIOProcessor.this.mq).getGlogueQuery().getLabelConstraintsDeltaCost(edge, target);
                }
            });
            DetailedExpandCost cost = (DetailedExpandCost)((Object)((EdgeCostEstimator)estimator).estimate(original, patternEdge, target));
            PatternVertex src = patternEdge.getSrcVertex();
            PatternVertex dst = patternEdge.getDstVertex();
            if (!original.containsVertex(src)) {
                original.addVertex(src);
            }
            if (!original.containsVertex(dst)) {
                original.addVertex(dst);
            }
            original.addEdge(src, dst, patternEdge);
            original.reordering();
            return cost;
        }

        @Override
        public RelNode visit(GraphExtendIntersect intersect) {
            GlogueExtendIntersectEdge glogueEdge = intersect.getGlogueEdge();
            Map<DataKey, DataValue> edgeDetails = this.getGlogueEdgeDetails(glogueEdge);
            this.details = this.createSubDetails(glogueEdge.getSrcPattern(), glogueEdge.getSrcToTargetOrderMapping(), null, null);
            ExtendStep extendStep = glogueEdge.getExtendStep();
            List<ExtendEdge> extendEdges = extendStep.getExtendEdges();
            RelNode child = this.visitChildren((RelNode)intersect).getInput(0);
            Pattern original = new Pattern(intersect.getGlogueEdge().getSrcPattern());
            original.reordering();
            if (extendEdges.size() == 1) {
                return this.addCachedCost(this.createExpandGetV(extendEdges.get(0), glogueEdge, edgeDetails, child), this.estimateCost(original, intersect, 0));
            }
            CommonOptTable commonTable = new CommonOptTable(child);
            CommonTableScan commonScan = new CommonTableScan(intersect.getCluster(), intersect.getTraitSet(), commonTable);
            AtomicInteger counter = new AtomicInteger(0);
            List<RelNode> inputs = extendEdges.stream().map(k -> {
                RelNode input = GraphIOProcessor.this.builder.push(this.createExpandGetV((ExtendEdge)k, glogueEdge, edgeDetails, (RelNode)commonScan)).build();
                RelOptCost estimatedCost = this.estimateCost(original, intersect, counter.getAndIncrement());
                this.addCachedCost(input, estimatedCost);
                return input;
            }).collect(Collectors.toList());
            MultiJoin rel = new MultiJoin(intersect.getCluster(), inputs, this.createIntersectFilter(glogueEdge, edgeDetails, inputs), this.deriveIntersectType(inputs), false, Stream.generate(() -> null).limit(inputs.size()).collect(Collectors.toList()), Stream.generate(() -> JoinRelType.INNER).limit(inputs.size()).collect(Collectors.toList()), Stream.generate(() -> null).limit(inputs.size()).collect(Collectors.toList()), ImmutableMap.of(), null);
            return this.addCachedCost((RelNode)rel, (RelOptCost)new RelOptCostImpl(GraphIOProcessor.this.mq.getRowCount((RelNode)new GraphPattern(intersect.getCluster(), intersect.getTraitSet(), glogueEdge.getDstPattern())).doubleValue()));
        }

        @Override
        public RelNode visit(GraphJoinDecomposition decomposition) {
            Map<Integer, Integer> probeOrderMap = decomposition.getOrderMappings().getLeftToTargetOrderMap();
            Map<Integer, Integer> buildOrderMap = decomposition.getOrderMappings().getRightToTargetOrderMap();
            List<GraphJoinDecomposition.JoinVertexPair> jointVertices = decomposition.getJoinVertexPairs();
            DataValue defaultValue = new DataValue(this.generatePxdSplitAlias(), null, null);
            Map<@Nullable DataKey, DataValue> parentVertexDetails = this.getJointVertexDetails(jointVertices, probeOrderMap, buildOrderMap, defaultValue);
            Map<DataKey, DataValue> probeDetails = this.createSubDetails(decomposition.getProbePattern(), probeOrderMap, new ParentPattern(decomposition.getParentPatten(), 0), defaultValue);
            Map<DataKey, DataValue> buildDetails = this.createSubDetails(decomposition.getBuildPattern(), buildOrderMap, new ParentPattern(decomposition.getParentPatten(), 1), defaultValue);
            RelNode joinLeft = decomposition.getLeft();
            RelNode joinRight = decomposition.getRight();
            this.details = probeDetails;
            RelNode newLeft = this.visitChild((RelNode)decomposition, 0, joinLeft).getInput(0);
            this.details = buildDetails;
            RelNode newRight = this.visitChild((RelNode)decomposition, 1, joinRight).getInput(1);
            RexNode joinCondition = this.createJoinFilter(jointVertices, parentVertexDetails, newLeft, newRight, probeOrderMap, buildOrderMap, decomposition.getProbePattern(), decomposition.getBuildPattern());
            GraphIOProcessor.this.builder.push(newLeft).push(newRight).join(JoinRelType.INNER, joinCondition);
            ArrayList concatExprs = Lists.newArrayList();
            ArrayList concatAliases = Lists.newArrayList();
            jointVertices.forEach(joint -> {
                PatternVertex probeJointVertex = decomposition.getProbePattern().getVertexByOrder(joint.getLeftOrderId());
                PatternVertex buildJointVertex = decomposition.getBuildPattern().getVertexByOrder(joint.getRightOrderId());
                Set<PatternEdge> probeEdges = decomposition.getProbePattern().getEdgesOf(probeJointVertex);
                Set<PatternEdge> buildEdges = decomposition.getBuildPattern().getEdgesOf(buildJointVertex);
                if (probeEdges.size() == 1 && buildEdges.size() == 1) {
                    PatternEdge probeEdge = probeEdges.iterator().next();
                    DataValue probeValue = (DataValue)probeDetails.get(new EdgeDataKey(decomposition.getProbePattern().getVertexOrder(probeEdge.getSrcVertex()), decomposition.getProbePattern().getVertexOrder(probeEdge.getDstVertex()), probeEdge.isBoth() ? PatternDirection.BOTH : PatternDirection.OUT));
                    PatternEdge buildEdge = buildEdges.iterator().next();
                    DataValue buildValue = (DataValue)buildDetails.get(new EdgeDataKey(decomposition.getBuildPattern().getVertexOrder(buildEdge.getSrcVertex()), decomposition.getBuildPattern().getVertexOrder(buildEdge.getDstVertex()), buildEdge.isBoth() ? PatternDirection.BOTH : PatternDirection.OUT));
                    if (probeValue != null && probeValue.getParentAlias() != null && buildValue != null && buildValue.getParentAlias() != null && probeValue.getParentAlias().equals(buildValue.getParentAlias())) {
                        String probeAlias = probeValue.getAlias();
                        String buildAlias = buildValue.getAlias();
                        concatExprs.add(GraphIOProcessor.this.builder.call(GraphStdOperatorTable.PATH_CONCAT, new RexNode[]{GraphIOProcessor.this.builder.variable(probeAlias), GraphIOProcessor.this.builder.getRexBuilder().makeFlag((Enum)this.getConcatDirection(probeJointVertex, joinLeft)), GraphIOProcessor.this.builder.variable(buildAlias), GraphIOProcessor.this.builder.getRexBuilder().makeFlag((Enum)this.getConcatDirection(buildJointVertex, joinRight))}));
                        concatAliases.add(probeValue.getParentAlias());
                    }
                }
            });
            if (!concatExprs.isEmpty()) {
                GraphIOProcessor.this.builder.project((Iterable)concatExprs, (Iterable)concatAliases, true);
            }
            RelNode rel = GraphIOProcessor.this.builder.build();
            RelOptCostImpl cost = new RelOptCostImpl(GraphIOProcessor.this.mq.getRowCount((RelNode)new GraphPattern(decomposition.getCluster(), decomposition.getTraitSet(), decomposition.getParentPatten())).doubleValue());
            return this.addCachedCost(rel, (RelOptCost)cost);
        }

        private String generatePxdSplitAlias() {
            return "PATTERN_SPLIT_VERTEX$" + UUID.randomUUID().hashCode();
        }

        private GraphOpt.GetV getConcatDirection(PatternVertex concatVertex, RelNode splitPattern) {
            ConcatDirectionVisitor visitor = new ConcatDirectionVisitor(concatVertex);
            visitor.go(splitPattern);
            return visitor.direction;
        }

        private RexNode createJoinFilter(List<GraphJoinDecomposition.JoinVertexPair> jointVertices, Map<DataKey, DataValue> vertexDetails, RelNode left, RelNode right, Map<Integer, Integer> probeOrderMap, Map<Integer, Integer> buildOrderMap, Pattern probePattern, Pattern buildPattern) {
            ArrayList joinCondition = Lists.newArrayList();
            List leftFields = com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(left).getFieldList();
            for (GraphJoinDecomposition.JoinVertexPair jointVertex : jointVertices) {
                GraphIOProcessor.this.builder.push(left);
                RexGraphVariable leftVar = this.convert((JoinVertexEntry)jointVertex.left, vertexDetails, probeOrderMap, probePattern);
                GraphIOProcessor.this.builder.build();
                GraphIOProcessor.this.builder.push(right);
                RexGraphVariable rightVar = this.convert((JoinVertexEntry)jointVertex.right, vertexDetails, buildOrderMap, buildPattern);
                rightVar = rightVar.getProperty() == null ? RexGraphVariable.of(rightVar.getAliasId(), leftFields.size() + rightVar.getIndex(), rightVar.getName(), rightVar.getType()) : RexGraphVariable.of(rightVar.getAliasId(), rightVar.getProperty(), leftFields.size() + rightVar.getIndex(), rightVar.getName(), rightVar.getType());
                GraphIOProcessor.this.builder.build();
                joinCondition.add(GraphIOProcessor.this.builder.equals((RexNode)leftVar, (RexNode)rightVar));
            }
            return RexUtil.composeConjunction((RexBuilder)GraphIOProcessor.this.builder.getRexBuilder(), (Iterable)joinCondition);
        }

        private RexGraphVariable convert(JoinVertexEntry<Integer> joinVertex, Map<@Nullable DataKey, DataValue> vertexDetails, Map<Integer, Integer> orderMap, Pattern pattern) {
            Integer orderId = orderMap.get(joinVertex.getVertex());
            VertexDataKey vertexKey = orderId == null ? null : new VertexDataKey(orderId);
            DataValue value = this.getVertexValue(vertexKey, vertexDetails, pattern.getVertexByOrder(joinVertex.getVertex()));
            return joinVertex.getKeyName() != null ? GraphIOProcessor.this.builder.variable(value.getAlias(), joinVertex.getKeyName()) : GraphIOProcessor.this.builder.variable(value.getAlias());
        }

        private Map<@Nullable DataKey, DataValue> getJointVertexDetails(List<GraphJoinDecomposition.JoinVertexPair> jointVertices, Map<Integer, Integer> probeOrderMap, Map<Integer, Integer> buildOrderMap, DataValue defaultValue) {
            HashMap vertexDetails = Maps.newHashMap();
            jointVertices.forEach(k -> {
                Integer probeOrderId;
                VertexDataKey dataKey;
                DataValue value;
                Integer buildOrderId = (Integer)buildOrderMap.get(k.getRightOrderId());
                if (buildOrderId != null && (value = this.details.get(dataKey = new VertexDataKey(buildOrderId))) != null) {
                    vertexDetails.put(dataKey, value);
                }
                if ((probeOrderId = (Integer)probeOrderMap.get(k.getLeftOrderId())) != null) {
                    VertexDataKey dataKey2 = new VertexDataKey(probeOrderId);
                    DataValue value2 = this.details.get(dataKey2);
                    if (!vertexDetails.containsKey(dataKey2) && value2 != null) {
                        vertexDetails.put(dataKey2, value2);
                    }
                }
                if (buildOrderId == null && probeOrderId == null) {
                    vertexDetails.put(null, defaultValue);
                }
            });
            return vertexDetails;
        }

        private @Nullable RelDataType deriveIntersectType(List<RelNode> inputs) {
            return inputs.isEmpty() ? null : com.alibaba.graphscope.common.ir.tools.Utils.getOutputType(inputs.get(0));
        }

        private RexNode createIntersectFilter(GlogueExtendIntersectEdge glogueEdge, Map<DataKey, DataValue> edgeDetails, List<RelNode> inputs) {
            ExtendStep step = glogueEdge.getExtendStep();
            VertexDataKey targetKey = new VertexDataKey(step.getTargetVertexOrder());
            DataValue targetValue = this.getVertexValue(targetKey, edgeDetails, glogueEdge.getDstPattern().getVertexByOrder(step.getTargetVertexOrder()));
            String alias = targetValue.getAlias();
            ArrayList intersectFilters = Lists.newArrayList();
            for (int i = 0; i < inputs.size() - 1; ++i) {
                GraphIOProcessor.this.builder.push(inputs.get(i));
                RexGraphVariable left = GraphIOProcessor.this.builder.variable(alias);
                GraphIOProcessor.this.builder.push(inputs.get(i + 1));
                RexGraphVariable right = GraphIOProcessor.this.builder.variable(alias);
                intersectFilters.add(GraphIOProcessor.this.builder.equals((RexNode)left, (RexNode)right));
            }
            return RexUtil.composeConjunction((RexBuilder)GraphIOProcessor.this.builder.getRexBuilder(), (Iterable)intersectFilters);
        }

        private RelNode createExpandGetV(ExtendEdge edge, GlogueExtendIntersectEdge glogueEdge, Map<DataKey, DataValue> edgeDetails, RelNode input) {
            GraphIOProcessor.this.builder.push(input);
            ExtendStep extendStep = glogueEdge.getExtendStep();
            DataValue edgeValue = this.getEdgeValue(this.createEdgeKey(edge, glogueEdge), edgeDetails);
            Map<Integer, Integer> srcToTargetMap = glogueEdge.getSrcToTargetOrderMapping();
            Integer srcInTargetOrderId = srcToTargetMap.get(edge.getSrcVertexOrder());
            if (srcInTargetOrderId == null) {
                srcInTargetOrderId = -1;
            }
            PatternVertex src = glogueEdge.getSrcPattern().getVertexByOrder(edge.getSrcVertexOrder());
            DataValue srcValue = this.getVertexValue(new VertexDataKey(srcInTargetOrderId), edgeDetails, src);
            PatternVertex target = glogueEdge.getDstPattern().getVertexByOrder(extendStep.getTargetVertexOrder());
            DataValue targetValue = this.getVertexValue(new VertexDataKey(extendStep.getTargetVertexOrder()), edgeDetails, target);
            ExpandConfig expandConfig = new ExpandConfig(this.createExpandOpt(edge.getDirection()), this.createLabels(edge.getEdgeTypeIds().stream().map(k -> k.getEdgeLabelId()).collect(Collectors.toList()), false), edgeValue.getAlias(), srcValue.getAlias());
            GraphLabelType tripletEdgeType = this.createTripletEdgeType(edge.getEdgeTypeIds());
            GetVConfig getVConfig = new GetVConfig(this.createGetVOpt(edge.getDirection()), this.createLabels(target.getVertexTypeIds(), true), targetValue.getAlias());
            if (edge.getElementDetails().getRange() != null) {
                PathExpandConfig.Builder pxdBuilder = PathExpandConfig.newBuilder(GraphIOProcessor.this.builder);
                pxdBuilder.expand(expandConfig);
                if (edgeValue.getFilter() != null) {
                    pxdBuilder.filter(edgeValue.getFilter());
                }
                GetVConfig innerGetVConfig = new GetVConfig(getVConfig.getOpt(), this.createLabels(this.createInnerGetVTypes(src.getVertexTypeIds(), target.getVertexTypeIds(), edge.getElementDetails()), true), getVConfig.getAlias());
                GraphOpt.PathExpandResult resultOpt = edge.getElementDetails().getResultOpt();
                GraphOpt.PathExpandPath pathOpt = edge.getElementDetails().getPathOpt();
                pxdBuilder.getV(innerGetVConfig).resultOpt(resultOpt == null ? GraphOpt.PathExpandResult.END_V : resultOpt).pathOpt(pathOpt == null ? GraphOpt.PathExpandPath.ARBITRARY : pathOpt).alias(edgeValue.getAlias()).startAlias(srcValue.getAlias()).range(edge.getElementDetails().getRange().getOffset(), edge.getElementDetails().getRange().getFetch());
                GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)GraphIOProcessor.this.builder.pathExpand(pxdBuilder.buildConfig()).build();
                GraphLogicalExpand expand = (GraphLogicalExpand)pxd.getExpand();
                GraphSchemaType edgeType = (GraphSchemaType)((RelDataTypeField)expand.getRowType().getFieldList().get(0)).getType();
                expand.setSchemaType(this.createSchemaType(tripletEdgeType, edgeType));
                GraphIOProcessor.this.builder.push((RelNode)this.createPathExpandWithOptional(pxd, edge.getElementDetails().isOptional())).getV(new GetVConfig(GraphOpt.GetV.END, getVConfig.getLabels(), getVConfig.getAlias(), getVConfig.getStartAlias()));
            } else {
                GraphLogicalExpand expand = this.createExpandWithOptional((GraphLogicalExpand)GraphIOProcessor.this.builder.expand(expandConfig).build(), edge.getElementDetails().isOptional());
                GraphSchemaType edgeType = (GraphSchemaType)((RelDataTypeField)expand.getRowType().getFieldList().get(0)).getType();
                expand.setSchemaType(this.createSchemaType(tripletEdgeType, edgeType));
                GraphIOProcessor.this.builder.push((RelNode)expand);
                if (edgeValue.getFilter() != null) {
                    GraphIOProcessor.this.builder.filter(edgeValue.getFilter());
                }
                GraphIOProcessor.this.builder.getV(getVConfig);
            }
            if (targetValue.getFilter() != null) {
                GraphIOProcessor.this.builder.filter(targetValue.getFilter());
            }
            return GraphIOProcessor.this.builder.build();
        }

        private List<Integer> createInnerGetVTypes(List<Integer> startVTypes, List<Integer> endVTypes, ElementDetails details) {
            List<Integer> originalInnerVTypes = details.getPxdInnerGetVTypes();
            if (!originalInnerVTypes.isEmpty()) {
                if (!endVTypes.isEmpty() && originalInnerVTypes.containsAll(endVTypes)) {
                    return originalInnerVTypes;
                }
                if (!startVTypes.isEmpty() && originalInnerVTypes.containsAll(startVTypes)) {
                    ArrayList reverseTypes = Lists.newArrayList(originalInnerVTypes);
                    reverseTypes.removeAll(startVTypes);
                    reverseTypes.addAll(endVTypes);
                    return reverseTypes.stream().distinct().collect(Collectors.toList());
                }
            }
            return endVTypes;
        }

        private GraphLogicalPathExpand createPathExpandWithOptional(GraphLogicalPathExpand pxd, boolean optional) {
            if (pxd.getFused() != null) {
                return GraphLogicalPathExpand.create((GraphOptCluster)pxd.getCluster(), (List<RelHint>)ImmutableList.of(), pxd.getInput(), pxd.getFused(), pxd.getOffset(), pxd.getFetch(), pxd.getResultOpt(), pxd.getPathOpt(), pxd.getUntilCondition(), pxd.getAliasName(), pxd.getStartAlias(), optional);
            }
            return GraphLogicalPathExpand.create((GraphOptCluster)pxd.getCluster(), (List<RelHint>)ImmutableList.of(), pxd.getInput(), pxd.getExpand(), pxd.getGetV(), pxd.getOffset(), pxd.getFetch(), pxd.getResultOpt(), pxd.getPathOpt(), pxd.getUntilCondition(), pxd.getAliasName(), pxd.getStartAlias(), optional);
        }

        private GraphLogicalExpand createExpandWithOptional(GraphLogicalExpand expand, boolean optional) {
            return GraphLogicalExpand.create((GraphOptCluster)expand.getCluster(), (List<RelHint>)expand.getHints(), expand.getInput(0), expand.getOpt(), expand.getTableConfig(), expand.getAliasName(), expand.getStartAlias(), optional);
        }

        private DataValue getVertexValue(VertexDataKey key, Map<DataKey, DataValue> edgeDetails, PatternVertex vertex) {
            DataValue vertexValue = edgeDetails.get(key);
            return vertexValue != null ? vertexValue : new DataValue("PATTERN_VERTEX$" + vertex.getId(), null);
        }

        private DataValue getEdgeValue(EdgeDataKey key, Map<DataKey, DataValue> edgeDetails) {
            DataValue edgeValue = edgeDetails.get(key);
            return edgeValue != null ? edgeValue : new DataValue("_", null);
        }

        private GraphLabelType createTripletEdgeType(List<EdgeTypeId> edgeTypeIds) {
            ArrayList entries = Lists.newArrayList();
            IrGraphSchema schema = GraphIOProcessor.this.irMeta.getSchema();
            block0: for (EdgeTypeId typeId : edgeTypeIds) {
                GraphEdge edgeWithTypeId = null;
                for (GraphEdge edge : schema.getEdgeList()) {
                    if (edge.getLabelId() != typeId.getEdgeLabelId().intValue()) continue;
                    edgeWithTypeId = edge;
                    break;
                }
                if (edgeWithTypeId == null) continue;
                for (EdgeRelation relation : edgeWithTypeId.getRelationList()) {
                    GraphVertex src = relation.getSource();
                    GraphVertex dst = relation.getTarget();
                    if (src.getLabelId() != typeId.getSrcLabelId().intValue() || dst.getLabelId() != typeId.getDstLabelId().intValue()) continue;
                    entries.add(new GraphLabelType.Entry().label(edgeWithTypeId.getLabel()).labelId(edgeWithTypeId.getLabelId()).srcLabel(src.getLabel()).srcLabelId(src.getLabelId()).dstLabel(dst.getLabel()).dstLabelId(dst.getLabelId()));
                    continue block0;
                }
            }
            return new GraphLabelType(entries);
        }

        private GraphSchemaType createSchemaType(GraphLabelType labelType, GraphSchemaType originalType) {
            if (labelType.getLabelsEntry().size() == 1) {
                return new GraphSchemaType(originalType.getScanOpt(), labelType, originalType.getFieldList(), originalType.isNullable());
            }
            List<GraphSchemaType> fuzzyTypes = labelType.getLabelsEntry().stream().map(k -> new GraphSchemaType(originalType.getScanOpt(), new GraphLabelType((GraphLabelType.Entry)k), originalType.getFieldList(), originalType.isNullable())).collect(Collectors.toList());
            return GraphSchemaType.create(fuzzyTypes, GraphIOProcessor.this.builder.getTypeFactory(), originalType.isNullable());
        }

        private LabelConfig createLabels(List<Integer> typeIds, boolean isVertex) {
            IrGraphSchema schema = GraphIOProcessor.this.irMeta.getSchema();
            List<String> labels = isVertex ? schema.getVertexList().stream().filter(v -> typeIds.contains(v.getLabelId())).map(k -> k.getLabel()).collect(Collectors.toList()) : schema.getEdgeList().stream().filter(v -> typeIds.contains(v.getLabelId())).map(k -> k.getLabel()).collect(Collectors.toList());
            LabelConfig config = new LabelConfig(false);
            labels.forEach(k -> config.addLabel((String)k));
            return config;
        }

        private GraphOpt.Expand createExpandOpt(PatternDirection direction) {
            return GraphOpt.Expand.valueOf(direction.name());
        }

        private GraphOpt.GetV createGetVOpt(PatternDirection direction) {
            switch (direction) {
                case IN: {
                    return GraphOpt.GetV.START;
                }
                case OUT: {
                    return GraphOpt.GetV.END;
                }
            }
            return GraphOpt.GetV.OTHER;
        }

        private Map<DataKey, DataValue> getGlogueEdgeDetails(GlogueExtendIntersectEdge edge) {
            HashMap edgeDetails = Maps.newHashMap();
            Map<Integer, Integer> srcToTargetMap = edge.getSrcToTargetOrderMapping();
            ExtendStep extendStep = edge.getExtendStep();
            VertexDataKey targetKey = new VertexDataKey(extendStep.getTargetVertexOrder());
            DataValue targetValue = this.details.get(targetKey);
            if (targetValue != null) {
                edgeDetails.put(targetKey, targetValue);
            }
            extendStep.getExtendEdges().forEach(k -> {
                VertexDataKey key2;
                DataValue value2;
                Integer srcInTargetOrderId;
                EdgeDataKey key = this.createEdgeKey((ExtendEdge)k, edge);
                DataValue value = this.details.get(key);
                if (value != null) {
                    edgeDetails.put(key, value);
                }
                if ((srcInTargetOrderId = (Integer)srcToTargetMap.get(k.getSrcVertexOrder())) != null && (value2 = this.details.get(key2 = new VertexDataKey(srcInTargetOrderId))) != null) {
                    edgeDetails.put(key2, value2);
                }
            });
            return edgeDetails;
        }

        private Map<DataKey, DataValue> createSubDetails(Pattern subPattern, Map<Integer, Integer> orderMappings, @Nullable ParentPattern parentPattern, @Nullable DataValue defaultValue) {
            HashMap newDetails = Maps.newHashMap();
            subPattern.getVertexSet().forEach(k -> {
                int newOrderId = subPattern.getVertexOrder((PatternVertex)k);
                Integer oldOrderId = (Integer)orderMappings.get(newOrderId);
                if (oldOrderId != null) {
                    DataValue value = this.details.get(new VertexDataKey(oldOrderId));
                    if (value != null) {
                        newDetails.put(new VertexDataKey(newOrderId), value);
                    }
                } else if (defaultValue != null) {
                    newDetails.put(new VertexDataKey(newOrderId), defaultValue);
                }
            });
            subPattern.getEdgeSet().forEach(k -> {
                DataValue value;
                int newSrcOrderId = subPattern.getVertexOrder(k.getSrcVertex());
                int newDstOrderId = subPattern.getVertexOrder(k.getDstVertex());
                Integer oldSrcOrderId = (Integer)orderMappings.get(newSrcOrderId);
                Integer oldDstOrderId = (Integer)orderMappings.get(newDstOrderId);
                PatternDirection direction = k.isBoth() ? PatternDirection.BOTH : PatternDirection.OUT;
                EdgeDataKey oldKey = null;
                boolean splitPathExpand = false;
                if (oldSrcOrderId != null && oldDstOrderId != null) {
                    oldKey = new EdgeDataKey(oldSrcOrderId, oldDstOrderId, direction);
                } else if (parentPattern != null) {
                    Pattern pattern = parentPattern.pattern;
                    for (PatternEdge edge : pattern.getEdgeSet()) {
                        if (k.getId() != edge.getId()) continue;
                        oldKey = new EdgeDataKey(pattern.getVertexOrder(edge.getSrcVertex()), pattern.getVertexOrder(edge.getDstVertex()), direction);
                        splitPathExpand = true;
                        break;
                    }
                }
                if (oldKey != null && (value = this.details.get(oldKey)) != null) {
                    EdgeDataKey newKey = new EdgeDataKey(newSrcOrderId, newDstOrderId, direction);
                    if (splitPathExpand && !AliasInference.isDefaultAlias(value.getAlias())) {
                        value = new DataValue(value.getAlias() + "$p_" + parentPattern.subId, value.getFilter(), value.getAlias());
                    }
                    newDetails.put(newKey, value);
                }
            });
            return newDetails;
        }

        private EdgeDataKey createEdgeKey(ExtendEdge edge, GlogueExtendIntersectEdge glogueEdge) {
            int targetOrderId = glogueEdge.getExtendStep().getTargetVertexOrder();
            Map<Integer, Integer> srcToTargetMap = glogueEdge.getSrcToTargetOrderMapping();
            Integer srcOrderId = srcToTargetMap.get(edge.getSrcVertexOrder());
            if (srcOrderId == null) {
                srcOrderId = -1;
            }
            return new EdgeDataKey(srcOrderId, targetOrderId, edge.getDirection());
        }

        private class ConcatDirectionVisitor
        extends RelVisitor {
            private GraphOpt.GetV direction;
            private final PatternVertex concatVertex;

            public ConcatDirectionVisitor(PatternVertex concatVertex) {
                this.concatVertex = concatVertex;
                this.direction = null;
            }

            public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                PatternVertex vertex;
                if (this.direction != null) {
                    return;
                }
                if (node instanceof GraphExtendIntersect) {
                    GlogueExtendIntersectEdge intersect = ((GraphExtendIntersect)node).getGlogueEdge();
                    ExtendStep extendStep = intersect.getExtendStep();
                    PatternVertex dstVertex = intersect.getDstPattern().getVertexByOrder(extendStep.getTargetVertexOrder());
                    if (dstVertex.equals(this.concatVertex)) {
                        this.direction = GraphOpt.GetV.END;
                        return;
                    }
                    for (ExtendEdge edge : extendStep.getExtendEdges()) {
                        PatternVertex srcVertex = intersect.getSrcPattern().getVertexByOrder(edge.getSrcVertexOrder());
                        if (!srcVertex.equals(this.concatVertex)) continue;
                        this.direction = GraphOpt.GetV.START;
                        return;
                    }
                } else if (node instanceof GraphPattern && (vertex = ((GraphPattern)node).getPattern().getVertexSet().iterator().next()).equals(this.concatVertex)) {
                    this.direction = GraphOpt.GetV.START;
                    return;
                }
                node.childrenAccept((RelVisitor)this);
            }
        }

        private class ParentPattern {
            private final Pattern pattern;
            private final int subId;

            public ParentPattern(Pattern pattern, int subId) {
                this.pattern = pattern;
                this.subId = subId;
            }
        }
    }

    private class InputConvertor
    extends GraphShuttle {
        private final Map<String, PatternVertex> aliasNameToVertex = Maps.newHashMap();
        private final AtomicInteger idGenerator = new AtomicInteger(0);
        private final Map<Object, DataValue> vertexOrEdgeDetails = Maps.newHashMap();
        private final Pattern inputPattern = new Pattern();

        public InputConvertor() {
            this.inputPattern.setPatternId(UUID.randomUUID().hashCode());
        }

        @Override
        public RelNode visit(GraphLogicalSingleMatch match) {
            return new GraphPattern(match.getCluster(), match.getTraitSet(), this.visit((List<RelNode>)ImmutableList.of((Object)match.getSentence()), match.getMatchOpt() == GraphOpt.Match.OPTIONAL));
        }

        @Override
        public RelNode visit(GraphLogicalMultiMatch match) {
            return new GraphPattern(match.getCluster(), match.getTraitSet(), this.visit(match.getSentences(), false));
        }

        public void build() {
            this.inputPattern.getVertexSet().forEach(k -> {
                Set<PatternEdge> edges = this.inputPattern.getEdgesOf((PatternVertex)k);
                if (!edges.isEmpty() && edges.stream().allMatch(e -> e.getElementDetails().isOptional())) {
                    k.getElementDetails().setOptional(true);
                }
            });
            this.inputPattern.reordering();
            this.checkPattern(this.inputPattern);
            if (!GraphIOProcessor.this.graphDetails.isEmpty()) {
                GraphIOProcessor.this.graphDetails.clear();
            }
            if (this.inputPattern != null && !this.vertexOrEdgeDetails.isEmpty()) {
                this.vertexOrEdgeDetails.forEach((k, v) -> {
                    DataKey key = null;
                    if (k instanceof PatternVertex) {
                        key = new VertexDataKey(this.inputPattern.getVertexOrder((PatternVertex)k));
                    } else if (k instanceof PatternEdge) {
                        int srcOrderId = this.inputPattern.getVertexOrder(((PatternEdge)k).getSrcVertex());
                        int dstOrderId = this.inputPattern.getVertexOrder(((PatternEdge)k).getDstVertex());
                        PatternDirection direction = ((PatternEdge)k).isBoth() ? PatternDirection.BOTH : PatternDirection.OUT;
                        key = new EdgeDataKey(srcOrderId, dstOrderId, direction);
                    }
                    GraphIOProcessor.this.graphDetails.put(key, (DataValue)v);
                });
            }
        }

        private Pattern visit(List<RelNode> sentences, final boolean optional) {
            RelVisitor visitor = new RelVisitor(){
                PatternVertex lastVisited = null;

                public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                    DataValue value;
                    PatternVertex vertex;
                    super.visit(node, ordinal, parent);
                    if (node instanceof GraphLogicalSource) {
                        GraphLogicalSource source = (GraphLogicalSource)node;
                        this.lastVisited = this.visitAndAddVertex(source);
                    } else if (node instanceof GraphLogicalExpand) {
                        Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (Object)"there should be a getV operator after expand since edge in patten should have two endpoints");
                        vertex = this.visitAndAddVertex((GraphLogicalGetV)parent);
                        this.visitAndAddEdge((GraphLogicalExpand)node, this.lastVisited, vertex);
                        this.lastVisited = vertex;
                    } else if (node instanceof GraphLogicalPathExpand) {
                        Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (Object)"there should be a getV operator after path expand since edge in patten should have two endpoints");
                        Preconditions.checkArgument((((GraphLogicalPathExpand)node).getUntilCondition() == null ? 1 : 0) != 0, (Object)"cannot apply optimization if path expand has until conditions");
                        vertex = this.visitAndAddVertex((GraphLogicalGetV)parent);
                        this.visitAndAddPxdEdge((GraphLogicalPathExpand)node, this.lastVisited, vertex);
                        this.lastVisited = vertex;
                    }
                    if (parent != null && (node instanceof GraphLogicalSource || node instanceof GraphLogicalGetV) && (value = InputConvertor.this.vertexOrEdgeDetails.get(this.lastVisited)) != null && (value.getAlias() == null || value.getAlias() == "_")) {
                        InputConvertor.this.vertexOrEdgeDetails.put(this.lastVisited, new DataValue(this.generateAlias(this.lastVisited), value.getFilter()));
                    }
                }

                private String generateAlias(PatternVertex vertex) {
                    return "PATTERN_VERTEX$" + vertex.getId();
                }

                private PatternVertex visitAndAddVertex(AbstractBindableTableScan tableScan) {
                    String alias = tableScan.getAliasName();
                    PatternVertex existVertex = InputConvertor.this.aliasNameToVertex.get(alias);
                    RexNode filters = InputConvertor.this.getFilters(tableScan);
                    if (existVertex == null) {
                        int vertexId = InputConvertor.this.idGenerator.getAndIncrement();
                        List<Integer> typeIds = Utils.getVertexTypeIds((RelNode)tableScan);
                        double selectivity = GraphIOProcessor.this.mq.getSelectivity((RelNode)tableScan, filters);
                        existVertex = typeIds.size() == 1 ? new SinglePatternVertex(typeIds.get(0), vertexId, new ElementDetails(selectivity)) : new FuzzyPatternVertex(typeIds, vertexId, new ElementDetails(selectivity));
                        InputConvertor.this.inputPattern.addVertex(existVertex);
                        if (alias != "_") {
                            InputConvertor.this.aliasNameToVertex.put(alias, existVertex);
                        }
                        InputConvertor.this.vertexOrEdgeDetails.put(existVertex, new DataValue(alias, filters));
                    } else if (filters != null) {
                        DataValue value = InputConvertor.this.vertexOrEdgeDetails.get(existVertex);
                        RexNode newCondition = value.getFilter() == null ? filters : RexUtil.composeConjunction((RexBuilder)GraphIOProcessor.this.builder.getRexBuilder(), (Iterable)ImmutableList.of((Object)filters, (Object)value.getFilter()));
                        InputConvertor.this.vertexOrEdgeDetails.put(existVertex, new DataValue(value.getAlias(), newCondition, value.getParentAlias()));
                    }
                    return existVertex;
                }

                private PatternEdge visitAndAddEdge(GraphLogicalExpand expand, PatternVertex left, PatternVertex right) {
                    PatternVertex dst;
                    PatternVertex src;
                    switch (expand.getOpt()) {
                        case OUT: 
                        case BOTH: {
                            src = left;
                            dst = right;
                            break;
                        }
                        default: {
                            src = right;
                            dst = left;
                        }
                    }
                    PatternEdge edge = this.visitEdge(expand, src, dst);
                    boolean added = InputConvertor.this.inputPattern.addEdge(src, dst, edge);
                    if (!added) {
                        throw new UnsupportedOperationException("edge " + edge + " already exists in the pattern, and pattern with multi-edges are not supported yet");
                    }
                    InputConvertor.this.vertexOrEdgeDetails.put(edge, new DataValue(expand.getAliasName(), InputConvertor.this.getFilters(expand)));
                    return edge;
                }

                private PatternEdge visitAndAddPxdEdge(GraphLogicalPathExpand pxd, PatternVertex left, PatternVertex right) {
                    PatternVertex dst;
                    PatternVertex src;
                    GraphLogicalExpand expand = (GraphLogicalExpand)pxd.getExpand();
                    switch (expand.getOpt()) {
                        case OUT: 
                        case BOTH: {
                            src = left;
                            dst = right;
                            break;
                        }
                        default: {
                            src = right;
                            dst = left;
                        }
                    }
                    PatternEdge expandEdge = this.visitEdge(expand, src, dst);
                    int offset = pxd.getOffset() == null ? 0 : ((Number)((RexLiteral)pxd.getOffset()).getValueAs(Number.class)).intValue();
                    int fetch = pxd.getFetch() == null ? Integer.MAX_VALUE - offset : ((Number)((RexLiteral)pxd.getFetch()).getValueAs(Number.class)).intValue();
                    GraphPathType pathType = (GraphPathType)((RelDataTypeField)pxd.getRowType().getFieldList().get(0)).getType();
                    GraphLabelType labelType = ((GraphSchemaType)pathType.getComponentType().getGetVType()).getLabelType();
                    List<Integer> innerGetVTypes = labelType.getLabelsEntry().stream().map(k -> k.getLabelId()).collect(Collectors.toList());
                    ElementDetails newDetails = new ElementDetails(expandEdge.getElementDetails().getSelectivity(), new PathExpandRange(offset, fetch), innerGetVTypes, pxd.getResultOpt(), pxd.getPathOpt());
                    expandEdge = expandEdge instanceof SinglePatternEdge ? new SinglePatternEdge(expandEdge.getSrcVertex(), expandEdge.getDstVertex(), expandEdge.getEdgeTypeIds().get(0), expandEdge.getId(), expandEdge.isBoth(), newDetails) : new FuzzyPatternEdge(expandEdge.getSrcVertex(), expandEdge.getDstVertex(), expandEdge.getEdgeTypeIds(), expandEdge.getId(), expandEdge.isBoth(), newDetails);
                    boolean added = InputConvertor.this.inputPattern.addEdge(src, dst, expandEdge);
                    if (!added) {
                        throw new UnsupportedOperationException("edge " + expandEdge + " already exists in the pattern, and pattern with multi-edges are not supported yet");
                    }
                    InputConvertor.this.vertexOrEdgeDetails.put(expandEdge, new DataValue(pxd.getAliasName(), InputConvertor.this.getFilters(expand)));
                    return expandEdge;
                }

                private PatternEdge visitEdge(GraphLogicalExpand expand, PatternVertex src, PatternVertex dst) {
                    boolean isBoth = expand.getOpt() == GraphOpt.Expand.BOTH;
                    List<EdgeTypeId> edgeTypeIds = Utils.getEdgeTypeIds((RelNode)expand);
                    int edgeId = InputConvertor.this.idGenerator.getAndIncrement();
                    double selectivity = GraphIOProcessor.this.mq.getSelectivity((RelNode)expand, InputConvertor.this.getFilters(expand));
                    PatternEdge edge = edgeTypeIds.size() == 1 ? new SinglePatternEdge(src, dst, edgeTypeIds.get(0), edgeId, isBoth, new ElementDetails(selectivity, optional)) : new FuzzyPatternEdge(src, dst, edgeTypeIds, edgeId, isBoth, new ElementDetails(selectivity, optional));
                    return edge;
                }
            };
            for (RelNode sentence : sentences) {
                visitor.go(sentence);
            }
            return this.inputPattern;
        }

        private @Nullable RexNode getFilters(AbstractBindableTableScan tableScan) {
            RexNode uniqueFilters;
            ArrayList filters = Lists.newArrayList();
            if (tableScan instanceof GraphLogicalSource && (uniqueFilters = ((GraphLogicalSource)tableScan).getUniqueKeyFilters()) != null) {
                filters.add(uniqueFilters);
            }
            if (ObjectUtils.isNotEmpty(tableScan.getFilters())) {
                filters.addAll(tableScan.getFilters());
            }
            return filters.isEmpty() ? null : RexUtil.composeConjunction((RexBuilder)GraphIOProcessor.this.builder.getRexBuilder(), (Iterable)filters);
        }

        private void checkPattern(Pattern pattern) {
            for (PatternEdge edge : pattern.getEdgeSet()) {
                PatternVertex src = edge.getSrcVertex();
                PatternVertex dst = edge.getDstVertex();
                HashSet expectedSrcIds = Sets.newHashSet();
                HashSet expectedDstIds = Sets.newHashSet();
                edge.getEdgeTypeIds().forEach(k -> {
                    if (!edge.isBoth()) {
                        expectedSrcIds.add(k.getSrcLabelId());
                        expectedDstIds.add(k.getDstLabelId());
                    } else {
                        expectedSrcIds.add(k.getSrcLabelId());
                        expectedDstIds.add(k.getDstLabelId());
                        expectedSrcIds.add(k.getDstLabelId());
                        expectedDstIds.add(k.getSrcLabelId());
                    }
                });
                if (edge.getElementDetails().getRange() != null) continue;
                Preconditions.checkArgument((boolean)(!edge.isBoth() ? Sets.newHashSet(src.getVertexTypeIds()).equals(expectedSrcIds) : expectedSrcIds.containsAll(src.getVertexTypeIds())), (String)"src vertex types %s not consistent with edge types %s", src.getVertexTypeIds(), edge.getEdgeTypeIds());
                Preconditions.checkArgument((boolean)(!edge.isBoth() ? Sets.newHashSet(dst.getVertexTypeIds()).equals(expectedDstIds) : expectedDstIds.containsAll(dst.getVertexTypeIds())), (String)"dst vertex types %s not consistent with edge types %s", dst.getVertexTypeIds(), edge.getEdgeTypeIds());
            }
        }
    }
}

