/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.config.PlannerConfig;
import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKeyMeta;
import com.alibaba.graphscope.common.ir.planner.GraphHepPlanner;
import com.alibaba.graphscope.common.ir.planner.GraphIOProcessor;
import com.alibaba.graphscope.common.ir.planner.GraphRelOptimizer;
import com.alibaba.graphscope.common.ir.planner.rules.ExpandGetVFusionRule;
import com.alibaba.graphscope.common.ir.planner.rules.ExtendIntersectRule;
import com.alibaba.graphscope.common.ir.planner.rules.FieldTrimRule;
import com.alibaba.graphscope.common.ir.planner.rules.FilterMatchRule;
import com.alibaba.graphscope.common.ir.planner.rules.JoinDecompositionRule;
import com.alibaba.graphscope.common.ir.planner.volcano.VolcanoPlannerX;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.tools.RelBuilderFactory;

public class PlannerGroup {
    private final RelOptPlanner relPlanner;
    private final RelOptPlanner matchPlanner;
    private final RelOptPlanner physicalPlanner;
    private final PlannerConfig config;
    private final RelBuilderFactory relBuilderFactory;

    public PlannerGroup(PlannerConfig config, RelBuilderFactory relBuilderFactory) {
        this.config = config;
        this.relBuilderFactory = relBuilderFactory;
        this.relPlanner = this.createRelPlanner();
        this.matchPlanner = this.createMatchPlanner();
        this.physicalPlanner = this.createPhysicalPlanner();
    }

    public synchronized RelNode optimize(RelNode before, GraphIOProcessor ioProcessor) {
        if (this.config.isOn()) {
            this.relPlanner.setRoot(before);
            RelNode relOptimized = this.relPlanner.findBestExp();
            if (this.config.getOpt() == PlannerConfig.Opt.CBO) {
                relOptimized = relOptimized.accept((RelShuttle)new GraphRelOptimizer.MatchOptimizer(ioProcessor, this.matchPlanner));
            }
            if (this.config.getRules().contains(FieldTrimRule.class.getSimpleName())) {
                relOptimized = FieldTrimRule.trim(ioProcessor.getBuilder(), relOptimized);
            }
            this.physicalPlanner.setRoot(relOptimized);
            RelNode physicalOptimized = this.physicalPlanner.findBestExp();
            this.clear();
            return physicalOptimized;
        }
        return before;
    }

    private RelOptPlanner createRelPlanner() {
        HepProgramBuilder hepBuilder = HepProgram.builder();
        if (this.config.isOn()) {
            ArrayList ruleConfigs = Lists.newArrayList();
            this.config.getRules().forEach(k -> {
                if (k.equals(FilterJoinRule.FilterIntoJoinRule.class.getSimpleName())) {
                    ruleConfigs.add(CoreRules.FILTER_INTO_JOIN.config);
                } else if (k.equals(FilterMatchRule.class.getSimpleName())) {
                    ruleConfigs.add(FilterMatchRule.Config.DEFAULT);
                }
            });
            ruleConfigs.forEach(k -> hepBuilder.addRuleInstance(k.withRelBuilderFactory(this.relBuilderFactory).toRule()));
        }
        return new GraphHepPlanner(hepBuilder.build());
    }

    private RelOptPlanner createMatchPlanner() {
        if (this.config.isOn() && this.config.getOpt() == PlannerConfig.Opt.CBO) {
            VolcanoPlannerX planner = new VolcanoPlannerX();
            planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
            planner.setTopDownOpt(true);
            planner.setNoneConventionHasInfiniteCost(false);
            this.config.getRules().forEach(k -> {
                Object ruleConfig = null;
                if (k.equals(ExtendIntersectRule.class.getSimpleName())) {
                    ruleConfig = ExtendIntersectRule.Config.DEFAULT.withMaxPatternSizeInGlogue(this.config.getGlogueSize()).withLabelConstraintsEnabled(this.config.labelConstraintsEnabled());
                } else if (k.equals(JoinDecompositionRule.class.getSimpleName())) {
                    ruleConfig = JoinDecompositionRule.Config.DEFAULT.withMinPatternSize(this.config.getJoinMinPatternSize()).withJoinQueueCapacity(this.config.getJoinQueueCapacity()).withJoinByEdgeEnabled(this.config.isJoinByEdgeEnabled());
                    ForeignKeyMeta foreignKeyMeta = this.config.getJoinByForeignKeyUri().isEmpty() ? null : new ForeignKeyMeta(this.config.getJoinByForeignKeyUri());
                    ((JoinDecompositionRule.Config)ruleConfig).withForeignKeyMeta(foreignKeyMeta);
                }
                if (ruleConfig != null) {
                    planner.addRule(ruleConfig.withRelBuilderFactory(this.relBuilderFactory).toRule());
                }
            });
            return planner;
        }
        return new GraphHepPlanner(HepProgram.builder().build());
    }

    private RelOptPlanner createPhysicalPlanner() {
        HepProgramBuilder hepBuilder = HepProgram.builder();
        if (this.config.isOn()) {
            ArrayList ruleConfigs = Lists.newArrayList();
            this.config.getRules().forEach(k -> {
                if (k.equals(ExpandGetVFusionRule.class.getSimpleName())) {
                    ruleConfigs.add(ExpandGetVFusionRule.BasicExpandGetVFusionRule.Config.DEFAULT);
                    ruleConfigs.add(ExpandGetVFusionRule.PathBaseExpandGetVFusionRule.Config.DEFAULT);
                }
            });
            ruleConfigs.forEach(k -> hepBuilder.addRuleInstance(k.withRelBuilderFactory(this.relBuilderFactory).toRule()));
        }
        return new GraphHepPlanner(hepBuilder.build());
    }

    public synchronized void clear() {
        List logicalRBORules = this.relPlanner.getRules();
        this.relPlanner.clear();
        for (Object rule : logicalRBORules) {
            this.relPlanner.addRule((RelOptRule)rule);
        }
        List logicalCBORules = this.matchPlanner.getRules();
        this.matchPlanner.clear();
        for (RelOptRule rule : logicalCBORules) {
            this.matchPlanner.addRule(rule);
        }
        List physicalRBORules = this.physicalPlanner.getRules();
        this.physicalPlanner.clear();
        for (RelOptRule rule : physicalRBORules) {
            this.physicalPlanner.addRule(rule);
        }
    }

    public RelOptPlanner getMatchPlanner() {
        return this.matchPlanner;
    }
}

