/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner.rules;

import com.alibaba.graphscope.common.ir.rel.PushFilterVisitor;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FilterMatchRule<C extends Config>
extends RelRule<C>
implements TransformationRule {
    protected FilterMatchRule(C config) {
        super(config);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        AbstractLogicalMatch match = (AbstractLogicalMatch)call.rel(1);
        List conjunctions = RelOptUtil.conjunctions((RexNode)filter.getCondition());
        int origSize = conjunctions.size();
        GraphBuilder graphBuilder = (GraphBuilder)call.builder();
        Iterator it = conjunctions.iterator();
        while (it.hasNext()) {
            RexNode condition = (RexNode)it.next();
            PushFilterVisitor visitor = new PushFilterVisitor(graphBuilder, condition);
            match = (AbstractLogicalMatch)match.accept((RelShuttle)visitor);
            if (!visitor.isPushed()) continue;
            it.remove();
        }
        if (!conjunctions.isEmpty() && conjunctions.size() < origSize) {
            filter = (Filter)graphBuilder.push((RelNode)match).filter((Iterable)conjunctions).build();
        }
        AbstractLogicalMatch newNode = conjunctions.isEmpty() ? match : filter;
        call.transformTo((RelNode)newNode);
    }

    public static class Config
    implements RelRule.Config {
        public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(AbstractLogicalMatch.class).anyInputs()));
        private RelRule.OperandTransform operandSupplier;
        private @Nullable String description;
        private RelBuilderFactory builderFactory;

        public RelRule toRule() {
            return new FilterMatchRule<Config>(this);
        }

        public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.builderFactory = relBuilderFactory;
            return this;
        }

        public Config withDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
            this.operandSupplier = operandTransform;
            return this;
        }

        public RelRule.OperandTransform operandSupplier() {
            return this.operandSupplier;
        }

        public @Nullable String description() {
            return this.description;
        }

        public RelBuilderFactory relBuilderFactory() {
            return this.builderFactory;
        }
    }
}

