/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner.type;

import com.alibaba.graphscope.common.ir.planner.type.DataKey;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternDirection;
import java.util.Objects;

public class EdgeDataKey
implements DataKey {
    private final int lowOrderId;
    private final int highOrderId;
    private final PatternDirection direction;

    public EdgeDataKey(int orderId1, int orderId2, PatternDirection direction) {
        if (orderId1 <= orderId2) {
            this.lowOrderId = orderId1;
            this.highOrderId = orderId2;
            this.direction = direction;
        } else {
            this.lowOrderId = orderId2;
            this.highOrderId = orderId1;
            this.direction = this.revert(direction);
        }
    }

    public PatternDirection getDirection() {
        return this.direction;
    }

    public int getLowOrderId() {
        return this.lowOrderId;
    }

    public int getHighOrderId() {
        return this.highOrderId;
    }

    private PatternDirection revert(PatternDirection direction) {
        switch (direction) {
            case IN: {
                return PatternDirection.OUT;
            }
            case OUT: {
                return PatternDirection.IN;
            }
        }
        return PatternDirection.BOTH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeDataKey edgeKey = (EdgeDataKey)o;
        return this.lowOrderId == edgeKey.lowOrderId && this.highOrderId == edgeKey.highOrderId && this.direction == edgeKey.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lowOrderId, this.highOrderId, this.direction});
    }

    public String toString() {
        return "EdgeDataKey{lowOrderId=" + this.lowOrderId + ", highOrderId=" + this.highOrderId + ", direction=" + this.direction + "}";
    }
}

