/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLogicalAggregate
extends Aggregate {
    private GraphGroupKeys groupKey;
    private List<GraphAggCall> aggCalls;

    protected GraphLogicalAggregate(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, GraphGroupKeys groupKey, List<GraphAggCall> aggCalls) {
        super(cluster, traitSet, hints, input, ImmutableBitSet.of(), null, (List)ImmutableList.of());
        Objects.requireNonNull(input);
        this.groupKey = Objects.requireNonNull(groupKey);
        this.aggCalls = Objects.requireNonNull(aggCalls);
    }

    public static GraphLogicalAggregate create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, GraphGroupKeys groupKey, List<GraphAggCall> aggCalls) {
        return new GraphLogicalAggregate(cluster, RelTraitSet.createEmpty(), hints, input, groupKey, aggCalls);
    }

    protected RelDataType deriveRowType() {
        ArrayList<RexNode> rexNodes = new ArrayList<RexNode>();
        ArrayList<@Nullable String> aliases = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty(this.groupKey.getVariables())) {
            rexNodes.addAll(this.groupKey.getVariables());
            aliases.addAll(this.groupKey.getAliases());
            while (aliases.size() < rexNodes.size()) {
                aliases.add(null);
            }
        }
        for (GraphAggCall aggCall : this.aggCalls) {
            rexNodes.add(aggCall.rexCall());
            aliases.add(aggCall.getAlias());
        }
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
        if (ObjectUtils.isNotEmpty(rexNodes)) {
            List<String> aliasList = AliasInference.inferProject(rexNodes, aliases, new HashSet<String>());
            assert (aliasList.size() == rexNodes.size());
            for (int i = 0; i < rexNodes.size(); ++i) {
                String aliasName = aliasList.get(i);
                RelOptCluster cluster = this.getCluster();
                int aliasId = ((GraphOptCluster)cluster).getIdGenerator().generate(aliasName);
                fields.add(new RelDataTypeFieldImpl(aliasName, aliasId, ((RexNode)rexNodes.get(i)).getType()));
            }
            this.groupKey = new GraphGroupKeys(this.groupKey.getVariables(), aliasList.subList(0, this.groupKey.groupKeyCount()));
            ArrayList<GraphAggCall> copyCalls = new ArrayList<GraphAggCall>();
            int offset = this.groupKey.groupKeyCount();
            for (int i = 0; i < this.aggCalls.size(); ++i) {
                copyCalls.add(this.aggCalls.get(i).copy(aliasList.get(offset + i)));
            }
            this.aggCalls = copyCalls;
        }
        return new RelRecordType(StructKind.FULLY_QUALIFIED, fields);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new GraphLogicalAggregate(this.getCluster(), traitSet, (List<RelHint>)this.getHints(), input, this.groupKey, this.aggCalls);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("input", (Object)this.input).item("keys", (Object)this.groupKey).item("values", this.aggCalls);
    }

    public GraphGroupKeys getGroupKey() {
        return this.groupKey;
    }

    public List<GraphAggCall> getAggCalls() {
        return Collections.unmodifiableList(this.aggCalls);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }
}

