/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;

public class GraphLogicalProject
extends Project {
    private boolean isAppend;

    protected GraphLogicalProject(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelNode input, List<? extends RexNode> projects, RelDataType rowType, boolean isAppend) {
        super(cluster, traits, hints, input, projects, rowType);
        this.isAppend = isAppend;
    }

    public static GraphLogicalProject create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, List<? extends RexNode> projects, RelDataType dataType, boolean isAppend) {
        return new GraphLogicalProject(cluster, RelTraitSet.createEmpty(), hints, input, projects, dataType, isAppend);
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new GraphLogicalProject(this.getCluster(), traitSet, (List<RelHint>)ImmutableList.of(), input, projects, rowType, this.isAppend);
    }

    public RelNode accept(RexShuttle shuttle) {
        List exps = shuttle.apply((List)this.exps);
        if (this.exps == exps) {
            return this;
        }
        Preconditions.checkArgument((exps.size() == this.exps.size() ? 1 : 0) != 0, (Object)"rex shuttle should not change the size of exps");
        List oldFields = this.getRowType().getFieldList();
        ArrayList newFields = Lists.newArrayList();
        for (int i = 0; i < exps.size(); ++i) {
            RelDataTypeField oldField = (RelDataTypeField)oldFields.get(i);
            newFields.add(new RelDataTypeFieldImpl(oldField.getName(), oldField.getIndex(), ((RexNode)exps.get(i)).getType()));
        }
        return this.copy(this.traitSet, this.input, exps, (RelDataType)new RelRecordType(StructKind.FULLY_QUALIFIED, (List)newFields));
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("isAppend", (Object)this.isAppend);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }
}

